/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.core.PdfPageRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfBookmark {
    private final int depth;
    private final String title;
    private final boolean open;
    private final boolean bold;
    private final boolean italic;
    private final int page;
    private final String pagePosition;
    private final String moreOptions;

    public PdfBookmark(int n, String string, boolean bl, int n2) {
        this(n, string, bl, n2, "", false, false, null);
    }

    public PdfBookmark(int n, String string, boolean bl, int n2, String string2, boolean bl2, boolean bl3, String string3) {
        this.depth = n;
        this.title = string;
        this.open = bl;
        this.bold = bl2;
        this.italic = bl3;
        this.page = n2;
        this.pagePosition = string2;
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        this.moreOptions = string3;
        if (string3 != null && !string3.equals(PdfBookmark.makeString(PdfBookmark.parseString(string3)))) {
            throw new IllegalArgumentException("More options incorrect");
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getMoreOptions() {
        return this.moreOptions;
    }

    public int getPage() {
        return this.page;
    }

    public String getPagePosition() {
        return this.pagePosition;
    }

    protected HashMap<String, Object> toBookmark(List<HashMap<String, Object>> list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(PdfBookmark.parseString(this.moreOptions));
        if (list != null) {
            hashMap.put("Kids", list);
        }
        if (this.page != 0) {
            hashMap.put("Action", "GoTo");
            hashMap.put("Page", this.page + (this.pagePosition.length() == 0 ? "" : " " + this.pagePosition));
        }
        hashMap.put("Open", this.open ? "true" : "false");
        String string = ((this.italic ? "italic " : "") + (this.bold ? "bold" : "")).trim();
        if (this.bold || this.italic) {
            hashMap.put("Style", string);
        }
        hashMap.put("Title", this.title);
        return hashMap;
    }

    public PdfBookmark shiftPageNumber(int n) {
        if (this.page == 0) {
            return this;
        }
        return new PdfBookmark(this.depth, this.title, this.open, this.page + n, this.pagePosition, this.bold, this.italic, this.moreOptions);
    }

    protected static List<HashMap<String, Object>> makeBookmarks(PdfBookmark[] pdfBookmarkArray) throws IOException {
        return PdfBookmark.makeBookmarks(pdfBookmarkArray, 1, 0, pdfBookmarkArray.length);
    }

    protected static List<HashMap<String, Object>> makeBookmarks(PdfBookmark[] pdfBookmarkArray, int n, int n2, int n3) throws IOException {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        int n4 = n2;
        while (n4 < n3) {
            int n5;
            PdfBookmark pdfBookmark = pdfBookmarkArray[n4];
            if (pdfBookmark.getDepth() != n) {
                throw new IOException("Invalid depth value");
            }
            for (n5 = n4 + 1; n5 < n3 && pdfBookmarkArray[n5].depth > n; ++n5) {
            }
            List<HashMap<String, Object>> list = null;
            if (n5 > n4 + 1) {
                list = PdfBookmark.makeBookmarks(pdfBookmarkArray, n + 1, n4 + 1, n5);
            }
            arrayList.add(pdfBookmark.toBookmark(list));
            n4 = n5;
        }
        return arrayList;
    }

    protected static List<PdfBookmark> parseBookmarks(List<HashMap> list, int n) {
        ArrayList<PdfBookmark> arrayList = new ArrayList<PdfBookmark>();
        if (list == null) {
            return arrayList;
        }
        for (HashMap hashMap : list) {
            PdfBookmark.fillInBookmark(arrayList, hashMap, n);
        }
        return arrayList;
    }

    protected static void fillInBookmark(List<PdfBookmark> list, HashMap hashMap, int n) {
        String string;
        String string2;
        int n2;
        int n3;
        HashMap hashMap2 = new HashMap(hashMap);
        List list2 = (List)hashMap2.remove("Kids");
        if ("GoTo".equals(hashMap2.get("Action")) && hashMap2.get("Page") != null) {
            hashMap2.remove("Action");
            String string3 = ((String)hashMap2.remove("Page")).trim();
            n3 = string3.indexOf(" ");
            if (n3 == -1) {
                n2 = Integer.parseInt(string3);
                string2 = "";
            } else {
                n2 = Integer.parseInt(string3.substring(0, n3));
                string2 = string3.substring(n3 + 1);
            }
            if (n2 == 0) {
                throw new RuntimeException();
            }
        } else {
            n2 = 0;
            string2 = "";
        }
        boolean bl = true;
        n3 = 0;
        boolean bl2 = false;
        if (hashMap2.get("Open") != null && "false".equals(hashMap2.remove("Open"))) {
            bl = false;
        }
        if ((string = (String)hashMap2.remove("Style")) != null && string.indexOf("italic") != -1) {
            bl2 = true;
        }
        if (string != null && string.indexOf("bold") != -1) {
            n3 = 1;
        }
        String string4 = (String)hashMap2.remove("Title");
        list.add(new PdfBookmark(n, string4, bl, n2, string2, n3 != 0, bl2, PdfBookmark.makeString(hashMap2)));
        if (list2 != null) {
            for (HashMap hashMap3 : list2) {
                PdfBookmark.fillInBookmark(list, hashMap3, n + 1);
            }
        }
    }

    private static String makeString(HashMap<?, ?> hashMap) {
        if (hashMap.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<?, ?> entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string).append("=\"");
            stringBuffer.append(string2.replaceAll("\"", "\"\""));
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private static HashMap<String, String> parseString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            return hashMap;
        }
        string = string.trim();
        while (string.length() > 0) {
            int n = string.indexOf("=\"");
            String string2 = string.substring(0, n);
            String string3 = "";
            string = string.substring(n + 2);
            while ((n = string.indexOf(34)) < string.length() - 1 && string.charAt(n + 1) == '\"') {
                string3 = string3 + string.substring(0, n + 1);
                string = string.substring(n + 2);
            }
            string3 = string3 + string.substring(0, n);
            string = string.substring(n + 1);
            hashMap.put(string2, string3);
            string = string.trim();
        }
        return hashMap;
    }

    public static List<PdfBookmark> buildBookmarks(List<PdfPageRange> list) {
        int n = 0;
        ArrayList<PdfBookmark> arrayList = new ArrayList<PdfBookmark>();
        for (PdfPageRange pdfPageRange : list) {
            arrayList.add(new PdfBookmark(1, pdfPageRange.getInputFile().getFile().getName(), true, n + 1));
            List<PdfBookmark> list2 = pdfPageRange.getInputFile().getBookmarks(2);
            for (PdfBookmark pdfBookmark : list2) {
                arrayList.add(pdfBookmark.shiftPageNumber(n));
            }
            n += pdfPageRange.getPages(n).length;
        }
        return arrayList;
    }

    public static PdfBookmark parseBookmark(String string) {
        Matcher matcher = Pattern.compile("(-?[0-9]+);(O?B?I?);([^;]*);(-?[0-9]+)( [^;]+)?(;[^;]*)?").matcher(string);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot parse bookmark");
        }
        String string2 = matcher.group(2);
        return new PdfBookmark(Integer.parseInt(matcher.group(1)), PdfBookmark.unescape(matcher.group(3)), string2.contains("O"), Integer.parseInt(matcher.group(4)), matcher.group(5) == null ? "" : PdfBookmark.unescape(matcher.group(5).substring(1)), string2.contains("B"), string2.contains("I"), matcher.group(6) == null ? null : PdfBookmark.unescape(matcher.group(6).substring(1)));
    }

    public String toString() {
        return this.depth + ";" + (this.open ? "O" : "") + (this.bold ? "B" : "") + (this.italic ? "I" : "") + ";" + PdfBookmark.escape(this.title) + ";" + this.page + (this.pagePosition.length() == 0 ? "" : " ") + PdfBookmark.escape(this.pagePosition) + (this.moreOptions == null ? "" : ";" + PdfBookmark.escape(this.moreOptions));
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < ' ' || "\\;\"'".contains("" + string.charAt(i))) {
                char c = string.charAt(i);
                stringBuffer.append("\\").append(c < '\u0010' ? "0" : "").append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

