/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.tabs.Tab;

public class EncryptSignTab
extends Tab {
    private final MainForm mainForm;
    private JCheckBox signDocument;
    private JCheckBox encryptDocument;
    private JCheckBox noEncryptMetadata;
    private JComboBox encryptMode;
    private JButton encryptLoad;
    private JTextField ownerPassword;
    private JTextField userPassword;
    private JCheckBox[] permissionBoxes = new JCheckBox[PdfTweak.permissionBits.length];
    private JCheckBox sigVisible;
    private JTextField keystore;
    private JTextField alias;
    private JPasswordField keyPassword;
    private JComboBox certLevel;

    public EncryptSignTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p, f:p:g, f:p", "f:p, f:p, f:p, f:p, f:p, f:p, 10dlu, f:p, f:p, f:p, f:p, f:p, f:p, f:p:g"));
        this.mainForm = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.encryptDocument = new JCheckBox("Encrypt PDF");
        this.add((Component)this.encryptDocument, cellConstraints.xyw(1, 1, 2));
        this.encryptDocument.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptSignTab.this.updateEncryptionControls();
            }
        });
        this.encryptLoad = new JButton("Load from document");
        this.add((Component)this.encryptLoad, cellConstraints.xy(3, 1));
        this.encryptLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptSignTab.this.loadEncryptionData();
            }
        });
        this.add((Component)new JLabel("Mode:"), cellConstraints.xy(1, 2));
        this.encryptMode = new JComboBox<String>(new String[]{"40-bit RC4", "128-bit RC4", "128-bit AES (Acrobat 7.0)"});
        this.add(this.encryptMode, cellConstraints.xyw(2, 2, 2));
        this.add((Component)new JLabel("Owner password:"), cellConstraints.xy(1, 3));
        this.ownerPassword = new JTextField("");
        this.add((Component)this.ownerPassword, cellConstraints.xyw(2, 3, 2));
        this.add((Component)new JLabel("User password:"), cellConstraints.xy(1, 4));
        this.userPassword = new JTextField("");
        this.add((Component)this.userPassword, cellConstraints.xyw(2, 4, 2));
        this.noEncryptMetadata = new JCheckBox("Do not encrypt metadata");
        this.add((Component)this.noEncryptMetadata, cellConstraints.xyw(1, 5, 3));
        JPanel jPanel = new JPanel((LayoutManager)new FormLayout("f:p:g, f:p:g, f:p:g, f:p:g", "f:p, f:p, "));
        this.add((Component)jPanel, cellConstraints.xyw(1, 6, 3));
        for (int i = 0; i < 8; ++i) {
            this.permissionBoxes[i] = new JCheckBox(PdfTweak.permissionTexts[i]);
            jPanel.add((Component)this.permissionBoxes[i], cellConstraints.xy(1 + i % 4, 1 + i / 4));
        }
        this.encryptMode.setSelectedIndex(1);
        this.encryptMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptSignTab.this.updateEncryptionControls();
            }
        });
        jPanel.setBorder(new TitledBorder("Permissions"));
        this.updateEncryptionControls();
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 7, 3));
        this.signDocument = new JCheckBox("Sign PDF");
        this.add((Component)this.signDocument, cellConstraints.xyw(1, 8, 3));
        this.signDocument.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptSignTab.this.updateSignatureControls();
            }
        });
        this.add((Component)new JLabel("Keystore file:"), cellConstraints.xy(1, 9));
        this.keystore = new JTextField(new File(System.getProperty("user.home"), ".keystore").getAbsolutePath());
        this.add((Component)this.keystore, cellConstraints.xyw(2, 9, 2));
        this.add((Component)new JLabel("Alias:"), cellConstraints.xy(1, 10));
        this.alias = new JTextField("mykey");
        this.add((Component)this.alias, cellConstraints.xyw(2, 10, 2));
        this.add((Component)new JLabel("Passphrase:"), cellConstraints.xy(1, 11));
        this.keyPassword = new JPasswordField("");
        this.add((Component)this.keyPassword, cellConstraints.xyw(2, 11, 2));
        this.add((Component)new JLabel("Certification level"), cellConstraints.xy(1, 12));
        this.certLevel = new JComboBox<String>(new String[]{"Not certified", "No changes allowed", "Form filling allowed", "Form filling and annotations allowed"});
        this.add(this.certLevel, cellConstraints.xyw(2, 12, 2));
        this.sigVisible = new JCheckBox("Show signature on page 1");
        this.add((Component)this.sigVisible, cellConstraints.xyw(1, 13, 3));
        this.updateSignatureControls();
    }

    protected void loadEncryptionData() {
        if (this.mainForm.getInputFile() == null) {
            return;
        }
        PdfInputFile pdfInputFile = this.mainForm.getInputFile();
        int n = pdfInputFile.getCryptoMode();
        if (n != -1) {
            this.encryptMode.setSelectedIndex(n);
        }
        this.noEncryptMetadata.setSelected(!pdfInputFile.isMetadataEncrypted());
        this.userPassword.setText(pdfInputFile.getUserPassword());
        this.ownerPassword.setText(pdfInputFile.getOwnerPassword());
        int n2 = pdfInputFile.getPermissions();
        for (int i = 0; i < this.permissionBoxes.length; ++i) {
            this.permissionBoxes[i].setSelected((PdfTweak.permissionBits[i] & n2) != 0);
        }
    }

    private void updateEncryptionControls() {
        boolean bl = this.encryptDocument.isSelected();
        this.encryptLoad.setEnabled(bl);
        this.encryptMode.setEnabled(bl);
        this.userPassword.setEnabled(bl);
        this.ownerPassword.setEnabled(bl);
        this.noEncryptMetadata.setEnabled(bl);
        for (int i = 0; i < this.permissionBoxes.length; ++i) {
            boolean bl2 = i < 4 || this.encryptMode.getSelectedIndex() != 0;
            this.permissionBoxes[i].setEnabled(bl && bl2);
            if (bl2) continue;
            this.permissionBoxes[i].setSelected(false);
        }
    }

    private void updateSignatureControls() {
        boolean bl = this.signDocument.isSelected();
        this.sigVisible.setEnabled(bl);
        this.keystore.setEnabled(bl);
        this.alias.setEnabled(bl);
        this.keyPassword.setEnabled(bl);
        this.certLevel.setEnabled(bl);
    }

    public String getTabName() {
        return "Encrypt/Sign";
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException {
        if (this.encryptDocument.isSelected()) {
            int n = 0;
            for (int i = 0; i < this.permissionBoxes.length; ++i) {
                if (!this.permissionBoxes[i].isSelected()) continue;
                n |= PdfTweak.permissionBits[i];
            }
            pdfTweak.setEncryption(this.encryptMode.getSelectedIndex() + (this.noEncryptMetadata.isSelected() ? 8 : 0), n, this.ownerPassword.getText().getBytes("ISO-8859-1"), this.userPassword.getText().getBytes("ISO-8859-1"));
        }
        if (this.signDocument.isSelected()) {
            pdfTweak.setSignature(new File(this.keystore.getText()), this.alias.getText(), this.keyPassword.getPassword(), this.certLevel.getSelectedIndex(), this.sigVisible.isSelected());
        }
        return pdfTweak;
    }
}

