/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MacTreeUI
extends BasicTreeUI {
    protected boolean pressedOnControl = false;
    protected boolean highlightControl = false;
    protected Icon darkExpandedIcon;
    protected Icon darkCollapsedIcon;
    protected TreePath firstPath;
    protected MouseMotionListener mouseMotionHandler;

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacTreeUI();
    }

    public Icon getCollapsedIcon() {
        if (this.highlightControl) {
            return this.darkCollapsedIcon;
        }
        return super.getCollapsedIcon();
    }

    public Icon getExpandedIcon() {
        if (this.highlightControl) {
            return this.darkExpandedIcon;
        }
        return super.getExpandedIcon();
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        super.handleExpandControlClick(treePath, n, n2);
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseMotionHandler = this.createMouseMotionListener();
        if (this.mouseMotionHandler != null) {
            this.tree.addMouseMotionListener(this.mouseMotionHandler);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.darkExpandedIcon = UIManager.getIcon("Tree.darkExpandedIcon");
        this.darkCollapsedIcon = UIManager.getIcon("Tree.darkCollapsedIcon");
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl;
        int n3 = this.getRowForPath(this.tree, treePath);
        int n4 = treePath.getPathCount() - 1;
        boolean bl2 = bl = n4 > 0 || n4 == 0 && this.getShowsRootHandles();
        if (this.tree != null && !this.isLeaf(n3) && bl) {
            Icon icon = this.tree.isExpanded(treePath) ? this.getExpandedIcon() : this.getCollapsedIcon();
            Rectangle rectangle = this.tree.getPathBounds(treePath);
            Insets insets = this.tree.getInsets();
            int n5 = rectangle.y + rectangle.height / 2;
            int n6 = n5 - icon.getIconHeight() / 2;
            int n7 = n5 + icon.getIconHeight() / 2;
            int n8 = insets.left + icon.getIconWidth() - 1;
            if (n2 >= n6 && n2 <= n7 && n >= insets.left && n <= n8) {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(insets.left, 0);
        Object object = treePath.getLastPathComponent();
        if (!(bl3 || bl2 && this.treeModel.getChildCount(object) <= 0)) {
            int n2 = rectangle2.y + rectangle2.height / 2;
            if (bl) {
                Icon icon = this.getExpandedIcon();
                int n3 = icon.getIconWidth() / 2;
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n3, n2);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                int n4 = icon.getIconWidth() / 2;
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n4, n2);
                }
            }
        }
        graphics.translate(-insets.left, 0);
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
    }

    protected void repaintControl(TreePath treePath) {
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        rectangle.x = this.tree.getInsets().left;
        rectangle.width = this.getExpandedIcon().getIconWidth();
        this.tree.repaint(rectangle);
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.getShowsRootHandles() && this.isRootVisible() && treePath.getPathCount() == 1) {
            return false;
        }
        return super.shouldPaintExpandControl(treePath, n, bl, bl2, bl3);
    }

    protected void uninstallListeners() {
        if (this.mouseMotionHandler != null) {
            this.tree.removeMouseMotionListener(this.mouseMotionHandler);
            this.mouseMotionHandler = null;
        }
        super.uninstallListeners();
    }

    public class MouseHandler
    extends BasicTreeUI.MouseHandler {
        public MouseHandler() {
            super(MacTreeUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            MacTreeUI.this.firstPath = treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
            if (MacTreeUI.this.isLocationInExpandControl(treePath, n, n2)) {
                MacTreeUI.this.pressedOnControl = true;
                MacTreeUI.this.highlightControl = true;
                MacTreeUI.this.repaintControl(treePath);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TreePath treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
            MacTreeUI.this.highlightControl = false;
            if (MacTreeUI.this.pressedOnControl && treePath == MacTreeUI.this.firstPath && MacTreeUI.this.isLocationInExpandControl(treePath, n, n2)) {
                MacTreeUI.this.pressedOnControl = false;
                MacTreeUI.this.handleExpandControlClick(treePath, n, n2);
            } else {
                MacTreeUI.this.pressedOnControl = false;
                super.mouseReleased(mouseEvent);
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (MacTreeUI.this.pressedOnControl) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
                boolean bl = MacTreeUI.this.isLocationInExpandControl(treePath, n, n2);
                if (!MacTreeUI.this.highlightControl && treePath == MacTreeUI.this.firstPath && bl) {
                    MacTreeUI.this.highlightControl = true;
                    MacTreeUI.this.repaintControl(MacTreeUI.this.firstPath);
                } else if (MacTreeUI.this.highlightControl && !bl) {
                    MacTreeUI.this.highlightControl = false;
                    MacTreeUI.this.repaintControl(MacTreeUI.this.firstPath);
                }
            }
        }
    }
}

