/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DebugGraphics;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DebugGraphicsPanel
extends JPanel {
    SwingSet swing;
    JPanel components;
    JButton button = new JButton("Button");
    JRadioButton radio = new JRadioButton("RadioButton");
    JCheckBox check = new JCheckBox("Checkbox");
    JSlider slider = new JSlider(0, 0, 100, 50);
    JScrollBar scrollbar = new JScrollBar(0, 50, 20, 0, 100);
    JSlider flashSlider = new JSlider(0, 1, 50, 10);
    JCheckBox buttonCheckbox = new JCheckBox("Button");
    JCheckBox radioCheckbox = new JCheckBox("RadioButton");
    JCheckBox checkboxCheckbox = new JCheckBox("Checkbox");
    JCheckBox sliderCheckbox = new JCheckBox("Slider");
    JCheckBox scrollbarCheckbox = new JCheckBox("ScrollBar");
    DebugGraphicsListener debugGraphicsListener = new DebugGraphicsListener();
    ChangeListener sliderListener;

    public DebugGraphicsPanel(SwingSet swingSet) {
        this.swing = swingSet;
        this.sliderListener = new 1();
        this.flashSlider.addChangeListener(this.sliderListener);
        this.setBorder(SwingSet.emptyBorder5);
        this.setLayout(new BoxLayout(this, 0));
        this.components = SwingSet.createVerticalPanel(true);
        this.components.setBorder(SwingSet.emptyBorder10);
        this.button.setEnabled(false);
        this.radio.setEnabled(false);
        this.radio.setSelected(true);
        this.check.setEnabled(false);
        this.check.setSelected(true);
        JPanel jPanel = SwingSet.createHorizontalPanel(false);
        jPanel.setBorder(SwingSet.etchedBorder10);
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        JLabel jLabel = (JLabel)this.components.add(new JLabel("Buttons"));
        jLabel.setFont(swingSet.boldFont);
        jPanel.add(this.button);
        jPanel.add(Box.createRigidArea(SwingSet.hpad20));
        jPanel.add(this.radio);
        jPanel.add(Box.createRigidArea(SwingSet.hpad20));
        jPanel.add(this.check);
        this.components.add(jPanel);
        this.components.add(Box.createRigidArea(SwingSet.vpad20));
        this.slider.setEnabled(false);
        this.slider.setPaintTicks(true);
        this.slider.setMinorTickSpacing(10);
        this.slider.setMajorTickSpacing(40);
        this.slider.getAccessibleContext().setAccessibleName("Sample slider");
        2 var4_4 = new 2();
        var4_4.setLayout(new BoxLayout(var4_4, 0));
        var4_4.setBorder(SwingSet.etchedBorder10);
        var4_4.setAlignmentX(0.0f);
        var4_4.setAlignmentY(0.0f);
        jLabel = (JLabel)this.components.add(new JLabel("Slider"));
        jLabel.setFont(swingSet.boldFont);
        var4_4.add(this.slider);
        this.components.add(var4_4);
        this.components.add(Box.createRigidArea(SwingSet.vpad20));
        this.scrollbar.setEnabled(false);
        this.scrollbar.getAccessibleContext().setAccessibleName("Sample scrollbarlider");
        3 var5_5 = new 3();
        var5_5.setLayout(new BoxLayout(var5_5, 1));
        var5_5.setBorder(SwingSet.etchedBorder10);
        var5_5.setAlignmentX(0.0f);
        var5_5.setAlignmentY(0.0f);
        JPanel jPanel2 = SwingSet.createHorizontalPanel(false);
        jPanel2.add(Box.createRigidArea(SwingSet.hpad5));
        jPanel2.add(this.scrollbar);
        jPanel2.add(Box.createRigidArea(SwingSet.hpad5));
        jLabel = (JLabel)this.components.add(new JLabel("ScrollBar"));
        jLabel.setFont(swingSet.boldFont);
        var5_5.add(Box.createRigidArea(SwingSet.vpad5));
        var5_5.add(jPanel2);
        var5_5.add(Box.createRigidArea(SwingSet.vpad5));
        this.components.add(var5_5);
        this.components.add(Box.createRigidArea(SwingSet.vpad20));
        jLabel = (JLabel)this.components.add(new JLabel("Note: the above components are intentionally disabled."));
        this.components.add(Box.createRigidArea(SwingSet.vpad5));
        jLabel = (JLabel)this.components.add(new JLabel("Choose a component checkbox at right, then click on"));
        jLabel = (JLabel)this.components.add(new JLabel("the \"Repaint\" button to see debug graphics at work."));
        this.components.add(Box.createGlue());
        4 var7_7 = new 4();
        var7_7.setLayout(new BoxLayout(var7_7, 1));
        JPanel jPanel3 = SwingSet.createHorizontalPanel(true);
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = SwingSet.createVerticalPanel(false);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.setAlignmentY(0.0f);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createRigidArea(SwingSet.hpad20));
        jPanel3.add(Box.createRigidArea(SwingSet.hpad20));
        var7_7.add(jPanel3);
        jLabel = new JLabel("Use Debug Graphics On:");
        jPanel4.add(jLabel);
        jLabel.setFont(swingSet.boldFont);
        this.buttonCheckbox.addItemListener(this.debugGraphicsListener);
        this.buttonCheckbox.setToolTipText("Turns DebugGraphics on or off.");
        jPanel4.add(this.buttonCheckbox);
        this.radioCheckbox.addItemListener(this.debugGraphicsListener);
        this.radioCheckbox.setToolTipText("Turns DebugGraphics on or off.");
        jPanel4.add(this.radioCheckbox);
        this.checkboxCheckbox.addItemListener(this.debugGraphicsListener);
        this.checkboxCheckbox.setToolTipText("Turns DebugGraphics on or off.");
        jPanel4.add(this.checkboxCheckbox);
        this.sliderCheckbox.addItemListener(this.debugGraphicsListener);
        this.sliderCheckbox.setToolTipText("Turns DebugGraphics on or off.");
        jPanel4.add(this.sliderCheckbox);
        this.scrollbarCheckbox.addItemListener(this.debugGraphicsListener);
        this.scrollbarCheckbox.setToolTipText("Turns DebugGraphics on or off.");
        jPanel4.add(this.scrollbarCheckbox);
        jPanel4.add(Box.createRigidArea(SwingSet.vpad40));
        jLabel = new JLabel("Debug Flash Interval:");
        jLabel.setFont(swingSet.boldFont);
        jPanel4.add(jLabel);
        jPanel4.add(this.flashSlider);
        this.flashSlider.setMaximumSize(new Dimension(150, 60));
        this.flashSlider.setPaintTicks(true);
        this.flashSlider.setMinorTickSpacing(5);
        this.flashSlider.setMajorTickSpacing(20);
        this.flashSlider.setToolTipText("Sets the sleep time between graphics operations, from 1 to 50 milliseconds");
        this.flashSlider.getAccessibleContext().setAccessibleName("Debug Flash Interval");
        jPanel4.add(Box.createRigidArea(SwingSet.vpad40));
        JButton jButton = new JButton("Repaint");
        jButton.setToolTipText("Causes the selected components to be repainted using DebugGraphics.");
        jButton.addActionListener(this.debugGraphicsListener);
        jPanel4.add(jButton);
        jPanel4.add(Box.createGlue());
        this.add(this.components);
        this.add(Box.createRigidArea(SwingSet.hpad10));
        this.add(var7_7);
    }

    public void resetAll() {
        this.scrollbarCheckbox.setSelected(false);
        this.buttonCheckbox.setSelected(false);
        this.radioCheckbox.setSelected(false);
        this.sliderCheckbox.setSelected(false);
        this.checkboxCheckbox.setSelected(false);
    }

    private final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            DebugGraphics.setFlashTime(jSlider.getValue());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends JPanel {
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, 60);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends JPanel {
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, 60);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends JPanel {
        public Dimension getMaximumSize() {
            return new Dimension(300, super.getMaximumSize().height);
        }

        /* synthetic */ 4() {
        }
    }

    class DebugGraphicsListener
    implements ItemListener,
    ActionListener {
        boolean repaintButton = false;
        boolean repaintRadio = false;
        boolean repaintCheck = false;
        boolean repaintSlider = false;
        boolean repaintScrollBar = false;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JButton) {
                if (this.repaintButton) {
                    DebugGraphicsPanel.this.button.repaint();
                }
                if (this.repaintRadio) {
                    DebugGraphicsPanel.this.radio.repaint();
                }
                if (this.repaintCheck) {
                    DebugGraphicsPanel.this.check.repaint();
                }
                if (this.repaintSlider) {
                    DebugGraphicsPanel.this.slider.repaint();
                }
                if (this.repaintScrollBar) {
                    DebugGraphicsPanel.this.scrollbar.repaint();
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
            String string = abstractButton.getText();
            if (string.equals("Button")) {
                if (abstractButton.isSelected()) {
                    DebugGraphicsPanel.this.button.setDebugGraphicsOptions(2);
                    this.repaintButton = true;
                    return;
                }
                DebugGraphicsPanel.this.button.setDebugGraphicsOptions(-1);
                this.repaintButton = false;
                return;
            }
            if (string.equals("RadioButton")) {
                if (abstractButton.isSelected()) {
                    DebugGraphicsPanel.this.radio.setDebugGraphicsOptions(2);
                    this.repaintRadio = true;
                    return;
                }
                DebugGraphicsPanel.this.radio.setDebugGraphicsOptions(-1);
                this.repaintRadio = false;
                return;
            }
            if (string.equals("Checkbox")) {
                if (abstractButton.isSelected()) {
                    DebugGraphicsPanel.this.check.setDebugGraphicsOptions(2);
                    this.repaintCheck = true;
                    return;
                }
                DebugGraphicsPanel.this.check.setDebugGraphicsOptions(-1);
                this.repaintCheck = false;
                return;
            }
            if (string.equals("Slider")) {
                if (abstractButton.isSelected()) {
                    DebugGraphicsPanel.this.slider.setDebugGraphicsOptions(2);
                    this.repaintSlider = true;
                    return;
                }
                DebugGraphicsPanel.this.slider.setDebugGraphicsOptions(-1);
                this.repaintSlider = false;
                return;
            }
            if (string.equals("ScrollBar")) {
                if (abstractButton.isSelected()) {
                    DebugGraphicsPanel.this.scrollbar.setDebugGraphicsOptions(2);
                    this.repaintScrollBar = true;
                    return;
                }
                DebugGraphicsPanel.this.scrollbar.setDebugGraphicsOptions(-1);
                this.repaintScrollBar = false;
            }
        }

        DebugGraphicsListener() {
            DebugGraphicsPanel.this = DebugGraphicsPanel.this;
        }
    }
}

