/*
 * @(#)MacComboBoxUI.java	1.16 98/05/25
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import java.io.Serializable;
import java.beans.*;

                                          
/**
 * Mac UI for JComboBox
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.16 05/25/98
 * @author Tom Santos
 */
public class MacComboBoxUI extends BasicComboBoxUI {

    public static ComponentUI createUI(JComponent c) {
        return new MacComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        comboBox.setRequestFocusEnabled( false );
    }

    // This override should not be necessary but it is because BasicComboBoxUI
    // should check for a null arrow button before it does the comboBox.add( arrowButton).
    protected void installComponents() {
        arrowButton = createArrowButton();

        if ( arrowButton != null ) {
            comboBox.add( arrowButton );
        }

        if ( comboBox.isEditable() ) {
            addEditor();
        }

        comboBox.add( currentValuePane );
    }

    public void paint(Graphics g, JComponent c) {
        Insets insets = c.getInsets();

        hasFocus = comboBox.hasFocus();
        if ( !comboBox.isEditable() ) {
            Rectangle r = rectangleForCurrentValue();

            paintCurrentValueBackground(g,r,hasFocus);
            paintCurrentValue(g,r,hasFocus);
        }

        g.translate( insets.left, insets.top );

        paintBorder( g, c, insets );
        paintIcon( g, c, insets );

        g.translate( -insets.left, -insets.top );
    }

    protected void paintBorder( Graphics g, JComponent c, Insets insets ) {
        int right = (c.getWidth() - 1) - insets.right;
        int bottom = (c.getHeight() - 1) - insets.bottom;

        g.setColor( MacLookAndFeel.getBlack() );
        g.drawLine( 0, 2, 0, bottom - 2 );                            // left
        g.drawLine( 1, 1, 1, 1 );                                     // top left dot
        g.drawLine( 2, 0, right - 2, 0 );                             // top
        g.drawLine( right - 1, 1, right - 1, 1 );                     // top right dot
        g.drawLine( right, 2, right, bottom - 2 );                    // right
        g.drawLine( right - 1, bottom - 1, right - 1, bottom - 1 );   // bottom right dot
        g.drawLine( 2, bottom, right - 2, bottom );                   // bottom
        g.drawLine( 1, bottom - 1, 1, bottom - 1 );                   // bottom left dot

        int buttonLeft = right - getButtonWidth( insets );

        g.setColor( MacLookAndFeel.getWhite() );
        g.drawLine( 2, 1, buttonLeft - 1, 1 );
        g.drawLine( 1, 2, 1, bottom - 2 );

        g.setColor( MacLookAndFeel.getGray4() );
        g.drawLine( 2, bottom - 1, buttonLeft - 1, bottom - 1 );
    }

    protected void paintIcon( Graphics g, JComponent c, Insets insets ) {
        int right = (c.getWidth() - 1) - insets.right;
        int bottom = (c.getHeight() - 1) - insets.bottom;
        int left = getButtonLeft( insets );

        g.setColor( MacLookAndFeel.getWhite() );
        g.drawLine( left + 2, 2, left + 2, bottom - 3 );
        g.drawLine( left + 2, 2, right - 3, 2 );

        g.setColor( MacLookAndFeel.getGray4() );
        g.drawLine( left, 2, left, bottom - 1 );
        g.drawLine( left + 3, bottom - 2, right - 3, bottom - 2 );
        g.drawLine( right - 2, 3, right - 2, bottom - 2 );
        g.drawLine( right - 1, 2, right - 1, 2 );

        g.setColor( MacLookAndFeel.getGray3() );
        g.drawLine( right - 2, 1, right - 2, 1 );
        g.drawLine( left + 1, bottom - 1, left + 1, bottom - 1 );

        g.setColor( MacLookAndFeel.getGray7() );
        g.drawLine( right - 1, 2, right - 1, bottom - 2 );
        g.drawLine( right - 2, bottom - 2, right - 2, bottom - 2 );
        g.drawLine( left + 2, bottom - 1, right - 2, bottom - 1 );

        g.setColor( MacLookAndFeel.getBlack() );

        int arrowHeight = c.getHeight() / 4;
        int middle = c.getHeight() / 2;
        int arrowTop = (middle - Math.max(1, arrowHeight / 4)) - arrowHeight;
        int arrowStart = getButtonLeft() + (getButtonWidth( insets ) / 2);

        for ( int i = 0; i < arrowHeight; ++ i ) {
            g.drawLine( arrowStart - i, arrowTop + i, arrowStart + i, arrowTop + i );
        }

        int arrowBottom = (middle + Math.max(1, arrowHeight / 4) + arrowHeight) - 1;

        for ( int i = 0; i < arrowHeight; ++i ) {
            g.drawLine( arrowStart - i, arrowBottom - i, arrowStart + i, arrowBottom - i );
        }
    }

    protected ComboPopup createPopup() {
        return new MacComboPopup( comboBox );
    }

    protected JButton createArrowButton() {
        return null;
    }

    public boolean isFocusTraversable( JComboBox c ) {
        return false;
    }

    protected int getButtonLeft( Insets insets ) {
        int width = comboBox.getWidth();
        int height = comboBox.getHeight();

        return (width - 1) - (insets.right + getButtonWidth( insets ));
    }

    protected int getButtonLeft() {
        return getButtonLeft( comboBox.getInsets() );
    }

    protected int getButtonWidth( Insets insets ) {
       return getButtonWidth(insets, comboBox.getHeight());
    }

    protected int getButtonWidth(Insets insets, int prefHeight) {
       // The archetypical Mac combo box  has a right button that's 19 high and 21 wide.
       int h = (prefHeight - (insets.top + insets.bottom) );
       h *= 21;
       h /= 19;        
       return h;
    }
    protected int getButtonWidth() {
        return getButtonWidth( comboBox.getInsets() );
    }

    protected Rectangle rectangleForCurrentValue() {
        Insets insets = comboBox.getInsets();
        int height = comboBox.getHeight();
        return new Rectangle( insets.left + 2, insets.top + 2,
                              getButtonLeft( insets ) - (insets.left + 2),
                              height - (insets.top + insets.bottom + 4) );
    }

    public Dimension getMinimumSize( JComponent c ) {
        if ( !isMinimumSizeDirty ) {
           
            return new Dimension( cachedMinimumSize );
        }

        Dimension size = null;

        Insets insets = comboBox.getInsets();
        final int kTopAndBottomInsets = 2 + 2;                      // top + bottom

        if ( !comboBox.isEditable() ) {
            size = getDisplaySize();

            size.height += kTopAndBottomInsets + insets.top + insets.bottom;
            size.width += getButtonWidth( insets, size.height ) + insets.left + insets.right + 2; 
        }
        else if ( comboBox.isEditable() && editor != null ) {
            size = getDisplaySize();
            size.height = Math.max( editor.getMinimumSize().height, size.height );
            if ( editor instanceof JComponent ) {
                Insets editorInsets = ((JComponent)editor).getInsets();
                size.height += editorInsets.top + editorInsets.bottom;
            }
            size.height += kTopAndBottomInsets + insets.top + insets.bottom;
        }
        else {
            size = super.getMinimumSize( c );
        }

        cachedMinimumSize = size;
        isMinimumSizeDirty = false;

        return new Dimension( size );
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     */          
    public static class MacComboPopup extends BasicComboPopup {
        public MacComboPopup( JComboBox cBox ) {
            super( cBox );
        }

        protected void configureScroller() {
            super.configureScroller();
            ScrollPaneLayout layout = (ScrollPaneLayout)scroller.getLayout();
            layout.setVerticalScrollBarPolicy( ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER );
            layout.setHorizontalScrollBarPolicy( ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER );
            scroller.invalidate();
        }

        protected JScrollPane createScroller() {
            return new JScrollPane( list, ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER,
                                    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER );
        }

        protected Rectangle computePopupBounds(int px,int py,int pw,int ph) {
            Rectangle absBounds;
            boolean inModalDialog = inModalDialog();
            Rectangle bounds = comboBox.getBounds();
            int currentElementCount = comboBox.getModel().getSize();
            absBounds = new Rectangle( 0, py, pw, ph );

            if ( currentElementCount > 0 ) {
                Rectangle cellBounds = list.getCellBounds( 0, 0 );

                Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                int maxHeight = getPopupHeightForRowCount( currentElementCount );

                int selectedIndex = comboBox.getSelectedIndex();
                int selectedLocation = getPopupHeightForRowCount( selectedIndex + 1 ) - 2;
                selectedLocation -= cellBounds.height;

                Point top;
                Point bottom;

                if ( inModalDialog ) {
                   Dialog dialog = getDialog();
                   top = SwingUtilities.convertPoint( dialog, 0, 0, comboBox );
                   bottom = SwingUtilities.convertPoint( dialog,
                                                         0,
                                                         dialog.getSize().height - 1,
                                                         comboBox );
                }
                else {
                   top = new Point( 0, 0 );
                   SwingUtilities.convertPointFromScreen( top, comboBox );
                   bottom = new Point( 0, scrSize.height - 1 );
                   SwingUtilities.convertPointFromScreen( bottom, comboBox );
                }

                int theRest = maxHeight - selectedLocation;

                JViewport port = scroller.getViewport();
                Point viewPos = port.getViewPosition();

                // Test to see if the popup hits the top or the bottom of the screen.

                boolean scrollingNeededAtTop = top.y + selectedLocation > 0;
                boolean scrollingNeededAtBottom = theRest > bottom.y - 2;

                if ( scrollingNeededAtTop ) {
                    absBounds.y = top.y + 1;

                    int newViewPos = selectedLocation + top.y;
                    port.setViewPosition( new Point( viewPos.x, newViewPos ) );

                    if ( scrollingNeededAtBottom ) {
                        absBounds.height = scrSize.height - 4;
                    }
                    else {
                        absBounds.height = maxHeight - newViewPos;
                    }
                }
                else {
                    absBounds.y = -selectedLocation + 1;
                    port.setViewPosition( new Point( viewPos.x, 0 ) );

                    if ( scrollingNeededAtBottom ) {
                        absBounds.height = (bottom.y - absBounds.y) - 2;
                    }
                    else {
                        absBounds.height = maxHeight;
                    }
                }
            }
            else {
                return super.computePopupBounds( px, py, pw, ph );
            }

            return absBounds;
/*
            if ( SwingUtilities.isRectangleContainingRectangle(absBounds,r) )
                return r;
            else {
                Rectangle r2      = new Rectangle(0,-r.height,r.width,r.height);

                if ( SwingUtilities.isRectangleContainingRectangle(absBounds,r2) )
                    return r2;

                if ( inModalDialog ) {
                    SwingUtilities.computeIntersection(absBounds.x,absBounds.y,absBounds.width,absBounds.height,r);
                    SwingUtilities.computeIntersection(absBounds.x,absBounds.y,absBounds.width,absBounds.height,r2);
                    if ( r.height > r2.height )
                        return r;
                    else
                        return r2;
                }
                else
                    return r2;
            }
*/
        }

        public void show() {
            Dimension popupSize = comboBox.getSize();
            popupSize.setSize( popupSize.width, getPopupHeightForRowCount( comboBox.getMaximumRowCount() ) );
            Rectangle popupBounds = computePopupBounds( 0, comboBox.getBounds().height,
                                                        popupSize.width, popupSize.height);
            scroller.setMaximumSize( popupBounds.getSize() );
            scroller.setPreferredSize( popupBounds.getSize() );
            scroller.setMinimumSize( popupBounds.getSize() );
            list.invalidate();
            list.setSelectedIndex( comboBox.getSelectedIndex() );
            list.ensureIndexIsVisible( list.getSelectedIndex() );

            setLightWeightPopupEnabled( comboBox.isLightWeightPopupEnabled() );

            show( comboBox, popupBounds.x, popupBounds.y );
        }

        private Dialog getDialog() {
            Container parent;
            for ( parent = comboBox.getParent() ; parent != null && !(parent instanceof Dialog)
                && !(parent instanceof Window) ; parent = parent.getParent() );
            if ( parent instanceof Dialog )
                return (Dialog) parent;
            else
                return null;
        }

        private boolean inModalDialog() {
            return (getDialog() != null);
        }

        public void delegateFocus( MouseEvent e ) {}
    }
}









