/*
 * @(#)MacTabbedPaneUI.java	1.00 98/08/08
 *
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.plaf.*;
import java.io.Serializable;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

/**
 * The Mac subclass of BasicTabbedPaneUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.00 08/08/98
 * @author Luca Lutterotti
 */

public class MacTabbedPaneUI extends BasicTabbedPaneUI {

    protected int minTabWidth = 40;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color nonSelectColor;
    protected int slant = 6;

    public static ComponentUI createUI( JComponent x ) {
        return new MacTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();

        selectColor = UIManager.getColor("TabbedPane.selected");
        selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        nonSelectColor = UIManager.getColor("TabbedPane.nonSelected");
    }

    protected void paintTabBorder( Graphics g, int tabPlacement,
                                   int tabIndex, int x, int y, int w, int h,
                                   boolean isSelected) {
        int bottom = y + (h-1);
        int right = x + (w-1);

        switch ( tabPlacement ) {
        case TOP:
        default:
            paintTopTabBorder(tabIndex, g, x, y, w, h, bottom, right,
                              isSelected);
        }
    }


    protected void paintTopTabBorder( int tabIndex, Graphics g,
                                      int x, int y, int w, int h,
                                      int btm, int rght,
                                      boolean isSelected ) {
        int currentRun = getRunForTab( tabPane.getTabCount(), tabIndex );
        int lastIndex = lastTabInRun( tabPane.getTabCount(), currentRun );
        int firstIndex = tabRuns[ currentRun ];

        //
        // Paint Gap
        //

        int bottom = h - 1;
        int right = w - 1;

        if ( shouldFillGap( currentRun, tabIndex, x, y ) ) {
            g.translate( x, y );

            g.setColor( nonSelectColor );
            int xc[] = new int[4];
            int yc[] = new int[4];

            xc[0] = 1;
            xc[1] = slant;
            xc[2] = slant+4;
            xc[3] = 1;
            yc[0] = h-1;
            yc[1] = 3;
            yc[2] = 0;
            yc[3] = 0;
            g.fillPolygon(new Polygon(xc,yc,4));

            xc[0] = right+1;
            xc[1] = right-slant;
            xc[2] = right-(slant+4);
            xc[3] = right+1;
            yc[0] = h-1;
            yc[1] = 3;
            yc[2] = 0;
            yc[3] = 0;
            g.fillPolygon(new Polygon(xc,yc,4));
            g.drawLine( 0,bottom-3, 0,0 );

            g.translate( -x, -y );

            int width = tabPane.getWidth();

            if (tabIndex == firstIndex) {
                xc[0] = 0;
                xc[1] = x;
                xc[2] = x;
                xc[3] = 0;
                yc[0] = y;
                yc[1] = y;
                yc[2] = y+h;
                yc[3] = y+h;
                g.fillPolygon(new Polygon(xc,yc,4));
            }
            if (tabIndex == lastIndex) {
                xc[0] = x+w;
                xc[1] = width;
                xc[2] = width;
                xc[3] = x+w;
                yc[0] = y;
                yc[1] = y;
                yc[2] = y+h;
                yc[3] = y+h;
                g.fillPolygon(new Polygon(xc,yc,4));
            }

            if (tabIndex == firstIndex) {
                g.setColor( MacLookAndFeel.getBlack() );
                g.drawLine( 0,y, x,y );
                g.setColor( MacLookAndFeel.getGray1() );
                g.drawLine( 0,y+1, x,y+1 );
            }
            if (tabIndex == lastIndex) {
                g.setColor( MacLookAndFeel.getBlack() );
                g.drawLine( x+w,y, width,y );
                g.setColor( MacLookAndFeel.getGray1() );
                g.drawLine( x+w,y+1, width,y+1 );
            }
        }

        g.translate( x, y );

        //
        // Paint Border
        //

        g.setColor( MacLookAndFeel.getGray0() );

        g.drawLine( 1,bottom-1, slant+1,3 );
        g.drawLine( slant+1,3 , slant+2,2 );
        g.drawLine( slant+2,2 , slant+4,1 );
        g.drawLine( slant+4,1, right-(slant+4),1 );
        g.setColor( MacLookAndFeel.getGray7() );
        g.drawLine( right-(slant+4),1 , right-(slant+2),2 );
        g.drawLine( right-(slant+2),2 , right-slant-1,3 );
        g.drawLine( right-slant-1,3 , right-1,bottom-1 );

        g.setColor( MacLookAndFeel.getBlack() );

        g.drawLine( 0,bottom, slant,3 );
        g.drawLine( slant,3 , slant+1,2 );
        g.drawLine( slant+2,1 , slant+4,0 );
        g.drawLine( slant+4,0, right-(slant+4),0 );
        g.drawLine( right-(slant+4),0 , right-(slant+2),1 );
        g.drawLine( right-(slant+1),2 , right-slant,3 );
        g.drawLine( right-slant,3 , right,bottom );

        g.translate( -x, -y );
    }

    protected boolean shouldFillGap( int currentRun, int tabIndex, int x,
                                     int y ) {

        if ( currentRun < runCount - 1 )  // If it's not the last row.
            return true;
        else
            return false;
    }

    protected void paintTabBackground( Graphics g, int tabPlacement,
                                       int tabIndex, int x, int y, int w,
                                       int h, boolean isSelected ) {
        int slantWidth = h / 2;
        if ( isSelected ) {
            g.setColor( tabPane.getBackground() );
        } else {
            g.setColor( nonSelectColor );
        }
        switch ( tabPlacement ) {
        case TOP:
        default:
            g.translate( x, y );
            int xc[] = new int[4];
            int yc[] = new int[4];

            xc[0] = 1;
            xc[1] = slant+1;
            xc[2] = w-xc[1];
            xc[3] = w-1;
            yc[0] = h;
            yc[1] = 3;
            yc[2] = yc[1];
            yc[3] = yc[0];
            g.fillPolygon(new Polygon(xc,yc,4));

            xc[0] = slant+1;
            xc[1] = slant+3;
            xc[2] = w-xc[1];
            xc[3] = w-xc[0];
            yc[0] = 3;
            yc[1] = 1;
            yc[2] = yc[1];
            yc[3] = yc[0];
            g.fillPolygon(new Polygon(xc,yc,4));

            g.translate( -x, -y );
        }
    }

    /**
     * Overidden to do nothing for the Java L&F.
     */
    protected int getTabLabelShiftX( int tabPlacement, int tabIndex,
                                     boolean isSelected ) {
        return 0;
    }


    /**
     * Overidden to do nothing for the Java L&F.
     */
    protected int getTabLabelShiftY( int tabPlacement, int tabIndex,
                                     boolean isSelected ) {
        return 0;
    }


    public void paint( Graphics g, JComponent c ) {
        int tabPlacement = tabPane.getTabPlacement();

        Insets insets = c.getInsets();
        Dimension size = c.getSize();

        // Paint the background for the tab area
        if ( tabPane.isOpaque() ) {
            g.setColor( c.getBackground() );
            switch ( tabPlacement ) {
            case TOP:
            default:
                g.fillRect( insets.left, insets.top,
                            size.width - insets.right - insets.left,
                            calculateTabAreaHeight(tabPlacement, runCount,
                                                   maxTabHeight) );
                paintHighlightBelowTab();
            }
        }

        super.paint( g, c );
    }

    protected void paintHighlightBelowTab( ) {

    }


    protected void paintFocusIndicator(Graphics g, int tabPlacement,
                                       Rectangle[] rects, int tabIndex,
                                       Rectangle iconRect, Rectangle textRect,
                                       boolean isSelected) {
    }


    protected void paintContentBorderTopEdge( Graphics g, int tabPlacement,
                                              int selectedIndex,
                                              int x, int y, int w, int h ) {
        g.setColor( MacLookAndFeel.getBlack() );

        Rectangle selRect = rects[selectedIndex];

        g.drawLine(x, y, selRect.x - 1, y);
        if (selRect.x + selRect.width < x + w - 2)
            g.drawLine(selRect.x + selRect.width, y,
                       x+w-2, y);

        g.setColor( MacLookAndFeel.getGray1() );

        g.drawLine(x, y+1, selRect.x - 1, y+1);
        if (selRect.x + selRect.width < x + w - 2)
            g.drawLine(selRect.x + selRect.width, y+1,
                       x+w-2, y+1);
    }


    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement,
                                                int selectedIndex,
                                                int x, int y, int w, int h) {
        g.setColor( MacLookAndFeel.getBlack() );
        g.drawLine( x, y+(h-1), x+(w-1), y+(h-1) );

        g.setColor( MacLookAndFeel.getGray6() );
        g.drawLine( x+1, y+(h-1)-1, x+(w-1)-1, y+(h-1)-1 );
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement,
                                              int selectedIndex,
                                              int x, int y, int w, int h) {
        g.setColor( MacLookAndFeel.getBlack() );
        g.drawLine( x, y, x, y+(h-1) );

        g.setColor( MacLookAndFeel.getGray1() );
        g.drawLine( x+1, y+1, x+1, y+(h-1)-1 );
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement,
                                               int selectedIndex,
                                               int x, int y, int w, int h) {
        g.setColor( MacLookAndFeel.getBlack() );
        g.drawLine( x+(w-1), y, x+(w-1), y+(h-1) );

        g.setColor( MacLookAndFeel.getGray6() );
        g.drawLine( x+(w-1)-1, y+1, x+(w-1)-1, y+(h-1)-1 );
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int
                                     fontHeight) {
        int height = fontHeight;
        Icon icon = getIconForTab(tabIndex);
        Insets tabInsets = getTabInsets(tabPlacement, tabIndex);

        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        height += tabInsets.top + tabInsets.bottom;

        return height;
    }

    protected int calculateMaxTabHeight( int tabPlacement ) {
        FontMetrics metrics = getFontMetrics();
        int height = metrics.getHeight();
        boolean tallerIcons = false;

        for ( int i = 0; i < tabPane.getTabCount(); ++i ) {
            Icon icon = tabPane.getIconAt( i );
            if ( icon != null ) {
                if ( icon.getIconHeight() > height ) {
                    tallerIcons = true;
                    break;
                }
            }
        }
        return super.calculateMaxTabHeight( tabPlacement ) -
        (tallerIcons ? (tabInsets.top + tabInsets.bottom) : 0);
    }


    protected int calculateTabWidth(int tabPlacement, int tabIndex,
                                    FontMetrics metrics) {
        String title = tabPane.getTitleAt(tabIndex);
        Icon icon = getIconForTab(tabIndex);
        Insets tabInsets = getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 5;

        if (icon != null) {
            width += icon.getIconWidth() + textIconGap;
        }
        width += SwingUtilities.computeStringWidth(metrics, title);

        return width;
    }

    protected int getTabRunOverlay( int tabPlacement ) {
        return 0;
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of MetalTabbedPaneUI.
     */
    public class TabbedPaneLayout extends BasicTabbedPaneUI.TabbedPaneLayout {

        // Don't pad selected tab
        protected void padSelectedTab( int tabPlacement, int selectedIndex ) {}}}
