/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.util.Encoder;
import com.imaginary.util.NoSuchEncoderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class MsqlPreparedStatement
extends MsqlStatement
implements PreparedStatement {
    private String[] constants = null;
    private int parsing = 0;
    private String statement = null;
    private String[] values = null;

    MsqlPreparedStatement(MsqlConnection msqlConnection, String string, int n) {
        this(msqlConnection, string, 1003, 1007, n);
    }

    MsqlPreparedStatement(MsqlConnection msqlConnection, String string, int n, int n2, int n3) {
        super(msqlConnection, n, n2, n3);
        this.statement = string;
        Thread thread = new Thread(){

            public void run() {
                MsqlPreparedStatement.this.parseSQL();
            }
        };
        thread.setPriority(4);
        thread.start();
    }

    public void addBatch() throws SQLException {
        this.addBatch(this.getSQL());
        this.clearParameters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearParameters() throws SQLException {
        MsqlPreparedStatement msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            while (this.parsing != 2) {
                try {
                    this.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        int n = 0;
        while (n < this.values.length) {
            this.values[n] = null;
            ++n;
        }
    }

    public boolean execute() throws SQLException {
        return this.execute(this.getSQL());
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.getSQL());
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.getSQL());
    }

    static String fixString(String string) {
        if (string.indexOf("'") != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '%': 
                    case '\'': 
                    case '_': {
                        stringBuffer.append('\\');
                        break;
                    }
                }
                stringBuffer.append(c);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new MsqlException("This operation is not yet supported.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSQL() throws SQLException {
        MsqlPreparedStatement msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            while (this.parsing != 2) {
                try {
                    this.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        String string = this.constants[0];
        int n = 0;
        while (n < this.values.length) {
            if (this.values[n] == null) {
                throw new MsqlException("No value set for parameter " + (n + 1) + ".");
            }
            string = String.valueOf(string) + this.values[n];
            if (n + 1 < this.constants.length) {
                string = String.valueOf(string) + this.constants[n + 1];
            }
            ++n;
        }
        return string;
    }

    private void parseSQL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.statement;
        int n = 0;
        MsqlPreparedStatement msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            if (this.parsing != 0) {
                Object var6_5 = null;
                return;
            }
            this.parsing = 1;
        }
        while (true) {
            int n2;
            if ((n2 = string.indexOf("?")) < 0) break;
            ++n;
            if (n2 == 0) {
                arrayList.add("");
            } else {
                arrayList.add(string.substring(0, n2));
            }
            if (n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
                continue;
            }
            string = "";
        }
        arrayList.add(string);
        this.values = new String[n];
        this.constants = new String[arrayList.size()];
        arrayList.toArray(this.constants);
        msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            this.parsing = 2;
            this.notifyAll();
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = array.toString();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateIndex(n);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            this.values[n - 1] = new String(byArray, "8859_1");
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = bigDecimal.toString();
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
        this.setBytes(n, byArray);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            throw new MsqlException("Binary length too long for mSQL.");
        }
        this.setBinaryStream(n, blob.getBinaryStream(), (int)l);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = bl ? "1" : "0";
    }

    public void setByte(int n, byte by) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.validateIndex(n);
        try {
            Encoder encoder = Encoder.getInstance(1);
            byArray = encoder.encode(byArray);
            this.setString(n, new String(byArray, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
        catch (NoSuchEncoderException noSuchEncoderException) {
            throw new MsqlException(noSuchEncoderException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        char[] cArray = new char[n2];
        this.validateIndex(n);
        try {
            reader.read(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
        this.values[n - 1] = MsqlPreparedStatement.fixString(new String(cArray));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new MsqlException("CLOBs are not supported in mSQL.");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.validateIndex(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        this.values[n - 1] = "'" + simpleDateFormat.format(date) + "'";
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.validateIndex(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        this.values[n - 1] = "'" + simpleDateFormat.format(date) + "'";
    }

    public void setDouble(int n, double d) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(d);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = "NULL";
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = "NULL";
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof String) {
            this.setString(n, object.toString());
        } else if (object instanceof StringBuffer) {
            this.setString(n, object.toString());
        } else {
            this.setObject(n, object, -2);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case -7: {
                String string = object.toString();
                if (string.length() < 1) {
                    this.setByte(n, (byte)0);
                } else {
                    byte by = (byte)string.charAt(0);
                    this.setByte(n, by);
                }
                return;
            }
            case -6: 
            case 5: {
                this.setShort(n, Short.parseShort(object.toString()));
                return;
            }
            case 4: {
                this.setInt(n, Integer.parseInt(object.toString()));
                return;
            }
            case -5: {
                this.setLong(n, Long.parseLong(object.toString()));
                return;
            }
            case 6: 
            case 7: {
                float f = Float.valueOf(object.toString()).floatValue();
                this.setFloat(n, f);
                return;
            }
            case 8: {
                double d = Double.valueOf(object.toString());
                this.setDouble(n, d);
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(n, new BigDecimal(object.toString()));
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                return;
            }
            case 91: 
            case 92: {
                String string = object.toString();
                String string2 = n2 == 91 ? "dd-MMM-yyyy" : "HH:mm:ss";
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
                    if (n2 == 91) {
                        this.setDate(n, (Date)simpleDateFormat.parse(string));
                    } else {
                        this.setTime(n, (Time)simpleDateFormat.parse(string));
                    }
                }
                catch (ParseException parseException) {
                    throw new MsqlException(parseException);
                }
                return;
            }
            case 93: {
                Timestamp timestamp = new Timestamp(Long.parseLong(object.toString()));
                this.setTimestamp(n, timestamp);
                return;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (object instanceof Blob) {
                    this.setBlob(n, (Blob)object);
                } else if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                } else if (object instanceof Serializable) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        this.setBytes(n, byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new MsqlException(iOException);
                    }
                } else {
                    throw new MsqlException("Invalid binary object type.");
                }
                return;
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: {
                throw new MsqlException("UDTs are not supported.");
            }
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new MsqlException("Refs are not supported in mSQL.");
    }

    public void setShort(int n, short s) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(s);
    }

    public void setString(int n, String string) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = "'" + MsqlPreparedStatement.fixString(string) + "'";
    }

    public void setTime(int n, Time time) throws SQLException {
        this.validateIndex(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        this.values[n - 1] = "'" + simpleDateFormat.format(time) + "'";
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.validateIndex(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        this.values[n - 1] = "'" + simpleDateFormat.format(time) + "'";
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setLong(n, ((java.util.Date)timestamp).getTime());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setLong(n, ((java.util.Date)timestamp).getTime());
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateIndex(n);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            this.values[n - 1] = new String(byArray, "UTF8");
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateIndex(int n) throws SQLException {
        MsqlPreparedStatement msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            while (this.parsing != 2) {
                try {
                    this.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (n < 1) {
            throw new MsqlException("Cannot address an index less than 1.");
        }
        if (n > this.values.length) {
            throw new MsqlException("Attempted to assign a value to parameter " + n + " when there are " + "only " + this.values.length + " parameters.");
        }
    }
}

