/* $Id: MsqlAsciiInputStream.java,v 2.1 1999/07/06 05:50:52 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.UnsupportedEncodingException;

/**
 * An MsqlAsciiInputStream is used for the JDBC ResultSet getAsciiStream()
 * method to represent an ascii stream from a query.<BR>
 * Last modified $Date: 1999/07/06 05:50:52 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlAsciiInputStream extends FilterInputStream {
    /**
     * Constructs an MsqlAsciiInputStream.
     * @param data the byte array representing the data to be streamed
     */
    public MsqlAsciiInputStream(byte[] data) {
	super(new ByteArrayInputStream(data));
    }

    /**
     * Constructs an MsqlAsciiInputStream for a string.
     * @param data the String to create a stream for
     * @throws java.io.UnsupportedEncodingException this should never
     * actually get thrown
     */
    public MsqlAsciiInputStream(String data)
    throws UnsupportedEncodingException {
	this(data.getBytes("8859_1"));
    }
}
