/* $Id: MsqlColumn.java,v 2.1 1999/07/06 05:50:53 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.sql.SQLException;
import java.sql.Types;

/**
 * This class holds meta information about mSQL columns in a result set.
 * <BR>
 * Last modified $Date: 1999/07/06 05:50:53 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlColumn {
    // the database name
    private String  catalog    = null;
    // the name of the column
    private String  columnName = null;
    // the max length of the column
    private int     length     = 0;
    // the mSQL type for the column
    private int     msqlType   = MsqlTypes.CHAR;
    // is the column nullable?
    private boolean nullable   = false;
    // is this column part of the primary key?
    private boolean primaryKey = false;
    // the name of the table this column originates from
    private String  tableName  = null;

    /**
     * Constructs an <CODE>MsqlColumn</CODE> object from the specified row.
     * @param cat the database name from which the column comes
     * @param row the row containing the column meta-data
     * @throws java.sql.SQLException could not read the row data
     */
    MsqlColumn(String cat, ParsedRow row) throws SQLException {
	super();
	{
	    tableName = row.get(0);
	    columnName = row.get(1);
	    msqlType = Integer.parseInt(row.get(2));
	    length = Integer.parseInt(row.get(3));
	    try {
		String tmp = row.get(4);
		    
		if( tmp.equals("Y") ) {
		    nullable = false;
		}
		else {
		    nullable = true;
		}
	    }
	    catch( IndexOutOfBoundsException e ) {
		nullable = true;
	    }
	    try {
		String tmp = row.get(5);
		    
		if( tmp.equals("Y") ) {
		    primaryKey = true;
		}
		else {
		    primaryKey = false;
		}
	    }
	    catch( IndexOutOfBoundsException e ) {
		primaryKey = false;
	    }
	}
    }

    /**
     * @return the name of this column
     */
    public String getColumnName() {
	return columnName;
    }

    /**
     * @return the maximum length for this column
     */
    public int getLength() {
	return length;
    }

    /**
     * @return the mSQL type for this column from <CODE>MsqlTypes</CODE>
     * @see com.imaginary.sql.msql.MsqlTypes
     */
    public int getMsqlType() {
	return msqlType;
    }

    /**
     * @return the SQL type for this column from <CODE>Types</CODE>
     * @see java.sql.Types
     */
    public int getSQLType() {
       return MsqlTypes.getSQLTypeForMsql(msqlType);
    }

    /**
     * @return the name of the table from which this column comes
     */
    public String getTableName() {
	return tableName;
    }

    /**
     * @deprecated use <CODE>getSQLType()</CODE>
     * @see com.imaginary.sql.msql.MsqlColumn#getSQLType()
     */
    int getType() {
	return getSQLType();
    }

    /**
     * @return true if this column is nullable, false otherwise
     */
    public boolean isNullable() {
	return nullable;
    }

    /**
     * @return true if this column is part of a unique index
     */
    public boolean isPrimaryKey() {
	return primaryKey;
    }
}
