/* $Id: MsqlInputStream.java,v 2.2 1998/10/25 18:05:20 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.IOException;

/**
 * The MsqlInputStream class handles communication between the mSQL database
 * and the JDBC implementation.<BR>
 * Last modified $Date: 1998/10/25 18:05:20 $
 * @version $Revision: 2.2 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlInputStream {
    private DataInputStream input;

    /**
     * Constructs an MsqlInputStream using an InputStream from
     * a socket connecting the driver to the database.
     * @param in the InputStream representing data form the database
     * @exception java.io.IOException an error occurred creating
     * a DataInputStream for the InputStream
     */
    public MsqlInputStream(InputStream in) throws IOException {
	super();
	input = new DataInputStream(new BufferedInputStream(in));
    }

    /**
     * Closes the stream.
     * @exception java.io.IOException an error occurred closing the stream
     */
    public void close() throws IOException {
	input.close();
    }

    /**
     * Reads data from the mSQL database as an array of bytes.
     * @return data from the database as an array of bytes
     * @exception java.io.IOException an error occured on read
     */
    public byte[] read() throws IOException {
	byte[] bytes;
	int size = 0;

	for(int i=0; i<4; i++) {
	    int b = input.read();
	    
	    if( i > 0 ) {
		size += b<<(i*8);
	    }
	    else {
		size += b;
	    }
	}
	bytes = new byte[size];
	input.readFully(bytes);
	return bytes;
    }

    /**
     * Instead of reading data raw, you can read it using the specified
     * encoding.
     * param encoding the encoding to use for the character set
     * @return the string from the database
     * @exception java.io.IOException an error occurred on read
     */
    public String readString(String encoding) throws IOException {
	return new String(read(), encoding);
    }
}
