(*  Copyright (c) John Gough 1999, 2000.			*)
MODULE ShowSyms;
  IMPORT 
	GPCPcopyright,
	RTS,
	CPmain,
	Console,
	ProgArgs,

	D := Symbols, 
	IdDesc, 
	TypeDesc,
	ExprDesc,
	Builtin,
	Visitor,

	GPText,
	LitValue,
	SymFileRW,
	CompState,
	FileNames,
	NameHash;

(* -------------------------------------------------------------------- *)

  VAR 	argN	: INTEGER;
	html	: BOOLEAN;
	junk	: BOOLEAN;
	modD	: IdDesc.BlkId;
	impD	: IdDesc.BlkId;
	name    : FileNames.NameString;
	symF    : SymFileRW.SymFileReader;

(* -------------------------------------------------------------------- *)
(* -------------  Extensions of SymForAll Visitor Pattern ------------- *)
(* -------------------------------------------------------------------- *)

  TYPE	ImportForAll* = POINTER TO RECORD (D.SymForAll) num : INTEGER END;
	ProcForAll*   = POINTER TO RECORD (D.SymForAll) num : INTEGER END;
	TypeForAll*   = POINTER TO RECORD (D.SymForAll) num : INTEGER END;
	ConstForAll*  = POINTER TO RECORD (D.SymForAll) 
			  num : INTEGER;
			  ind : INTEGER;
			  stt : BOOLEAN;
			END;
	VarForAll*    = POINTER TO RECORD (D.SymForAll) 
			  num : INTEGER;
			  ind : INTEGER;
			  wrk : D.IdSeq;
			  stt : BOOLEAN;
			END;


(* -------------------------------------------------------------------- *)

  PROCEDURE WriteComment(IN strng : ARRAY OF CHAR);
  BEGIN
    Console.WriteString("(* ");
    Console.WriteString(strng);
    Console.WriteString(" *)");
    Console.WriteLn;
  END WriteComment;

  (* ---------------------------------- *)

  PROCEDURE isSyntheticTypId(typId : D.Idnt) : BOOLEAN;
 (* Most types in symbols files have names, even if totally	*)
 (* synthetic.  The convention is synthetic ones start with '$'	*)
  BEGIN
    RETURN (typId = NIL) OR
(*
 *	   (typId.dfScp = NIL) OR
 *)
	   (NameHash.charOpenOfHash(typId.hash)[0] = '$') OR
	   ((typId.type # NIL) &
	    (typId.type IS TypeDesc.Record) &
	    (Symbols.anon IN typId.type(TypeDesc.Record).xAttr));
  END isSyntheticTypId;

(* -------------------------------------------------------------------- *)

  PROCEDURE NameLength(id : D.Idnt) : INTEGER;
  BEGIN
    RETURN LEN(NameHash.charOpenOfHash(id.hash)); 
  END NameLength;

(* -------------------------------------------------------------------- *)

  PROCEDURE WriteName(id : D.Idnt);
  BEGIN
    Console.WriteString(NameHash.charOpenOfHash(id.hash)); 
    Console.Write(D.modMrk[id.vMod]);
  END WriteName;

(* -------------------------------------------------------------------- *)

  PROCEDURE WriteTypename(ty : D.Type);
    VAR id : D.Idnt;
  BEGIN
    IF ty = NIL THEN 
      Console.WriteString("no-type");
    ELSE
      Console.WriteString(ty.name()); 
    END;
  END WriteTypename;

(* -------------------------------------------------------------------- *)

  PROCEDURE WriteIndent(in : INTEGER);
  BEGIN
    WHILE in >= 8 DO 
      Console.Write("	"); DEC(in, 8);
    END;
    WHILE in > 0 DO 
      Console.Write(" "); DEC(in);
    END;
  END WriteIndent;

(* -------------------------------------------------------------------- *)

  PROCEDURE WriteFormals(ty : TypeDesc.Procedure; in : INTEGER);
    VAR index : INTEGER;

   (* ---------------------------------- *)

    PROCEDURE WriteFormal(ty : TypeDesc.Procedure; ix : INTEGER);
      VAR thisP : IdDesc.ParId;
    BEGIN
      thisP := ty.formals.a[ix];
      Console.WriteString(D.modStr[thisP.parMod]);
      Console.Write("p"); 
      Console.WriteInt(ix, 1); 
      Console.WriteString(" : ");
      WriteTypename(thisP.type);
    END WriteFormal;

   (* ---------------------------------- *)

  BEGIN
    Console.Write("("); 
    IF ty.formals.tide > 0 THEN WriteFormal(ty, 0) END;
    FOR index := 1 TO ty.formals.tide - 1 DO
      Console.Write(";");
      Console.WriteLn;
      WriteIndent(in + 1);
      WriteFormal(ty, index);
    END;
    Console.Write(")"); 
    IF ty.retType # NIL THEN
      Console.WriteString(" : ");
      WriteTypename(ty.retType);
    END;
  END WriteFormals;

(* -------------------------------------------------------------------- *)

  (* ---------------------------------- *)
  PROCEDURE^ WriteTypeStructure(ty : D.Type; in : INTEGER);
  PROCEDURE^ Constants(symTb : D.SymbolTable);
  PROCEDURE^ StatConstants(symTb : D.SymbolTable; in : INTEGER);
  PROCEDURE^ Vars(symTb : D.SymbolTable);
  PROCEDURE^ StatVars(symTb : D.SymbolTable; in : INTEGER);
  PROCEDURE^ StatProcs(symTb : D.SymbolTable);

  (* ---------------------------------- *)

  PROCEDURE WriteType(ty : D.Type; in : INTEGER);
  BEGIN
    IF isSyntheticTypId(ty.idnt) THEN
      WriteTypeStructure(ty, in);
    ELSE
      WriteTypename(ty);
      Console.Write(";");
    END;
  END WriteType;

  (* ---------------------------------- *)

  PROCEDURE WriteTypeStructure(ty : D.Type; in : INTEGER);
    VAR eT : TypeDesc.Enum;
	aT : TypeDesc.Array;
	rT : TypeDesc.Record;
	pT : TypeDesc.Pointer;
	isAlias : BOOLEAN;

  (* ---------------------------------- *)

    PROCEDURE WriteRecordAttributes(att : INTEGER);
    BEGIN
      CASE att OF
      | TypeDesc.isAbs : Console.WriteString("ABSTRACT ");
      | TypeDesc.extns : Console.WriteString("EXTENSIBLE ");
      | TypeDesc.limit : Console.WriteString("LIMITED ");
      | TypeDesc.iFace : Console.WriteString("INTERFACE ");
      ELSE
      END;
    END WriteRecordAttributes;

  (* ---------------------------------- *)

    PROCEDURE WriteMethodAttributes(att : SET);
    BEGIN
      IF IdDesc.isNew * att # {} THEN Console.WriteString(",NEW") END;
      att := att * IdDesc.mask;
      IF IdDesc.isAbs = att THEN
	Console.WriteString(",ABSTRACT");
      ELSIF IdDesc.empty = att THEN
	Console.WriteString(",EMPTY");
      ELSIF IdDesc.extns = att THEN
	Console.WriteString(",EXTENSIBLE ");
      END;
    END WriteMethodAttributes;

  (* ---------------------------------- *)

    PROCEDURE WriteFields(rt : TypeDesc.Record; in : INTEGER);
      VAR index : INTEGER;
	  field : D.Idnt;
    BEGIN
      FOR index := 0 TO rt.fields.tide - 1 DO
	field := rt.fields.a[index];
	WriteIndent(in);
	WriteName(field);
	Console.WriteString(" : ");
	WriteType(field.type, in+2);
	Console.WriteLn;
      END;
    END WriteFields;

  (* ---------------------------------- *)

    PROCEDURE WriteMethods(rt : TypeDesc.Record; in : INTEGER);
      VAR index  : INTEGER;
	  seqIdn : D.Idnt;
	  method : IdDesc.MthId;
    BEGIN
      FOR index := 0 TO rt.methods.tide - 1 DO
	seqIdn := rt.methods.a[index];
	method := seqIdn(IdDesc.MthId);
	WriteIndent(in);
	Console.WriteString("PROCEDURE (");
	Console.WriteString(D.modStr[method.rcvFrm.parMod]);
	Console.WriteString("self : ");
	WriteTypename(method.rcvFrm.type);
	Console.Write(")");
	WriteName(method);
	IF method.prcNm # NIL THEN
	  Console.WriteString('["');
	  Console.WriteString(method.prcNm);
	  Console.WriteString('"]');
	END;
(*
 *    WriteFormals(i.type(TypeDesc.Procedure), LEN(str) + NameLength(i));
 *)
	WriteFormals(method.type(TypeDesc.Procedure), in);
	WriteMethodAttributes(method.mthAtt);
	Console.Write(";");
	Console.WriteLn;
      END;
    END WriteMethods;

  (* ---------------------------------- *)

  BEGIN
    isAlias :=  (ty.idnt # NIL) &
		(ty.idnt.dfScp # NIL) &
		(ty.idnt.dfScp # impD);
    IF isAlias THEN
      WriteTypename(ty); 
      Console.Write(";");
      Console.WriteLn;
      WriteIndent(in);
      Console.WriteString("(* -----  really  ------ *");
      Console.WriteLn;
      INC(in,4);
      WriteIndent(in);
    END;
    CASE ty.kind OF
    | TypeDesc.recTp :
	rT := ty(TypeDesc.Record);
        IF ~(Symbols.clsTp IN rT.xAttr) THEN 
					Console.WriteString("(* VALUE *) ") END;
	WriteRecordAttributes(rT.recAtt);
	Console.WriteString("RECORD ");
	(* basetype !!! *)
	IF rT.baseTp # NIL THEN
	  Console.Write("("); 
	  WriteTypename(rT.baseTp); 
	  Console.Write(")");
	END;
	IF    D.fnInf IN rT.xAttr THEN Console.WriteString(" (* foreignInf *)");
	ELSIF D.isFn  IN rT.xAttr THEN Console.WriteString(" (* foreignCls *)");
	END;
	IF rT.fields.tide > 0 THEN
	  Console.WriteLn;
	  WriteFields(rT, in + 2);
	  WriteIndent(in);
	ELSE
	  Console.Write(" "); 
	END;
	IF    D.isFn IN rT.xAttr THEN 
	  IF rT.fields.tide = 0 THEN Console.WriteLn; WriteIndent(in) END;
	  Console.WriteString("STATIC"); Console.WriteLn;
	  StatConstants(rT.symTb, in+2);
	  StatVars(rT.symTb, in+2);
	  StatProcs(rT.symTb);
	  WriteIndent(in);
        END;
	Console.WriteString("END;");
	IF rT.methods.tide > 0 THEN
	  Console.WriteLn; 
	  WriteIndent(in); 
	  Console.Write("{"); 
	  Console.WriteLn;
	  WriteMethods(rT, in + 2);
	  WriteIndent(in); 
	  Console.Write("}");
	END;
    | TypeDesc.enuTp :
	Console.WriteString("ENUM ");
	eT := ty(TypeDesc.Enum);
	Console.WriteLn;
	StatConstants(eT.symTb, in+2);
	WriteIndent(in);
	Console.WriteString("END;");
    | TypeDesc.ptrTp :
	pT := ty(TypeDesc.Pointer);
	Console.WriteString("POINTER TO ");
	WriteType(pT.boundTp, in);
    | TypeDesc.prcTp :
	Console.WriteString("PROCEDURE");
	WriteFormals(ty(TypeDesc.Procedure), in + 2);
	Console.Write(";");
    | TypeDesc.arrTp :
	aT := ty(TypeDesc.Array);
	Console.WriteString("ARRAY");
	IF aT.length # 0 THEN Console.WriteInt(aT.length, 0) END;
	Console.WriteString(" OF ");
	WriteType(aT.elemTp, in + 2);
    | TypeDesc.namTp : 
	WriteTypename(ty);
	Console.Write(";");
    ELSE
      WriteTypename(ty);
      Console.Write(";");
    END;
    IF isAlias THEN
      Console.WriteLn;
      WriteIndent(in-4);
      Console.WriteString(" * --------------------- *)");
    END;
  END WriteTypeStructure;

(* -------------------------------------------------------------------- *)
(* ---------  Extension Methods of SymForAll Visitor Pattern ---------- *)
(* -------------------------------------------------------------------- *)

  PROCEDURE (s : ImportForAll)Op*(i : D.Idnt);
    VAR imp : IdDesc.BlkId;
	chO : LitValue.CharOpen;
	idx : INTEGER;
  BEGIN 
    IF (i.kind = IdDesc.impId) & (i # impD) THEN
      imp := i(IdDesc.BlkId);
      chO := NameHash.charOpenOfHash(i.hash);
      IF s.num = 0 THEN
	Console.WriteString("  IMPORT"); Console.WriteLn;
      ELSE
	Console.Write(","); Console.WriteLn;
      END;
      Console.Write("	");
      Console.WriteString(chO);
      IF imp.scopeNm # NIL THEN
	FOR idx := LEN(chO) TO 20 DO Console.Write(" ") END;
	Console.WriteString(' (* "');
	Console.WriteString(imp.scopeNm);
	Console.WriteString('" *)');
      END;
      INC(s.num);
    END;
  END Op;

  (* ---------------------------------- *)

  PROCEDURE (s : ConstForAll)Op*(i : D.Idnt);
    VAR exp : ExprDesc.LeafX;
	nam : FileNames.NameString;

    PROCEDURE WriteElements(s : SET);
      CONST space = ", ";
      VAR ix, mn, mx : INTEGER;
	  elems      : BOOLEAN;
    BEGIN
      ix := 0;
      mn := 0;
      elems := FALSE;
      WHILE ix < 32 DO
	WHILE (mn < 32) & ~(mn IN s) DO INC(mn) END;
	IF mn = 32 THEN RETURN END;
	mx := mn;
	WHILE (mx < 31) & ((mx+1) IN s) DO INC(mx) END;
	IF elems THEN Console.WriteString(space) END;
	IF mn = mx THEN 
	  Console.WriteInt(mn,1);
	ELSIF mn+1 = mx THEN
	  Console.WriteInt(mn,1);
	  Console.WriteString(space);
	  Console.WriteInt(mx,1);
	ELSE
	  Console.WriteInt(mn,1);
	  Console.WriteString(" .. ");
	  Console.WriteInt(mx,1);
	END;
	mn := mx+1;
	elems := TRUE;
      END; (* while *)
    END WriteElements;

  BEGIN 
    IF i.kind = IdDesc.conId THEN
      IF s.stt THEN 
	WriteIndent(s.ind);
      ELSIF s.num = 0 THEN 
	Console.WriteString("  CONST	");
      ELSE
	Console.Write("	");
      END;
      WriteName(i);
      Console.WriteString("	= "); 
      exp := i(IdDesc.ConId).conExp(ExprDesc.LeafX);
      CASE exp.kind OF
      | ExprDesc.realLt : 
	  RTS.RealToStr(exp.value.real(), nam);
	  Console.WriteString(nam$);
      | ExprDesc.numLt  : 
	  Console.WriteInt(exp.value.int(), 0);
      | ExprDesc.charLt : 
	  Console.Write("'");
	  Console.Write(exp.value.char());
	  Console.Write("'");
      | ExprDesc.strLt  : 
	  exp.value.GetStr(nam);
	  Console.Write('"');
	  Console.WriteString(nam$);
	  Console.Write('"');
      | ExprDesc.setLt  : 
	  Console.Write('{');
	  WriteElements(exp.value.set());
	  Console.Write('}');
      | ExprDesc.nilLt  : 
	  Console.WriteString("NIL");
      | ExprDesc.tBool  : 
	  Console.WriteString("TRUE");
      | ExprDesc.fBool  : 
	  Console.WriteString("FALSE");
      END;
      Console.Write(';');
      Console.WriteLn;
      INC(s.num);
    END;
  END Op;

  (* ---------------------------------- *)

  PROCEDURE (s : VarForAll)Op*(i : D.Idnt);
  BEGIN 
    IF i.kind = IdDesc.varId THEN
      IF isSyntheticTypId(i.type.idnt) THEN
	D.AppendIdnt(s.wrk, i);
      ELSE
        IF s.stt THEN 
	  WriteIndent(s.ind);
	ELSIF s.num = 0 THEN 
	  Console.WriteString("  VAR	");
	ELSE
	  Console.Write("	");
	END;
	WriteName(i);
	Console.WriteString("	: "); 
	WriteTypename(i.type); 
	Console.Write(';');
	Console.WriteLn;
	INC(s.num);
      END;
    END;
  END Op;

  (* ---------------------------------- *)

  PROCEDURE (s : VarForAll)DoWorklist(),NEW;
    VAR index : INTEGER;
	inPos : INTEGER;
	thisT : D.Type;
	thisV : D.Idnt;
  BEGIN
    IF s.wrk.tide > 0 THEN
      WriteComment("Vars with anonymous types ..."); 
      LOOP
	inPos := 0;
	thisT := s.wrk.a[0].type;
	Console.WriteString("  VAR	");
	FOR index := 0 TO s.wrk.tide - 1 DO
	  thisV := s.wrk.a[index];
	  IF thisV.type = thisT THEN (* write var name out *)
	    (* Assert: index > 0 ==> not first in var list *)
	    IF index > 0 THEN Console.WriteString(", ") END;
	    WriteName(thisV);
	  ELSE (* put back on work list *)
	    s.wrk.a[inPos] := thisV; INC(inPos);
	  END;
	END;
	Console.WriteString(" : ");
	WriteTypeStructure(thisT, 12);
        Console.WriteLn;
	IF inPos > 0 THEN
	  s.wrk.ResetTo(inPos);
	ELSE
	  EXIT;
	END;
      END;
      Console.WriteLn;
    END;
  END DoWorklist;

  (* ---------------------------------- *)

  PROCEDURE (s : TypeForAll)Op*(i : D.Idnt);
  BEGIN 
    IF (i.kind = IdDesc.typId) & ~isSyntheticTypId(i) THEN
      Console.WriteString("  TYPE  ");
      WriteName(i);
      Console.WriteString(" = ");
      WriteTypeStructure(i.type, 12);
      Console.WriteLn;
      Console.WriteLn;
      INC(s.num);
    END;
  END Op;

  (* ---------------------------------- *)

  PROCEDURE (s : ProcForAll)Op*(i : D.Idnt);
    CONST str = "  PROCEDURE ";
    VAR   prc : IdDesc.PrcId;
  BEGIN 
    IF i.kind = IdDesc.conPrc THEN
      Console.WriteString(str);
      WriteName(i);
      prc := i(IdDesc.PrcId);
      IF prc.prcNm # NIL THEN
	Console.WriteString('["');
	Console.WriteString(prc.prcNm);
	Console.WriteString('"]');
      END;
      WriteFormals(i.type(TypeDesc.Procedure), LEN(str) + NameLength(i));
      Console.Write(";");
      Console.WriteLn; Console.WriteLn;
      INC(s.num);
    END;
  END Op;

(* -------------------------------------------------------------------- *)

    PROCEDURE Constants(symTb : D.SymbolTable);
      VAR conFA : ConstForAll;
    BEGIN
      NEW(conFA);
      conFA.num := 0;
      conFA.stt := FALSE;
      symTb.Apply(conFA);
      IF conFA.num > 0 THEN Console.WriteLn END;
    END Constants;

  (* ---------------------------------- *)

    PROCEDURE StatConstants(symTb : D.SymbolTable; in : INTEGER);
      VAR conFA : ConstForAll;
    BEGIN
      NEW(conFA);
      conFA.num := 0;
      conFA.stt := TRUE;
      conFA.ind := in;
      symTb.Apply(conFA);
    END StatConstants;

  (* ---------------------------------- *)

    PROCEDURE Vars(symTb : D.SymbolTable);
      VAR varFA : VarForAll;
    BEGIN
      NEW(varFA);
      varFA.num := 0;
      varFA.stt := FALSE;
      symTb.Apply(varFA);
      IF varFA.num > 0 THEN Console.WriteLn END;
      varFA.DoWorklist();
    END Vars;

  (* ---------------------------------- *)

    PROCEDURE StatVars(symTb : D.SymbolTable; in : INTEGER);
      VAR varFA : VarForAll;
    BEGIN
      NEW(varFA);
      varFA.num := 0;
      varFA.stt := TRUE;
      varFA.ind := in;
      symTb.Apply(varFA);
    END StatVars;

  (* ---------------------------------- *)

    PROCEDURE StatProcs(symTb : D.SymbolTable);
      VAR prcFA : ProcForAll;
    BEGIN
      NEW(prcFA);
      prcFA.num := 0;
      symTb.Apply(prcFA);
      (* IF prcFA.num > 0 THEN Console.WriteLn END; *)
    END StatProcs;

(* -------------------------------------------------------------------- *)

  PROCEDURE ScreenWrite;

  (* ---------------------------------- *)

    PROCEDURE Header;
      VAR daTm : ARRAY 64 OF CHAR;
    BEGIN
      RTS.GetDateString(daTm);
      WriteComment("Interface automatically produced from symbol file");
      WriteComment("at date-time : " + daTm);
      WriteComment("by the ShowSyms tool. Exported symbols only...   ");
      IF Symbols.rtsMd IN impD.xAttr THEN
        Console.WriteString("SYSTEM ");
      END;
      Console.WriteString("MODULE ");
      Console.WriteString(name); 
      IF impD.scopeNm # NIL THEN
	Console.WriteString('["');
	Console.WriteString(impD.scopeNm);
	Console.WriteString('"]');
      END;
      Console.Write(";");
      Console.WriteLn;
    END Header;

  (* ---------------------------------- *)

    PROCEDURE Imports;
      VAR impFA : ImportForAll;
    BEGIN
      (* Assert: only impSc symbols are in the module scope *)
      NEW(impFA); 
      impFA.num := 0;
      modD.symTb.Apply(impFA);
      IF impFA.num > 0 THEN 
	Console.Write(";"); 
	Console.WriteLn;
      ELSE
	WriteComment("No imports");
      END;
    END Imports;

  (* ---------------------------------- *)

    PROCEDURE Types;
      VAR typFA : TypeForAll;
    BEGIN
      NEW(typFA);
      typFA.num := 0;
      impD.symTb.Apply(typFA);
      (* IF typFA.num > 0 THEN Console.WriteLn END; *)
    END Types;

  (* ---------------------------------- *)

    PROCEDURE Trailer;
    BEGIN
      Console.WriteString("END ");
      Console.WriteString(name); 
      Console.Write(".");
      Console.WriteLn;
    END Trailer;

  (* ---------------------------------- *)

  BEGIN
    Header;	Console.WriteLn;
    Imports;	Console.WriteLn;
    Constants(impD.symTb);
    Types;
    Vars(impD.symTb);
    StatProcs(impD.symTb);
    Trailer;	
  END ScreenWrite;

(* -------------------------------------------------------------------- *)

  PROCEDURE Usage();
  BEGIN
    Console.WriteString("Usage: ShowSyms [-nohtml] moduleName");
    Console.WriteLn;
    HALT(0);
  END Usage;

(* -------------------------------------------------------------------- *)

BEGIN
  html := TRUE;
  argN := ProgArgs.ArgNumber();
  IF (argN = 0) OR (argN > 2) THEN
    Usage;
  ELSE
    ProgArgs.GetArg(0, name);
    IF name = "-nohtml" THEN
      html := FALSE;
      IF argN # 2 THEN Usage END;
      ProgArgs.GetArg(1, name);
    ELSIF argN = 2 THEN
      Usage;
    END;
    CompState.InitCompState(name);
    modD := CompState.thisMod;
    impD := IdDesc.newImpId();
    NameHash.InitNameHash(4099);
    Builtin.InitBuiltins();
    Builtin.RebindBuiltins();
    FileNames.StripExt(name, name);
    impD.hash := NameHash.enterStr(name);
    junk := D.refused(impD, modD);
    symF := SymFileRW.newSymFileReader(modD);
    symF.Parse(impD, name);

    impD.symTb.Apply(Visitor.newResolver());

    ScreenWrite;
  END;  
END ShowSyms.
