/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.selection;

import com.l2fprod.common.application.selection.EmptySelection;
import com.l2fprod.common.application.selection.Selection;
import com.l2fprod.common.application.selection.SelectionProvider;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DefaultSelection
implements Selection {
    private Object[] objects;

    public DefaultSelection(JList list) {
        this.objects = list.getSelectedValues();
    }

    public DefaultSelection(JTree tree) {
        this(tree, false);
    }

    public DefaultSelection(JTree tree, boolean onlyLastPathComponent) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            this.objects = null;
        } else {
            this.objects = new Object[paths.length];
            if (onlyLastPathComponent) {
                int c = this.objects.length;
                for (int i = 0; i < c; ++i) {
                    this.objects[i] = paths[i].getLastPathComponent();
                }
            }
        }
    }

    public DefaultSelection(Object[] objects) {
        this.objects = objects;
    }

    public Object[] getSelection() {
        return this.objects;
    }

    public boolean isEmpty() {
        return this.objects == null || this.objects.length == 0;
    }

    public String toString() {
        return super.toString() + "[size=" + (this.isEmpty() ? "0" : String.valueOf(this.objects.length)) + "]";
    }

    public static Selection findSelection(Component component) {
        if (component instanceof JList) {
            return new DefaultSelection((JList)component);
        }
        if (component instanceof JTree) {
            return new DefaultSelection((JTree)component, true);
        }
        if (component instanceof SelectionProvider) {
            return ((SelectionProvider)((Object)component)).getSelection();
        }
        return new EmptySelection();
    }
}

