/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.ColData;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.TdsCore;

public class CachedResultSet
extends JtdsResultSet {
    protected ArrayList rowData;
    protected static final int INITIAL_ROW_COUNT = 1000;
    protected ColData[] savedRow;
    protected ColData[] insertRow;
    protected boolean onInsertRow;
    protected boolean hasKeys;
    protected boolean rowUpdated = false;
    protected boolean rowDeleted = false;
    protected int initialRowCnt;

    CachedResultSet(JtdsStatement statement, String sql, String procName, ParamInfo[] procedureParams, int resultSetType, int concurrency) throws SQLException {
        super(statement, resultSetType, concurrency, null, false);
        this.cursorCreate(sql, procName, procedureParams);
    }

    private void cursorCreate(String sql, String procName, ParamInfo[] parameters) throws SQLException {
        TdsCore tds;
        block16: {
            tds = this.statement.getTds();
            if ((this.concurrency == 1008 || this.resultSetType == 1005) && (procName == null || procName.startsWith("#jtds") || TdsCore.isPreparedProcedureName(procName))) {
                try {
                    tds.executeSQL(sql + " FOR BROWSE", null, parameters, false, this.statement.getQueryTimeout(), this.statement.getMaxRows());
                    while (!tds.getMoreResults() && !tds.isEndOfResponse()) {
                    }
                    if (tds.isResultSet()) {
                        this.columns = tds.getColumns();
                        String tableName = null;
                        int i = 0;
                        while (i < this.columns.length) {
                            if (this.columns[i].tableName != null) {
                                if (tableName != null && !tableName.equals(this.columns[i].tableName)) {
                                    this.columns = null;
                                    break;
                                }
                                tableName = this.columns[i].tableName;
                            }
                            if (this.columns[i].isKey) {
                                this.hasKeys = true;
                            }
                            ++i;
                        }
                        if (tableName == null) {
                            this.columns = null;
                        }
                    }
                }
                catch (SQLException e) {
                    if (!this.statement.getConnection().isClosed()) break block16;
                    throw e;
                }
            }
        }
        if (this.columns != null && this.resultSetType == 1005 && !this.isKeyed()) {
            this.resultSetType = 1004;
            this.statement.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", "TYPE_SCROLL_INSENSITIVE"), "01000"));
        }
        if (this.columns == null) {
            tds.executeSQL(sql, procName, parameters, false, this.statement.getQueryTimeout(), this.statement.getMaxRows());
            while (!tds.getMoreResults() && !tds.isEndOfResponse()) {
            }
            if (!tds.isResultSet()) {
                throw new SQLException(Messages.get("error.statement.noresult"), "24000");
            }
            this.columns = tds.getColumns();
            if (this.concurrency == 1008) {
                this.statement.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", "CONCUR_READ_ONLY"), "01000"));
                this.concurrency = 1007;
            }
        }
        this.columnCount = this.getColumnCount(this.columns);
        this.rowData = new ArrayList(1000);
        while (super.next()) {
            this.rowData.add(this.copyRow(this.currentRow));
        }
        this.initialRowCnt = this.rowsInResult = this.rowData.size();
        this.pos = 0;
    }

    private boolean cursorFetch(int rowNum) throws SQLException {
        this.savedRow = null;
        this.rowUpdated = false;
        if (this.rowsInResult == 0) {
            this.pos = 0;
            this.currentRow = null;
            return false;
        }
        if (rowNum == this.pos) {
            if (this.resultSetType == 1005) {
                this.refreshRow();
            }
            return true;
        }
        if (rowNum < 1) {
            this.currentRow = null;
            this.pos = 0;
            return false;
        }
        if (rowNum > this.rowsInResult) {
            this.currentRow = null;
            this.pos = -1;
            return false;
        }
        this.pos = rowNum;
        this.currentRow = (ColData[])this.rowData.get(rowNum - 1);
        boolean bl = this.rowDeleted = this.currentRow == null;
        if (this.resultSetType == 1005 && this.currentRow != null) {
            this.refreshRow();
        }
        return true;
    }

    private void cursorClose() {
        this.rowData = null;
    }

    protected boolean isKeyed() {
        return this.hasKeys;
    }

    private void saveRow(ColData[] row) {
        this.savedRow = new ColData[row.length];
        int i = 0;
        while (i < row.length) {
            this.savedRow[i] = new ColData(row[i]);
            ++i;
        }
    }

    protected ParamInfo buildParameter(int pos, ColInfo info, ColData col) throws SQLException {
        ParamInfo param = new ParamInfo(pos);
        param.jdbcType = info.jdbcType;
        param.value = col.getValue();
        param.length = col.getLength();
        param.scale = info.scale;
        param.isSet = true;
        String sqlType = info.sqlType;
        boolean bl = param.isUnicode = sqlType.equals("nvarchar") || sqlType.equals("nchar") || sqlType.equals("ntext");
        if (param.value instanceof BlobImpl) {
            BlobImpl blob = (BlobImpl)param.value;
            param.value = blob.getBinaryStream();
            param.length = (int)blob.length();
        } else if (param.value instanceof ClobImpl) {
            ClobImpl clob = (ClobImpl)param.value;
            param.value = clob.getCharacterStream();
            param.length = (int)clob.length();
        }
        return param;
    }

    protected void setColValue(int colIndex, Object value, int length) throws SQLException {
        ColData col;
        if (this.onInsertRow && this.insertRow == null || !this.onInsertRow && this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            col = this.insertRow[colIndex - 1];
        } else {
            if (this.savedRow == null) {
                this.saveRow(this.currentRow);
            }
            col = this.currentRow[colIndex - 1];
        }
        col.setValue(value);
        col.setLength(length);
    }

    public void afterLast() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != -1) {
            this.cursorFetch(this.rowsInResult + 1);
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != 0) {
            this.cursorFetch(0);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.savedRow != null) {
            this.rowUpdated = false;
            int i = 0;
            while (i < this.savedRow.length) {
                this.currentRow[i] = new ColData(this.savedRow[i]);
                ++i;
            }
        }
    }

    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.cursorClose();
                Object var2_1 = null;
                this.closed = true;
                this.statement = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                this.statement = null;
                throw throwable;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        StringBuffer sql = new StringBuffer(128);
        String dbName = this.columns[0].catalog;
        String userName = this.columns[0].schema;
        String tableName = this.columns[0].tableName;
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
        sql.append("DELETE FROM ");
        if (dbName != null) {
            sql.append(dbName);
            sql.append('.');
            if (userName == null) {
                sql.append('.');
            }
        }
        if (userName != null) {
            sql.append(userName);
            sql.append('.');
        }
        sql.append(tableName);
        sql.append(" WHERE ");
        int count = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.currentRow[i].getValue() == null) {
                if (count > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.columns[i].realName);
                sql.append(" IS NULL");
            } else if (!(this.columns[i].sqlType.equals("text") || this.columns[i].sqlType.equals("ntext") || this.columns[i].sqlType.equals("image"))) {
                if (count > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.columns[i].realName);
                sql.append("=?");
                ++count;
                params.add(this.buildParameter(sql.length() - 1, this.columns[i], this.currentRow[i]));
            }
            ++i;
        }
        ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
        TdsCore tds = this.statement.getTds();
        tds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows());
        int updateCount = 0;
        while (!tds.isEndOfResponse()) {
            if (tds.getMoreResults() || !tds.isUpdateCount()) continue;
            updateCount = tds.getUpdateCount();
        }
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        if (updateCount <= 0) {
            throw new SQLException(Messages.get("error.resultset.deletefail"), "24000");
        }
        this.rowDeleted = true;
        this.currentRow = null;
        this.rowData.set(this.pos - 1, null);
    }

    public void insertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.notinsrow"), "24000");
        }
        StringBuffer sql = new StringBuffer(128);
        String dbName = this.columns[0].catalog;
        String userName = this.columns[0].schema;
        String tableName = this.columns[0].tableName;
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
        sql.append("INSERT INTO ");
        if (dbName != null) {
            sql.append(dbName);
            sql.append('.');
            if (userName == null) {
                sql.append('.');
            }
        }
        if (userName != null) {
            sql.append(userName);
            sql.append('.');
        }
        sql.append(tableName);
        sql.append(" (");
        int count = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.insertRow[i].isUpdated()) {
                if (count > 0) {
                    sql.append(", ");
                }
                sql.append(this.columns[i].realName);
                ++count;
            }
            ++i;
        }
        sql.append(") VALUES(");
        count = 0;
        int i2 = 0;
        while (i2 < this.columnCount) {
            if (this.insertRow[i2].isUpdated()) {
                if (count > 0) {
                    sql.append(", ");
                }
                sql.append("?");
                params.add(this.buildParameter(sql.length() - 1, this.columns[i2], this.insertRow[i2]));
                ++count;
            }
            ++i2;
        }
        sql.append(')');
        ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
        TdsCore tds = this.statement.getTds();
        tds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows());
        int updateCount = 0;
        while (!tds.isEndOfResponse()) {
            if (tds.getMoreResults() || !tds.isUpdateCount()) continue;
            updateCount = tds.getUpdateCount();
        }
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        if (updateCount > 0) {
            this.rowData.add(this.insertRow);
            ++this.rowsInResult;
        } else {
            throw new SQLException(Messages.get("error.resultset.insertfail"), "24000");
        }
        this.insertRow = this.newRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.insertRow = null;
        this.onInsertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.insertRow = this.newRow();
        this.onInsertRow = true;
    }

    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.savedRow != null) {
            this.rowUpdated = false;
            int i = 0;
            while (i < this.savedRow.length) {
                this.currentRow[i] = new ColData(this.savedRow[i]);
                ++i;
            }
        }
        if (this.isKeyed() && this.currentRow != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            int i = 0;
            while (i < this.columns.length) {
                if (i > 0) {
                    sql.append(',');
                }
                sql.append(this.columns[i].realName);
                ++i;
            }
            sql.append(" FROM ");
            if (this.columns[0].catalog != null && this.columns[0].catalog.length() > 0) {
                sql.append(this.columns[0].catalog).append('.');
                if (this.columns[0].schema == null || this.columns[0].schema.length() == 0) {
                    sql.append("..");
                }
            }
            if (this.columns[0].schema != null && this.columns[0].schema.length() > 0) {
                sql.append(this.columns[0].schema).append('.');
            }
            sql.append(this.columns[0].tableName);
            sql.append(" WHERE ");
            ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
            int count = 0;
            int i2 = 0;
            while (i2 < this.columns.length) {
                if (this.columns[i2].isKey) {
                    if (this.currentRow[i2].getValue() == null) {
                        if (count > 0) {
                            sql.append(" AND ");
                        }
                        sql.append(this.columns[i2].realName);
                        sql.append(" IS NULL");
                    } else {
                        if (count > 0) {
                            sql.append(" AND ");
                        }
                        sql.append(this.columns[i2].realName);
                        sql.append("=?");
                        ++count;
                        params.add(this.buildParameter(sql.length() - 1, this.columns[i2], this.currentRow[i2]));
                    }
                }
                ++i2;
            }
            ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
            TdsCore tds = this.statement.getTds();
            tds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows());
            if (!tds.isEndOfResponse()) {
                if (tds.getMoreResults() && tds.getNextRow()) {
                    ColData[] col = tds.getRowData();
                    int i3 = 0;
                    while (i3 < col.length) {
                        this.currentRow[i3] = col[i3];
                        ++i3;
                    }
                } else {
                    this.currentRow = null;
                }
            } else {
                this.currentRow = null;
            }
            tds.clearResponseQueue();
            this.statement.getMessages().checkErrors();
            if (this.currentRow == null) {
                this.rowData.set(this.pos - 1, null);
                this.rowDeleted = true;
            }
        }
    }

    public void updateRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.savedRow == null) {
            return;
        }
        StringBuffer sql = new StringBuffer(128);
        String dbName = this.columns[0].catalog;
        String userName = this.columns[0].schema;
        String tableName = this.columns[0].tableName;
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
        sql.append("UPDATE ");
        if (dbName != null) {
            sql.append(dbName);
            sql.append('.');
            if (userName == null) {
                sql.append('.');
            }
        }
        if (userName != null) {
            sql.append(userName);
            sql.append('.');
        }
        sql.append(tableName);
        sql.append(" SET ");
        int count = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.currentRow[i].isUpdated()) {
                if (count > 0) {
                    sql.append(", ");
                }
                sql.append(this.columns[i].realName);
                sql.append("=?");
                params.add(this.buildParameter(sql.length() - 1, this.columns[i], this.currentRow[i]));
                ++count;
            }
            ++i;
        }
        sql.append(" WHERE ");
        count = 0;
        int i2 = 0;
        while (i2 < this.columnCount) {
            if (this.savedRow[i2].getValue() == null) {
                if (count > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.columns[i2].realName);
                sql.append(" IS NULL");
            } else if (!(this.columns[i2].sqlType.equals("text") || this.columns[i2].sqlType.equals("ntext") || this.columns[i2].sqlType.equals("image"))) {
                if (count > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.columns[i2].realName);
                sql.append("=?");
                ++count;
                params.add(this.buildParameter(sql.length() - 1, this.columns[i2], this.savedRow[i2]));
            }
            ++i2;
        }
        ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
        TdsCore tds = this.statement.getTds();
        tds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows());
        int updateCount = 0;
        while (!tds.isEndOfResponse()) {
            if (tds.getMoreResults() || !tds.isUpdateCount()) continue;
            updateCount = tds.getUpdateCount();
        }
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        this.rowUpdated = updateCount > 0;
        this.savedRow = null;
        if (updateCount == 0) {
            throw new SQLException(Messages.get("error.resultset.updatefail"), "24000");
        }
    }

    public boolean first() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        return this.cursorFetch(1);
    }

    public boolean isLast() throws SQLException {
        this.checkOpen();
        return this.pos == this.rowsInResult && this.rowsInResult != 0;
    }

    public boolean last() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        return this.cursorFetch(this.rowsInResult);
    }

    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.pos != -1) {
            return this.cursorFetch(this.pos + 1);
        }
        return false;
    }

    public boolean previous() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos == -1) {
            this.pos = this.rowsInResult + 1;
        }
        return this.cursorFetch(this.pos - 1);
    }

    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        return this.rowDeleted;
    }

    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        return this.pos > this.initialRowCnt;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        return this.rowUpdated;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (row < 1) {
            row = this.rowsInResult + 1 + row;
        }
        return this.cursorFetch(row);
    }

    public boolean relative(int row) throws SQLException {
        if (this.pos == -1) {
            return this.absolute(this.rowsInResult + 1 + row);
        }
        return this.absolute(this.pos + row);
    }
}

