/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.Messages;

public final class DefaultProperties {
    public static final String APP_NAME = "jTDS";
    public static final String DATABASE_NAME = "";
    public static final String LAST_UPDATE_COUNT = "true";
    public static final String LOB_BUFFER_SIZE = "32768";
    public static final String LOGIN_TIMEOUT = "0";
    public static final String MAC_ADDRESS = "000000000000";
    public static final String NAMED_PIPE = "false";
    public static final String NAMED_PIPE_PATH_SQLSERVER = "/sql/query";
    public static final String NAMED_PIPE_PATH_SYBASE = "/sybase/query";
    public static final String PACKET_SIZE_42_50 = String.valueOf(512);
    public static final String PACKET_SIZE_70_80 = "0";
    public static final String PASSWORD = "";
    public static final String PORT_NUMBER_SQLSERVER = "1433";
    public static final String PORT_NUMBER_SYBASE = "7100";
    public static final String PREPARE_SQL = String.valueOf(1);
    public static final String PROG_NAME = "jTDS";
    public static final String USE_UNICODE = "true";
    public static final String USER = "";
    public static final String SERVER_TYPE_SQLSERVER = "sqlserver";
    public static final String SERVER_TYPE_SYBASE = "sybase";
    public static final String TDS_VERSION_42 = "4.2";
    public static final String TDS_VERSION_50 = "5.0";
    public static final String TDS_VERSION_70 = "7.0";
    public static final String TDS_VERSION_80 = "8.0";
    private static final HashMap tdsDefaults = new HashMap(2);
    private static final HashMap portNumberDefaults;
    private static final HashMap packetSizeDefaults;

    public static Properties addDefaultProperties(Properties props) {
        String serverType = props.getProperty(Messages.get("prop.servertype"));
        if (serverType == null) {
            return null;
        }
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.tds", "prop.servertype", tdsDefaults);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.portnumber", "prop.servertype", portNumberDefaults);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.user", "");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.password", "");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.databasename", "");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.appname", "jTDS");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.lastupdatecount", "true");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.lobbuffer", LOB_BUFFER_SIZE);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.logintimeout", "0");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.macaddress", MAC_ADDRESS);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.namedpipe", NAMED_PIPE);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.packetsize", "prop.tds", packetSizeDefaults);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.preparesql", PREPARE_SQL);
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.progname", "jTDS");
        DefaultProperties.addDefaultPropertyIfNotSet(props, "prop.useunicode", "true");
        return props;
    }

    private static void addDefaultPropertyIfNotSet(Properties props, String key, String defaultValue) {
        String messageKey = Messages.get(key);
        if (props.getProperty(messageKey) == null) {
            props.setProperty(messageKey, defaultValue);
        }
    }

    private static void addDefaultPropertyIfNotSet(Properties props, String key, String defaultKey, Map defaults) {
        Object defaultValue;
        String defaultKeyValue = props.getProperty(Messages.get(defaultKey));
        if (defaultKeyValue == null) {
            return;
        }
        String messageKey = Messages.get(key);
        if (props.getProperty(messageKey) == null && (defaultValue = defaults.get(defaultKeyValue)) != null) {
            props.setProperty(messageKey, String.valueOf(defaultValue));
        }
    }

    public static String getServerType(int serverType) {
        if (serverType == 1) {
            return SERVER_TYPE_SQLSERVER;
        }
        if (serverType == 2) {
            return SERVER_TYPE_SYBASE;
        }
        return null;
    }

    public static Integer getServerType(String serverType) {
        if (SERVER_TYPE_SQLSERVER.equals(serverType)) {
            return new Integer(1);
        }
        if (SERVER_TYPE_SYBASE.equals(serverType)) {
            return new Integer(2);
        }
        return null;
    }

    public static Integer getTdsVersion(String tdsVersion) {
        if (TDS_VERSION_42.equals(tdsVersion)) {
            return new Integer(1);
        }
        if (TDS_VERSION_50.equals(tdsVersion)) {
            return new Integer(2);
        }
        if (TDS_VERSION_70.equals(tdsVersion)) {
            return new Integer(3);
        }
        if (TDS_VERSION_80.equals(tdsVersion)) {
            return new Integer(4);
        }
        return null;
    }

    static {
        tdsDefaults.put(String.valueOf(1), TDS_VERSION_80);
        tdsDefaults.put(String.valueOf(2), TDS_VERSION_50);
        portNumberDefaults = new HashMap(2);
        portNumberDefaults.put(String.valueOf(1), PORT_NUMBER_SQLSERVER);
        portNumberDefaults.put(String.valueOf(2), PORT_NUMBER_SYBASE);
        packetSizeDefaults = new HashMap(4);
        packetSizeDefaults.put(TDS_VERSION_42, PACKET_SIZE_42_50);
        packetSizeDefaults.put(TDS_VERSION_50, PACKET_SIZE_42_50);
        packetSizeDefaults.put(TDS_VERSION_70, "0");
        packetSizeDefaults.put(TDS_VERSION_80, "0");
    }
}

