/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.ProtocolException;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.UniqueIdentifier;

public class TdsData {
    private static final int SYBCHAR = 47;
    private static final int SYBVARCHAR = 39;
    private static final int SYBINTN = 38;
    private static final int SYBINT1 = 48;
    private static final int SYBDATE = 49;
    private static final int SYBTIME = 51;
    private static final int SYBINT2 = 52;
    private static final int SYBINT4 = 56;
    private static final int SYBINT8 = 127;
    private static final int SYBFLT8 = 62;
    private static final int SYBDATETIME = 61;
    private static final int SYBBIT = 50;
    private static final int SYBTEXT = 35;
    private static final int SYBNTEXT = 99;
    private static final int SYBIMAGE = 34;
    private static final int SYBMONEY4 = 122;
    private static final int SYBMONEY = 60;
    private static final int SYBDATETIME4 = 58;
    private static final int SYBREAL = 59;
    private static final int SYBBINARY = 45;
    private static final int SYBVOID = 31;
    private static final int SYBVARBINARY = 37;
    private static final int SYBNVARCHAR = 103;
    private static final int SYBBITN = 104;
    private static final int SYBNUMERIC = 108;
    private static final int SYBDECIMAL = 106;
    private static final int SYBFLTN = 109;
    private static final int SYBMONEYN = 110;
    private static final int SYBDATETIMN = 111;
    private static final int SYBDATEN = 123;
    private static final int SYBTIMEN = 147;
    private static final int XSYBCHAR = 175;
    private static final int XSYBVARCHAR = 167;
    private static final int XSYBNVARCHAR = 231;
    private static final int XSYBNCHAR = 239;
    private static final int XSYBVARBINARY = 165;
    private static final int XSYBBINARY = 173;
    private static final int SYBLONGBINARY = 225;
    private static final int SYBSINT1 = 64;
    private static final int SYBUINT2 = 65;
    private static final int SYBUINT4 = 66;
    private static final int SYBUINT8 = 67;
    private static final int SYBUNIQUE = 36;
    private static final int SYBVARIANT = 98;
    private static final TypeInfo[] types = new TypeInfo[256];
    static final int DEFAULT_SCALE = 10;
    private static GregorianCalendar cal;
    private static BigDecimal limit28;
    private static BigDecimal limit38;

    static int getCollation(ResponseStream in, ColInfo ci) throws IOException {
        if (TdsData.isCollation(ci)) {
            ci.collation = new byte[5];
            in.read(ci.collation);
            return 5;
        }
        return 0;
    }

    static int readType(ResponseStream in, ColInfo ci) throws IOException, ProtocolException {
        boolean isTds8 = in.getTdsVersion() >= 4;
        boolean isTds5 = in.getTdsVersion() == 2;
        int bytesRead = 1;
        int type = in.read();
        if (types[type] == null) {
            throw new ProtocolException("Invalid TDS data type 0x" + Integer.toHexString(type));
        }
        ci.tdsType = type;
        ci.jdbcType = TdsData.types[type].jdbcType;
        ci.bufferSize = TdsData.types[type].size;
        if (ci.bufferSize == -5) {
            ci.bufferSize = in.readInt();
            bytesRead += 4;
        } else if (ci.bufferSize == -4) {
            ci.bufferSize = in.readInt();
            if (isTds8) {
                bytesRead += TdsData.getCollation(in, ci);
            }
            int lenName = in.readShort();
            ci.tableName = in.readString(lenName);
            bytesRead += 6 + (in.getTdsVersion() >= 3 ? lenName * 2 : lenName);
        } else if (ci.bufferSize == -2) {
            if (isTds5 && ci.tdsType == 175) {
                ci.bufferSize = in.readInt();
                bytesRead += 4;
            } else {
                ci.bufferSize = in.readShort();
                bytesRead += 2;
            }
            if (isTds8) {
                bytesRead += TdsData.getCollation(in, ci);
            }
        } else if (ci.bufferSize == -1) {
            ++bytesRead;
            ci.bufferSize = in.read();
        }
        if (TdsData.isCurrency(ci)) {
            ci.scale = 4;
        } else if (type == 61 || type == 111 && ci.bufferSize == 8) {
            ci.scale = 3;
        }
        ci.displaySize = TdsData.types[type].displaySize;
        ci.precision = TdsData.types[type].precision;
        ci.sqlType = TdsData.types[type].sqlType;
        if (type == 111) {
            if (ci.bufferSize == 8) {
                ci.displaySize = TdsData.types[61].displaySize;
                ci.precision = TdsData.types[61].precision;
            } else {
                ci.displaySize = TdsData.types[58].displaySize;
                ci.precision = TdsData.types[58].precision;
                ci.sqlType = TdsData.types[58].sqlType;
            }
        } else if (type == 109) {
            if (ci.bufferSize == 8) {
                ci.displaySize = TdsData.types[62].displaySize;
                ci.precision = TdsData.types[62].precision;
            } else {
                ci.displaySize = TdsData.types[59].displaySize;
                ci.precision = TdsData.types[59].precision;
                ci.jdbcType = 7;
                ci.sqlType = TdsData.types[59].sqlType;
            }
        } else if (type == 38) {
            if (ci.bufferSize == 8) {
                ci.displaySize = TdsData.types[127].displaySize;
                ci.precision = TdsData.types[127].precision;
                ci.jdbcType = -5;
                ci.sqlType = TdsData.types[127].sqlType;
            } else if (ci.bufferSize == 4) {
                ci.displaySize = TdsData.types[56].displaySize;
                ci.precision = TdsData.types[56].precision;
            } else if (ci.bufferSize == 2) {
                ci.displaySize = TdsData.types[52].displaySize;
                ci.precision = TdsData.types[52].precision;
                ci.jdbcType = 5;
                ci.sqlType = TdsData.types[52].sqlType;
            } else {
                ci.displaySize = TdsData.types[48].displaySize;
                ci.precision = TdsData.types[48].precision;
                ci.jdbcType = -6;
                ci.sqlType = TdsData.types[48].sqlType;
            }
        } else if (type == 110) {
            if (ci.bufferSize == 8) {
                ci.displaySize = TdsData.types[60].displaySize;
                ci.precision = TdsData.types[60].precision;
            } else {
                ci.displaySize = TdsData.types[122].displaySize;
                ci.precision = TdsData.types[122].precision;
                ci.sqlType = TdsData.types[122].sqlType;
            }
        }
        if (ci.precision == -1) {
            ci.precision = ci.bufferSize;
            ci.displaySize = ci.displaySize == -2 ? ci.bufferSize / 2 : (ci.displaySize == 2 ? ci.precision * 2 : ci.precision);
        }
        if (type == 106 || type == 108) {
            ci.precision = in.read();
            ci.scale = in.read();
            ci.displaySize = (ci.scale > 0 ? 2 : 1) + ci.precision;
            bytesRead += 2;
            ci.sqlType = TdsData.types[type].sqlType;
        }
        if (ci.isIdentity) {
            ci.sqlType = ci.sqlType + " identity";
        }
        if (isTds5) {
            if (ci.tdsType == 225) {
                switch (ci.userType) {
                    case 3: {
                        ci.sqlType = "binary";
                        ci.displaySize = ci.bufferSize * 2;
                        ci.jdbcType = -2;
                        break;
                    }
                    case 4: {
                        ci.sqlType = "varbinary";
                        ci.displaySize = ci.bufferSize * 2;
                        ci.jdbcType = -3;
                        break;
                    }
                    case 34: {
                        ci.sqlType = "unichar";
                        ci.displaySize = ci.bufferSize / 2;
                        ci.jdbcType = 1;
                        break;
                    }
                    case 35: {
                        ci.sqlType = "univarchar";
                        ci.displaySize = ci.bufferSize / 2;
                        ci.jdbcType = 12;
                    }
                }
            } else if (ci.tdsType == 175) {
                switch (ci.userType) {
                    case 1: {
                        ci.sqlType = "char";
                        ci.displaySize = ci.bufferSize;
                        ci.jdbcType = 1;
                        break;
                    }
                    case 2: {
                        ci.sqlType = "varchar";
                        ci.displaySize = ci.bufferSize;
                        ci.jdbcType = 12;
                        break;
                    }
                    case 24: {
                        ci.sqlType = "nchar";
                        ci.displaySize = ci.bufferSize;
                        ci.jdbcType = 1;
                        break;
                    }
                    case 25: {
                        ci.sqlType = "nvarchar";
                        ci.displaySize = ci.bufferSize;
                        ci.jdbcType = 12;
                    }
                }
            }
        }
        return bytesRead;
    }

    /*
     * Unable to fully structure code
     */
    static Object readData(Object callerReference, ResponseStream in, ColInfo ci, boolean readTextMode) throws IOException, ProtocolException {
        switch (ci.tdsType) {
            case 38: {
                switch (in.read()) {
                    case 1: {
                        return new Integer(in.read() & 255);
                    }
                    case 2: {
                        return new Integer(in.readShort());
                    }
                    case 4: {
                        return new Integer(in.readInt());
                    }
                    case 8: {
                        return new Long(in.readLong());
                    }
                }
                break;
            }
            case 48: {
                return new Integer(in.read() & 255);
            }
            case 52: {
                return new Integer(in.readShort());
            }
            case 56: {
                return new Integer(in.readInt());
            }
            case 127: {
                return new Long(in.readLong());
            }
            case 34: {
                len = in.read();
                if (len <= 0) break;
                return new BlobImpl(callerReference, in);
            }
            case 35: {
                len = in.read();
                if (len <= 0) break;
                return new ClobImpl(callerReference, in, false, readTextMode);
            }
            case 99: {
                len = in.read();
                if (len <= 0) break;
                return new ClobImpl(callerReference, in, true, readTextMode);
            }
            case 39: 
            case 47: {
                len = in.read();
                if (len == 1 && in.getTdsVersion() < 3) {
                    value = in.readAsciiString(len);
                    return value.equals(" ") != false ? "" : value;
                }
                if (len <= 0) break;
                return in.readAsciiString(len);
            }
            case 103: {
                len = in.read();
                if (len <= 0) break;
                return in.readString(len / 2);
            }
            case 167: 
            case 175: {
                if (in.getTdsVersion() == 2) {
                    len = in.readInt();
                    if (len <= 0) break;
                    tmp = in.readAsciiString(len);
                    if (tmp.equals(" ") && !ci.sqlType.equals("char")) {
                        tmp = "";
                    }
                    return tmp;
                }
                len = in.readShort();
                if (len == -1) break;
                return in.readAsciiString(len);
            }
            case 231: 
            case 239: {
                len = in.readShort();
                if (len == -1) break;
                return in.readString(len / 2);
            }
            case 37: 
            case 45: {
                len = in.read();
                if (len <= 0) break;
                bytes = new byte[len];
                in.read(bytes);
                return bytes;
            }
            case 165: 
            case 173: {
                len = in.readShort();
                if (len == -1) break;
                bytes = new byte[len];
                in.read(bytes);
                return bytes;
            }
            case 225: {
                len = in.readInt();
                if (len == 0) break;
                if (ci.sqlType.equals("unichar") || ci.sqlType.equals("univarchar")) {
                    buf = new char[len / 2];
                    in.read(buf);
                    if ((len & 1) != 0) {
                        in.skip(1);
                    }
                    if (len == 2 && buf[0] == ' ') {
                        return "";
                    }
                    return new String(buf);
                }
                bytes = new byte[len];
                in.read(bytes);
                return bytes;
            }
            case 60: 
            case 110: 
            case 122: {
                return TdsData.getMoneyValue(in, ci.tdsType);
            }
            case 58: 
            case 61: 
            case 111: {
                return TdsData.getDatetimeValue(in, ci.tdsType);
            }
            case 49: 
            case 123: {
                v0 = len = ci.tdsType == 123 ? in.read() : 4;
                if (len == 4) {
                    daysSince1900 = in.readInt();
                    var6_31 = TdsData.cal;
                    synchronized (var6_31) {
                        TdsData.sybDateToCalendar(daysSince1900, TdsData.cal);
                        var7_34 = new Date(TdsData.cal.getTime().getTime());
                        return var7_34;
                    }
                }
                in.skip(len);
                break;
            }
            case 51: 
            case 147: {
                v1 = len = ci.tdsType == 147 ? in.read() : 4;
                if (len == 4) {
                    daysSince1900 = TdsData.cal;
                    synchronized (daysSince1900) {
                        time = in.readInt();
                        TdsData.sybTimeToCalendar(time, TdsData.cal);
                        TdsData.cal.set(1, 1970);
                        TdsData.cal.set(2, 0);
                        TdsData.cal.set(5, 1);
                        var7_35 = new Time(TdsData.cal.getTime().getTime());
                        return var7_35;
                    }
                }
                in.skip(len);
                break;
            }
            case 50: {
                return in.read() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 104: {
                len = in.read();
                if (len <= 0) break;
                return in.read() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 59: {
                return new Float(Float.intBitsToFloat(in.readInt()));
            }
            case 62: {
                return new Double(Double.longBitsToDouble(in.readLong()));
            }
            case 109: {
                len = in.read();
                if (len == 4) {
                    return new Float(Float.intBitsToFloat(in.readInt()));
                }
                if (len != 8) break;
                return new Double(Double.longBitsToDouble(in.readLong()));
            }
            case 36: {
                len = in.read();
                if (len <= 0) break;
                bytes = new byte[len];
                in.read(bytes);
                return new UniqueIdentifier(bytes);
            }
            case 106: 
            case 108: {
                len = in.read();
                if (len <= 0) break;
                sign = in.read();
                bytes = new byte[--len];
                if (in.getServerType() != 2) ** GOTO lbl164
                i = 0;
                while (i < len) {
                    bytes[i] = (byte)in.read();
                    ++i;
                }
                bi = new BigInteger(sign == 0 ? 1 : -1, bytes);
                ** GOTO lbl166
lbl-1000:
                // 1 sources

                {
                    bytes[len] = (byte)in.read();
lbl164:
                    // 2 sources

                    ** while (len-- > 0)
                }
lbl165:
                // 1 sources

                bi = new BigInteger(sign == 0 ? -1 : 1, bytes);
lbl166:
                // 2 sources

                return new BigDecimal(bi, ci.scale);
            }
            case 98: {
                return TdsData.getVariant(in);
            }
            default: {
                throw new ProtocolException("Unsupported TDS data type 0x" + Integer.toHexString(ci.tdsType));
            }
        }
        return null;
    }

    static boolean isSigned(ColInfo ci) {
        int type = ci.tdsType;
        if (type < 0 || type > 255 || types[type] == null) {
            throw new IllegalArgumentException("TDS data type " + type + " invalid");
        }
        if (type == 38 && ci.bufferSize == 1) {
            type = 48;
        }
        return TdsData.types[type].isSigned;
    }

    static boolean isCollation(ColInfo ci) {
        int type = ci.tdsType;
        if (type < 0 || type > 255 || types[type] == null) {
            throw new IllegalArgumentException("TDS data type " + type + " invalid");
        }
        return TdsData.types[type].isCollation;
    }

    static boolean isCurrency(ColInfo ci) {
        int type = ci.tdsType;
        if (type < 0 || type > 255 || types[type] == null) {
            throw new IllegalArgumentException("TDS data type " + type + " invalid");
        }
        return type == 60 || type == 122 || type == 110;
    }

    static boolean isSearchable(ColInfo ci) {
        int type = ci.tdsType;
        if (type < 0 || type > 255 || types[type] == null) {
            throw new IllegalArgumentException("TDS data type " + type + " invalid");
        }
        return TdsData.types[type].size != -4;
    }

    static void getNativeType(ConnectionJDBC2 connection, ParamInfo pi) throws SQLException {
        int jdbcType = pi.jdbcType;
        if (jdbcType == 1111) {
            jdbcType = Support.getJdbcType(pi.value);
        }
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int len = pi.value == null ? 0 : pi.length;
                if (connection.getTdsVersion() < 3) {
                    if (len > 0 && connection.getSybaseInfo(16) && connection.isUseUnicode()) {
                        try {
                            String charset = connection.getCharSet();
                            String tmp = pi.getString(charset);
                            if (!TdsData.canEncode(tmp, charset)) {
                                pi.sqlType = "univarchar(" + tmp.length() + ")";
                                pi.tdsType = 225;
                                pi.length = tmp.length();
                                break;
                            }
                        }
                        catch (IOException e) {
                            throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
                        }
                    }
                    if (len < 256) {
                        pi.tdsType = 39;
                        pi.sqlType = "varchar(255)";
                        break;
                    }
                    if (connection.getSybaseInfo(1)) {
                        pi.tdsType = 175;
                        pi.sqlType = "varchar(" + len + ")";
                        break;
                    }
                    pi.tdsType = 35;
                    pi.sqlType = "text";
                    break;
                }
                if (pi.isUnicode && len < 4001) {
                    pi.tdsType = 231;
                    pi.sqlType = "nvarchar(4000)";
                    break;
                }
                if (!pi.isUnicode && len < 8001) {
                    pi.tdsType = 167;
                    pi.sqlType = "varchar(8000)";
                    break;
                }
                if (pi.isOutput) {
                    throw new SQLException(Messages.get("error.textoutparam"), "HY000");
                }
                if (pi.isUnicode) {
                    pi.tdsType = 99;
                    pi.sqlType = "ntext";
                    break;
                }
                pi.tdsType = 35;
                pi.sqlType = "text";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                pi.tdsType = 38;
                pi.sqlType = "int";
                break;
            }
            case -7: 
            case 16: {
                pi.tdsType = connection.getSybaseInfo(4) ? 104 : 50;
                pi.sqlType = "bit";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                pi.tdsType = 109;
                pi.sqlType = "float";
                break;
            }
            case 91: {
                if (connection.getSybaseInfo(2)) {
                    pi.tdsType = 123;
                    pi.sqlType = "date";
                    break;
                }
                pi.tdsType = 111;
                pi.sqlType = "datetime";
                break;
            }
            case 92: {
                if (connection.getSybaseInfo(2)) {
                    pi.tdsType = 147;
                    pi.sqlType = "time";
                    break;
                }
                pi.tdsType = 111;
                pi.sqlType = "datetime";
                break;
            }
            case 93: {
                pi.tdsType = 111;
                pi.sqlType = "datetime";
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                int len = pi.value == null ? 0 : pi.length;
                if (connection.getTdsVersion() < 3) {
                    if (len < 256) {
                        pi.tdsType = 37;
                        pi.sqlType = "varbinary(255)";
                        break;
                    }
                    if (connection.getSybaseInfo(1)) {
                        pi.tdsType = 225;
                        pi.sqlType = "varbinary(" + len + ")";
                        break;
                    }
                    pi.tdsType = 34;
                    pi.sqlType = "image";
                    break;
                }
                if (len < 8001) {
                    pi.tdsType = 165;
                    pi.sqlType = "varbinary(8000)";
                    break;
                }
                if (pi.isOutput) {
                    throw new SQLException(Messages.get("error.textoutparam"), "HY000");
                }
                pi.tdsType = 34;
                pi.sqlType = "image";
                break;
            }
            case -5: {
                if (connection.getTdsVersion() >= 4) {
                    pi.tdsType = 38;
                    pi.sqlType = "bigint";
                    break;
                }
                pi.tdsType = 106;
                if (connection.getMaxPrecision() > 28) {
                    pi.sqlType = "decimal(38)";
                    break;
                }
                pi.sqlType = "decimal(28)";
                break;
            }
            case 2: 
            case 3: {
                pi.tdsType = 106;
                pi.sqlType = connection.getMaxPrecision() > 28 ? (pi.scale > 10 && pi.scale <= 38 ? "decimal(38," + pi.scale + ")" : "decimal(38,10)") : (pi.scale > 10 && pi.scale <= 28 ? "decimal(28," + pi.scale + ")" : "decimal(28,10)");
                if (!(pi.value instanceof BigDecimal)) break;
                BigDecimal value = (BigDecimal)pi.value;
                if (connection.getMaxPrecision() > 28) {
                    if (value.scale() <= 10 && value.compareTo(limit38) <= 0) break;
                    pi.sqlType = "decimal(38," + value.scale() + ")";
                    break;
                }
                if (value.scale() <= 10 && value.compareTo(limit28) <= 0) break;
                pi.sqlType = "decimal(28," + value.scale() + ")";
                break;
            }
            case 0: 
            case 1111: {
                pi.tdsType = 39;
                pi.sqlType = "varchar(255)";
                break;
            }
            default: {
                throw new SQLException(Messages.get("error.baddatatype", Integer.toString(pi.jdbcType)), "HY000");
            }
        }
    }

    static int getTds5ParamSize(String charset, boolean isWideChar, ParamInfo pi, boolean useParamNames) {
        int size = 8;
        if (pi.name != null && useParamNames) {
            if (isWideChar) {
                byte[] buf = Support.encodeString(charset, pi.name);
                size += buf.length;
            } else {
                size += pi.name.length();
            }
        }
        switch (pi.tdsType) {
            case 37: 
            case 38: 
            case 39: 
            case 109: 
            case 111: 
            case 123: 
            case 147: {
                ++size;
                break;
            }
            case 106: {
                size += 3;
                break;
            }
            case 175: 
            case 225: {
                size += 4;
                break;
            }
            case 50: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported output TDS type 0x" + Integer.toHexString(pi.tdsType));
            }
        }
        return size;
    }

    static void writeTds5ParamFmt(RequestStream out, String charset, boolean isWideChar, ParamInfo pi, boolean useParamNames) throws IOException {
        if (pi.name != null && useParamNames) {
            if (isWideChar) {
                byte[] buf = Support.encodeString(charset, pi.name);
                out.write((byte)buf.length);
                out.write(buf);
            } else {
                out.write((byte)pi.name.length());
                out.write(pi.name);
            }
        } else {
            out.write((byte)0);
        }
        out.write(pi.isOutput ? (byte)1 : 0);
        out.write(0);
        out.write((byte)pi.tdsType);
        switch (pi.tdsType) {
            case 37: 
            case 39: {
                out.write((byte)-1);
                break;
            }
            case 175: {
                out.write(Integer.MAX_VALUE);
                break;
            }
            case 225: {
                out.write(Integer.MAX_VALUE);
                break;
            }
            case 50: {
                break;
            }
            case 38: {
                out.write((byte)4);
                break;
            }
            case 109: 
            case 111: {
                out.write((byte)8);
                break;
            }
            case 123: 
            case 147: {
                out.write((byte)4);
                break;
            }
            case 106: {
                out.write((byte)17);
                out.write((byte)38);
                if (pi.jdbcType == -5) {
                    out.write((byte)0);
                    break;
                }
                if (pi.value instanceof BigDecimal) {
                    out.write((byte)((BigDecimal)pi.value).scale());
                    break;
                }
                out.write((byte)10);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported output TDS type " + Integer.toHexString(pi.tdsType));
            }
        }
        out.write((byte)0);
    }

    static void writeTds5Param(RequestStream out, String charset, boolean isWideChar, ParamInfo pi) throws IOException, SQLException {
        switch (pi.tdsType) {
            case 39: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                if (buf.length == 0) {
                    buf = new byte[]{32};
                }
                if (buf.length > 255) {
                    throw new SQLException(Messages.get("error.generic.truncmbcs"), "HY000");
                }
                out.write((byte)buf.length);
                out.write(buf);
                break;
            }
            case 37: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                out.write((byte)buf.length);
                out.write(buf);
                break;
            }
            case 175: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                if (buf.length == 0) {
                    buf = new byte[]{32};
                }
                out.write(buf.length);
                out.write(buf);
                break;
            }
            case 225: {
                if (pi.value == null) {
                    out.write(0);
                    break;
                }
                if (pi.sqlType.startsWith("univarchar")) {
                    String tmp = pi.getString(charset);
                    out.write(tmp.length() * 2);
                    out.write(tmp.toCharArray(), 0, tmp.length());
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                out.write(buf.length);
                out.write(buf);
                break;
            }
            case 38: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((byte)4);
                out.write(((Number)pi.value).intValue());
                break;
            }
            case 109: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((byte)8);
                out.write(((Number)pi.value).doubleValue());
                break;
            }
            case 111: {
                TdsData.putDateTimeValue(out, pi.value);
                break;
            }
            case 123: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                GregorianCalendar buf = cal;
                synchronized (buf) {
                    out.write((byte)4);
                    cal.setTime((java.util.Date)pi.value);
                    int daysSince1900 = TdsData.calendarToSybDate(cal.get(1), cal.get(2) + 1, cal.get(5));
                    out.write(daysSince1900);
                    break;
                }
            }
            case 147: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                GregorianCalendar buf = cal;
                synchronized (buf) {
                    out.write((byte)4);
                    int time = TdsData.calendarToSybTime(cal, pi.value);
                    cal.setTime((java.util.Date)pi.value);
                    out.write(time);
                    break;
                }
            }
            case 50: {
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((Boolean)pi.value != false ? (byte)1 : 0);
                break;
            }
            case 106: 
            case 108: {
                BigDecimal value = null;
                if (pi.value != null) {
                    value = pi.value instanceof Long ? new BigDecimal(pi.value.toString()) : (BigDecimal)pi.value;
                }
                out.write(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported output TDS type " + Integer.toHexString(pi.tdsType));
            }
        }
    }

    static void putCollation(RequestStream out, ParamInfo pi) throws IOException {
        if (TdsData.types[pi.tdsType].isCollation) {
            if (pi.collation != null) {
                out.write(pi.collation);
            } else {
                byte[] collation = new byte[]{0, 0, 0, 0, 0};
                out.write(collation);
            }
        }
    }

    static void writeParam(RequestStream out, String charset, boolean isWideChar, byte[] collation, ParamInfo pi) throws IOException, SQLException {
        boolean isTds8;
        boolean bl = isTds8 = out.getTdsVersion() >= 4;
        if (isTds8 && pi.collation == null) {
            pi.collation = collation;
        }
        switch (pi.tdsType) {
            case 167: {
                if (pi.value == null) {
                    out.write((byte)pi.tdsType);
                    out.write((short)8000);
                    if (isTds8) {
                        TdsData.putCollation(out, pi);
                    }
                    out.write((short)-1);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                if (buf.length > 8000) {
                    out.write((byte)35);
                    out.write(buf.length);
                    if (isTds8) {
                        TdsData.putCollation(out, pi);
                    }
                    out.write(buf.length);
                    out.write(buf);
                    break;
                }
                out.write((byte)pi.tdsType);
                out.write((short)8000);
                if (isTds8) {
                    TdsData.putCollation(out, pi);
                }
                out.write((short)buf.length);
                out.write(buf);
                break;
            }
            case 39: {
                if (pi.value == null) {
                    out.write((byte)pi.tdsType);
                    out.write((byte)-1);
                    out.write((byte)0);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                if (buf.length > 255) {
                    if (buf.length < 8001 && out.getTdsVersion() >= 3) {
                        out.write((byte)-89);
                        out.write((short)8000);
                        if (isTds8) {
                            TdsData.putCollation(out, pi);
                        }
                        out.write((short)buf.length);
                        out.write(buf);
                        break;
                    }
                    out.write((byte)35);
                    out.write(buf.length);
                    if (isTds8) {
                        TdsData.putCollation(out, pi);
                    }
                    out.write(buf.length);
                    out.write(buf);
                    break;
                }
                if (buf.length == 0) {
                    buf = new byte[]{32};
                }
                out.write((byte)pi.tdsType);
                out.write((byte)-1);
                out.write((byte)buf.length);
                out.write(buf);
                break;
            }
            case 231: {
                out.write((byte)pi.tdsType);
                out.write((short)8000);
                if (isTds8) {
                    TdsData.putCollation(out, pi);
                }
                if (pi.value == null) {
                    out.write((short)-1);
                    break;
                }
                String tmp = pi.getString(charset);
                out.write((short)(tmp.length() * 2));
                out.write(tmp);
                break;
            }
            case 35: {
                int len;
                if (pi.value == null) {
                    len = 0;
                } else {
                    len = pi.length;
                    if (len == 0 && out.getTdsVersion() < 3) {
                        pi.value = " ";
                        len = 1;
                    }
                }
                out.write((byte)pi.tdsType);
                if (len > 0) {
                    if (pi.value instanceof InputStream) {
                        out.write(len);
                        if (isTds8) {
                            TdsData.putCollation(out, pi);
                        }
                        out.write(len);
                        out.writeStreamBytes((InputStream)pi.value, len);
                        break;
                    }
                    if (pi.value instanceof Reader && !isWideChar) {
                        out.write(len);
                        if (isTds8) {
                            TdsData.putCollation(out, pi);
                        }
                        out.write(len);
                        out.writeReaderBytes((Reader)pi.value, len);
                        break;
                    }
                    byte[] buf = pi.getBytes(charset);
                    out.write(buf.length);
                    if (isTds8) {
                        TdsData.putCollation(out, pi);
                    }
                    out.write(buf.length);
                    out.write(buf);
                    break;
                }
                out.write(len);
                if (isTds8) {
                    TdsData.putCollation(out, pi);
                }
                out.write(len);
                break;
            }
            case 99: {
                int len = pi.value == null ? 0 : pi.length;
                out.write((byte)pi.tdsType);
                if (len > 0) {
                    if (pi.value instanceof Reader) {
                        out.write(len);
                        if (isTds8) {
                            TdsData.putCollation(out, pi);
                        }
                        out.write(len * 2);
                        out.writeReaderChars((Reader)pi.value, len);
                        break;
                    }
                    if (pi.value instanceof InputStream && !isWideChar) {
                        out.write(len);
                        if (isTds8) {
                            TdsData.putCollation(out, pi);
                        }
                        out.write(len * 2);
                        out.writeReaderChars(new InputStreamReader((InputStream)pi.value, charset), len);
                        break;
                    }
                    String tmp = pi.getString(charset);
                    len = tmp.length();
                    out.write(len);
                    if (isTds8) {
                        TdsData.putCollation(out, pi);
                    }
                    out.write(len * 2);
                    out.write(tmp);
                    break;
                }
                out.write(len);
                if (isTds8) {
                    TdsData.putCollation(out, pi);
                }
                out.write(len);
                break;
            }
            case 165: {
                out.write((byte)pi.tdsType);
                out.write((short)8000);
                if (pi.value == null) {
                    out.write((short)-1);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                out.write((short)buf.length);
                out.write(buf);
                break;
            }
            case 37: {
                out.write((byte)pi.tdsType);
                out.write((byte)-1);
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                byte[] buf = pi.getBytes(charset);
                out.write((byte)buf.length);
                out.write(buf);
                break;
            }
            case 34: {
                int len = pi.value == null ? 0 : pi.length;
                out.write((byte)pi.tdsType);
                if (len > 0) {
                    if (pi.value instanceof InputStream) {
                        out.write(len);
                        out.write(len);
                        out.writeStreamBytes((InputStream)pi.value, len);
                        break;
                    }
                    byte[] buf = pi.getBytes(charset);
                    out.write(buf.length);
                    out.write(buf.length);
                    out.write(pi.getBytes(charset));
                    break;
                }
                out.write(len);
                out.write(len);
                break;
            }
            case 38: {
                out.write((byte)pi.tdsType);
                if (pi.value == null) {
                    out.write(pi.sqlType.equals("bigint") ? (byte)8 : 4);
                    out.write((byte)0);
                    break;
                }
                if (pi.sqlType.equals("bigint")) {
                    out.write((byte)8);
                    out.write((byte)8);
                    out.write(((Number)pi.value).longValue());
                    break;
                }
                out.write((byte)4);
                out.write((byte)4);
                out.write(((Number)pi.value).intValue());
                break;
            }
            case 109: {
                out.write((byte)pi.tdsType);
                out.write((byte)8);
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((byte)8);
                out.write(((Number)pi.value).doubleValue());
                break;
            }
            case 111: {
                out.write((byte)111);
                out.write((byte)8);
                TdsData.putDateTimeValue(out, pi.value);
                break;
            }
            case 50: {
                out.write((byte)pi.tdsType);
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((Boolean)pi.value != false ? (byte)1 : 0);
                break;
            }
            case 104: {
                out.write((byte)104);
                out.write((byte)1);
                if (pi.value == null) {
                    out.write((byte)0);
                    break;
                }
                out.write((byte)1);
                out.write((Boolean)pi.value != false ? (byte)1 : 0);
                break;
            }
            case 106: 
            case 108: {
                out.write((byte)pi.tdsType);
                BigDecimal value = null;
                int prec = out.getMaxPrecision();
                int scale = pi.jdbcType == -5 ? 0 : (pi.scale > 10 && pi.scale < prec ? pi.scale : 10);
                if (pi.value != null) {
                    if (pi.value instanceof Long) {
                        value = new BigDecimal(((Long)pi.value).toString());
                        scale = 0;
                    } else {
                        value = (BigDecimal)pi.value;
                        scale = value.scale();
                    }
                }
                int maxLen = prec <= 28 ? 13 : 17;
                out.write((byte)maxLen);
                out.write((byte)prec);
                out.write((byte)scale);
                out.write(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported output TDS type " + Integer.toHexString(pi.tdsType));
            }
        }
    }

    private TdsData() {
    }

    private static void sybDateToCalendar(int julianDate, GregorianCalendar cal) {
        int l = julianDate + 68569 + 2415021;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        l = l - 1461 * i / 4 + 31;
        int j = 80 * l / 2447;
        int k = l - 2447 * j / 80;
        l = j / 11;
        j = j + 2 - 12 * l;
        i = 100 * (n - 49) + i + l;
        cal.set(1, i);
        cal.set(2, j - 1);
        cal.set(5, k);
    }

    private static void sybTimeToCalendar(int time, GregorianCalendar cal) {
        int hours = time / 1080000;
        cal.set(11, hours);
        int minutes = (time -= hours * 1080000) / 18000;
        cal.set(12, minutes);
        int seconds = (time -= minutes * 18000) / 300;
        cal.set(13, seconds);
        time -= seconds * 300;
        time = Math.round((float)(time * 1000) / 300.0f);
        cal.set(14, time);
    }

    private static Object getDatetimeValue(ResponseStream in, int type) throws IOException, ProtocolException {
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            int len = type == 111 ? in.read() : (type == 58 ? 4 : 8);
            switch (len) {
                case 0: {
                    Object var8_4 = null;
                    return var8_4;
                }
                case 8: {
                    int daysSince1900 = in.readInt();
                    TdsData.sybDateToCalendar(daysSince1900, cal);
                    int time = in.readInt();
                    TdsData.sybTimeToCalendar(time, cal);
                    Timestamp timestamp = new Timestamp(cal.getTime().getTime());
                    return timestamp;
                }
                case 4: {
                    int daysSince1900 = in.readShort() & 0xFFFF;
                    TdsData.sybDateToCalendar(daysSince1900, cal);
                    int minutes = in.readShort();
                    int hours = minutes / 60;
                    cal.set(11, hours);
                    cal.set(12, minutes -= hours * 60);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Timestamp timestamp = new Timestamp(cal.getTime().getTime());
                    return timestamp;
                }
            }
            throw new ProtocolException("Invalid DATETIME value with size of " + len + " bytes.");
        }
    }

    private static int calendarToSybDate(int year, int month, int day) {
        return day - 32075 + 1461 * (year + 4800 + (month - 14) / 12) / 4 + 367 * (month - 2 - (month - 14) / 12 * 12) / 12 - 3 * ((year + 4900 + (month - 14) / 12) / 100) / 4 - 2415021;
    }

    private static int calendarToSybTime(GregorianCalendar cal, Object value) {
        cal.setTime((java.util.Date)value);
        if (!Driver.JDBC3 && value instanceof Timestamp) {
            cal.set(14, ((Timestamp)value).getNanos() / 1000000);
        }
        int time = cal.get(11) * 1080000;
        time += cal.get(12) * 18000;
        time += cal.get(13) * 300;
        if (value instanceof Timestamp) {
            time += Math.round((float)cal.get(14) * 300.0f / 1000.0f);
        }
        if (time > 25919999) {
            time = 0;
            cal.add(5, 1);
        }
        return time;
    }

    private static void putDateTimeValue(RequestStream out, Object value) throws IOException {
        if (value == null) {
            out.write((byte)0);
            return;
        }
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            out.write((byte)8);
            int time = TdsData.calendarToSybTime(cal, value);
            int daysSince1900 = value instanceof Time ? 0 : TdsData.calendarToSybDate(cal.get(1), cal.get(2) + 1, cal.get(5));
            out.write(daysSince1900);
            out.write(time);
        }
    }

    private static Object getMoneyValue(ResponseStream in, int type) throws IOException, ProtocolException {
        int len = type == 60 ? 8 : (type == 110 ? in.read() : 4);
        BigInteger x = null;
        if (len == 4) {
            x = BigInteger.valueOf(in.readInt());
        } else if (len == 8) {
            byte b4 = (byte)in.read();
            byte b5 = (byte)in.read();
            byte b6 = (byte)in.read();
            byte b7 = (byte)in.read();
            byte b0 = (byte)in.read();
            byte b1 = (byte)in.read();
            byte b2 = (byte)in.read();
            byte b3 = (byte)in.read();
            long l = (long)(b0 & 0xFF) + ((long)(b1 & 0xFF) << 8) + ((long)(b2 & 0xFF) << 16) + ((long)(b3 & 0xFF) << 24) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 40) + ((long)(b6 & 0xFF) << 48) + ((long)(b7 & 0xFF) << 56);
            x = BigInteger.valueOf(l);
        } else if (len != 0) {
            throw new ProtocolException("Invalid money value.");
        }
        return x == null ? null : new BigDecimal(x, 4);
    }

    private static Object getVariant(ResponseStream in) throws IOException, ProtocolException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        ColInfo ci = new ColInfo();
        len -= 2;
        ci.tdsType = in.read();
        len -= in.read();
        switch (ci.tdsType) {
            case 48: {
                return new Integer(in.read() & 0xFF);
            }
            case 52: {
                return new Integer(in.readShort());
            }
            case 56: {
                return new Integer(in.readInt());
            }
            case 127: {
                return new Long(in.readLong());
            }
            case 167: 
            case 175: {
                in.skip(7);
                return in.readAsciiString(len);
            }
            case 231: 
            case 239: {
                in.skip(7);
                return in.readString(len / 2);
            }
            case 165: 
            case 173: {
                in.skip(2);
                byte[] bytes = new byte[len];
                in.read(bytes);
                return bytes;
            }
            case 60: 
            case 122: {
                return TdsData.getMoneyValue(in, ci.tdsType);
            }
            case 58: 
            case 61: {
                return TdsData.getDatetimeValue(in, ci.tdsType);
            }
            case 50: {
                return in.read() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 59: {
                return new Float(Float.intBitsToFloat(in.readInt()));
            }
            case 62: {
                return new Double(Double.longBitsToDouble(in.readLong()));
            }
            case 36: {
                byte[] bytes = new byte[len];
                in.read(bytes);
                return new UniqueIdentifier(bytes);
            }
            case 106: 
            case 108: {
                ci.precision = in.read();
                ci.scale = in.read();
                int sign = in.read();
                byte[] bytes = new byte[--len];
                while (len-- > 0) {
                    bytes[len] = (byte)in.read();
                }
                BigInteger bi = new BigInteger(sign == 0 ? -1 : 1, bytes);
                return new BigDecimal(bi, ci.scale);
            }
        }
        throw new ProtocolException("Unsupported TDS data type 0x" + Integer.toHexString(ci.tdsType) + " in sql_variant");
    }

    public static int getTdsVersion(int rawTdsVersion) {
        if (rawTdsVersion >= 0x71000001) {
            return 5;
        }
        if (rawTdsVersion >= 0x7010000) {
            return 4;
        }
        if (rawTdsVersion >= 0x7000000) {
            return 3;
        }
        if (rawTdsVersion >= 0x5000000) {
            return 2;
        }
        return 1;
    }

    private static boolean canEncode(String value, String charset) {
        char[] buf = value.toCharArray();
        int i = 0;
        while (i < buf.length) {
            if (buf[i] > '\u007f') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        TdsData.types[47] = new TypeInfo("char", -1, -1, 1, false, false, 1);
        TdsData.types[39] = new TypeInfo("varchar", -1, -1, 1, false, false, 12);
        TdsData.types[38] = new TypeInfo("int", -1, 10, 11, true, false, 4);
        TdsData.types[48] = new TypeInfo("tinyint", 1, 2, 3, false, false, -6);
        TdsData.types[52] = new TypeInfo("smallint", 2, 5, 6, true, false, 5);
        TdsData.types[56] = new TypeInfo("int", 4, 10, 11, true, false, 4);
        TdsData.types[127] = new TypeInfo("bigint", 8, 20, 20, true, false, -5);
        TdsData.types[62] = new TypeInfo("float", 8, 15, 24, true, false, 8);
        TdsData.types[61] = new TypeInfo("datetime", 8, 23, 23, false, false, 93);
        TdsData.types[50] = new TypeInfo("bit", 1, 1, 1, false, false, -7);
        TdsData.types[35] = new TypeInfo("text", -4, -1, 1, false, true, -1);
        TdsData.types[99] = new TypeInfo("ntext", -4, -1, -2, false, true, -1);
        TdsData.types[34] = new TypeInfo("image", -4, -1, 2, false, false, -4);
        TdsData.types[122] = new TypeInfo("smallmoney", 4, 10, 12, true, false, 3);
        TdsData.types[60] = new TypeInfo("money", 8, 19, 21, true, false, 3);
        TdsData.types[58] = new TypeInfo("smalldatetime", 4, 16, 19, false, false, 93);
        TdsData.types[59] = new TypeInfo("real", 4, 7, 14, true, false, 7);
        TdsData.types[45] = new TypeInfo("binary", -1, 1, 2, false, false, -2);
        TdsData.types[31] = new TypeInfo("void", -1, 1, 1, false, false, 0);
        TdsData.types[37] = new TypeInfo("varbinary", -1, -1, 2, false, false, -3);
        TdsData.types[103] = new TypeInfo("nvarchar", -1, -1, -2, false, false, 12);
        TdsData.types[104] = new TypeInfo("bit", -1, 1, 1, false, false, -7);
        TdsData.types[108] = new TypeInfo("numeric", -1, -1, -1, true, false, 2);
        TdsData.types[106] = new TypeInfo("decimal", -1, -1, -1, true, false, 3);
        TdsData.types[109] = new TypeInfo("float", -1, 15, 24, true, false, 8);
        TdsData.types[110] = new TypeInfo("money", -1, 19, 21, true, false, 3);
        TdsData.types[111] = new TypeInfo("datetime", -1, 23, 23, false, false, 93);
        TdsData.types[49] = new TypeInfo("date", 4, 10, 10, false, false, 91);
        TdsData.types[51] = new TypeInfo("time", 4, 8, 8, false, false, 92);
        TdsData.types[123] = new TypeInfo("date", -1, 10, 10, false, false, 91);
        TdsData.types[147] = new TypeInfo("time", -1, 8, 8, false, false, 92);
        TdsData.types[175] = new TypeInfo("char", -2, -1, 1, false, true, 1);
        TdsData.types[167] = new TypeInfo("varchar", -2, -1, 1, false, true, 12);
        TdsData.types[231] = new TypeInfo("nvarchar", -2, -1, -2, false, true, 12);
        TdsData.types[239] = new TypeInfo("nchar", -2, -1, -2, false, true, 1);
        TdsData.types[165] = new TypeInfo("varbinary", -2, -1, 2, false, false, -3);
        TdsData.types[173] = new TypeInfo("binary", -2, -1, 2, false, false, -2);
        TdsData.types[225] = new TypeInfo("varbinary", -5, -1, 2, false, false, -2);
        TdsData.types[64] = new TypeInfo("tinyint", 1, 2, 3, false, false, -6);
        TdsData.types[65] = new TypeInfo("smallint", 2, 5, 6, false, false, 5);
        TdsData.types[66] = new TypeInfo("int", 4, 10, 11, false, false, 4);
        TdsData.types[67] = new TypeInfo("bigint", 8, 20, 20, false, false, -5);
        TdsData.types[36] = new TypeInfo("uniqueidentifier", -1, 36, 36, false, false, 12);
        TdsData.types[98] = new TypeInfo("sql_variant", -5, 1, 1, false, false, 1111);
        cal = new GregorianCalendar();
        limit28 = new BigDecimal("999999999999999999");
        limit38 = new BigDecimal("9999999999999999999999999999");
    }

    private static class TypeInfo {
        public String sqlType;
        public int size;
        public int precision;
        public int displaySize;
        public boolean isSigned;
        public boolean isCollation;
        public int jdbcType;

        TypeInfo(String sqlType, int size, int precision, int displaySize, boolean isSigned, boolean isCollation, int jdbcType) {
            this.sqlType = sqlType;
            this.size = size;
            this.precision = precision;
            this.displaySize = displaySize;
            this.isSigned = isSigned;
            this.isCollation = isCollation;
            this.jdbcType = jdbcType;
        }
    }
}

