/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.classEditor;

import ch.abacus.designcockpit.classEditor.LizardBasicComboBoxEditor;
import ch.abacus.designcockpit.classEditor.LizardMetalComboBoxEditor;
import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.Component;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;

public class LizardComboBox
extends JComboBox {
    MetaClass theMetaClass = null;
    public MetadataDispenser theMetadataDispenser = null;
    public Object theReceiver = null;
    public ComboBoxModel theModel = null;
    ComboBoxEditor theComboBoxEditor = null;
    String sStoredValue = null;

    public LizardComboBox(ComboBoxModel objModel, Object objReceiver) {
        super(objModel);
        this.setEditable(true);
        this.theModel = objModel;
        this.theReceiver = objReceiver;
        ComboBoxEditor theEditor = this.getEditor();
        if (theEditor instanceof MetalComboBoxEditor) {
            this.theComboBoxEditor = new LizardMetalComboBoxEditor(objReceiver);
            this.setEditor(this.theComboBoxEditor);
        } else if (theEditor instanceof BasicComboBoxEditor) {
            this.theComboBoxEditor = new LizardBasicComboBoxEditor(objReceiver);
            this.setEditor(this.theComboBoxEditor);
        } else if (theEditor != null) {
            System.out.println("Don't know this combo! " + theEditor.getClass().getName());
            this.theComboBoxEditor = this.getEditor();
        } else {
            System.out.println("Cannot find editor for combobox");
            this.setEditable(false);
            this.theComboBoxEditor = null;
        }
    }

    public void setEditorText(String sValue) {
        ComboBoxEditor theEditor = this.getEditor();
        JTextField theEditField = (JTextField)theEditor.getEditorComponent();
        theEditField.setText(sValue);
    }

    public void SelectAllText() {
        ComboBoxEditor theEditor = this.getEditor();
        JATextArea theEditField = (JATextArea)theEditor.getEditorComponent();
        theEditField.selectAll();
    }

    public void resetEditor() {
        this.configureEditor(this.getEditor(), "");
    }

    public static void registerComboFocusListener(JAComboBox box, FocusListener listener, String name) {
        Component editor = box.getEditor().getEditorComponent();
        editor.setName(name);
        editor.addFocusListener(listener);
        LookAndFeel currentLAF = null;
        currentLAF = UIManager.getLookAndFeel();
        if (currentLAF != null) {
            if (currentLAF.getID().equals("Metal")) {
                Component[] comboComponents = box.getComponents();
                for (int i = 0; i < comboComponents.length; ++i) {
                    if (!(comboComponents[i] instanceof MetalComboBoxButton)) continue;
                    comboComponents[i].addFocusListener(listener);
                    comboComponents[i].setName(name);
                    return;
                }
            }
            box.setName(name);
            box.addFocusListener(listener);
        }
    }
}

