/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import com.ibm.cf.CodeFormatter;
import electric.xml.Child;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DesignCockpitPreferences {
    final SuperDesignCockpit theDesignCockpit;
    public static final int METAL_LAF = 0;
    public static final int MOTIF_LAF = 1;
    public static final int MAC_LAF = 2;
    public static final int WINDOWS_LAF = 3;
    public static final int DEFAULT_LOOK = 0;
    public static final int PLASTICXP_LOOK = 1;
    public static final int PLASTIC3D_LOOK = 2;
    public static final int PLASTIC_LOOK = 3;
    private static final int MINIMUM_WINDOW_SIZE = 100;
    public String sFontChooserName = "ch.abacus.designcockpit.ide.IDEObjectFontChooser";
    public String sLookAndFeelName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public String sGenLookFeelName = "Default";
    public String sCodeGenerationDocument = "metadata.meta";
    public String sAuthor = "The unknown programmer";
    public String theWorkspace = "";
    public String sTransientDirectory = "transient";
    public String sStickyDelimiters = "";
    public String sDelimiters = "";
    public int iIndentation = 0;
    public int iMaxLineLength = 0;
    public int iSizeBoxHeight = 4;
    public int iSizeBoxWidth = 4;
    public int iViewDisplayerGridX = 8;
    public int iViewDisplayerGridY = 8;
    private int iWidthColumnOne;
    private int iWidthColumnTwo;
    private int iSplitColumnOne;
    private int iSplitColumnTwo;
    private int iSplitColumnThree;
    private String sGeneratedCodeLookFeel;
    public String thePreferencesDocument = null;
    public String sWorkingDirectory = "";
    public boolean bDisplayGrid = true;
    private boolean bFrameMaximized = true;
    private Rectangle framePlacement = new Rectangle(100, 100, 800, 600);
    private String sRepositPath = null;
    private String sAdditionalClasspath = null;
    public boolean bDisplayBackgroundGrid = false;
    public boolean bSnapToGrid = true;

    public DesignCockpitPreferences(int theMode, SuperDesignCockpit designCockpit) {
        this.theDesignCockpit = designCockpit;
        this.theWorkspace = "default";
        this.thePreferencesDocument = this.theWorkspace + ".conf";
        this.cfInit();
        this.load(theMode, this.theDesignCockpit);
    }

    public DesignCockpitPreferences(int theMode, SuperDesignCockpit designCockpit, String sWorkspace) {
        this.theDesignCockpit = designCockpit;
        this.theWorkspace = sWorkspace;
        this.thePreferencesDocument = this.theWorkspace + ".conf";
        this.cfInit();
        this.load(theMode, this.theDesignCockpit);
    }

    public void cfInit() {
        CodeFormatter theFormatter = new CodeFormatter();
        this.iIndentation = theFormatter.getIndentationStep();
        this.iMaxLineLength = theFormatter.getMaxLineLength();
        this.sStickyDelimiters = theFormatter.getStickyDelimiters();
        this.sDelimiters = theFormatter.getDelimiters();
    }

    public boolean load(int theMode, SuperDesignCockpit theDesignCockpit) {
        if (theDesignCockpit.isCustomizing()) {
            this.setDefaultWindowSizes();
            theDesignCockpit.theCustomizer.loadPreferences(this);
        } else {
            Element xmlMruRoot;
            Element xmlAdditionalClassPath;
            Element xmlRepositPath;
            Element xmlSnapToGrid;
            Element xmlDisplayGrid;
            Element xmlGeneratedCodeLookFeel;
            Element xmlColumnThreeSplit;
            Element xmlColumnTwoSplit;
            Element xmlColumnOneSplit;
            Element xmlColumnTwoWidth;
            Element xmlGridY;
            Element xmlGridX;
            Element xmlSizeBoxWidth;
            Element xmlSizeBoxHeight;
            Element xmlMaxLineLength;
            Element xmlIndentation;
            Element xmlDelims;
            Element xmlSticky;
            Element xmlWorking;
            Element xmlTransient;
            Element xmlAuthor;
            Element xmlMetafile;
            Element xmlLookAndFeel;
            Document xmlPreferencesDocument = null;
            try {
                File fileInput = new File(this.thePreferencesDocument);
                if (!fileInput.exists()) {
                    return true;
                }
                xmlPreferencesDocument = new Document(fileInput);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                return false;
            }
            Element xmlRoot = xmlPreferencesDocument.getRoot();
            Element xmlFontChooser = xmlRoot.getElement("FONT_CHOOSER");
            if (xmlFontChooser != null) {
                this.sFontChooserName = xmlFontChooser.getTextString();
            }
            if ((xmlLookAndFeel = xmlRoot.getElement("PLAF")) != null) {
                this.sLookAndFeelName = xmlLookAndFeel.getTextString();
            }
            if ((xmlMetafile = xmlRoot.getElement("Metafile")) != null) {
                this.sCodeGenerationDocument = xmlMetafile.getTextString();
            }
            if ((xmlAuthor = xmlRoot.getElement("Author")) != null) {
                this.sAuthor = xmlAuthor.getTextString();
            }
            if ((xmlTransient = xmlRoot.getElement("Transient")) != null) {
                this.sTransientDirectory = xmlTransient.getTextString();
            }
            if ((xmlWorking = xmlRoot.getElement("Working")) != null) {
                this.sWorkingDirectory = xmlWorking.getTextString();
            }
            if ((xmlSticky = xmlRoot.getElement("StickyDelims")) != null) {
                this.sStickyDelimiters = xmlSticky.getTextString();
            }
            if ((xmlDelims = xmlRoot.getElement("Delims")) != null) {
                this.sDelimiters = xmlDelims.getTextString();
            }
            if ((xmlIndentation = xmlRoot.getElement("Indentation")) != null) {
                this.iIndentation = new Integer(xmlIndentation.getTextString());
            }
            if ((xmlMaxLineLength = xmlRoot.getElement("MaxLineLength")) != null) {
                this.iMaxLineLength = new Integer(xmlMaxLineLength.getTextString());
            }
            if ((xmlSizeBoxHeight = xmlRoot.getElement("SizeBoxHeight")) != null) {
                this.iSizeBoxHeight = new Integer(xmlSizeBoxHeight.getTextString());
            }
            if ((xmlSizeBoxWidth = xmlRoot.getElement("SizeBoxWidth")) != null) {
                this.iSizeBoxWidth = new Integer(xmlSizeBoxWidth.getTextString());
            }
            if ((xmlGridX = xmlRoot.getElement("GridWidth")) != null) {
                this.iViewDisplayerGridX = new Integer(xmlGridX.getTextString());
            }
            if ((xmlGridY = xmlRoot.getElement("GridHeight")) != null) {
                this.iViewDisplayerGridY = new Integer(xmlGridY.getTextString());
            }
            this.readFramePosition(xmlRoot);
            this.setDefaultWindowSizes();
            Element xmlColumnOneWidth = xmlRoot.getElement("ColumnOneWidth");
            if (xmlColumnOneWidth != null) {
                this.iWidthColumnOne = this.getSizeOrMinimum(xmlColumnOneWidth.getTextString());
            }
            if ((xmlColumnTwoWidth = xmlRoot.getElement("ColumnTwoWidth")) != null) {
                this.iWidthColumnTwo = this.getSizeOrMinimum(xmlColumnTwoWidth.getTextString());
            }
            if ((xmlColumnOneSplit = xmlRoot.getElement("ColumnOneSplit")) != null) {
                this.iSplitColumnOne = this.getSizeOrMinimum(xmlColumnOneSplit.getTextString());
            }
            if ((xmlColumnTwoSplit = xmlRoot.getElement("ColumnTwoSplit")) != null) {
                this.iSplitColumnTwo = this.getSizeOrMinimum(xmlColumnTwoSplit.getTextString());
            }
            if ((xmlColumnThreeSplit = xmlRoot.getElement("ColumnThreeSplit")) != null) {
                this.iSplitColumnThree = this.getSizeOrMinimum(xmlColumnThreeSplit.getTextString());
            }
            if (theDesignCockpit != null && theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER && (xmlGeneratedCodeLookFeel = xmlRoot.getElement("GeneratedCodeLookFeel")) != null) {
                this.sGeneratedCodeLookFeel = xmlGeneratedCodeLookFeel.getTextString();
            }
            if ((xmlDisplayGrid = xmlRoot.getElement("DisplayGrid")) != null) {
                this.bDisplayGrid = xmlDisplayGrid.getBoolean();
            }
            if ((xmlSnapToGrid = xmlRoot.getElement("SnapToGrid")) != null) {
                this.bSnapToGrid = xmlSnapToGrid.getBoolean();
            }
            if ((xmlRepositPath = xmlRoot.getElement("RepositoryPath")) != null) {
                this.sRepositPath = xmlRepositPath.getTextString();
            }
            if ((xmlAdditionalClassPath = xmlRoot.getElement("AdditionalClassPath")) != null) {
                this.sAdditionalClasspath = xmlAdditionalClassPath.getTextString();
            }
            if ((xmlMruRoot = xmlRoot.getElement("MRU")) != null) {
                int iFiles;
                for (int iFile = iFiles = xmlMruRoot.getElements().size(); iFile >= 1; --iFile) {
                    Element xmlMruFile = xmlMruRoot.getElement(new Integer(iFile).toString());
                    String sFile = xmlMruFile.getTextString();
                    theDesignCockpit.mruList.fileClosed(sFile);
                }
            }
        }
        return true;
    }

    private void setDefaultWindowSizes() {
        Dimension frameSize;
        if (this.bFrameMaximized) {
            Toolkit kit = Toolkit.getDefaultToolkit();
            frameSize = kit.getScreenSize();
        } else {
            frameSize = this.framePlacement.getSize();
        }
        this.iWidthColumnOne = frameSize.width / 4;
        this.iWidthColumnTwo = frameSize.width / 2 + this.iWidthColumnOne;
        this.iSplitColumnTwo = this.iSplitColumnThree = frameSize.height / 2;
        this.iSplitColumnOne = this.iSplitColumnThree;
    }

    public boolean save(SuperDesignCockpit theDesignCockpit) {
        this.iWidthColumnTwo = theDesignCockpit.paneRight.getDividerLocation();
        this.iSplitColumnOne = theDesignCockpit.paneOne.getDividerLocation();
        this.iSplitColumnTwo = theDesignCockpit.paneTwo.getDividerLocation();
        this.iSplitColumnThree = theDesignCockpit.paneThree.getDividerLocation();
        if (theDesignCockpit.isCustomizing()) {
            theDesignCockpit.theCustomizer.savePreferences(this);
        } else {
            try {
                Element xmlValue;
                File fileOutput = new File(this.thePreferencesDocument);
                PrintWriter pwOutput = new PrintWriter(new FileWriter(fileOutput));
                Document xmlPreferencesDocument = new Document();
                Element xmlRoot = new Element("Preferences");
                xmlPreferencesDocument.addChild((Child)xmlRoot);
                if (this.sLookAndFeelName != null) {
                    xmlValue = new Element("PLAF");
                    xmlValue.setText(this.sLookAndFeelName);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sCodeGenerationDocument != null) {
                    xmlValue = new Element("Metafile");
                    xmlValue.setText(this.sCodeGenerationDocument);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sAuthor != null) {
                    xmlValue = new Element("Author");
                    xmlValue.setText(this.sAuthor);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sTransientDirectory != null) {
                    xmlValue = new Element("Transient");
                    xmlValue.setText(this.sTransientDirectory);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sWorkingDirectory != null) {
                    xmlValue = new Element("Working");
                    xmlValue.setText(this.sWorkingDirectory);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sStickyDelimiters != null) {
                    xmlValue = new Element("StickyDelims");
                    xmlValue.setText(this.sStickyDelimiters);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sDelimiters != null) {
                    xmlValue = new Element("Delims");
                    xmlValue.setText(this.sDelimiters);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sGenLookFeelName != null) {
                    xmlValue = new Element("sGenLookFeelName");
                    xmlValue.setText(this.sGenLookFeelName);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sRepositPath != null) {
                    xmlValue = new Element("RepositoryPath");
                    xmlValue.setText(this.sRepositPath);
                    xmlRoot.addElement(xmlValue);
                }
                if (this.sAdditionalClasspath != null) {
                    xmlValue = new Element("AdditionalClassPath");
                    xmlValue.setText(this.sAdditionalClasspath);
                    xmlRoot.addElement(xmlValue);
                }
                xmlValue = new Element("Indentation");
                xmlValue.setText(new Integer(this.iIndentation).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("MaxLineLength");
                xmlValue.setText(new Integer(this.iMaxLineLength).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("SizeBoxHeight");
                xmlValue.setText(new Integer(this.iSizeBoxHeight).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("SizeBoxWidth");
                xmlValue.setText(new Integer(this.iSizeBoxWidth).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("GridHeight");
                xmlValue.setText(new Integer(this.iViewDisplayerGridY).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("GridWidth");
                xmlValue.setText(new Integer(this.iViewDisplayerGridX).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("ColumnOneWidth");
                xmlValue.setText(new Integer(this.iWidthColumnOne).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("ColumnTwoWidth");
                xmlValue.setText(new Integer(this.iWidthColumnTwo).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("ColumnOneSplit");
                xmlValue.setText(new Integer(this.iSplitColumnOne).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("ColumnTwoSplit");
                xmlValue.setText(new Integer(this.iSplitColumnTwo).toString());
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("ColumnThreeSplit");
                xmlValue.setText(new Integer(this.iSplitColumnThree).toString());
                xmlRoot.addElement(xmlValue);
                this.writeFramePosition(xmlRoot);
                xmlValue = new Element("DisplayGrid");
                xmlValue.setBoolean(theDesignCockpit.thePreferences.bDisplayGrid);
                xmlRoot.addElement(xmlValue);
                xmlValue = new Element("SnapToGrid");
                xmlValue.setBoolean(theDesignCockpit.thePreferences.bSnapToGrid);
                xmlRoot.addElement(xmlValue);
                Element xmlMru = new Element("MRU");
                xmlRoot.addChild((Child)xmlMru);
                Iterator li = theDesignCockpit.mruList.getArrayList().iterator();
                int iPosition = 1;
                while (li.hasNext()) {
                    String sFile = (String)li.next();
                    xmlValue = new Element(new Integer(iPosition).toString());
                    xmlValue.setText(sFile);
                    xmlMru.addElement(xmlValue);
                    ++iPosition;
                }
                xmlPreferencesDocument.write((Writer)pwOutput);
                pwOutput.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private void writeFramePosition(Element xmlRoot) {
        boolean bIsFrameMaximized = this.theDesignCockpit.theFramePlacement.isMaximized();
        Dimension frameSize = this.theDesignCockpit.theFramePlacement.getNormalSize();
        Point frameLocation = this.theDesignCockpit.theFramePlacement.getNormalLocation();
        Element xmlFramePosition = new Element("FramePlacement");
        Element xmlValue = new Element("Maximized");
        xmlValue.setText(new Boolean(bIsFrameMaximized).toString());
        xmlFramePosition.addElement(xmlValue);
        xmlValue = new Element("Height");
        xmlValue.setText(new Integer(frameSize.height).toString());
        xmlFramePosition.addElement(xmlValue);
        xmlValue = new Element("Width");
        xmlValue.setText(new Integer(frameSize.width).toString());
        xmlFramePosition.addElement(xmlValue);
        xmlValue = new Element("Top");
        xmlValue.setText(new Integer(frameLocation.y).toString());
        xmlFramePosition.addElement(xmlValue);
        xmlValue = new Element("Left");
        xmlValue.setText(new Integer(frameLocation.x).toString());
        xmlFramePosition.addElement(xmlValue);
        xmlRoot.addElement(xmlFramePosition);
    }

    private void readFramePosition(Element xmlRoot) {
        try {
            Element xmlFramePlacement = xmlRoot.getElement("FramePlacement");
            if (xmlFramePlacement != null) {
                this.bFrameMaximized = xmlFramePlacement.getBoolean("Maximized");
                this.framePlacement.height = xmlFramePlacement.getInt("Height");
                this.framePlacement.width = xmlFramePlacement.getInt("Width");
                this.framePlacement.y = xmlFramePlacement.getInt("Top");
                this.framePlacement.x = xmlFramePlacement.getInt("Left");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getPLAF(String sPLAF) {
        if (sPLAF.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
            return 0;
        }
        if (sPLAF.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            return 1;
        }
        if (sPLAF.equals("com.sun.java.swing.plaf.mac.MacLookAndFeel")) {
            return 2;
        }
        if (sPLAF.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
            return 3;
        }
        return 3;
    }

    public String getRepositPath() {
        return this.sRepositPath;
    }

    public void setRepositPath(String sValue) {
        this.sRepositPath = sValue;
    }

    public String getAdditionalClasspath() {
        return this.sAdditionalClasspath;
    }

    public void setAdditionalClasspath(String sValue) {
        this.sAdditionalClasspath = sValue;
    }

    public int getPLAF() {
        return this.getPLAF(this.sLookAndFeelName);
    }

    public String getPLAF(int iPLAF) {
        this.sLookAndFeelName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        switch (iPLAF) {
            case 0: {
                this.sLookAndFeelName = "javax.swing.plaf.metal.MetalLookAndFeel";
                break;
            }
            case 1: {
                this.sLookAndFeelName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                break;
            }
            case 2: {
                this.sLookAndFeelName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
            }
        }
        return this.sLookAndFeelName;
    }

    public void setPLAF(int iChoice, Component topComponent) {
        String sOldLookAndFeelName = this.sLookAndFeelName;
        this.sLookAndFeelName = this.getPLAF(iChoice);
        try {
            UIManager.setLookAndFeel(this.sLookAndFeelName);
            SwingUtilities.updateComponentTreeUI(topComponent);
        }
        catch (Exception evt) {
            JOptionPane.showMessageDialog(null, "Cannot change the look and feel to " + this.sLookAndFeelName, "Swing Failure", 1);
            this.sLookAndFeelName = sOldLookAndFeelName;
        }
    }

    public String getGenCodeLookFeel(int iGenCodeLAF) {
        this.sGenLookFeelName = "Default";
        switch (iGenCodeLAF) {
            case 1: {
                this.sGenLookFeelName = "PlasticXPLookAndFeel";
                break;
            }
            case 2: {
                this.sGenLookFeelName = "Plastic3DLookAndFeel";
                break;
            }
            case 3: {
                this.sGenLookFeelName = "PlasticLookAndFeel";
            }
        }
        return this.sGenLookFeelName;
    }

    public int getGenCodeLookFeel() {
        return this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getGenCodeLookFeel(this.sGenLookFeelName);
    }

    private int getSizeOrMinimum(String sSize) {
        int iSize = 100;
        try {
            iSize = Integer.parseInt(sSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (iSize < 100) {
            iSize = 100;
        }
        return iSize;
    }

    public int getFrameWidth() {
        return this.framePlacement.width;
    }

    public int getFrameHeight() {
        return this.framePlacement.height;
    }

    public int getFrameTop() {
        return this.framePlacement.y;
    }

    public int getFrameLeft() {
        return this.framePlacement.x;
    }

    public boolean isFrameMaximized() {
        return this.bFrameMaximized;
    }

    public void setFrameMaximized(boolean bMaximized) {
        this.bFrameMaximized = bMaximized;
    }

    public void setFrameWidth(int iWidth) {
        this.framePlacement.width = iWidth;
    }

    public void setFrameHeight(int iHeight) {
        this.framePlacement.height = iHeight;
    }

    public void setFrameLeft(int iLeft) {
        this.framePlacement.x = iLeft;
    }

    public void setFrameTop(int iTop) {
        this.framePlacement.y = iTop;
    }

    public int getWidthColumnOne() {
        return this.iWidthColumnOne;
    }

    public int getWidthColumnTwo() {
        return this.iWidthColumnTwo;
    }

    public int getSplitColumnOne() {
        return this.iSplitColumnOne;
    }

    public int getSplitColumnTwo() {
        return this.iSplitColumnTwo;
    }

    public int getSplitColumnThree() {
        return this.iSplitColumnThree;
    }

    public void setWidthColumnOne(int iWidthColumnOne) {
        this.iWidthColumnOne = iWidthColumnOne;
    }

    public void setWidthColumnTwo(int iWidthColumnTwo) {
        this.iWidthColumnTwo = iWidthColumnTwo;
    }

    public void setSplitColumnOne(int iSplitColumnOne) {
        this.iSplitColumnOne = iSplitColumnOne;
    }

    public void setSplitColumnTwo(int iSplitColumnTwo) {
        this.iSplitColumnTwo = iSplitColumnTwo;
    }

    public void setSplitColumnThree(int iSplitColumnThree) {
        this.iSplitColumnThree = iSplitColumnThree;
    }
}

