/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.IDEActionManager;
import ch.abacus.designcockpit.ide.LanguageManager;
import ch.abacus.designcockpit.ide.MruList;
import ch.abacus.designcockpit.ide.MruMenu;
import ch.abacus.designcockpit.ide.MruMenuEvent;
import ch.abacus.designcockpit.ide.SelectProjectAction;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.HammerException;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class IDEMenuBar
extends JMenuBar {
    private final SuperDesignCockpit theCockpit;
    private final IDEActionManager theActionManager;
    private FileMenu theFileMenu;
    private EditMenu theEditMenu;
    private ToolsMenu theToolsMenu;
    private WindowMenu theWindowMenu;
    private LanguageMenu theLanguageMenu;
    private HelpMenu theHelpMenu;

    public IDEMenuBar(SuperDesignCockpit superDesignCockpit, IDEActionManager ideActionManager) {
        this.theCockpit = superDesignCockpit;
        this.theActionManager = ideActionManager;
        this.initializeMenus();
        this.setBorder(null);
        this.setBackground(null);
    }

    void initializeMenus() {
        LanguageManager langManager = this.theCockpit.theLanguageManager;
        String sFileMenuLabel = langManager.getMessage("MenuBar.File.label", "File");
        char cFileMenuMnemonic = langManager.getMessage("MenuBar.File.mnemonic", "F").charAt(0);
        String sReopenMenuLabel = langManager.getMessage("MenuBar.File.Reopen.label", "Reopen");
        char cReopenMenuMnemonic = langManager.getMessage("MenuBar.File.Reopen.mnemonic", "R").charAt(0);
        this.theFileMenu = new FileMenu(sFileMenuLabel, cFileMenuMnemonic, sReopenMenuLabel, cReopenMenuMnemonic);
        String sEditMenuLabel = langManager.getMessage("MenuBar.Edit.label", "Edit");
        char cEditMenuMnemonic = langManager.getMessage("MenuBar.Edit.mnemonic", "E").charAt(0);
        this.theEditMenu = new EditMenu(sEditMenuLabel, cEditMenuMnemonic);
        String sToolsMenuLabel = langManager.getMessage("MenuBar.Tools.label", "Tools");
        char cToolsMenuMnemonic = langManager.getMessage("MenuBar.Tools.mnemonic", "T").charAt(0);
        this.theToolsMenu = new ToolsMenu(sToolsMenuLabel, cToolsMenuMnemonic);
        String sWindowMenuLabel = langManager.getMessage("MenuBar.Window.label", "Window");
        char cWindowMenuMnemonic = langManager.getMessage("MenuBar.Window.mnemonic", "W").charAt(0);
        this.theWindowMenu = new WindowMenu(sWindowMenuLabel, cWindowMenuMnemonic);
        String sLanguageMenuLabel = langManager.getMessage("MenuBar.Language.label", "Language");
        char cLanguageMenuMnemonic = langManager.getMessage("MenuBar.Language.mnemonic", "L").charAt(0);
        this.theLanguageMenu = new LanguageMenu(sLanguageMenuLabel, cLanguageMenuMnemonic);
        String sHelpMenuLabel = langManager.getMessage("MenuBar.Help.label", "Help");
        char cHelpMenuMnemonic = langManager.getMessage("MenuBar.Help.mnemonic", "H").charAt(0);
        this.theHelpMenu = new HelpMenu(sHelpMenuLabel, cHelpMenuMnemonic);
        this.add(this.theFileMenu);
        this.add(this.theEditMenu);
        this.add(this.theToolsMenu);
        if (!this.theCockpit.isCustomizing()) {
            this.add(this.theWindowMenu);
        }
        this.add(this.theLanguageMenu);
        this.add(this.theHelpMenu);
    }

    public void addProjectItem(SelectProjectAction projectAction) {
        this.theWindowMenu.addProjectItem(projectAction);
    }

    public WindowMenu getWindowMenu() {
        return this.theWindowMenu;
    }

    class HelpMenu
    extends JMenu {
        private JMenuItem menuItemAbout;

        public HelpMenu(String sLabel, char mnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
            if (IDEMenuBar.this.theActionManager.getAboutAction() != null) {
                this.menuItemAbout = this.add(IDEMenuBar.this.theActionManager.getAboutAction());
            }
        }

        public JMenuItem getMenuItemAbout() {
            return this.menuItemAbout;
        }
    }

    class LanguageMenu
    extends JMenu {
        private JMenuItem menuItemDeutsch;
        private JMenuItem menuItemFrench;
        private JMenuItem menuItemItalian;
        private JMenuItem menuItemEnglish;

        public LanguageMenu(String sLabel, char mnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
            if (IDEMenuBar.this.theActionManager.getLanguageDeutschAction() != null) {
                this.menuItemDeutsch = this.add(IDEMenuBar.this.theActionManager.getLanguageDeutschAction());
            }
            if (IDEMenuBar.this.theActionManager.getLanguageFrancaisAction() != null) {
                this.menuItemFrench = this.add(IDEMenuBar.this.theActionManager.getLanguageFrancaisAction());
            }
            if (IDEMenuBar.this.theActionManager.getLanguageItalianAction() != null) {
                this.menuItemItalian = this.add(IDEMenuBar.this.theActionManager.getLanguageItalianAction());
            }
            if (IDEMenuBar.this.theActionManager.getLanguageEnglishAction() != null) {
                this.menuItemEnglish = this.add(IDEMenuBar.this.theActionManager.getLanguageEnglishAction());
            }
        }

        public JMenuItem getMenuItemDeutsch() {
            return this.menuItemDeutsch;
        }

        public JMenuItem getMenuItemFrench() {
            return this.menuItemFrench;
        }

        public JMenuItem getMenuItemItalian() {
            return this.menuItemItalian;
        }

        public JMenuItem getMenuItemEnglish() {
            return this.menuItemEnglish;
        }
    }

    class WindowMenu
    extends JMenu {
        public WindowMenu(String sLabel, char mnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
        }

        public void addProjectItem(SelectProjectAction projectAction) {
            JMenuItem menuItemProject = new JMenuItem(projectAction);
            IDEMenuBar.this.theWindowMenu.add(menuItemProject);
        }
    }

    class ToolsMenu
    extends JMenu {
        private JMenuItem menuItemCompile;
        private JMenuItem menuItemRun;
        private JMenuItem menuItemProjectEdit;
        private JMenuItem menuItemImporter;
        private JMenuItem menuItemFontChooser;
        private JMenuItem menuItemForegroundColorChooser;
        private JMenuItem menuItemBackgroundColorChooser;
        private JMenuItem menuItemDatabaseSelect;
        private JMenuItem menuItemDuplicateObjectNames;

        public ToolsMenu(String sLabel, char mnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
            if (IDEMenuBar.this.theActionManager.getCompileAction() != null) {
                this.menuItemCompile = this.add(IDEMenuBar.this.theActionManager.getCompileAction());
            }
            if (IDEMenuBar.this.theActionManager.getRunAction() != null) {
                this.menuItemRun = this.add(IDEMenuBar.this.theActionManager.getRunAction());
            }
            if (IDEMenuBar.this.theActionManager.getProjectPreferencesAction() != null) {
                this.menuItemProjectEdit = this.add(IDEMenuBar.this.theActionManager.getProjectPreferencesAction());
            }
            if (IDEMenuBar.this.theActionManager.getImporterAction() != null) {
                this.menuItemImporter = this.add(IDEMenuBar.this.theActionManager.getImporterAction());
            }
            if (IDEMenuBar.this.theActionManager.getFontChooserAction() != null) {
                this.menuItemFontChooser = this.add(IDEMenuBar.this.theActionManager.getFontChooserAction());
            }
            if (IDEMenuBar.this.theActionManager.getForegroundColorChooserAction() != null) {
                this.menuItemForegroundColorChooser = this.add(IDEMenuBar.this.theActionManager.getForegroundColorChooserAction());
            }
            if (IDEMenuBar.this.theActionManager.getBackgroundColorChooserAction() != null) {
                this.menuItemBackgroundColorChooser = this.add(IDEMenuBar.this.theActionManager.getBackgroundColorChooserAction());
            }
            if (IDEMenuBar.this.theActionManager.getDatabaseSelectionAction() != null) {
                this.menuItemDatabaseSelect = this.add(IDEMenuBar.this.theActionManager.getDatabaseSelectionAction());
            }
            if (IDEMenuBar.this.theActionManager.getDuplicateObjectNamesAction() != null) {
                this.menuItemDuplicateObjectNames = this.add(IDEMenuBar.this.theActionManager.getDuplicateObjectNamesAction());
            }
        }

        public JMenuItem getMenuItemCompile() {
            return this.menuItemCompile;
        }

        public JMenuItem getMenuItemRun() {
            return this.menuItemRun;
        }

        public JMenuItem getMenuItemProjectEdit() {
            return this.menuItemProjectEdit;
        }

        public JMenuItem getMenuItemImporter() {
            return this.menuItemImporter;
        }

        public JMenuItem getMenuItemFontChooser() {
            return this.menuItemFontChooser;
        }

        public JMenuItem getMenuItemForegroundColorChooser() {
            return this.menuItemForegroundColorChooser;
        }

        public JMenuItem getMenuItemBackgroundColorChooser() {
            return this.menuItemBackgroundColorChooser;
        }

        public JMenuItem getMenuItemDatabaseSelect() {
            return this.menuItemDatabaseSelect;
        }

        public JMenuItem getMenuItemDuplicateObjectNames() {
            return this.menuItemDuplicateObjectNames;
        }
    }

    class EditMenu
    extends JMenu {
        private JMenuItem menuItemCut;
        private JMenuItem menuItemCopy;
        private JMenuItem menuItemPaste;
        private JMenuItem menuItemUndo;
        private JMenuItem menuItemRedo;

        public EditMenu(String sLabel, char mnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
            if (IDEMenuBar.this.theActionManager.getCutAction() != null) {
                this.menuItemCut = this.add(IDEMenuBar.this.theActionManager.getCutAction());
            }
            if (IDEMenuBar.this.theActionManager.getCopyAction() != null) {
                this.menuItemCopy = this.add(IDEMenuBar.this.theActionManager.getCopyAction());
            }
            if (IDEMenuBar.this.theActionManager.getPasteAction() != null) {
                this.menuItemPaste = this.add(IDEMenuBar.this.theActionManager.getPasteAction());
            }
            if (IDEMenuBar.this.theActionManager.getUndoAction() != null) {
                this.menuItemUndo = this.add(IDEMenuBar.this.theActionManager.getUndoAction());
            }
            if (IDEMenuBar.this.theActionManager.getRedoAction() != null) {
                this.menuItemRedo = this.add(IDEMenuBar.this.theActionManager.getRedoAction());
            }
        }

        public JMenuItem getMenuItemCut() {
            return this.menuItemCut;
        }

        public JMenuItem getMenuItemCopy() {
            return this.menuItemCopy;
        }

        public JMenuItem getMenuItemPaste() {
            return this.menuItemPaste;
        }

        public JMenuItem getMenuItemUndo() {
            return this.menuItemUndo;
        }

        public JMenuItem getMenuItemRedo() {
            return this.menuItemRedo;
        }
    }

    class FileMenu
    extends JMenu {
        private JMenuItem menuItemNew;
        private JMenuItem menuItemOpen;
        private ReopenMenu reopenMenu;
        private JMenuItem menuItemSave;
        private JMenuItem menuItemSaveAs;
        private JMenuItem menuItemSaveWithCompile;
        private JMenuItem menuItemSaveMeta;
        private JMenuItem menuItemSaveAll;
        private JMenuItem menuItemClose;
        private JMenuItem menuItemExit;

        public FileMenu(String sLabel, char mnemonic, String sReopenLanel, char reopenMnemonic) {
            super(sLabel);
            this.setMnemonic(mnemonic);
            if (IDEMenuBar.this.theActionManager.getNewAction() != null) {
                this.menuItemNew = this.add(IDEMenuBar.this.theActionManager.getNewAction());
            }
            if (IDEMenuBar.this.theActionManager.getOpenAction() != null) {
                this.menuItemOpen = this.add(IDEMenuBar.this.theActionManager.getOpenAction());
            }
            if (!IDEMenuBar.this.theCockpit.isCustomizing()) {
                this.reopenMenu = new ReopenMenu(sReopenLanel, reopenMnemonic, ((IDEMenuBar)IDEMenuBar.this).theCockpit.mruList);
                this.add(this.reopenMenu);
            }
            if (IDEMenuBar.this.theActionManager.getSaveAction() != null) {
                this.menuItemSave = this.add(IDEMenuBar.this.theActionManager.getSaveAction());
            }
            if (IDEMenuBar.this.theActionManager.getSaveAsAction() != null) {
                this.menuItemSaveAs = this.add(IDEMenuBar.this.theActionManager.getSaveAsAction());
            }
            if (IDEMenuBar.this.theActionManager.getSaveWithCompileAction() != null) {
                this.menuItemSaveWithCompile = this.add(IDEMenuBar.this.theActionManager.getSaveWithCompileAction());
            }
            if (IDEMenuBar.this.theActionManager.getSaveMetadataAction() != null) {
                this.menuItemSaveMeta = this.add(IDEMenuBar.this.theActionManager.getSaveMetadataAction());
                this.menuItemSaveMeta.setEnabled(IDEMenuBar.this.theCockpit.isCanSaveMetadata());
            }
            if (IDEMenuBar.this.theActionManager.getSaveAllAction() != null) {
                this.menuItemSaveAll = this.add(IDEMenuBar.this.theActionManager.getSaveAllAction());
            }
            if (IDEMenuBar.this.theActionManager.getCloseAction() != null) {
                this.menuItemClose = this.add(IDEMenuBar.this.theActionManager.getCloseAction());
            }
            if (IDEMenuBar.this.theActionManager.getExitAction() != null) {
                this.addSeparator();
                this.menuItemExit = this.add(IDEMenuBar.this.theActionManager.getExitAction());
            }
        }

        public JMenuItem getMenuItemNew() {
            return this.menuItemNew;
        }

        public JMenuItem getMenuItemOpen() {
            return this.menuItemOpen;
        }

        public ReopenMenu getReopenMenu() {
            return this.reopenMenu;
        }

        public JMenuItem getMenuItemSave() {
            return this.menuItemSave;
        }

        public JMenuItem getMenuItemSaveAs() {
            return this.menuItemSaveAs;
        }

        public JMenuItem getMenuItemSaveWithCompile() {
            return this.menuItemSaveWithCompile;
        }

        public JMenuItem getMenuItemSaveMeta() {
            return this.menuItemSaveMeta;
        }

        public JMenuItem getMenuItemSaveAll() {
            return this.menuItemSaveAll;
        }

        public JMenuItem getMenuItemClose() {
            return this.menuItemClose;
        }

        public JMenuItem getMenuItemExit() {
            return this.menuItemExit;
        }

        class ReopenMenu
        extends MruMenu {
            public ReopenMenu(String s, char mnemonic, MruList mruList) {
                super(s, mruList);
                this.setMnemonic(mnemonic);
            }

            public void actionPerformed(MruMenuEvent e) {
                DesignProject newProject = null;
                try {
                    newProject = IDEMenuBar.this.theCockpit.loadProject(e.sFilePath, e.sFileName, IDEMenuBar.this.theCockpit, 1);
                }
                catch (HammerException e1) {
                    // empty catch block
                }
                if (newProject != null) {
                    SelectProjectAction actionProject = new SelectProjectAction(newProject, IDEMenuBar.this.theCockpit);
                    JMenuItem menuitemProject = new JMenuItem(actionProject);
                    IDEMenuBar.this.theWindowMenu.add(menuitemProject);
                    actionProject.actionPerformed(new ActionEvent((Object)IDEMenuBar.this.theCockpit, 0, actionProject.theDesignProject.theMetaProject.sName));
                    newProject.theMetaProject.setProjectChangedState(false);
                }
            }
        }
    }
}

