/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Dimension;
import java.util.ArrayList;

public class IDEMultiSelectCommandProcessor {
    public static final int NOP = 0;
    public static final int ALIGN_HORZ_NO_CHANGE = 0;
    public static final int ALIGN_HORZ_LEFT = 1;
    public static final int ALIGN_HORZ_CENTERS = 2;
    public static final int ALIGN_HORZ_RIGHT = 4;
    public static final int ALIGN_HORZ_EQUAL = 8;
    public static final int ALIGN_HORZ_CENTER_IN_WINDOW = 16;
    public static final int ALIGN_HORZ_MASK = 255;
    public static final int ALIGN_VERT_NO_CHANGE = 0;
    public static final int ALIGN_VERT_TOP = 256;
    public static final int ALIGN_VERT_CENTERS = 512;
    public static final int ALIGN_VERT_BOTTOM = 1024;
    public static final int ALIGN_VERT_EQUAL = 2048;
    public static final int ALIGN_VERT_CENTER_IN_WINDOW = 4096;
    public static final int ALIGN_VERT_MASK = 65280;
    public static final int SIZE_HORZ_NO_CHANGE = 0;
    public static final int SIZE_HORZ_SHRINK = 65536;
    public static final int SIZE_HORZ_GROW = 131072;
    public static final int SIZE_HORZ_SET = 262144;
    public static final int SIZE_HORZ_MASK = 0xFF0000;
    public static final int SIZE_VERT_NO_CHANGE = 0;
    public static final int SIZE_VERT_SHRINK = 0x1000000;
    public static final int SIZE_VERT_GROW = 0x2000000;
    public static final int SIZE_VERT_SET = 0x4000000;
    public static final int SIZE_VERT_MASK = -16777216;
    int horzSet = 0;
    int vertSet = 0;
    int Command = 0;
    SuperDesignCockpit theCockpit;

    public IDEMultiSelectCommandProcessor(SuperDesignCockpit theCockpit, int Command) {
        this.theCockpit = theCockpit;
        this.Command = Command;
    }

    boolean doCommand() {
        int prev;
        int ref;
        int avgSpace;
        int iExchange;
        int obj2;
        int obj1;
        int j;
        int SubCommand;
        int i;
        int iObjectCount = this.theCockpit.theCurrentDesignProject.getSelectedObjectCount();
        int[] left = new int[iObjectCount];
        int[] right = new int[iObjectCount];
        int[] top = new int[iObjectCount];
        int[] bottom = new int[iObjectCount];
        int[] height = new int[iObjectCount];
        int[] width = new int[iObjectCount];
        ArrayList<MetaObject> objects = new ArrayList<MetaObject>();
        int iObject = 0;
        for (i = 0; i < iObjectCount; ++i) {
            MetaObject theObject = this.theCockpit.theCurrentDesignProject.getSelectedObject(i);
            if (theObject.isFrame() || theObject.isAbalet()) continue;
            left[iObject] = theObject.getLocation().x;
            width[iObject] = theObject.getSize().width;
            right[iObject] = left[iObject] + width[iObject] - 1;
            top[iObject] = theObject.getLocation().y;
            height[iObject] = theObject.getSize().height;
            bottom[iObject] = top[iObject] + height[iObject] - 1;
            objects.add(theObject);
            ++iObject;
        }
        iObjectCount = iObject;
        if ((this.Command & 0xFF) != 0) {
            SubCommand = this.Command & 0xFF;
            switch (SubCommand) {
                case 1: {
                    int iLeft = left[0];
                    for (int i2 = 1; i2 < iObjectCount; ++i2) {
                        left[i2] = iLeft;
                        right[i2] = iLeft + width[i2];
                    }
                    break;
                }
                case 2: {
                    int i3;
                    int iAvgCenter = 0;
                    for (i3 = 0; i3 < iObjectCount; ++i3) {
                        iAvgCenter += left[i3] + width[i3] / 2;
                    }
                    iAvgCenter /= iObjectCount;
                    for (i3 = 0; i3 < iObjectCount; ++i3) {
                        left[i3] = iAvgCenter - width[i3] / 2;
                        right[i3] = left[i3] + width[i3];
                    }
                    break;
                }
                case 4: {
                    int iRight = right[0];
                    for (int i4 = 1; i4 < iObjectCount; ++i4) {
                        right[i4] = iRight;
                        left[i4] = iRight - width[i4];
                    }
                    break;
                }
                case 8: {
                    int i5;
                    int[] spaces = new int[iObjectCount];
                    int[] sorted = new int[iObjectCount];
                    for (j = 0; j < iObjectCount; ++j) {
                        sorted[j] = j;
                    }
                    for (j = 1; j < iObjectCount; ++j) {
                        for (i5 = iObjectCount - 1; i5 >= j; --i5) {
                            obj1 = sorted[i5 - 1];
                            obj2 = sorted[i5];
                            if (left[obj1] <= left[obj2]) continue;
                            iExchange = sorted[i5 - 1];
                            sorted[i5 - 1] = sorted[i5];
                            sorted[i5] = iExchange;
                        }
                    }
                    avgSpace = 0;
                    for (i5 = 0; i5 < iObjectCount; ++i5) {
                        ref = sorted[i5];
                        spaces[ref] = 0;
                        if (i5 <= 0) continue;
                        prev = sorted[i5 - 1];
                        spaces[ref] = left[ref] - right[prev];
                        avgSpace += spaces[ref];
                    }
                    avgSpace /= iObjectCount - 1;
                    for (i5 = 1; i5 < iObjectCount; ++i5) {
                        ref = sorted[i5];
                        prev = sorted[i5 - 1];
                        left[ref] = right[prev] + avgSpace;
                        right[ref] = left[ref] + width[ref];
                    }
                    break;
                }
                case 16: {
                    for (int i6 = 0; i6 < iObjectCount; ++i6) {
                        MetaObject theMetaObject = (MetaObject)objects.get(i6);
                        MetaObject theParentObject = theMetaObject.theParentObject;
                        Dimension dimParent = theParentObject.getSize();
                        left[i6] = dimParent.width / 2 - width[i6] / 2;
                        right[i6] = left[i6] + width[i6];
                    }
                    break;
                }
            }
        }
        if ((this.Command & 0xFF00) != 0) {
            SubCommand = this.Command & 0xFF00;
            switch (SubCommand) {
                case 256: {
                    int iTop = top[0];
                    for (int i7 = 1; i7 < iObjectCount; ++i7) {
                        top[i7] = iTop;
                        bottom[i7] = iTop + height[i7];
                    }
                    break;
                }
                case 512: {
                    int i8;
                    int iAvgCenter = 0;
                    for (i8 = 0; i8 < iObjectCount; ++i8) {
                        iAvgCenter += top[i8] + height[i8] / 2;
                    }
                    iAvgCenter /= iObjectCount;
                    for (i8 = 0; i8 < iObjectCount; ++i8) {
                        top[i8] = iAvgCenter - height[i8] / 2;
                        bottom[i8] = top[i8] + height[i8];
                    }
                    break;
                }
                case 1024: {
                    int iBottom = bottom[0];
                    for (int i9 = 1; i9 < iObjectCount; ++i9) {
                        bottom[i9] = iBottom;
                        top[i9] = iBottom - height[i9];
                    }
                    break;
                }
                case 2048: {
                    int i10;
                    int[] spaces = new int[iObjectCount];
                    int[] sorted = new int[iObjectCount];
                    for (j = 0; j < iObjectCount; ++j) {
                        sorted[j] = j;
                    }
                    for (j = 1; j < iObjectCount; ++j) {
                        for (int i11 = iObjectCount - 1; i11 >= j; --i11) {
                            obj1 = sorted[i11 - 1];
                            obj2 = sorted[i11];
                            if (top[obj1] <= top[obj2]) continue;
                            iExchange = sorted[i11 - 1];
                            sorted[i11 - 1] = sorted[i11];
                            sorted[i11] = iExchange;
                        }
                    }
                    avgSpace = 0;
                    for (i10 = 0; i10 < iObjectCount; ++i10) {
                        ref = sorted[i10];
                        spaces[ref] = 0;
                        if (i10 <= 0) continue;
                        prev = sorted[i10 - 1];
                        spaces[ref] = top[ref] - bottom[prev];
                        avgSpace += spaces[ref];
                    }
                    avgSpace /= iObjectCount - 1;
                    for (i10 = 1; i10 < iObjectCount; ++i10) {
                        ref = sorted[i10];
                        prev = sorted[i10 - 1];
                        top[ref] = bottom[prev] + avgSpace;
                        bottom[ref] = top[ref] + height[ref];
                    }
                    break;
                }
                case 4096: {
                    for (int i12 = 0; i12 < iObjectCount; ++i12) {
                        MetaObject theMetaObject = (MetaObject)objects.get(i12);
                        MetaObject theParentObject = theMetaObject.theParentObject;
                        Dimension dimParent = theParentObject.getSize();
                        top[i12] = dimParent.height / 2 - height[i12] / 2;
                        bottom[i12] = top[i12] + height[i12];
                    }
                    break;
                }
            }
        }
        if ((this.Command & 0xFF00) != 0 || (this.Command & 0xFF) != 0) {
            for (i = 0; i < iObjectCount; ++i) {
                MetaObject theMetaObject = (MetaObject)objects.get(i);
                theMetaObject.bAnchoringOff = true;
                theMetaObject.setLocation(left[i], top[i]);
                this.theCockpit.theSizeboxes.update(theMetaObject, theMetaObject.iXLocation, theMetaObject.iYLocation, (int)theMetaObject.dimSize.getWidth(), (int)theMetaObject.dimSize.getHeight());
            }
            return true;
        }
        if ((this.Command & 0xFF0000) != 0) {
            SubCommand = this.Command & 0xFF0000;
            switch (SubCommand) {
                case 65536: {
                    int i13;
                    int iSmallest = width[0];
                    for (i13 = 1; i13 < iObjectCount; ++i13) {
                        if (iSmallest <= width[i13]) continue;
                        iSmallest = width[i13];
                    }
                    for (i13 = 0; i13 < iObjectCount; ++i13) {
                        width[i13] = iSmallest;
                        right[i13] = left[i13] + iSmallest;
                    }
                    break;
                }
                case 131072: {
                    int i14;
                    int iWidest = width[0];
                    for (i14 = 1; i14 < iObjectCount; ++i14) {
                        if (iWidest >= width[i14]) continue;
                        iWidest = width[i14];
                    }
                    for (i14 = 0; i14 < iObjectCount; ++i14) {
                        width[i14] = iWidest;
                        right[i14] = left[i14] + iWidest;
                    }
                    break;
                }
                case 262144: {
                    for (int i15 = 0; i15 < iObjectCount; ++i15) {
                        width[i15] = this.horzSet;
                        right[i15] = left[i15] + this.horzSet;
                    }
                    break;
                }
            }
        }
        if ((this.Command & 0xFF000000) != 0) {
            SubCommand = this.Command & 0xFF000000;
            switch (SubCommand) {
                case 0x1000000: {
                    int i16;
                    int iShortest = height[0];
                    for (i16 = 1; i16 < iObjectCount; ++i16) {
                        if (iShortest <= height[i16]) continue;
                        iShortest = height[i16];
                    }
                    for (i16 = 0; i16 < iObjectCount; ++i16) {
                        height[i16] = iShortest;
                        bottom[i16] = top[i16] + iShortest;
                    }
                    break;
                }
                case 0x2000000: {
                    int i17;
                    int iTallest = height[0];
                    for (i17 = 1; i17 < iObjectCount; ++i17) {
                        if (iTallest >= height[i17]) continue;
                        iTallest = height[i17];
                    }
                    for (i17 = 0; i17 < iObjectCount; ++i17) {
                        height[i17] = iTallest;
                        bottom[i17] = top[i17] + iTallest;
                    }
                    break;
                }
                case 0x4000000: {
                    for (int i18 = 0; i18 < iObjectCount; ++i18) {
                        height[i18] = this.vertSet;
                        bottom[i18] = top[i18] + this.vertSet;
                    }
                    break;
                }
            }
        }
        if ((this.Command & 0xFF000000) != 0 || (this.Command & 0xFF0000) != 0) {
            for (i = 0; i < iObjectCount; ++i) {
                MetaObject theMetaObject = (MetaObject)objects.get(i);
                theMetaObject.bAnchoringOff = true;
                theMetaObject.setSize(width[i], height[i]);
                this.theCockpit.theSizeboxes.update(theMetaObject, theMetaObject.iXLocation, theMetaObject.iYLocation, (int)theMetaObject.dimSize.getWidth(), (int)theMetaObject.dimSize.getHeight());
            }
            return true;
        }
        return false;
    }
}

