/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.Lizard;
import ch.abacus.designcockpit.ide.IDEEditorMouseListener;
import ch.abacus.designcockpit.ide.IDEEditorPopupMenu;
import ch.abacus.designcockpit.ide.IDESourceCaretListener;
import ch.abacus.designcockpit.ide.IDESourceEditor;
import ch.abacus.designcockpit.ide.IDESourceTextArea;
import ch.abacus.designcockpit.ide.IIDESourceEditor;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeJumper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IDESourceViewer
extends JATabbedPane {
    IIDESourceEditor theCodeEditor = null;
    IDESourceTextArea theMessagesEditor = null;
    SuperDesignCockpit theDesignCockpit;
    public MessageSourceMouseListener theListener = null;

    public IDESourceViewer(SuperDesignCockpit objDesignCockpit) {
        super(1);
        this.theDesignCockpit = objDesignCockpit;
        this.addChangeListener(new TabbedPaneListener());
        String editPlugin = objDesignCockpit.theConfigurationManager.getConfigurationVariable("EditorPlugin", null);
        if (editPlugin == null) {
            this.theCodeEditor = new IDESourceEditor();
            this.theCodeEditor.setDesignCockpit(objDesignCockpit);
        } else {
            try {
                Class<?> thePluginEditorClass = Class.forName(editPlugin);
                this.theCodeEditor = (IIDESourceEditor)thePluginEditorClass.newInstance();
                this.theCodeEditor.setDesignCockpit(this.theDesignCockpit);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.theMessagesEditor = new IDESourceTextArea();
        this.theMessagesEditor.addCaretListener(new IDESourceCaretListener(this.theDesignCockpit));
        this.theCodeEditor.addCaretListener(new IDESourceCaretListener(this.theDesignCockpit));
        this.theCodeEditor.thePopupMenu = new IDEEditorPopupMenu(this.theCodeEditor, objDesignCockpit);
        this.theCodeEditor.getTextEdit().addMouseListener(new IDEEditorMouseListener(this.theCodeEditor.getTextEdit(), this.theCodeEditor.thePopupMenu));
        this.theMessagesEditor.thePopupMenu = new IDEEditorPopupMenu(this.theMessagesEditor, objDesignCockpit);
        this.theMessagesEditor.addMouseListener(new IDEEditorMouseListener((Component)((Object)this.theMessagesEditor), this.theMessagesEditor.thePopupMenu));
        String sCodePageLabel = this.theDesignCockpit.theLanguageManager.getMessage("MessagesPane.CodePage.label", "Event Code");
        String sMessagesPageLabel = this.theDesignCockpit.theLanguageManager.getMessage("MessagesPane.MessagesPage.label", "Messages");
        String sObjectCodePageLabel = this.theDesignCockpit.theLanguageManager.getMessage("MessagesPane.ObjectCodePage.label", "Object Code");
        if (objDesignCockpit.getProgramMode() == SuperDesignCockpit.JAVABUILDER) {
            if (this.theCodeEditor.getContainer() != null) {
                this.addTab(sCodePageLabel, this.theCodeEditor.getContainer());
            } else {
                this.addTab(sCodePageLabel, this.theCodeEditor.getTextEdit());
            }
        }
        this.addTab(sMessagesPageLabel, (Component)((Object)this.theMessagesEditor));
        this.theListener = new MessageSourceMouseListener(this.theDesignCockpit);
        this.theMessagesEditor.addMouseListener(this.theListener);
    }

    public Component getActiveEditor() {
        Component theSelectedComponent = this.getSelectedComponent();
        if (theSelectedComponent.equals(this.theMessagesEditor)) {
            return this.theMessagesEditor;
        }
        if (theSelectedComponent.equals(this.theCodeEditor)) {
            return this.theCodeEditor;
        }
        return null;
    }

    public void setCodeText(String sText) {
        StringReader theStringReader = new StringReader(sText);
        try {
            this.theCodeEditor.read(theStringReader, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getCodeText() {
        return this.theCodeEditor.getText();
    }

    public void setMessagesText(String sText) {
        this.theMessagesEditor.setText(sText);
    }

    public void showErrorMessage(String sText) {
        this.theMessagesEditor.setText(sText);
        this.showMessageEditor();
    }

    public void showCodeEditor(int iRow, int iColumn) {
        Component theSelectedComponent = this.getSelectedComponent();
        if (!theSelectedComponent.equals(this.theCodeEditor)) {
            int iSelectedIndex = this.getSelectedIndex();
            this.setEnabledAt(iSelectedIndex, false);
            if (this.theCodeEditor.hasContainer()) {
                this.setSelectedComponent(this.theCodeEditor.getContainer());
            } else {
                this.setSelectedComponent(this.theCodeEditor.getTextEdit());
            }
        }
    }

    public void showCodeEditor() {
        this.showCodeEditor(0, 0);
    }

    public void showMessageEditor() {
        Component theSelectedComponent = this.getSelectedComponent();
        if (!theSelectedComponent.equals(this.theMessagesEditor)) {
            int iSelectedIndex = this.getSelectedIndex();
            this.setEnabledAt(iSelectedIndex, false);
            this.setSelectedComponent((Component)((Object)this.theMessagesEditor));
        }
    }

    public void update() {
        this.paintImmediately(0, 0, this.getWidth(), this.getWidth());
    }

    class MessageSourceMouseListener
    extends MouseAdapter {
        UIFactoryCodeJumper theCodeJumper;
        SuperDesignCockpit theDesignCockpit = null;

        MessageSourceMouseListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void setCodeJumper(UIFactoryCodeJumper objCodeJumper) {
            this.theCodeJumper = objCodeJumper;
        }

        public void mouseClicked(MouseEvent evt) {
            IDESourceTextArea theMessageViewer;
            String sSelection;
            if (evt.getClickCount() != 2) {
                return;
            }
            if (this.theCodeJumper != null && (sSelection = (theMessageViewer = (IDESourceTextArea)evt.getSource()).getSelectedText()) != null && sSelection.length() != 0) {
                try {
                    int iLineNumber = new Integer(sSelection);
                    if (iLineNumber != 0) {
                        int iJumpClass = this.theCodeJumper.getJumpPointClass(iLineNumber);
                        int iJumpType = this.theCodeJumper.getJumpPointType(iLineNumber);
                        String sClassName = this.theCodeJumper.getClassName(iLineNumber);
                        String sListenerName = "";
                        if (iJumpClass == 2) {
                            sListenerName = this.theCodeJumper.getListenerName(iLineNumber);
                            int iMatch = sListenerName.indexOf("$$$");
                            String sObjectIdentifier = "";
                            if (iMatch == -1) {
                                return;
                            }
                            sObjectIdentifier = sListenerName.substring(0, iMatch);
                            String sMethodName = this.theCodeJumper.getMethodName(iLineNumber);
                            MetaObject theMetaObject = this.theDesignCockpit.getDesignProject().findObject(sObjectIdentifier);
                            if (theMetaObject != null) {
                                this.theDesignCockpit.setSelectedObject(theMetaObject);
                                IDESourceViewer.this.showCodeEditor();
                            }
                        } else {
                            if (iJumpType == 0) {
                                return;
                            }
                            MetaClass theMetaClass = this.theDesignCockpit.getDesignProject().findClass(sClassName);
                            if (theMetaClass == null) {
                                return;
                            }
                            Lizard theClassEditor = new Lizard(theMetaClass, this.theDesignCockpit.getDesignProject().theMetaProject.getMetadataDispenser(), this.theDesignCockpit);
                            switch (iJumpType) {
                                case 2: {
                                    String sMemberDataName = this.theCodeJumper.getMemberDataName(iLineNumber);
                                    theClassEditor.theViewerTabs.setCurrentPanel((JPanel)((Object)theClassEditor.theViewerTabs.theMemberDataViewer));
                                    theClassEditor.theViewerTabs.theMemberDataViewer.selectMemberData(sMemberDataName);
                                    break;
                                }
                                case 1: {
                                    String sMethodName = this.theCodeJumper.getMethodName(iLineNumber);
                                    theClassEditor.theViewerTabs.setCurrentPanel((JPanel)((Object)theClassEditor.theViewerTabs.theMethodViewer));
                                    theClassEditor.theViewerTabs.theMethodViewer.selectMethod(sMethodName);
                                    break;
                                }
                                case 3: {
                                    String sPropertyName = this.theCodeJumper.getPropertyName(iLineNumber);
                                    theClassEditor.theViewerTabs.setCurrentPanel((JPanel)((Object)theClassEditor.theViewerTabs.thePropertyViewer));
                                    theClassEditor.theViewerTabs.thePropertyViewer.selectProperty(sPropertyName);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    class TabbedPaneListener
    implements ChangeListener {
        int selectedIndex = -1;
        JATabbedPane tp;

        TabbedPaneListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            this.tp = (JATabbedPane)evt.getSource();
            if (this.selectedIndex == -1 || this.selectedIndex != this.tp.getSelectedIndex()) {
                this.tp.setEnabledAt(this.tp.getSelectedIndex(), false);
                if (this.selectedIndex != -1) {
                    this.tp.setEnabledAt(this.selectedIndex, true);
                }
            }
            this.selectedIndex = this.tp.getSelectedIndex();
        }
    }
}

