/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignTabbedPane;
import ch.abacus.designcockpit.ide.IDETabControlEditorTable;
import ch.abacus.designcockpit.ide.IDETabControlEditorTableModel;
import ch.abacus.designcockpit.ide.IDETabPageDescriptor;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class IDETabControlEditorDialog
extends JADialog {
    MetaObject theObject;
    IDETabControlEditorTableModel theModel;
    IDETabControlEditorTable theTabControlTable;
    JAScrollPane theTabControlScrollPane;
    UpButtonAction theUpAction;
    DownButtonAction theDownAction;
    DeleteButtonAction theDeleteAction;
    OKButtonAction theOKAction;
    CancelButtonAction theCancelAction;
    SuperDesignCockpit theDesignCockpit;
    JAButton theUpButton;
    JAButton theDownButton;
    JAButton theDeleteButton;
    JAButton theOKButton;
    JAButton theCancelButton;
    private boolean m_structureChanged;

    public IDETabControlEditorDialog(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        super((JAFrame)theDesignCockpit, null, true, false);
        this.theModel = new IDETabControlEditorTableModel(theDesignCockpit);
        String sTitle = theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.label", "Tab Control Editor");
        this.setTitle(sTitle);
        this.theDesignCockpit = theDesignCockpit;
        this.theObject = theObject;
        this.theModel.theMetaObject = theObject;
        this.theTabControlTable = new IDETabControlEditorTable(this.theModel, theDesignCockpit);
        this.theTabControlScrollPane = new JAScrollPane((Component)((Object)this.theTabControlTable));
        this.theTabControlTable.Load();
        this.theUpAction = new UpButtonAction(this, theObject);
        this.theDownAction = new DownButtonAction(this, theObject);
        this.theDeleteAction = new DeleteButtonAction(this, theObject);
        this.theOKAction = new OKButtonAction(this, theObject);
        this.theCancelAction = new CancelButtonAction(this, theObject);
        this.theUpButton = new JAButton((Action)this.theUpAction);
        this.theDownButton = new JAButton((Action)this.theDownAction);
        this.theDeleteButton = new JAButton((Action)this.theDeleteAction);
        this.theOKButton = new JAButton((Action)this.theOKAction);
        this.theCancelButton = new JAButton((Action)this.theCancelAction);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlTable = new JAPanel();
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        pnlTable.setLayout((LayoutManager)new BorderLayout());
        pnlTable.add((Component)this.theTabControlScrollPane, (Object)"Center");
        pane.add((Component)pnlTable, "Center");
        JAPanel pnlButtons = new JAPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        pnlButtons.setLayout((LayoutManager)new BorderLayout());
        JAPanel pnlTopButtons = new JAPanel((LayoutManager)new BorderLayout(0, 5));
        JAPanel pnlMiddleButtons = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlBottomButtons = new JAPanel((LayoutManager)new BorderLayout(0, 5));
        pnlMiddleButtons.setBorder(BorderFactory.createEmptyBorder(50, 0, 20, 0));
        pnlTopButtons.add((Component)this.theUpButton, (Object)"North");
        pnlTopButtons.add((Component)this.theDownButton, (Object)"South");
        pnlMiddleButtons.add((Component)this.theDeleteButton, (Object)"North");
        pnlBottomButtons.add((Component)this.theOKButton, (Object)"North");
        pnlBottomButtons.add((Component)this.theCancelButton, (Object)"South");
        pnlButtons.add((Component)pnlTopButtons, (Object)"North");
        pnlButtons.add((Component)pnlMiddleButtons, (Object)"Center");
        pnlButtons.add((Component)pnlBottomButtons, (Object)"South");
        pane.add((Component)pnlButtons, "East");
        this.theTabControlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                IDETabControlEditorDialog.this.enableButtons();
            }
        });
        this.theTabControlTable.setSelectionMode(0);
        Dimension size = new Dimension(450, 300);
        this.setSize(size);
        this.setMinimumMaximumFrameSize(9999, size.width, 9999, size.height);
        this.setLocationRelativeTo(null);
        this.show(null);
    }

    private void enableButtons() {
        int iRow = this.theTabControlTable.getSelectedRow();
        this.theUpButton.setEnabled(iRow > 0);
        this.theDownButton.setEnabled(iRow < this.theTabControlTable.getModel().getRowCount() - 1);
        this.theDeleteButton.setEnabled(iRow != -1);
    }

    class CancelButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDETabControlEditorDialog theEditor;

        public CancelButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(IDETabControlEditorDialog.this.theDesignCockpit.theLanguageManager.getMessage("Dialogs.Cancel", "Cancel"));
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.removeAll();
            this.theEditor.hide();
            this.theEditor = null;
        }
    }

    class OKButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDETabControlEditorDialog theEditor;

        public OKButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(IDETabControlEditorDialog.this.theDesignCockpit.theLanguageManager.getMessage("Dialogs.OK", "OK"));
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = this.theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = this.theEditor.theModel;
            DesignTabbedPane theTabPane = (DesignTabbedPane)((Object)this.theMetaObject.theVisualObject);
            this.theMetaObject.theFirstChild = null;
            this.theMetaObject.theLastChild = null;
            theTabPane.bAllowRemoveTab = false;
            theTabPane.removeAll();
            theTabPane.bAllowRemoveTab = true;
            IDETabControlEditorDialog.this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(this.theMetaObject, "TabTitle");
            for (int iRow = 0; iRow < theTable.getRowCount(); ++iRow) {
                IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor)theModel.theTabPages.get(iRow);
                theDescriptor.theMetaObject.setName(theDescriptor.sObjectName);
                theDescriptor.theMetaObject.thePreviousObject = null;
                theDescriptor.theMetaObject.theNextObject = null;
                this.theMetaObject.addObject(theDescriptor.theMetaObject);
                boolean bGlobal = theDescriptor.sTitle.startsWith("@AbaNLS");
                this.theMetaObject.setPropertyValue("TabTitle", iRow, 0, (Object)theDescriptor.sTitle, bGlobal);
                theTabPane.addTab(theDescriptor.sTitle, theDescriptor.theMetaObject.theVisualObject);
            }
            this.theEditor.removeAll();
            this.theEditor.hide();
            this.theEditor = null;
            MetaProject metaProject = IDETabControlEditorDialog.this.theDesignCockpit.getDesignProject().theMetaProject;
            metaProject.setProjectChangedState(true);
            if (IDETabControlEditorDialog.this.m_structureChanged) {
                IDETabControlEditorDialog.this.theDesignCockpit.theObjectTreeViewPane.redisplayProject();
            }
        }
    }

    class DeleteButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDETabControlEditorDialog theEditor;

        public DeleteButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(IDETabControlEditorDialog.this.theDesignCockpit.theLanguageManager.getMessage("Delete.label", "Delete"));
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = this.theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = this.theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                theModel.theTabPages.remove(iRow);
                int iRowCount = theModel.getRowCount();
                if (iRowCount == 0) {
                    theTable.getSelectionModel().clearSelection();
                } else if (iRow == iRowCount) {
                    theTable.getSelectionModel().setSelectionInterval(iRowCount - 1, iRowCount - 1);
                } else {
                    theTable.getSelectionModel().setSelectionInterval(iRow, iRow);
                }
                IDETabControlEditorDialog.this.enableButtons();
                theTable.updateUI();
                IDETabControlEditorDialog.this.m_structureChanged = true;
            }
            this.theEditor.theDeleteButton.setSelected(false);
        }
    }

    class DownButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDETabControlEditorDialog theEditor;

        public DownButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(IDETabControlEditorDialog.this.theDesignCockpit.theLanguageManager.getMessage("Down.label", "Down"));
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = this.theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = this.theEditor.theModel;
            int iRowFrom = theTable.getSelectedRow();
            int iRowCount = theTable.getRowCount();
            if (iRowFrom != -1 && iRowFrom < iRowCount - 1) {
                int iRowTo = iRowFrom + 1;
                Object objToRaise = theModel.theTabPages.get(iRowTo);
                Object objToLower = theModel.theTabPages.get(iRowFrom);
                theModel.theTabPages.set(iRowTo, objToLower);
                theModel.theTabPages.set(iRowFrom, objToRaise);
                theTable.getSelectionModel().setSelectionInterval(iRowTo, iRowTo);
                theTable.repaint();
                IDETabControlEditorDialog.this.m_structureChanged = true;
            }
            this.theEditor.theDownButton.setFocusPainted(false);
        }
    }

    class UpButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDETabControlEditorDialog theEditor;

        public UpButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(IDETabControlEditorDialog.this.theDesignCockpit.theLanguageManager.getMessage("Up.label", "Up"));
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = this.theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = this.theEditor.theModel;
            int iRowFrom = theTable.getSelectedRow();
            if (iRowFrom > 0) {
                int iRowTo = iRowFrom - 1;
                Object objToRaise = theModel.theTabPages.get(iRowFrom);
                Object objToLower = theModel.theTabPages.get(iRowTo);
                theModel.theTabPages.set(iRowFrom, objToLower);
                theModel.theTabPages.set(iRowTo, objToRaise);
                theTable.getSelectionModel().setSelectionInterval(iRowTo, iRowTo);
                theTable.repaint();
                IDETabControlEditorDialog.this.m_structureChanged = true;
            }
            this.theEditor.theUpButton.setFocusPainted(false);
        }
    }
}

