/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.designcockpit.ide.DesignAnchoringLayoutManager;
import ch.abacus.designcockpit.ide.DesignTabbedPane;
import ch.abacus.designcockpit.ide.IDEObjectPopupMenu;
import ch.abacus.designcockpit.ide.IDEViewDisplayerComponentKeyListener;
import ch.abacus.designcockpit.ide.IDEViewDisplayerComponentMouseListener;
import ch.abacus.designcockpit.ide.IDEViewDisplayerComponentMouseMotionListener;
import ch.abacus.designcockpit.ide.IDEViewDisplayerMouseListener;
import ch.abacus.designcockpit.ide.IDEViewDisplayerMouseMotionListener;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;

public class IDEViewDisplayer
extends JAPanel
implements Serializable {
    Color clrBackground = null;
    private String text = null;
    public SuperDesignCockpit theDesignCockpit = null;
    public int iMouseX = 0;
    public int iMouseY = 0;
    private IDEComponentPaletteNode selectedNode;
    IDEObjectPopupMenu thePopupMenu = null;

    public IDEViewDisplayer() {
        try {
            this.setTransferHandler(new TransferHandler("dummy"));
            this.getDropTarget().addDropTargetListener(new ComponentDropListener(this, null));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    public IDEViewDisplayer(SuperDesignCockpit objDesignCockpit) {
        this.theDesignCockpit = objDesignCockpit;
        this.setBackground(this.clrBackground);
        this.addMouseListener(new IDEViewDisplayerMouseListener(this));
        this.addMouseMotionListener(new IDEViewDisplayerMouseMotionListener(this));
        try {
            this.setTransferHandler(new TransferHandler("dummy"));
            this.getDropTarget().addDropTargetListener(new ComponentDropListener(this, null));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return this.text;
    }

    public void initPopupMenu(SuperDesignCockpit objDesignCockpit) {
        this.thePopupMenu = new IDEObjectPopupMenu(objDesignCockpit);
    }

    public void setText(String sText) {
        this.text = sText;
    }

    void resetContents() {
        this.removeAll();
        this.repaint();
    }

    public MetaObject findContainerByPoint(MetaObject theTestObject, Point pt) {
        while (theTestObject != null) {
            Dimension dimTest = theTestObject.theVisualObject.getSize();
            if (theTestObject.theVisualObject.isShowing()) {
                Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if (ptTest.x <= pt.x && (double)ptTest.x + dimTest.getWidth() >= (double)pt.x && ptTest.y <= pt.y && (double)ptTest.y + dimTest.getHeight() >= (double)pt.y) {
                    if (theTestObject.theFirstChild != null) {
                        MetaObject theChildObject = this.findContainerByPoint(theTestObject.theFirstChild, pt);
                        if (theChildObject == null) {
                            return theTestObject;
                        }
                        return theChildObject;
                    }
                    return theTestObject;
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        return null;
    }

    public MetaObject findContainerByPoint(Point pt) {
        if (this.theDesignCockpit.getSelectedFrame() == null) {
            return null;
        }
        MetaObject theSelectedFrame = this.theDesignCockpit.getSelectedFrame();
        while (!theSelectedFrame.isAbalet() && !theSelectedFrame.isFrame()) {
            theSelectedFrame = theSelectedFrame.theParentObject;
        }
        if (theSelectedFrame == null) {
            return null;
        }
        ArrayList<MetaObject> theMatchingContainers = new ArrayList<MetaObject>(1);
        MetaObject theTestObject = theSelectedFrame.theFirstChild;
        while (theTestObject != null) {
            if (theTestObject.isGroup() || theTestObject.isPanel() || theTestObject.isTabbedPane() || theTestObject.isTabPage() || theTestObject.isScrollPane() || theTestObject.isScrollingPanel()) {
                Dimension dimTest = theTestObject.theVisualObject.getSize();
                Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if (pt.x >= ptTest.x && (double)pt.x <= dimTest.getWidth() + (double)ptTest.x && pt.y >= ptTest.y && (double)pt.y <= dimTest.getHeight() + (double)ptTest.y) {
                    if (theTestObject.theFirstChild != null) {
                        MetaObject theChildContainer = this.findContainerByPoint(theTestObject.theFirstChild, pt);
                        if (theChildContainer == null) {
                            theMatchingContainers.add(theTestObject);
                        } else {
                            theMatchingContainers.add(theChildContainer);
                        }
                    }
                    theMatchingContainers.add(theTestObject);
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        theMatchingContainers.add(theSelectedFrame);
        MetaObject highestObject = null;
        for (int i = 0; i < theMatchingContainers.size(); ++i) {
            MetaObject testObject = (MetaObject)theMatchingContainers.get(i);
            if (highestObject == null) {
                highestObject = testObject;
                continue;
            }
            if (highestObject.iDisplayLayer >= testObject.iDisplayLayer) continue;
            highestObject = testObject;
        }
        return highestObject;
    }

    public Point findContainerLocation(MetaObject theTestObject, Point pt) {
        while (theTestObject != null) {
            if (theTestObject.isGroup() || theTestObject.isPanel() || theTestObject.isTabbedPane() || theTestObject.isTabPage() || theTestObject.isScrollPane() || theTestObject.isScrollingPanel()) {
                if (theTestObject.theVisualObject == null) {
                    this.theDesignCockpit.theLogFile.doLogEntry("Class definition error in find container location", theTestObject.theClass.getMetadata().sClassName);
                    return null;
                }
                Dimension dimTest = theTestObject.theVisualObject.getSize();
                if (theTestObject.theVisualObject.isShowing()) {
                    Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                    if (ptTest.x <= pt.x && (double)ptTest.x + dimTest.getWidth() >= (double)pt.x && ptTest.y <= pt.y && (double)ptTest.y + dimTest.getHeight() >= (double)pt.y) {
                        if (theTestObject.theFirstChild != null) {
                            Point ptCheckChild = this.findContainerLocation(theTestObject.theFirstChild, pt);
                            if (ptCheckChild == null) {
                                return ptTest;
                            }
                            return ptCheckChild;
                        }
                        return ptTest;
                    }
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        return null;
    }

    public Point findContainerLocation(Point pt) {
        Point ptTest;
        Dimension dimTest;
        if (this.theDesignCockpit.getSelectedFrame() == null) {
            return null;
        }
        MetaObject theSelectedFrame = this.theDesignCockpit.getSelectedFrame();
        MetaObject theTestObject = theSelectedFrame.theFirstChild;
        while (theTestObject != null) {
            if (theTestObject.isGroup() || theTestObject.isPanel() || theTestObject.isTabbedPane() || theTestObject.isTabPage() || theTestObject.isScrollPane() || theTestObject.isScrollingPanel()) {
                if (theTestObject.theVisualObject == null) {
                    this.theDesignCockpit.theLogFile.doLogEntry("Class definition error in find container location", theTestObject.theClass.getMetadata().sClassName);
                    return null;
                }
                dimTest = theTestObject.theVisualObject.getSize();
                ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if (pt.x >= ptTest.x && (double)pt.x <= dimTest.getWidth() + (double)ptTest.x && pt.y >= ptTest.y && (double)pt.y <= dimTest.getHeight() + (double)ptTest.y) {
                    if (theTestObject.theFirstChild != null) {
                        Point ptCheckChild = this.findContainerLocation(theTestObject.theFirstChild, pt);
                        if (ptCheckChild == null) {
                            return ptTest;
                        }
                        return ptCheckChild;
                    }
                    return ptTest;
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        if (theSelectedFrame.isAbalet() || theSelectedFrame.isFrame()) {
            return this.getLocationOnScreen();
        }
        theTestObject = theSelectedFrame;
        dimTest = theTestObject.theVisualObject.getSize();
        ptTest = theTestObject.theVisualObject.getLocationOnScreen();
        if (pt.x >= ptTest.x && (double)pt.x <= dimTest.getWidth() + (double)ptTest.x && pt.y >= ptTest.y && (double)pt.y <= dimTest.getHeight() + (double)ptTest.y) {
            return ptTest;
        }
        return null;
    }

    public MetaObject importObject(MetaObject theClickedObject, Point ptLocation, boolean bShiftDown, CustomizerDataElementInterface dataElement) {
        this.theDesignCockpit.allowDragging(false);
        if (theClickedObject != null && theClickedObject.isTabbedPane()) {
            DesignTabbedPane theTabbedPane = (DesignTabbedPane)((Object)theClickedObject.theVisualObject);
            int iSelectedIndex = theTabbedPane.getSelectedIndex();
            if (iSelectedIndex == -1 && theClickedObject.theFirstChild != null) {
                iSelectedIndex = 0;
            }
            if (iSelectedIndex != -1) {
                int iPage = 0;
                MetaObject testPage = theClickedObject.theFirstChild;
                while (testPage != null) {
                    if (iPage == iSelectedIndex) {
                        theClickedObject = testPage;
                        break;
                    }
                    ++iPage;
                    testPage = testPage.theNextObject;
                }
            }
        }
        this.theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        if (!bShiftDown) {
            this.selectedNode = this.theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode();
        }
        if (this.selectedNode != null) {
            String sClassToCreate;
            MetaObject theMetaObject;
            Point ptContainerLocation;
            Point ptScreenLocation = this.getLocationOnScreen();
            ptScreenLocation.x += ptLocation.x;
            ptScreenLocation.y += ptLocation.y;
            MetaObject theContainer = null;
            if (theClickedObject != null) {
                theContainer = theClickedObject.getVisualContainerObject(false);
            }
            if (theContainer != null) {
                this.theDesignCockpit.SelectObject(theContainer, false);
                this.theDesignCockpit.SelectContainer(theContainer);
                MetaObject testContainer = theContainer;
                Serializable childTestComponent = this;
                int splitx = 0;
                int splity = 0;
                while (testContainer != null) {
                    JSplitPane splitter;
                    if (testContainer.isHorzSplit()) {
                        splitter = (JSplitPane)testContainer.theVisualObject;
                        if (splitter.getRightComponent().equals(childTestComponent)) {
                            splitx += splitter.getDividerLocation();
                        }
                    } else if (testContainer.isVertSplit() && (splitter = (JSplitPane)testContainer.theVisualObject).getBottomComponent().equals(childTestComponent)) {
                        splity += splitter.getDividerLocation();
                    }
                    childTestComponent = testContainer.theVisualObject;
                    testContainer = testContainer.theParentObject;
                }
                ptScreenLocation.x -= splitx;
                ptScreenLocation.y -= splity;
            }
            if ((ptContainerLocation = this.findContainerLocation(ptScreenLocation)) != null) {
                ptLocation.x = ptScreenLocation.x - ptContainerLocation.x;
                ptLocation.y = ptScreenLocation.y - ptContainerLocation.y;
            }
            if ((theMetaObject = this.addObject(sClassToCreate = dataElement == null ? this.selectedNode.getMetaClass().getMetadata().sClassName : this.theDesignCockpit.theCustomizer.getImplementingClass(dataElement), dataElement)) != null) {
                if (theMetaObject.theVisualObject != null) {
                    if (this.theDesignCockpit.getDesignProject() != null) {
                        this.theDesignCockpit.getDesignProject().theUndoRedoController.createImportObjectEvent(theMetaObject, theMetaObject.theParentObject);
                    }
                    Dimension dimSize = theMetaObject.theVisualObject.getSize();
                    if (theMetaObject.theParentObject != null) {
                        Dimension dimParentSize = theMetaObject.theParentObject.getSize();
                        Dimension dimNewSize = dimSize;
                        if (dimParentSize.width < dimSize.width + ptLocation.x) {
                            dimNewSize.width = dimParentSize.width - ptLocation.x;
                        }
                        if (dimParentSize.height < dimSize.height + ptLocation.y) {
                            dimNewSize.height = dimParentSize.height - ptLocation.y;
                        }
                    }
                    this.theDesignCockpit.resizeAction(theMetaObject, (int)ptLocation.getX(), (int)ptLocation.getY(), (int)dimSize.getWidth(), (int)dimSize.getHeight(), 3, true, true);
                    ptLocation = theMetaObject.getLocation();
                    dimSize = theMetaObject.getSize();
                    if ((theMetaObject.isAbalet() || theMetaObject.isFrame()) && theMetaObject.iMode == 1 || theMetaObject.theParentObject.isScrollPane()) {
                        theMetaObject.setLocation(0, 0);
                    } else {
                        theMetaObject.theVisualObject.setLocation((int)ptLocation.getX(), (int)ptLocation.getY());
                    }
                    theMetaObject.theVisualObject.setSize((int)dimSize.getWidth(), (int)dimSize.getHeight());
                    if (theMetaObject.isPanel() || theMetaObject.isTabbedPane() || theMetaObject.isGroup() || theMetaObject.isScrollPane() || theMetaObject.isTabPage() || theMetaObject.isScrollingPanel()) {
                        this.theDesignCockpit.SelectContainer(theMetaObject, true);
                    }
                    this.theDesignCockpit.getDesignProject().deselectObjects();
                    this.theDesignCockpit.SelectObject(theMetaObject, false);
                }
                this.theDesignCockpit.theComponentPalettePane.theTree.setSelectionInterval(0, 0);
                if (this.theDesignCockpit.isCustomizing() && dataElement != null) {
                    this.theDesignCockpit.theCustomizer.newInstanceCreated(dataElement, theMetaObject);
                }
                if (theMetaObject.isCompositeComponent()) {
                    theMetaObject.refreshListeners();
                }
                return theMetaObject;
            }
            this.theDesignCockpit.allowDragging(true);
            return null;
        }
        this.theDesignCockpit.allowDragging(true);
        return null;
    }

    public boolean testObject(MetaObject theMetaObject) {
        if (theMetaObject.theVisualObject == null) {
            return true;
        }
        int iContainerType = theMetaObject.theClass.getMetadata().containerType.getContainerType();
        MetaObject theParent = theMetaObject.theParentObject;
        if (theParent != null && theParent.theClass.getMetadata().containerType.getContainerType() == 4) {
            return iContainerType == 7;
        }
        if (iContainerType == 7) {
            return false;
        }
        return !(iContainerType != 3 && iContainerType != 5 ? theParent == null : theParent != null);
    }

    public void displayObjects(MetaObject currObj) {
        this.displayObject(currObj);
        currObj = currObj.theFirstChild;
        while (currObj != null) {
            this.displayObjects(currObj);
            currObj = currObj.theNextObject;
        }
    }

    public void removeHammerComponentKeyInterfaces(Component comp, IDEViewDisplayerComponentKeyListener theNewListener) {
        int iCompCount;
        KeyListener[] theListeners = comp.getKeyListeners();
        for (int iListener = 0; iListener < theListeners.length; ++iListener) {
            comp.removeKeyListener(theListeners[iListener]);
        }
        if (comp instanceof Container && (iCompCount = ((Container)comp).getComponentCount()) > 0) {
            Component[] theComponents = ((Container)comp).getComponents();
            for (int iComponent = 0; iComponent < iCompCount; ++iComponent) {
                Component childComp = theComponents[iComponent];
                this.removeHammerComponentKeyInterfaces(childComp, theNewListener);
            }
        }
        comp.setFocusable(true);
        comp.setEnabled(true);
        comp.addKeyListener(theNewListener);
    }

    public void setKeyboardInterface(MetaObject theObject) {
        JComponent comp = theObject.theVisualObject;
        IDEViewDisplayerComponentKeyListener theNewListener = new IDEViewDisplayerComponentKeyListener(theObject);
        this.removeHammerComponentKeyInterfaces(comp, theNewListener);
        if (comp instanceof JButton) {
            ((JButton)comp).setFocusPainted(false);
        }
        if (comp instanceof JTextArea) {
            ((JTextArea)comp).setEditable(false);
        }
        if (comp instanceof JTextField) {
            ((JTextField)comp).setEditable(false);
        }
    }

    public boolean displayObject(MetaObject theMetaObject) {
        if (theMetaObject.theVisualObject == null) {
            return true;
        }
        int iContainerType = theMetaObject.theClass.getMetadata().containerType.getContainerType();
        if (iContainerType == 5 || iContainerType == 3 || iContainerType == 6 || iContainerType == 10 || iContainerType == 2 || iContainerType == 7) {
            DesignAnchoringLayoutManager theAnchoringLayout = new DesignAnchoringLayoutManager(theMetaObject, this.theDesignCockpit);
            theMetaObject.theLayoutManager = theAnchoringLayout;
            theMetaObject.theVisualObject.setLayout(theAnchoringLayout);
            try {
                theMetaObject.theVisualObject.setTransferHandler(new TransferHandler("dummy"));
                theMetaObject.theVisualObject.getDropTarget().addDropTargetListener(new ComponentDropListener(this, theMetaObject));
            }
            catch (TooManyListenersException e) {
                e.printStackTrace();
            }
        }
        this.setKeyboardInterface(theMetaObject);
        if (iContainerType != 5 && iContainerType != 3 && iContainerType != 8 && iContainerType != 9) {
            if (iContainerType == 7) {
                theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject.theParentObject, this.theDesignCockpit, theMetaObject.theVisualObject);
                theMetaObject.theMouseMotionListener = new IDEViewDisplayerComponentMouseMotionListener(theMetaObject.theParentObject, theMetaObject.theParentObject.theVisualObject, this.theDesignCockpit);
            } else {
                theMetaObject.removeListeners();
                theMetaObject.theMouseMotionListener = new IDEViewDisplayerComponentMouseMotionListener(theMetaObject, theMetaObject.theVisualObject, this.theDesignCockpit);
                theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject, this.theDesignCockpit, theMetaObject.theVisualObject);
            }
        } else {
            theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject, this.theDesignCockpit, theMetaObject.theVisualObject);
            theMetaObject.theMouseMotionListener = null;
        }
        theMetaObject.refreshListeners();
        if (iContainerType != 3 && iContainerType != 5) {
            ButtonGroup theButtonGroup;
            MetaObject theParent = theMetaObject.theParentObject;
            if (theParent == null) {
                return false;
            }
            int iParentContainerType = theParent.theClass.getMetadata().containerType.getContainerType();
            if (iParentContainerType == 6 && (theButtonGroup = theParent.getButtonGroup()) != null && theMetaObject.theVisualObject instanceof AbstractButton) {
                theButtonGroup.add((AbstractButton)theMetaObject.theVisualObject);
            }
            if (iContainerType == 7 && iParentContainerType != 4) {
                JOptionPane pane = new JOptionPane("Tab page only allowed within tabbed pane");
                JDialog dialog = pane.createDialog((Component)((Object)this.theDesignCockpit), "Component Selection Error");
                dialog.show();
                return false;
            }
            if (iParentContainerType == 0) {
                this.add(theMetaObject.theVisualObject, theMetaObject);
            } else {
                if (iContainerType != 3 && iContainerType != 5) {
                    theMetaObject.setPropertyValue("Attached", 0, 0, (Object)new Boolean(true), false);
                }
                if (iParentContainerType == 1) {
                    JAScrollPane theScrollPane = (JAScrollPane)theParent.theVisualObject;
                    theScrollPane.setLayout(null);
                    theMetaObject.theLayoutManager = null;
                    theMetaObject.setPropertyValue("Location.Left", 0, 0, (Object)"0", true);
                    theMetaObject.setPropertyValue("Location.Top", 0, 1, (Object)"0", true);
                    theMetaObject.setPropertyValue("Size.Width", 0, 0, (Object)theParent.getPropertyValue("Size.Width", 0), true);
                    theMetaObject.setPropertyValue("Size.Height", 0, 1, (Object)theParent.getPropertyValue("Size.Height", 0), true);
                    if (theMetaObject.theVisualObject != null) {
                        theMetaObject.doProperties();
                    }
                    theScrollPane.add((Component)theMetaObject.theVisualObject);
                } else {
                    JComponent jm;
                    if (theMetaObject.theVisualObject != null) {
                        theMetaObject.doProperties();
                    }
                    if (iParentContainerType == 4) {
                        theMetaObject.setPropertyValue("Location.Left", 0, 0, (Object)"0", true);
                        theMetaObject.setPropertyValue("Location.Top", 0, 1, (Object)"0", true);
                        Dimension theSize = theParent.getSize();
                        theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                        theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);
                        if (theParent.theVisualObject instanceof DesignTabbedPane) {
                            DesignTabbedPane theTabbedPane = (DesignTabbedPane)((Object)theParent.theVisualObject);
                            if (theMetaObject.theClass.getMetadata().containerType.getContainerType() == 7) {
                                int iIndex = theTabbedPane.indexOfComponent(theMetaObject.theVisualObject);
                                if (iIndex == -1) {
                                    iIndex = theParent.getChildIndex(theMetaObject);
                                    MetaPropertyValueEx theTabTitle = theParent.getPropertyValue("TabTitle", iIndex);
                                    if (theTabTitle == null) {
                                        theTabbedPane.addTab("tab", theMetaObject.theVisualObject);
                                    } else {
                                        theTabbedPane.addTab(theTabTitle.getStringValue(), theMetaObject.theVisualObject);
                                    }
                                }
                            } else {
                                System.out.println("Serious error - Child of tabbed pane should be a tab page.");
                            }
                        } else {
                            System.out.println("Serious error - Tabbed Pane class should be defined with tabbed pane display object");
                        }
                    } else if (iParentContainerType == 11) {
                        if (theParent.theVisualObject instanceof JMenuBar) {
                            jm = (JMenuBar)theParent.theVisualObject;
                            JMenu ji = (JMenu)theMetaObject.getSwingObject();
                            ((JMenuBar)jm).add(ji);
                        }
                    } else if (iParentContainerType == 12) {
                        if (theParent.theVisualObject instanceof JMenu) {
                            jm = (JMenu)theParent.theVisualObject;
                            if (theMetaObject.getSwingObject() instanceof JMenuItem) {
                                JMenuItem ji = (JMenuItem)theMetaObject.getSwingObject();
                                ((JMenu)jm).add(ji);
                            } else if (theMetaObject.getSwingObject() instanceof JSeparator) {
                                JSeparator js = (JSeparator)theMetaObject.getSwingObject();
                                ((JMenu)jm).add(js);
                            }
                        }
                    } else if (iParentContainerType == 14) {
                        if (theParent.theVisualObject instanceof JToolBar) {
                            jm = (JToolBar)theParent.theVisualObject;
                            ((JToolBar)jm).setFloatable(false);
                            JButton ji = (JButton)theMetaObject.getSwingObject();
                            Dimension theSize = theMetaObject.getSize();
                            theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                            theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);
                            jm.add(ji);
                            ((JToolBar)jm).updateUI();
                        }
                    } else if (iParentContainerType == 8 || iParentContainerType == 9) {
                        MetaObject objGrandparent = theParent.theParentObject;
                        Dimension theSize = objGrandparent.getSize();
                        theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                        theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);
                        JSplitPane theParentContainer = (JSplitPane)theParent.theVisualObject;
                        int iIndex = theParent.getChildIndex(theMetaObject);
                        if (iIndex == 0) {
                            if (theParentContainer.getOrientation() == 0) {
                                theParentContainer.setLeftComponent(theMetaObject.theVisualObject);
                            } else {
                                theParentContainer.setTopComponent(theMetaObject.theVisualObject);
                            }
                        } else if (theParentContainer.getOrientation() == 0) {
                            theParentContainer.setRightComponent(theMetaObject.theVisualObject);
                        } else {
                            theParentContainer.setBottomComponent(theMetaObject.theVisualObject);
                        }
                    } else if (theParent.theLayoutManager instanceof DesignAnchoringLayoutManager) {
                        DesignAnchoringLayoutManager theLayoutManager = (DesignAnchoringLayoutManager)theParent.theLayoutManager;
                        JComponent theContainer = theParent.theVisualObject;
                        if (theContainer instanceof JLayeredPane) {
                            JLayeredPane thePane = (JLayeredPane)theContainer;
                            thePane.add(theMetaObject.theVisualObject, theMetaObject.getName(), JLayeredPane.DEFAULT_LAYER);
                        } else {
                            theContainer.add((Component)theMetaObject.theVisualObject, theMetaObject.getName());
                        }
                        theLayoutManager.setAnchoring(theMetaObject.theVisualObject, theMetaObject, theMetaObject.getAnchorLeft(), theMetaObject.getAnchorRight(), theMetaObject.getAnchorTop(), theMetaObject.getAnchorBottom());
                    }
                }
            }
        } else {
            this.theDesignCockpit.SelectContainer(theMetaObject, true);
        }
        return true;
    }

    boolean addObjects(MetaObject theMetaObject) {
        if (!theMetaObject.isFrame() && !theMetaObject.isAbalet()) {
            if (theMetaObject.theFabricatedObject == null) {
                theMetaObject.iMode = 1;
                theMetaObject.create();
            }
            if (!this.displayObject(theMetaObject)) {
                return false;
            }
        }
        MetaObject theChildObject = theMetaObject.theFirstChild;
        while (theChildObject != null) {
            if (!theChildObject.isFrame() && !theChildObject.isAbalet()) {
                this.addObjects(theChildObject);
            }
            theChildObject = theChildObject.theNextObject;
        }
        return true;
    }

    void add(JComponent component, MetaObject theObject) {
        theObject.setPropertyValue("Attached", 0, 0, (Object)new Boolean(true), false);
        if (theObject.theVisualObject != null) {
            theObject.doProperties();
        }
    }

    MetaObject addObject(String sClassName, CustomizerDataElementInterface dataElement) {
        if (sClassName != null && sClassName.trim().length() != 0) {
            String sNewObjectName = "";
            MetaProject theDesignProject = this.theDesignCockpit.getDesignProject().theMetaProject;
            MetaClass theClass = theDesignProject.findClass(sClassName);
            if (theClass == null) {
                return null;
            }
            sNewObjectName = this.theDesignCockpit.getDesignProject().getNewObjectName(theClass.getMetadata().sClassName);
            MetaObject theMetaObject = theClass.Create(sNewObjectName, this.theDesignCockpit.getDesignProject().theMetaProject, false);
            theMetaObject.iMode = 1;
            theMetaObject.theClass = theClass;
            if (theClass.getMetadata().containerType.getContainerType() != 0) {
                theMetaObject.setPropertyValue("ContainerType", 0, 0, (Object)new String(theClass.getMetadata().containerType.getContainerTypeAsString()), false);
            }
            if (!theMetaObject.isJMenuBar()) {
                theMetaObject.setPropertyValue("Text", 0, 0, (Object)sNewObjectName, true);
            }
            if (theMetaObject.isAbalet() || theMetaObject.isFrame()) {
                theMetaObject.setPropertyValue("Location.Left", 0, 0, 0, true);
                theMetaObject.setPropertyValue("Location.Top", 0, 1, 0, true);
            } else if (theMetaObject.isJMenuBar()) {
                theMetaObject.setPropertyValue("Location.Left", 0, 0, 0, true);
                theMetaObject.setPropertyValue("Location.Top", 0, 1, 0, true);
            } else if (!(theMetaObject.isJMenu() || theMetaObject.isJMenuItem() || theMetaObject.isJMenuSeparator() || theMetaObject.isJToolBarButton())) {
                theMetaObject.setPropertyValue("Location.Left", 0, 0, this.iMouseX, false);
                theMetaObject.setPropertyValue("Location.Top", 0, 1, this.iMouseY, false);
            }
            theMetaObject.psText = sNewObjectName;
            theMetaObject.iMode = 1;
            if (this.create(theMetaObject)) {
                if (this.theDesignCockpit.isCustomizing()) {
                    this.theDesignCockpit.theCustomizer.setProperties(theMetaObject, dataElement);
                    theMetaObject.refresh();
                }
                return theMetaObject;
            }
        }
        return null;
    }

    public boolean create(MetaObject theMetaObject) {
        boolean bTest1 = theMetaObject.create();
        if (bTest1) {
            boolean bTest2 = this.testObject(theMetaObject);
            if (bTest2) {
                this.theDesignCockpit.theObjectTreeViewPane.addObject(theMetaObject, theMetaObject.theParentObject);
                this.displayObject(theMetaObject);
                return true;
            }
            theMetaObject.DeleteObject(this.theDesignCockpit.theCurrentDesignProject.theMetaProject, (AbaMetaDataUser)this.theDesignCockpit);
            return false;
        }
        return false;
    }

    void setMouseCoordinates(int x, int y) {
        this.iMouseX = x;
        this.iMouseY = y;
    }

    Color getAppropriateColor(Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256, (theColor.getGreen() + 128) % 256, (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public void paintComponent(Graphics g) {
        Dimension theSize = this.getSize();
        if (this.theDesignCockpit != null && this.theDesignCockpit.getDesignProject() != null && this.theDesignCockpit.getDesignProject().getSelectedFrame() != null) {
            MetaObject theSelectedFrame = this.theDesignCockpit.getDesignProject().getSelectedFrame();
            while (theSelectedFrame != null && !theSelectedFrame.isFrame() && !theSelectedFrame.isAbalet()) {
                theSelectedFrame = theSelectedFrame.theParentObject;
            }
            Dimension theAbaletSize = theSelectedFrame.getSize();
            Color theColor = theSelectedFrame.getBackgroundColor();
            if (theColor == null) {
                theColor = new Color(160, 160, 160);
            }
            g.setColor(theColor);
            g.fillRect(0, 0, (int)theAbaletSize.getWidth() - 1, (int)theAbaletSize.getHeight() - 1);
            if (theSize.getWidth() - theAbaletSize.getWidth() > 0.0) {
                g.setColor(this.getBackground());
                g.fillRect((int)theAbaletSize.getWidth(), 0, (int)theSize.getWidth() - (int)theAbaletSize.getWidth(), (int)theSize.getHeight());
            }
            if (theSize.getHeight() - theAbaletSize.getHeight() > 0.0) {
                g.setColor(this.getBackground());
                g.fillRect(0, (int)theAbaletSize.getHeight(), (int)theAbaletSize.getWidth(), (int)theSize.getHeight() - (int)theAbaletSize.getHeight());
            }
            if (this.theDesignCockpit.thePreferences.bDisplayBackgroundGrid) {
                Color thePenColor = this.getAppropriateColor(theColor);
                g.setColor(thePenColor);
                int x = this.theDesignCockpit.thePreferences.iViewDisplayerGridX;
                int cx = (int)theSize.getWidth();
                int cy = (int)theSize.getHeight();
                for (int y = this.theDesignCockpit.thePreferences.iViewDisplayerGridY; y < cy; y += this.theDesignCockpit.thePreferences.iViewDisplayerGridY) {
                    g.drawLine(0, y, cx - 1, y);
                }
                while (x < cx) {
                    g.drawLine(x, 0, x, cy - 1);
                    x += this.theDesignCockpit.thePreferences.iViewDisplayerGridX;
                }
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, (int)theSize.getWidth() - 1, (int)theSize.getHeight() - 1);
        }
    }

    class ComponentDropListener
    implements DropTargetListener {
        IDEViewDisplayer viewDisplayer;
        MetaObject designObject;

        public ComponentDropListener(IDEViewDisplayer paramViewDisplayer, MetaObject paramDesignObject) {
            this.designObject = paramDesignObject;
            this.viewDisplayer = paramViewDisplayer;
        }

        public void dragEnter(DropTargetDragEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getSourceActions());
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            try {
                IDEComponentPaletteNode selectedNode;
                e.acceptDrop(e.getSourceActions());
                Point pt = e.getLocation();
                Point ptViewDisplayerScreen = IDEViewDisplayer.this.getLocationOnScreen();
                if (this.designObject != null) {
                    Point ptObjectLocation = this.designObject.theVisualObject.getLocationOnScreen();
                    pt.x += ptObjectLocation.x - ptViewDisplayerScreen.x;
                    pt.y += ptObjectLocation.y - ptViewDisplayerScreen.y;
                }
                if ((selectedNode = IDEViewDisplayer.this.theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode()) != null) {
                    if (selectedNode.isCustomizerDataElement()) {
                        IDEViewDisplayer.this.theDesignCockpit.theCustomizer.importElement(this.designObject, pt, false);
                    } else {
                        IDEViewDisplayer.this.theDesignCockpit.theViewDisplayer.importObject(this.designObject, pt, false, null);
                    }
                }
                IDEViewDisplayer.this.theDesignCockpit.setMouseSelectState(true);
                if (this.designObject != null) {
                    IDEFocusRequester.requestFocus(this.designObject.theVisualObject);
                }
                e.getDropTargetContext().dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                e.rejectDrop();
            }
        }
    }
}

