/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.LizardValueChoiceComboBoxModel;
import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.IDEArrayValueEditor;
import ch.abacus.designcockpit.ide.IDECommonEditFocusAdapter;
import ch.abacus.designcockpit.ide.IDETitleBar;
import ch.abacus.designcockpit.ide.PropertyComboBoxEditor;
import ch.abacus.designcockpit.ide.PropertyTableModel;
import ch.abacus.designcockpit.ide.PropertyTableMouseListener;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.validation.IgnoreStandardEventsInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PropertyTable
extends JATable
implements ItemListener,
IgnoreStandardEventsInterface {
    HelperTableCellRenderer helperButtonCellRenderer = null;
    ColorPropertyRenderer colorPropertyCellRenderer = null;
    BooleanRenderer booleanPropertyCellRenderer = null;
    public PropertyTableModel theModel;
    public SuperDesignCockpit theDesignCockpit;
    public LizardValueChoiceComboBoxModel theComboModel;
    public PropertyComboBoxEditor theComboEditor;
    public IDEArrayValueEditor theArrayValueEditor;
    PropertyTableTextField theTextboxEditor;
    PropertyTableTextField theStaticEditor;

    public PropertyTable(PropertyTableModel theTableModel, SuperDesignCockpit objDesignCockpit) {
        super((TableModel)theTableModel);
        this.setBorder(null);
        this.setGridColor(Color.LIGHT_GRAY);
        this.theComboModel = new LizardValueChoiceComboBoxModel(objDesignCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser());
        this.theComboEditor = new PropertyComboBoxEditor(this.theComboModel, (Object)this);
        this.theStaticEditor = new PropertyTableTextField(this);
        this.theTextboxEditor = new PropertyTableTextField(this);
        this.theModel = theTableModel;
        this.theDesignCockpit = objDesignCockpit;
        this.setCellSelectionEnabled(true);
        this.addMouseListener(new PropertyTableMouseListener(this));
        this.theComboEditor.addItemListener(this);
        this.theComboEditor.setEditable(true);
        this.theStaticEditor.setEditable(false);
        this.setBackground(Color.WHITE);
        this.getTableHeader().setBackground(IDETitleBar.colGroupFill);
        this.getTableHeader().setBorder(null);
    }

    public boolean isValidationIndependent() {
        return true;
    }

    public void itemStateChanged(ItemEvent evt) {
        Object oText = this.theComboEditor.getSelectedItem();
        String sText = "";
        if (oText instanceof String) {
            sText = (String)oText;
        } else if (oText instanceof Boolean) {
            sText = oText.toString();
        }
        if (sText != null && sText.length() > 0) {
            this.theComboEditor.setEditorText(sText);
            this.theModel.setValueAt(sText, this.theComboEditor.iRow, this.theComboEditor.iColumn);
        } else if (oText != null) {
            this.theComboEditor.setEditorText(sText);
            this.theModel.setValueAt(sText, this.theComboEditor.iRow, this.theComboEditor.iColumn);
        }
    }

    public void nextRow() {
        int row = this.getSelectedRow();
        int column = 1;
        if (++row >= this.getRowCount()) {
            row = this.getRowCount() - 1;
        }
        this.changeSelection(row, column, true, true);
        this.editCellAt(row, column);
        Component theEditor = this.getEditorComponent();
        if (theEditor instanceof JComponent) {
            IDEFocusRequester.requestFocus((JComponent)theEditor);
        }
        if (theEditor instanceof PropertyTableTextField) {
            PropertyTableTextField theField = (PropertyTableTextField)theEditor;
            theField.selectAll();
        }
    }

    public void prevRow() {
        int row = this.getSelectedRow();
        int column = 1;
        if (--row < 0) {
            row = 0;
        }
        this.changeSelection(row, column, true, true);
        this.editCellAt(row, column);
        Component theEditor = this.getEditorComponent();
        if (theEditor instanceof JComponent) {
            IDEFocusRequester.requestFocus((JComponent)theEditor);
        }
        if (theEditor instanceof PropertyTableTextField) {
            PropertyTableTextField theField = (PropertyTableTextField)theEditor;
            theField.selectAll();
        }
    }

    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        return new Boolean(true);
    }

    public Boolean getPromptForComboBox(String sText, Object objLosingFocus) {
        MetaPropertyDescriptor theProp;
        int iRow = this.getSelectedRow();
        String sPropertyName = (String)this.getValueAt(iRow, 0);
        int iLeftBracket = sPropertyName.indexOf("[");
        if (iLeftBracket != -1) {
            sPropertyName = sPropertyName.substring(0, iLeftBracket);
        }
        if ((theProp = this.theModel.theMetaObject.theClass.getProperty(sPropertyName, true)) != null && theProp.bAllowMultipleValues) {
            this.theArrayValueEditor.close();
            this.theArrayValueEditor = new IDEArrayValueEditor(this.theModel.theMetaObject, sPropertyName, this.theDesignCockpit);
        }
        return new Boolean(true);
    }

    public boolean editCellAt(int row, int column) {
        Component theEditor;
        boolean bRetVal = super.editCellAt(row, column);
        if (this.getCellEditor() != null && (theEditor = this.getEditorComponent()) instanceof JTextField) {
            ((JTextField)theEditor).selectAll();
        }
        return bRetVal;
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        this.theModel.Load(this);
        this.setVisible(false);
        this.setVisible(true);
    }

    public void resetContents() {
        this.theModel.clear();
        this.setVisible(false);
        this.setVisible(true);
    }

    Color getItemColor(String avalue, int iRow) {
        MetaPropertyDescriptor theProperty = this.theModel.theClassProperties.get(iRow);
        Object theResolvedValue = null;
        MetaConstantGroupCollection theConstantTableGroup = this.theModel.theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
        if (avalue == null) {
            avalue = theProperty.getDefaultValue();
        }
        String nv = theConstantTableGroup.get(avalue);
        try {
            theResolvedValue = MetaConstantGroup.resolve((Object)nv, (MetadataDispenser)this.theDesignCockpit.theMetadataDispenser, (ClassLoader)this.theDesignCockpit.theFirstDesignProject.getMetaDataUser().getClassLoader().getLoader());
        }
        catch (HammerException e) {
            e.printStackTrace();
        }
        return (Color)theResolvedValue;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        MetaPropertyDescriptor theProperty = this.theModel.theClassProperties.get(row);
        String sClass = theProperty.getClassName().trim();
        if (column == 0 && theProperty != null && theProperty.getHelperClass() != null && theProperty.getHelperClass().length() > 0) {
            if (this.helperButtonCellRenderer == null) {
                this.helperButtonCellRenderer = new HelperTableCellRenderer();
            }
            renderer = this.helperButtonCellRenderer;
        }
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.theModel.getCellClass(row, column));
        }
        if (column == 1 && theProperty != null && sClass != null && sClass.endsWith("Color")) {
            if (this.colorPropertyCellRenderer == null) {
                this.colorPropertyCellRenderer = new ColorPropertyRenderer();
            }
            renderer = this.colorPropertyCellRenderer;
        }
        if (this.theModel.getCellClass(row, column) != null && this.theModel.getCellClass(row, column) == Boolean.class) {
            if (this.booleanPropertyCellRenderer == null) {
                this.booleanPropertyCellRenderer = new BooleanRenderer();
            }
            renderer = this.booleanPropertyCellRenderer;
        }
        return renderer;
    }

    public Component getEditorComponent() {
        Component theComponent = super.getEditorComponent();
        if (theComponent != null && theComponent instanceof JTextField) {
            IDECommonEditFocusAdapter.setSelectAllOnEdit((JTextField)theComponent, this);
        }
        return theComponent;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        MetaPropertyDescriptor theProp = this.theModel.getPropertyAt(row);
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null && (editor = this.getDefaultEditor(this.theModel.getCellClass(row, column))) instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        if (theProp == null) {
            return editor;
        }
        MetaProperty thePropertyValue = this.theModel.theMetaObject.getPropertyMetadata(theProp.getName());
        switch (column) {
            case 0: {
                this.theStaticEditor.setColumn(column);
                this.theStaticEditor.setRow(row);
                DefaultCellEditor theEditor = new DefaultCellEditor(this.theStaticEditor);
                theEditor.setClickCountToStart(1);
                return theEditor;
            }
            case 1: {
                String sValue;
                String sClass = theProp.getClassName().trim();
                String sName = theProp.getName();
                if (sClass.endsWith("Boolean") || sClass.equals("boolean")) {
                    return new BooleanEditor((JTable)((Object)this));
                }
                if (theProp.bObjectReference) {
                    DesignProject theDesignProject = this.theDesignCockpit.getDesignProject();
                    ArrayList arrObj = theDesignProject.findObjectsByClass(sClass);
                    theProp.setObjectReferenceList(arrObj);
                    this.theComboEditor.Load(theProp);
                    this.theComboEditor.setColumn(column);
                    this.theComboEditor.setRow(row);
                    this.theComboEditor.setEditorText("");
                    DefaultCellEditor theEditor = new DefaultCellEditor(this.theComboEditor);
                    theEditor.setClickCountToStart(1);
                    return theEditor;
                }
                if (theProp.getDataAwareness()) {
                    DesignProject theDesignProject = this.theDesignCockpit.getDesignProject();
                    MetaObject mt = theDesignProject.getLastObjectSelected();
                    Object objFieldAccess = mt.getSwingObject();
                    Class<?> fldAccsClass = objFieldAccess.getClass();
                    Method[] availMthds = fldAccsClass.getMethods();
                    for (int i = 0; i < availMthds.length; ++i) {
                        Method chMth = availMthds[i];
                        String methodName = chMth.getName();
                        if (!methodName.equalsIgnoreCase("getFieldNames")) continue;
                        try {
                            ArrayList fields = (ArrayList)chMth.invoke(objFieldAccess, (Object[])null);
                            for (int n = 0; n < fields.size(); ++n) {
                                try {
                                    theProp.setValueChoice(n, (Object)fields.get(n).toString());
                                    continue;
                                }
                                catch (Exception e) {
                                    theProp.addValueChoice(fields.get(n).toString());
                                }
                            }
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    this.theComboEditor.Load(theProp);
                    this.theComboEditor.setColumn(column);
                    this.theComboEditor.setRow(row);
                    DefaultCellEditor theEditor = new DefaultCellEditor(this.theComboEditor);
                    theEditor.setClickCountToStart(1);
                    return theEditor;
                }
                if (!(theProp.getValueChoiceCount() > 1 || theProp.bObjectReference || theProp.getIncludeTypeConstants() != null && theProp.getIncludeTypeConstants().length() != 0)) {
                    this.theTextboxEditor.setColumn(column);
                    this.theTextboxEditor.setRow(row);
                    DefaultCellEditor theEditor = new DefaultCellEditor(this.theTextboxEditor);
                    theEditor.setClickCountToStart(1);
                    return theEditor;
                }
                MetaPropertyValueEx pvValue = this.theModel.theMetaObject.getPropertyValue(theProp.getName(), 0);
                if (theProp.getClassName().endsWith("Color")) {
                    this.theComboEditor.enableColorSelection();
                } else {
                    this.theComboEditor.enableDefaultSelection();
                }
                this.theComboEditor.Load(theProp);
                this.theComboEditor.setColumn(column);
                this.theComboEditor.setRow(row);
                if (pvValue != null && (sValue = pvValue.getStringValue()) != null) {
                    this.theComboEditor.setSelectedItem(sValue);
                }
                DefaultCellEditor theEditor = new DefaultCellEditor(this.theComboEditor);
                theEditor.setClickCountToStart(1);
                return theEditor;
            }
        }
        return editor;
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        JTable theTable;

        public BooleanEditor(JTable atable) {
            super(new JCheckBox());
            this.theTable = atable;
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setForeground(atable.getForeground());
            checkBox.setBackground(atable.getBackground());
            checkBox.setHorizontalAlignment(2);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            super("False");
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean shouldSelect;
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            boolean bl = shouldSelect = value != null && (Boolean)value != false;
            if (shouldSelect) {
                this.setText("True");
            } else {
                this.setText("False");
            }
            this.setSelected(shouldSelect);
            return this;
        }
    }

    public class ColorPropertyEditor
    extends DefaultCellEditor {
        public ColorPropertyEditor() {
            super(new JComboBox());
        }
    }

    public class ColorPropertyRenderer
    extends JLabel
    implements TableCellRenderer {
        Color currentColor;
        int currentRow;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.currentRow = row;
            this.currentColor = PropertyTable.this.getItemColor(value.toString(), this.currentRow);
            return this;
        }

        public void paint(Graphics g) {
            JButton button = new JButton();
            Dimension dim = new Dimension(button.getFontMetrics(button.getFont()).stringWidth("...") * 2, button.getFontMetrics(button.getFont()).getHeight());
            g.setColor(Color.black);
            g.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
            g.setColor(this.currentColor);
            g.fillRect(1, 1, (int)dim.getWidth() - 2, (int)dim.getHeight() - 2);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(super.getForeground());
            g.drawString((String)PropertyTable.this.getValueAt(this.currentRow, 1), (int)dim.getWidth() + 2, fontMetrics.getAscent());
        }
    }

    class HelperTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        protected JLabel label = new JLabel();
        protected JButton button = new JButton("...");
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public HelperTableCellRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "West");
            this.add((Component)this.button, "East");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.setPreferredSize(new Dimension(this.getWidth(), (int)this.button.getPreferredSize().getHeight()));
            this.setValue(value);
            this.button.setBackground(new Color(153, 204, 255));
            Dimension dim = new Dimension(this.button.getFontMetrics(this.button.getFont()).stringWidth("...") * 2, this.button.getFontMetrics(this.button.getFont()).getHeight());
            this.button.setPreferredSize(dim);
            return this;
        }

        protected void setValue(Object value) {
            this.label.setText(value == null ? "" : value.toString());
        }
    }

    class PropertyTableFocusListener
    implements FocusListener {
        PropertyTable theTable;

        PropertyTableFocusListener(PropertyTable theTableParent) {
            this.theTable = theTableParent;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            MetaObject theMetaObject = this.theTable.theDesignCockpit.getDesignProject().getLastObjectSelected();
            this.theTable.invalidate();
            this.theTable.repaint();
            theMetaObject.doProperties();
            theMetaObject.theVisualObject.repaint();
            if (theMetaObject.equals(this.theTable.theDesignCockpit.getDesignProject().getSelectedFrame())) {
                this.theTable.theDesignCockpit.theViewDisplayer.repaint();
            }
        }
    }

    class PropertyTableTextField
    extends JTextField {
        String thePropertyName;
        int theCellRow;
        int theCellColumn;
        boolean bHighlight;
        PropertyTable theTable;

        public PropertyTableTextField(PropertyTable theTable) {
            this.theTable = theTable;
        }

        void setRow(int row) {
            this.theCellRow = row;
        }

        void setColumn(int column) {
            this.theCellColumn = column;
        }

        void setHighlight(boolean state) {
            this.bHighlight = state;
        }

        void setPropertyName(String propertyName) {
            this.thePropertyName = propertyName;
        }

        int getRow() {
            return this.theCellRow;
        }

        int getColumn() {
            return this.theCellColumn;
        }

        boolean getHighlight() {
            return this.bHighlight;
        }

        String getPropertyName() {
            return this.thePropertyName;
        }
    }
}

