/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.designcockpit.ide.IDEPropertyInspectorController;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.propertyinspector.IDEPropertyInspectorInterface;
import ch.abacus.designcockpit.ide.propertyinspector.ObjecReferenceListEditor;
import ch.abacus.designcockpit.ide.propertyinspector.PropertyFactory;
import ch.abacus.designcockpit.ide.propertyinspector.PropertyRegistry;
import ch.abacus.lib.ui.propertyinspector.core.AccessorInterface;
import ch.abacus.lib.ui.propertyinspector.core.Clazz;
import ch.abacus.lib.ui.propertyinspector.core.Property;
import ch.abacus.lib.ui.propertyinspector.display.ObjectInstance;
import ch.abacus.lib.ui.propertyinspector.display.PropertyInspector;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

public class IDEAbacusPropertyInspector
implements IDEPropertyInspectorInterface {
    private HashMap<String, Clazz> m_clazzes;
    private PropertyInspector m_propertyInspector;
    private PropertyRegistry m_propertyRegistry;
    private PropertyFactory m_propertyfactory;
    private SuperDesignCockpit m_cockpit;
    private IDEPropertyInspectorController m_controller;
    private MetadataDispenser m_metadataDispenser;

    public void init(IDEPropertyInspectorController controller) {
        this.m_controller = controller;
        this.m_cockpit = controller.getSuperDesignCockpit();
        this.m_metadataDispenser = this.m_cockpit.getMetadataDispenser();
        this.m_propertyInspector = new PropertyInspector(this.m_cockpit.getGlobalInterface(), false);
        this.m_propertyRegistry = new PropertyRegistry(this.m_propertyInspector, this.m_cockpit);
        this.m_propertyfactory = new PropertyFactory(this.m_propertyRegistry, this.m_controller);
        this.m_propertyInspector.getModel().setAccessor((AccessorInterface)new MyAccessorInterface(controller));
        this.m_propertyInspector.getModel().setSortAlphabetically(true);
        String sReadOnly = this.m_cockpit.getLanguageManager().getMessage("PropertyInspector.Property_ReadOnly.label", "This property cannot be changed, as it has been designated as read-only");
        String sSingleSelect = this.m_cockpit.getLanguageManager().getMessage("PropertyInspector.Property_SingleSelect.label", "This property cannot be changed when multiple components are selected");
        this.m_propertyInspector.getLanguageStrings().put("readonly", sReadOnly);
        this.m_propertyInspector.getLanguageStrings().put("single selection", sSingleSelect);
        this.m_clazzes = new HashMap();
        this.loadClasses();
    }

    public void editingCanceled(ChangeEvent event) {
        this.getPropertyInspector().getTable().editingCanceled(event);
    }

    public void updateSelectedProperties() {
        this.getPropertyInspector().getModel().changeSelection();
    }

    public void newObjectsSelected(MetaObject[] objects) {
        PropertyModel model = this.m_propertyInspector.getModel();
        model.beginUpdate();
        for (int iMetaObject = 0; iMetaObject < objects.length; ++iMetaObject) {
            MetaObject metaObject = objects[iMetaObject];
            if (metaObject == null) continue;
            model.addSelection(metaObject.theClass.theMetadata.sClassName, (Object)metaObject);
        }
        model.endUpdate();
    }

    public void clearSelectedObjects() {
        this.m_propertyInspector.getModel().getSelection().clear();
        this.m_propertyInspector.getModel().changeSelection();
    }

    public JComponent getPropertyInspectorComponent() {
        return this.m_propertyInspector;
    }

    public void loadClasses() {
        MetaClass firstClass = this.m_metadataDispenser.getFirstClass();
        this.m_propertyInspector.getModel().getClazzes().clear();
        this.m_clazzes.clear();
        this.addClazzes(firstClass);
    }

    private void addClazz(MetaClass metaClass) {
        String sClassName = metaClass.getMetadata().sClassName;
        String sParentClassName = null;
        Clazz parentClazz = null;
        MetaClass parentClass = metaClass.getParentClass();
        if (parentClass != null) {
            sParentClassName = parentClass.getMetadata().sClassName;
            parentClazz = this.m_clazzes.get(sParentClassName);
        }
        Clazz clazz = new Clazz(parentClazz, sClassName);
        this.m_propertyInspector.getModel().getClazzes().add((Object)clazz);
        this.m_clazzes.put(sClassName, clazz);
        this.addProperties(metaClass, clazz);
    }

    private void addProperties(MetaClass metaClass, Clazz clazz) {
        for (MetaPropertyDescriptor metaPropertyDescriptor = metaClass.getMetadata().theFirstProperty; metaPropertyDescriptor != null; metaPropertyDescriptor = metaPropertyDescriptor.getNextProperty()) {
            this.addProperty(clazz, metaPropertyDescriptor);
        }
    }

    private void addProperty(Clazz clazz, MetaPropertyDescriptor metaPropertyDescriptor) {
        if (metaPropertyDescriptor.bVisible) {
            Property property = this.m_propertyfactory.getProperty(metaPropertyDescriptor);
            clazz.getProperties().add(property);
        } else {
            MetaPropertyDescriptor subProperty = metaPropertyDescriptor.theFirstSubproperty;
            if (subProperty != null) {
                if (subProperty.bVisible) {
                    this.addProperty(clazz, subProperty);
                }
                if ((subProperty = subProperty.getNextProperty()) != null && subProperty.bVisible) {
                    this.addProperty(clazz, subProperty);
                }
            }
        }
    }

    private void addClazzes(MetaClass currentClass) {
        while (currentClass != null) {
            MetaClassDetail metadata = currentClass.getMetadata();
            this.addClazz(currentClass);
            if (currentClass.getFirstClass() != null) {
                this.addClazzes(currentClass.getFirstClass());
            }
            currentClass = currentClass.getNextSibling();
        }
    }

    public PropertyInspector getPropertyInspector() {
        return this.m_propertyInspector;
    }

    private class MyAccessorInterface
    implements AccessorInterface {
        private IDEPropertyInspectorController m_controller;

        public MyAccessorInterface(IDEPropertyInspectorController controller) {
            this.m_controller = controller;
        }

        public void beginUpdate() {
        }

        public void setValue(Property property, ObjectInstance instance, Object value) {
            if (value != null) {
                MetaObject metaObject = (MetaObject)instance.getObject();
                String propertyName = (String)property.getData();
                this.m_controller.setPropertyValue(metaObject, propertyName, value);
            }
        }

        public Object getValue(Property property, ObjectInstance instance) {
            MetaObject metaObject = (MetaObject)instance.getObject();
            String propertyName = (String)property.getData();
            Object value = null;
            value = this.m_controller.getPropertyValue(metaObject, propertyName);
            MetaClass metaClass = metaObject.theClass;
            MetaPropertyDescriptor mpd = metaClass.getProperty(propertyName, true);
            if (mpd != null && IDEAbacusPropertyInspector.this.m_cockpit.getOpenSourceState()) {
                if (mpd.bObjectReference) {
                    ArrayList refList = mpd.getObjectReferenceList();
                    ArrayList<String> stringSources = new ArrayList<String>();
                    for (int i = 0; i < refList.size(); ++i) {
                        MetaObject mo = (MetaObject)refList.get(i);
                        stringSources.add(mo.getName());
                    }
                    PropertyValueEditorInterface pve = IDEAbacusPropertyInspector.this.m_propertyRegistry.getEditorRegistry().get("-ObjReferenceList-" + propertyName);
                    if (refList != null) {
                        ((ObjecReferenceListEditor)pve).refreshList(stringSources);
                    }
                    if (value instanceof JComponent) {
                        value = ((JComponent)value).getName();
                    }
                } else if (mpd.getDataAwareness()) {
                    ArrayList<String> refList = new ArrayList<String>();
                    int iChoiceCount = mpd.getValueChoiceCount();
                    for (int i = 0; i < iChoiceCount; ++i) {
                        refList.add(mpd.getValueChoiceAsString(i));
                    }
                    if (refList != null) {
                        PropertyValueEditorInterface pve = IDEAbacusPropertyInspector.this.m_propertyRegistry.getEditorRegistry().get("-dbFieldNameList-" + propertyName);
                        pve = IDEAbacusPropertyInspector.this.m_propertyRegistry.getEditorRegistry().get("-dbFieldNameList-" + propertyName);
                        if (pve != null) {
                            ((ObjecReferenceListEditor)pve).refreshList(refList);
                        }
                    }
                }
            }
            return value;
        }

        public void endUpdate() {
            this.m_controller.newObjectsSelected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyIds {
        Dumy;

    }
}

