/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.JATable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AboutDialog
extends JADialog {
    private final MetadataEditor theEditor;

    public AboutDialog(MetadataEditor editor) {
        super((JAFrame)editor, "About Metadata Editor", true, false);
        this.theEditor = editor;
        JATabbedPane theAboutBoxPane = new JATabbedPane();
        theAboutBoxPane.setBorder(BorderFactory.createRaisedBevelBorder());
        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(editor);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel();
        theAboutBoxPane.addTab("Version Information", (Component)((Object)theProductInfoPanel));
        theAboutBoxPane.addTab("System Information", (Component)((Object)theSystemInfoPanel));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)theAboutBoxPane, "Center");
        JAPanel theButtonPanel = new JAPanel();
        theButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)theButtonPanel, "South");
        JAButton theButton = new JAButton("OK");
        theButtonPanel.add((Component)theButton);
        theButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AboutDialog.this.hide();
            }
        });
        this.setResizable(true);
        this.setSize(600, 320);
        this.setLocationRelativeTo(null);
        this.show(null);
    }

    class SystemInformationPanel
    extends JAPanel {
        public SystemInformationPanel() {
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            Enumeration<?> e = sysprops.propertyNames();
            while (e.hasMoreElements()) {
                String sPropName = (String)e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable((TableModel)thePropertyModel);
            this.setLayout(new BorderLayout());
            this.add((Component)new JAScrollPane((Component)thePropertyTable));
        }
    }

    class SystemPropertyModel
    extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public void addPair(String sName, String sValue) {
            this.ColumnOneValues.add(sName);
            this.ColumnTwoValues.add(sValue);
        }

        public int getRowCount() {
            return this.ColumnOneValues.size();
        }

        public Object getValueAt(int iRow, int iCol) {
            if (iCol == 0) {
                return this.ColumnOneValues.get(iRow);
            }
            return this.ColumnTwoValues.get(iRow);
        }

        public String getColumnName(int iCol) {
            if (iCol == 0) {
                return "Property";
            }
            return "Value";
        }

        public int getColumnCount() {
            return 2;
        }
    }

    class ProductInformationPanel
    extends JAPanel {
        public ProductInformationPanel(MetadataEditor editor) {
            this.setLayout(new BorderLayout());
            String sHead = "<HTML><Body><CENTER>";
            String sFoot = "</Body></HTML>";
            String sToolName = "Metadata Editor";
            String sCaption = "<B>" + sToolName + "</b><BR><p>";
            String sVersion = "<B>Version:</B> " + editor.getVersionNumber() + "<P>";
            String sRevision = "<B>Revision:</B> " + editor.getRevisionNumber() + "<P>";
            String sSubRevision = "<B>Sub Revsion:</B> " + editor.getSubRevisionNumber() + "<P>";
            String sBuild = "<B>Build:</B> " + editor.getBuildNumber() + "<P>";
            this.add((Component)new JALabel(sHead + sCaption + sVersion + sRevision + sSubRevision + sBuild + sFoot, 0), "Center");
        }
    }
}

