/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.EditGroupConstantsDialog;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ManageGroupConstantsDialog
extends JDialog {
    final MetadataEditor editor;
    private TableModel theModel;
    private ArrayList theConstantNames;
    private ArrayList theConstantValues;
    protected MetaConstantGroup theGroup;
    protected String marshalledConstantName;
    protected String marshalledConstantValue;
    private boolean dialogModified = false;
    JATable tblConstants = new JATable();

    public ManageGroupConstantsDialog(MetadataEditor editor, MetaConstantGroup group) {
        super((Frame)((Object)editor), "Manage Constants in Group", true);
        this.editor = editor;
        this.theGroup = group;
        this.createDataForInitialTableModel();
        this.initDisplay("Constants for \"" + group.sClassName + "\"", (JComponent)this.tblConstants);
        this.populateDisplay();
    }

    private void createDataForInitialTableModel() {
        this.theConstantNames = new ArrayList();
        this.theConstantValues = new ArrayList();
        ArrayList constants = this.theGroup.getConstantList();
        for (int iConstant = 0; iConstant < constants.size(); ++iConstant) {
            String sConstantName = (String)constants.get(iConstant);
            String sConstantValue = this.theGroup.get(sConstantName);
            this.theConstantNames.add(sConstantName);
            this.theConstantValues.add(sConstantValue);
        }
    }

    private void populateDisplay() {
        this.tblConstants.setModel((TableModel)new ConstantsTableModel());
    }

    private void initDisplay(String sCaption, JComponent list) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel((LayoutManager)new BorderLayout());
        pnlConstants.setBorder((Border)BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add((Component)new JScrollPane(list), (Object)"Center");
        JAButton btnAdd = new JAButton("Add");
        JAButton btnEdit = new JAButton("Edit");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener((ActionListener)new AddConstantAction(this));
        btnEdit.addActionListener((ActionListener)new EditConstantAction(this));
        btnDelete.addActionListener((ActionListener)new DeleteConstantAction(this));
        JAPanel pnlButtons = new JAPanel((LayoutManager)new FlowLayout(0, 5, 5));
        pnlButtons.add((Component)btnAdd);
        pnlButtons.add((Component)btnEdit);
        pnlButtons.add((Component)btnDelete);
        pnlConstants.add((Component)pnlButtons, (Object)"South");
        pane.add((Component)pnlConstants, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlDialogButtons, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageGroupConstantsDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    class OkAction
    implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public OkAction(ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (!ManageGroupConstantsDialog.this.dialogModified) {
                return;
            }
            this.dialog.editor.setMetadataModified(true);
            ManageGroupConstantsDialog.this.theGroup.clearConstants();
            for (int iConstant = 0; iConstant < ManageGroupConstantsDialog.this.theConstantNames.size(); ++iConstant) {
                ManageGroupConstantsDialog.this.theGroup.set((String)ManageGroupConstantsDialog.this.theConstantNames.get(iConstant), (String)ManageGroupConstantsDialog.this.theConstantValues.get(iConstant));
            }
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public CancelAction(ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog.dialogModified) {
                String sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = 0;
                int messageType = 3;
                int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) {
                    this.dialog.hide();
                }
            } else {
                ManageGroupConstantsDialog.this.hide();
            }
        }
    }

    class DeleteConstantAction
    implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public DeleteConstantAction(ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int messageType;
            int optionType;
            String sConfirmationTitle;
            int iSelectedRow = this.dialog.tblConstants.getSelectedRow();
            if (iSelectedRow == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a constant before you can delete it.", "No Constant Selected", 0);
                return;
            }
            String sConstantName = (String)this.dialog.tblConstants.getValueAt(iSelectedRow, 0);
            String sConfirmationText = "Are you sure you want to delete the constant  \"" + sConstantName + "\" ?";
            int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle = "Delete Constant", optionType = 0, messageType = 3);
            if (iChoice == 0) {
                ManageGroupConstantsDialog.this.theConstantNames.remove(iSelectedRow);
                ManageGroupConstantsDialog.this.theConstantValues.remove(iSelectedRow);
                ManageGroupConstantsDialog.this.populateDisplay();
                ManageGroupConstantsDialog.this.dialogModified = true;
            }
        }
    }

    class AddConstantAction
    implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public AddConstantAction(ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            EditGroupConstantsDialog editDialog = new EditGroupConstantsDialog(this.dialog, "Add Constant To Group", false);
            editDialog.show();
            if (ManageGroupConstantsDialog.this.marshalledConstantName != null) {
                ManageGroupConstantsDialog.this.theConstantNames.add(ManageGroupConstantsDialog.this.marshalledConstantName);
                ManageGroupConstantsDialog.this.theConstantValues.add(ManageGroupConstantsDialog.this.marshalledConstantValue);
                ManageGroupConstantsDialog.this.populateDisplay();
                ManageGroupConstantsDialog.this.dialogModified = true;
            }
        }
    }

    class EditConstantAction
    implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public EditConstantAction(ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int iSelectedRow = this.dialog.tblConstants.getSelectedRow();
            if (iSelectedRow == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a constant before you can edit it.", "No Constant Selected", 0);
                return;
            }
            ManageGroupConstantsDialog.this.marshalledConstantName = (String)this.dialog.tblConstants.getValueAt(iSelectedRow, 0);
            ManageGroupConstantsDialog.this.marshalledConstantValue = (String)this.dialog.tblConstants.getValueAt(iSelectedRow, 1);
            EditGroupConstantsDialog editDialog = new EditGroupConstantsDialog(this.dialog, "Edit Constant", true);
            editDialog.show();
            if (ManageGroupConstantsDialog.this.marshalledConstantName != null) {
                ManageGroupConstantsDialog.this.theConstantNames.set(iSelectedRow, ManageGroupConstantsDialog.this.marshalledConstantName);
                ManageGroupConstantsDialog.this.theConstantValues.set(iSelectedRow, ManageGroupConstantsDialog.this.marshalledConstantValue);
                ManageGroupConstantsDialog.this.populateDisplay();
                ManageGroupConstantsDialog.this.dialogModified = true;
            }
        }
    }

    class ConstantsTableModel
    extends AbstractTableModel {
        private int rowCount;

        public ConstantsTableModel() {
            this.rowCount = ManageGroupConstantsDialog.this.theConstantNames.size();
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            return "Value";
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String sConstantName = (String)ManageGroupConstantsDialog.this.theConstantNames.get(rowIndex);
            String sConstantValue = (String)ManageGroupConstantsDialog.this.theConstantValues.get(rowIndex);
            if (columnIndex == 0) {
                return sConstantName;
            }
            return sConstantValue;
        }
    }
}

