/*
 * Decompiled with CFR 0.152.
 */
package com.ozten.font;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JComponent {
    private String[] sizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "24", "26", "28", "32", "36", "40", "48", "56", "64", "72"};
    private static String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private JDialog jd;
    private JPanel p;
    private JLabel font;
    private JList fontChoices;
    private JList sizeChoices;
    private JScrollPane fontChoiceScroll;
    private JScrollPane previewScroll;
    private JScrollPane sizeScroll;
    private JTextArea preview;
    private static JButton apply;
    private static JButton cancel;
    private Font fPreview;
    private JCheckBox checkBold;
    private JCheckBox checkItalic;

    public JFontChooser() {
        this.doJFCLayout();
        this.setPreviewText("How does this font fit?");
        this.setPreviewFont(JFontChooser.getAvailableFont());
    }

    public JFontChooser(Font font) {
        this.setPreviewFont(font);
        this.setPreviewText("How does this font fit?");
    }

    public JFontChooser(Font font, String string) {
        this.setPreviewFont(font);
        this.setPreviewText(string);
    }

    public static Font showDialog(Component component, String string, String string2, Font font) {
        final JFontChooser jFontChooser = new JFontChooser(font, string2);
        jFontChooser.doJFCLayout();
        jFontChooser.setJDialog(JFontChooser.initDialog(component, string, true));
        jFontChooser.getJDialog().getContentPane().add((Component)jFontChooser, "Center");
        JPanel jPanel = new JPanel();
        apply = new JButton("Ok");
        jPanel.add(apply);
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFontChooser.setPreviewFont(jFontChooser.buildFont());
                if (jFontChooser.getJDialog() != null) {
                    jFontChooser.getJDialog().dispose();
                    jFontChooser.getJDialog().setVisible(false);
                }
            }
        });
        cancel = new JButton("Cancel");
        jPanel.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFontChooser.setPreviewFont(null);
                if (jFontChooser.getJDialog() != null) {
                    jFontChooser.getJDialog().dispose();
                    jFontChooser.getJDialog().setVisible(false);
                }
            }
        });
        jFontChooser.getJDialog().getContentPane().add((Component)jPanel, "South");
        jFontChooser.getJDialog().pack();
        jFontChooser.getJDialog().setResizable(false);
        jFontChooser.getJDialog().setVisible(true);
        return jFontChooser.getPreviewFont();
    }

    private static JDialog initDialog(Component component, String string, boolean bl) {
        JDialog jDialog = null;
        JFrame jFrame = new JFrame();
        jDialog = jFrame != null ? new JDialog(jFrame, string, bl) : new JDialog();
        return jDialog;
    }

    public static Font getAvailableFont() {
        Font font = null;
        String[] stringArray = JFontChooser.getSystemFonts();
        font = new Font(stringArray[0], 0, 18);
        return font;
    }

    private void doJFCLayout() {
        Object object;
        boolean bl = false;
        this.setLayout(new BorderLayout());
        this.p = new JPanel(new FlowLayout());
        this.add((Component)this.p, "Center");
        this.fontChoices = new JList<String>(fonts);
        boolean bl2 = false;
        if (this.getPreviewFont() != null) {
            object = JFontChooser.getSystemFonts();
            int n = 0;
            while (n < ((String[])object).length) {
                if (object[n].equalsIgnoreCase(this.getPreviewFont().getFontName())) {
                    this.fontChoices.setSelectedIndex(n);
                    bl2 = true;
                }
                ++n;
            }
        }
        if (!bl2) {
            this.fontChoices.setSelectedIndex(0);
        }
        this.fontChoices.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFontChooser.this.updateGUI();
            }
        });
        this.fontChoiceScroll = new JScrollPane(this.fontChoices);
        this.fontChoiceScroll.setPreferredSize(new Dimension(200, 150));
        this.p.add(this.fontChoiceScroll);
        this.sizeChoices = new JList<String>(this.getFontSizes());
        bl2 = false;
        if (this.getPreviewFont() != null) {
            int n = 0;
            while (n < this.getFontSizes().length) {
                if (Integer.parseInt(this.sizes[n]) == this.getPreviewFont().getSize()) {
                    this.sizeChoices.setSelectedIndex(n);
                    bl2 = true;
                }
                ++n;
            }
        }
        if (!bl2) {
            this.sizeChoices.setSelectedIndex(12);
        }
        this.sizeChoices.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFontChooser.this.updateGUI();
            }
        });
        this.sizeScroll = new JScrollPane(this.sizeChoices);
        this.sizeScroll.setPreferredSize(new Dimension(48, 150));
        this.p.add(this.sizeScroll);
        object = new JPanel(new GridLayout(1, 2));
        this.checkBold = new JCheckBox("Bold");
        this.checkBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateGUI();
            }
        });
        if (this.getPreviewFont() != null && this.getPreviewFont().isBold()) {
            this.checkBold.setSelected(true);
        }
        ((Container)object).add(this.checkBold);
        this.checkItalic = new JCheckBox("Italic");
        this.checkItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateGUI();
            }
        });
        if (this.getPreviewFont() != null && this.getPreviewFont().isItalic()) {
            this.checkItalic.setSelected(true);
        }
        ((Container)object).add(this.checkItalic);
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 3));
        jPanel.add((Component)object);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = new JLabel("Current Selection:");
        jPanel2.add(jLabel);
        this.font = new JLabel();
        this.font.setForeground(Color.black);
        jPanel2.add(this.font);
        jPanel.add(jPanel2);
        this.p.add(jPanel);
        this.previewScroll = new JScrollPane(this.preview);
        this.previewScroll.setPreferredSize(new Dimension(400, 80));
        this.add((Component)this.previewScroll, "South");
        this.updateGUI();
    }

    private void updateStatus() {
        Font font = this.buildFont();
        String string = font.getName().length() > 11 ? font.getName().substring(0, 12) : font.getName();
        this.font.setText(string + " " + font.getSize() + "pt.");
    }

    private Font buildFont() {
        Font font = null;
        String string = (String)this.sizeChoices.getSelectedValue();
        if (string != null) {
            int n = Integer.parseInt(string);
            int n2 = 0;
            if (this.checkBold.isSelected() && this.checkItalic.isSelected()) {
                n2 = 1;
                n2 |= 2;
            } else if (this.checkBold.isSelected()) {
                n2 = 1;
            } else if (this.checkItalic.isSelected()) {
                n2 = 2;
            }
            return new Font((String)this.fontChoices.getSelectedValue(), n2, n);
        }
        return font;
    }

    private void updateGUI() {
        Font font = this.buildFont();
        if (font != null && this.getPreviewText() != null) {
            this.getPreviewText().setFont(font);
            if (font != null) {
                this.setPreviewFont(font);
            }
            this.updateStatus();
        }
    }

    public static String[] getSystemFonts() {
        return fonts;
    }

    public String[] getFontSizes() {
        return this.sizes;
    }

    public JDialog getJDialog() {
        return this.jd;
    }

    public void setJDialog(JDialog jDialog) {
        this.jd = jDialog;
    }

    public JTextArea getPreviewText() {
        return this.preview;
    }

    public void setPreviewText(String string) {
        this.preview = new JTextArea(string);
    }

    public Font getPreviewFont() {
        return this.fPreview;
    }

    public void setPreviewFont(Font font) {
        this.fPreview = font;
    }

    public static Font showDialog(Component component, String string, String string2) {
        Font font = JFontChooser.showDialog(component, string, string2, component.getFont());
        return font;
    }

    public static Font showDialog(Component component, String string) {
        Font font = JFontChooser.showDialog(component, string, "How about this font?", component.getFont());
        return font;
    }

    public static Font showDialog(Component component) {
        Font font = JFontChooser.showDialog(component, "Choose a font", "How about this font?", component.getFont());
        return font;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Font font = JFontChooser.showDialog(jFrame, "Chooser a font", "Fishing for Bobby Searcher", JFontChooser.getAvailableFont());
    }
}

