/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.PercentLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;

public class PercentLayoutAnimator
implements ActionListener {
    private Timer animatorTimer;
    private List tasks = new ArrayList();
    private PercentLayout layout;
    private Container container;

    public PercentLayoutAnimator(Container container, PercentLayout layout) {
        this.container = container;
        this.layout = layout;
    }

    public void setTargetPercent(Component component, float percent) {
        PercentLayout.Constraint oldConstraint = this.layout.getConstraint(component);
        if (oldConstraint instanceof PercentLayout.PercentConstraint) {
            this.setTargetPercent(component, ((PercentLayout.PercentConstraint)oldConstraint).floatValue(), percent);
        }
    }

    public void setTargetPercent(Component component, float startPercent, float endPercent) {
        this.tasks.add(new PercentTask(component, startPercent, endPercent));
    }

    public void start() {
        this.animatorTimer = new Timer(15, this);
        this.animatorTimer.start();
    }

    public void stop() {
        this.animatorTimer.stop();
    }

    public void actionPerformed(ActionEvent e) {
        boolean allCompleted = true;
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            PercentTask element = (PercentTask)iter.next();
            if (element.isCompleted()) continue;
            allCompleted = false;
            element.execute();
        }
        this.container.invalidate();
        this.container.doLayout();
        this.container.repaint();
        if (allCompleted) {
            this.stop();
        }
    }

    class PercentTask {
        Component component;
        float targetPercent;
        float currentPercent;
        boolean completed;
        boolean incrementing;
        float delta;

        public PercentTask(Component component, float currentPercent, float targetPercent) {
            this.component = component;
            this.currentPercent = currentPercent;
            this.targetPercent = targetPercent;
            float diff = targetPercent - currentPercent;
            this.incrementing = diff > 0.0f;
            this.delta = diff / 10.0f;
        }

        public void execute() {
            this.currentPercent += this.delta;
            if (this.incrementing) {
                if (this.currentPercent > this.targetPercent) {
                    this.currentPercent = this.targetPercent;
                    this.completed = true;
                }
            } else if (this.currentPercent < this.targetPercent) {
                this.currentPercent = this.targetPercent;
                this.completed = true;
            }
            PercentLayoutAnimator.this.layout.setConstraint(this.component, new PercentLayout.PercentConstraint(this.currentPercent));
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

