/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.plaf.basic.BasicTaskPaneGroupUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsTaskPaneGroupUI
extends BasicTaskPaneGroupUI {
    private static int TITLE_HEIGHT = 25;
    private static int ROUND_HEIGHT = 5;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsTaskPaneGroupUI();
    }

    protected Border createPaneBorder() {
        return new XPPaneBorder();
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getParent().getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(c.getBackground());
            g.fillRect(0, ROUND_HEIGHT, c.getWidth(), c.getHeight() - ROUND_HEIGHT);
        }
        this.paint(g, c);
    }

    protected int getTitleHeight() {
        return TITLE_HEIGHT;
    }

    class XPPaneBorder
    extends BasicTaskPaneGroupUI.PaneBorder {
        XPPaneBorder() {
        }

        protected void paintTitleBackground(JTaskPaneGroup group, Graphics g) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
                g.fillRoundRect(0, 0, group.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                g.fillRect(0, ROUND_HEIGHT, group.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
            } else {
                Paint oldPaint = ((Graphics2D)g).getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, group.getWidth() / 2, this.titleBackgroundGradientStart, group.getWidth(), TITLE_HEIGHT, this.titleBackgroundGradientEnd);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setPaint(gradient);
                g.fillRoundRect(0, 0, group.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                g.fillRect(0, ROUND_HEIGHT, group.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
                ((Graphics2D)g).setPaint(oldPaint);
            }
        }

        protected void paintExpandedControls(JTaskPaneGroup group, Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int ovalSize = TITLE_HEIGHT - 2 * ROUND_HEIGHT;
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground.brighter());
                g.drawOval(group.getWidth() - TITLE_HEIGHT, ROUND_HEIGHT - 1, ovalSize, ovalSize);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
                g.fillOval(group.getWidth() - TITLE_HEIGHT, ROUND_HEIGHT - 1, ovalSize, ovalSize);
                g.setColor(this.titleBackgroundGradientEnd.darker());
                g.drawOval(group.getWidth() - TITLE_HEIGHT, ROUND_HEIGHT - 1, ovalSize, ovalSize);
            }
            Color paintColor = WindowsTaskPaneGroupUI.this.mouseOver ? (group.isSpecial() ? this.specialTitleOver : this.titleOver) : (group.isSpecial() ? this.specialTitleForeground : this.titleForeground);
            BasicTaskPaneGroupUI.ChevronIcon chevron = group.isExpanded() ? new BasicTaskPaneGroupUI.ChevronIcon(true) : new BasicTaskPaneGroupUI.ChevronIcon(false);
            int chevronX = group.getWidth() - TITLE_HEIGHT + ovalSize / 2 - chevron.getIconWidth() / 2;
            int chevronY = ROUND_HEIGHT + (ovalSize / 2 - chevron.getIconHeight()) - 1;
            g.setColor(paintColor);
            chevron.paintIcon(group, g, chevronX, chevronY);
            chevron.paintIcon(group, g, chevronX, chevronY + chevron.getIconHeight() + 1);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JTaskPaneGroup group = (JTaskPaneGroup)c;
            this.paintTitleBackground(group, g);
            this.paintExpandedControls(group, g);
            Color paintColor = WindowsTaskPaneGroupUI.this.mouseOver ? (group.isSpecial() ? this.specialTitleOver : this.titleOver) : (group.isSpecial() ? this.specialTitleForeground : this.titleForeground);
            if (group.hasFocus()) {
                g.setColor(paintColor);
                BasicGraphicsUtils.drawDashedRect(g, 3, 3, width - 6, TITLE_HEIGHT - 6);
            }
            this.paintTitle(group, g, paintColor, 3, 0, c.getWidth() - TITLE_HEIGHT - 3, TITLE_HEIGHT);
        }
    }
}

