/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CXmlScanner
extends CScanner {
    private boolean insideTag = false;

    public boolean isInsideTag() {
        return this.insideTag;
    }

    public void setBuffer(String string) {
        this.insideTag = false;
        super.setBuffer(string);
    }

    protected int lowRunLex(CScanner.Lexem lexem) {
        char c;
        this.innerStartLex(lexem);
        if (lexem.tokenType != 0) {
            return lexem.tokenType;
        }
        char c2 = lexem.token.charAt(0);
        char c3 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
        char c4 = this.bufferPos + 1 < this.bufferLen ? this.buffer.charAt(this.bufferPos + 1) : (char)'\u0000';
        char c5 = c = this.bufferPos + 2 < this.bufferLen ? this.buffer.charAt(this.bufferPos + 2) : (char)'\u0000';
        if (c2 == '<' && c3 == '!' && c4 == '-' && c == '-') {
            lexem.token = lexem.token + c3 + c4 + c;
            this.bufferPos += 3;
            while (this.bufferPos + 2 < this.bufferLen) {
                c2 = this.buffer.charAt(this.bufferPos);
                c3 = this.buffer.charAt(this.bufferPos + 1);
                c4 = this.buffer.charAt(this.bufferPos + 2);
                lexem.token = lexem.token + c2;
                ++this.bufferPos;
                if (c2 == '-' && c3 == '-' && c4 == '>') {
                    lexem.token = lexem.token + c3 + c4;
                    this.bufferPos += 2;
                    break;
                }
                if (c2 != '\n') continue;
                ++this.bufferLine;
            }
            lexem.tokenType = 1;
            return 1;
        }
        if (c2 == '<') {
            if (c3 == '?' || c3 == '!' || c3 == '/') {
                lexem.token = lexem.token + c3;
                ++this.bufferPos;
            }
            this.insideTag = true;
            lexem.tokenType = 32;
            return 32;
        }
        if (c2 == '>') {
            this.insideTag = false;
            lexem.tokenType = 32;
            return 32;
        }
        if (c3 == '>' && (c2 == '?' || c2 == '/')) {
            lexem.token = lexem.token + c3;
            ++this.bufferPos;
            this.insideTag = false;
            lexem.tokenType = 32;
            return 32;
        }
        if (this.insideTag && c2 == '=') {
            lexem.tokenType = 16;
            return 16;
        }
        if (this.insideTag && (c2 == '\'' || c2 == '\"')) {
            return this.innerProcString(lexem);
        }
        this.innerProcIdent(lexem);
        if (this.insideTag && lexem.tokenType == 8) {
            lexem.tokenType = 2;
            return 2;
        }
        if (this.insideTag && lexem.tokenType == 0) {
            lexem.tokenType = 64;
        }
        while (!this.insideTag && this.bufferPos < this.bufferLen) {
            c2 = this.buffer.charAt(this.bufferPos);
            if (CScanner.isWhite(c2) || c2 == '\n' || c2 == '\r' || c2 == '<') break;
            lexem.token = lexem.token + c2;
            ++this.bufferPos;
        }
        lexem.tokenType = this.insideTag ? lexem.tokenType : 0;
        return lexem.tokenType;
    }

    public static String wrapValue(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '&': {
                    string2 = string2 + "&amp;";
                    break;
                }
                case '\"': {
                    string2 = string2 + "&quot;";
                    break;
                }
                case '\'': {
                    string2 = string2 + "&apos;";
                    break;
                }
                case '>': {
                    string2 = string2 + "&gt;";
                    break;
                }
                case '<': {
                    string2 = string2 + "&lt;";
                    break;
                }
                default: {
                    string2 = string2 + string.charAt(n);
                }
            }
            ++n;
        }
        return string2;
    }

    public static String wrapString(String string) {
        return "'" + CXmlScanner.wrapValue(string) + "'";
    }

    public static int convertHex2Int(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                n = n << 4 | (byte)string.charAt(n2) - 48;
            }
            if (string.charAt(n2) >= 'A' && string.charAt(n2) <= 'F') {
                n = n << 4 | (byte)string.charAt(n2) - 65 + 10;
            }
            if (string.charAt(n2) >= 'a' && string.charAt(n2) <= 'f') {
                n = n << 4 | (byte)string.charAt(n2) - 97 + 10;
            }
            ++n2;
        }
        return n;
    }

    public static String unwrapValue(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        String string2 = "";
        while (n < n2) {
            char c = string.charAt(n);
            ++n;
            if (c == '&') {
                String string3 = "";
                while (n < n2) {
                    c = string.charAt(n);
                    ++n;
                    if (c == ';') break;
                    string3 = string3 + c;
                }
                string3 = string3.toLowerCase();
                if (string3.equals("amp")) {
                    string2 = string2 + "&";
                    continue;
                }
                if (string3.equals("quot")) {
                    string2 = string2 + "\"";
                    continue;
                }
                if (string3.equals("apos")) {
                    string2 = string2 + "'";
                    continue;
                }
                if (string3.equals("gt")) {
                    string2 = string2 + ">";
                    continue;
                }
                if (string3.equals("lt")) {
                    string2 = string2 + "<";
                    continue;
                }
                if (string3.startsWith("#x")) {
                    string2 = string2 + (char)CXmlScanner.convertHex2Int(string3.substring(2));
                    continue;
                }
                if (!string3.startsWith("#")) continue;
                try {
                    string2 = string2 + (char)new Integer(string3.substring(1)).intValue();
                }
                catch (Exception exception) {}
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String unwrapString(String string) {
        return CXmlScanner.unwrapValue(CScanner.unwrapString(string));
    }

    public static void main(String[] stringArray) {
        System.out.println("*********** Xml Scanner Test *************");
        CXmlScanner cXmlScanner = new CXmlScanner();
        cXmlScanner.setBuffer("<?xml <!-- comment -->param+0.1=\"xxx\">\"www\" +=11 labmda</ a/>");
        cXmlScanner.setShowEol(true);
        cXmlScanner.setShowSpace(true);
        cXmlScanner.setShowComment(true);
        String string = "The test & 'string'";
        System.out.println("Start string: " + string);
        string = CXmlScanner.wrapString(string);
        System.out.println("Wrapped string: " + string);
        string = CXmlScanner.unwrapString("&#169;" + string + "&#xA9;");
        System.out.println("Unwrapped string: " + string);
        System.out.println();
        System.out.println("Initial string: " + cXmlScanner.getBuffer());
        while (cXmlScanner.lex() != 32768) {
            switch (cXmlScanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                    break;
                }
                default: {
                    System.out.print("Type: ??? ");
                }
            }
            System.out.println("Value: '" + cXmlScanner.getToken() + "' Pos: " + cXmlScanner.getPosition() + " Line: " + cXmlScanner.getLineNo());
        }
    }
}

