/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CAnalogClock
extends JComponent {
    private ClockThread clockThread = new ClockThread();
    private boolean showDate = true;
    private Point center;
    private Point leftTop;
    private Point rightBottom;
    private double radius;

    public CAnalogClock() {
        this.clockThread.start();
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public void setShowDate(boolean bl) {
        this.showDate = bl;
        this.repaint();
    }

    private Font findFont(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics;
        int n3 = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), n3);
        while ((fontMetrics = graphics.getFontMetrics(font)).getHeight() <= n2 && fontMetrics.stringWidth(string) <= n) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++n3);
        }
        return font;
    }

    private Point countPoint(double d, double d2) {
        return new Point((int)(-d * Math.sin(-0.10466667264699936 * d2)) + this.center.x, (int)(-d * Math.cos(0.10466667264699936 * d2)) + this.center.y);
    }

    private void drawColoredPoint(Graphics graphics, int n, int n2, int n3, Color color, Color color2, Color color3) {
        graphics.setColor(color3);
        graphics.fillRect(n - n3, n2 - n3, n3 * 2, n3 * 2);
        graphics.setColor(color);
        graphics.drawLine(n - n3, n2 + n3, n - n3, n2 - n3);
        graphics.drawLine(n - n3, n2 - n3, n + n3 - 1, n2 - n3);
        graphics.setColor(color2);
        graphics.drawLine(n + n3, n2 - n3, n + n3, n2 + n3);
        graphics.drawLine(n + n3, n2 + n3, n - n3 + 1, n2 + n3);
    }

    private void drawPoint(Graphics graphics, double d) {
        Point point = this.countPoint(this.radius, d);
        int n = (int)(this.radius * 0.02);
        int n2 = n = n == 0 ? 1 : n;
        if ((int)d % 5 == 0) {
            this.drawColoredPoint(graphics, point.x, point.y, n, new Color(0, 255, 255), Color.black, new Color(0, 130, 132));
        } else {
            this.drawColoredPoint(graphics, point.x, point.y, n, Color.gray, Color.white, Color.lightGray);
        }
    }

    private void drawSecArrow(Graphics graphics, double d) {
        Point point = this.countPoint(this.radius * 0.85, d);
        graphics.setColor(new Color(41, 44, 49));
        graphics.drawLine(this.center.x, this.center.y, point.x, point.y);
    }

    private void drawThickArrow(Graphics graphics, double d, double d2, double d3, double d4, Color color) {
        Point point = this.countPoint(this.radius * d2, d);
        Point point2 = this.countPoint(this.radius * d3, d + 30.0);
        Point point3 = this.countPoint(this.radius * d4, d + 15.0);
        Point point4 = this.countPoint(this.radius * d4, d + 45.0);
        int[] nArray = new int[]{point.x, point3.x, point2.x, point4.x};
        int[] nArray2 = new int[]{point.y, point3.y, point2.y, point4.y};
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, 4);
    }

    private void drawMinArrow(Graphics graphics, double d) {
        Point point = this.center;
        this.center = this.countPoint(3.0, d + 45.0);
        this.drawThickArrow(graphics, d, 0.8, 0.15, 0.05, Color.white);
        this.center = this.countPoint(5.0, d + 15.0);
        this.drawThickArrow(graphics, d, 0.8, 0.15, 0.05, Color.gray);
        this.center = point;
        this.drawThickArrow(graphics, d, 0.8, 0.15, 0.05, new Color(0, 130, 132));
    }

    private void drawHourArrow(Graphics graphics, double d) {
        Point point = this.center;
        this.center = this.countPoint(3.0, d + 45.0);
        this.drawThickArrow(graphics, d, 0.6, 0.15, 0.07, Color.white);
        this.center = this.countPoint(5.0, d + 15.0);
        this.drawThickArrow(graphics, d, 0.6, 0.15, 0.07, Color.gray);
        this.center = point;
        this.drawThickArrow(graphics, d, 0.6, 0.15, 0.07, new Color(0, 130, 132));
    }

    public void paint(Graphics graphics) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        double d = this.showDate ? 0.6 : 0.8;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.leftTop = new Point((int)(dimension.getWidth() * 0.1), (int)(dimension.getHeight() * 0.1));
        this.rightBottom = new Point((int)(dimension.getWidth() * 0.9), (int)(dimension.getHeight() * (d + 0.1)));
        this.center = new Point((this.rightBottom.x + this.leftTop.x) / 2, (this.rightBottom.y + this.leftTop.y) / 2);
        this.radius = this.center.x < this.center.y ? (double)((this.rightBottom.x - this.leftTop.x) / 2) : (double)((this.rightBottom.y - this.leftTop.y) / 2);
        int n = 0;
        while (n < 60) {
            this.drawPoint(graphics, n);
            ++n;
        }
        this.drawHourArrow(graphics, gregorianCalendar.get(10) % 12 * 5 + gregorianCalendar.get(12) / 12);
        this.drawMinArrow(graphics, gregorianCalendar.get(12));
        this.drawSecArrow(graphics, gregorianCalendar.get(13));
        if (this.showDate) {
            simpleDateFormat.applyPattern("EEEE, dd MMMM yyyy");
            String string = simpleDateFormat.format(gregorianCalendar.getTime());
            Font font = this.findFont(graphics, string, (int)(dimension.getWidth() * 0.8), (int)(dimension.getHeight() * 0.2));
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = (dimension.width - fontMetrics.stringWidth(string)) / 2;
            int n3 = (int)((dimension.getHeight() * 0.2 - (double)fontMetrics.getHeight()) / 2.0 + dimension.getHeight() * 0.7) + fontMetrics.getAscent();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            graphics.drawString(string, n2, n3);
        }
    }

    public static void main(String[] stringArray) {
        CAnalogClock cAnalogClock = new CAnalogClock();
        JFrame jFrame = new JFrame("Analog Clock");
        jFrame.setContentPane(cAnalogClock);
        jFrame.setDefaultCloseOperation(3);
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setLocation(300, 300);
        jFrame.show();
    }

    private class ClockThread
    extends Thread {
        private ClockThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        CAnalogClock.this.repaint();
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

