/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class CVerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private int hgap;
    private int vgap;
    private boolean hfill;
    private boolean vfill;

    public CVerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public CVerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, 5, 5, bl, bl2);
    }

    public CVerticalFlowLayout(int n) {
        this(n, 5, 5, true, false);
    }

    public CVerticalFlowLayout(int n, boolean bl, boolean bl2) {
        this(n, 5, 5, bl, bl2);
    }

    public CVerticalFlowLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setAlignment(n);
        this.hgap = n2;
        this.vgap = n3;
        this.hfill = bl;
        this.vfill = bl2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        super.setHgap(n);
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        super.setVgap(n);
        this.vgap = n;
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < container.getComponentCount()) {
            serializable = container.getComponent(n);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n > 0) {
                    dimension.height += this.vgap;
                }
                dimension.height += dimension2.height;
            }
            ++n;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < container.getComponentCount()) {
            serializable = container.getComponent(n);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).getMinimumSize();
                if (dimension.width < dimension2.width) {
                    dimension.width = dimension2.width;
                }
                if (n > 0) {
                    dimension.height += this.vgap;
                }
                dimension.height += dimension2.height;
            }
            ++n;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    public void setVerticalFill(boolean bl) {
        this.vfill = bl;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean bl) {
        this.hfill = bl;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    private void arrange(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getAlignment();
        Insets insets = container.getInsets();
        if (n7 == 1) {
            n2 += n4 / 2;
        }
        if (n7 == 2) {
            n2 += n4;
        }
        int n8 = n5;
        while (n8 < n6) {
            Component component = container.getComponent(n8);
            Dimension dimension = component.getSize();
            if (component.isVisible()) {
                int n9 = n + (n3 - dimension.width) / 2;
                component.setLocation(n9, n2);
                n2 += this.vgap + dimension.height;
            }
            ++n8;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int n2 = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int n3 = container.getComponentCount();
        int n4 = insets.left + this.hgap;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            Component component = container.getComponent(n8);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (this.vfill && n8 == n3 - 1) {
                    dimension.height = Math.max(n - n5, component.getPreferredSize().height);
                }
                if (this.hfill) {
                    component.setSize(n2, dimension.height);
                    dimension.width = n2;
                } else {
                    component.setSize(dimension.width, dimension.height);
                }
                if (n5 + dimension.height > n) {
                    this.arrange(container, n4, insets.top + this.vgap, n6, n - n5, n7, n8);
                    n5 = dimension.height;
                    n4 += this.hgap + n6;
                    n6 = dimension.width;
                    n7 = n8;
                } else {
                    if (n5 > 0) {
                        n5 += this.vgap;
                    }
                    n5 += dimension.height;
                    n6 = Math.max(n6, dimension.width);
                }
            }
            ++n8;
        }
        this.arrange(container, n4, insets.top + this.vgap, n6, n - n5, n7, n3);
    }
}

