/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.comedia.text.CAbstractHighlighter;
import org.comedia.text.CJavaHighlighter;
import org.comedia.text.CSyntaxDocument;
import org.comedia.text.CSyntaxEditorKit;
import org.comedia.ui.CEditor;

public class CSyntaxEditor
extends CEditor
implements DocumentListener {
    private boolean indent = true;
    private int tabSpace = 2;
    private CHighlightThread thread = null;
    private CAbstractHighlighter syntaxHighlighter = null;

    public CSyntaxEditor() {
        this.setEditorKit(new CSyntaxEditorKit());
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public CSyntaxEditor(CSyntaxDocument cSyntaxDocument) {
        this();
        this.setDocument(cSyntaxDocument);
    }

    public void setDocument(Document document) {
        if (!(document instanceof CSyntaxDocument)) {
            return;
        }
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        super.setDocument(document);
        if (this.getDocument() != null) {
            this.getDocument().addDocumentListener(this);
            this.performHighlight();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!(this.syntaxHighlighter == null || this.thread != null && this.thread.ready)) {
            try {
                int n = this.getCaretPosition();
                String string = this.getDocument().getText(0, this.getDocument().getLength());
                int n2 = string.lastIndexOf(10, n - 2);
                n2 = n2 < 0 ? 0 : n2;
                int n3 = string.indexOf(10, n - 1);
                n3 = n3 < 0 ? string.length() - 1 : n3;
                int n4 = this.syntaxHighlighter.locateUnclosedComment(string, n2);
                int n5 = n2 = n4 >= 0 ? n4 : n2;
                if (this.thread == null) {
                    this.thread = new CHighlightThread();
                    this.thread.start();
                }
                this.thread.start = n2;
                this.thread.end = n3;
                this.thread.ready = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void performHighlight() {
        this.performHighlight(0, this.getDocument().getLength() - 1);
    }

    public synchronized void performHighlight(int n, int n2) {
        if (this.getDocument() instanceof CSyntaxDocument && this.syntaxHighlighter != null) {
            ((CSyntaxDocument)this.getDocument()).performHighlight(this.syntaxHighlighter, n, n2);
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public int getTabSpace() {
        return this.tabSpace;
    }

    public void setTabSpace(int n) {
        this.tabSpace = n;
    }

    public CAbstractHighlighter getSyntaxHighlighter() {
        return this.syntaxHighlighter;
    }

    public void setSyntaxHighlighter(CAbstractHighlighter cAbstractHighlighter) {
        this.syntaxHighlighter = cAbstractHighlighter;
    }

    protected EditorKit createDefaultEditorKit() {
        return new CSyntaxEditorKit();
    }

    private static String extractLineFromEnd(String string) {
        int n = string.lastIndexOf(10);
        if (n < 0) {
            return string;
        }
        if (n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    private static int defineIndent(String string) {
        int n = 0;
        while (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return n;
    }

    private static String removeLastLine(String string) {
        int n = string.lastIndexOf(10);
        return n > 0 ? string.substring(0, n) : "";
    }

    private String createString(String string, int n) {
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + string;
            ++n2;
        }
        return string2;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltDown() || keyEvent.isMetaDown() || keyEvent.isAltGraphDown() || keyEvent.getID() != 401) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (!(keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 9 || keyEvent.isShiftDown() || keyEvent.isControlDown() || !this.indent)) {
            int n = this.getCaretPosition();
            String string = "";
            try {
                string = this.getDocument().getText(0, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string2 = CSyntaxEditor.extractLineFromEnd(string);
            int n2 = CSyntaxEditor.defineIndent(string2);
            string = CSyntaxEditor.removeLastLine(string.substring(0, string.length() - string2.length()));
            if (keyEvent.getKeyCode() == 10) {
                try {
                    while (string.length() > 0 && n2 > 0 && n2 == string2.length()) {
                        string2 = CSyntaxEditor.extractLineFromEnd(string);
                        n2 = CSyntaxEditor.defineIndent(string2);
                        string = CSyntaxEditor.removeLastLine(string.substring(0, string.length() - string2.length()));
                    }
                    this.getDocument().insertString(this.getCaretPosition(), "\n" + this.createString(" ", n2), null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (keyEvent.getKeyCode() == 8) {
                if (n2 == string2.length()) {
                    String string3 = CSyntaxEditor.extractLineFromEnd(string);
                    int n3 = CSyntaxEditor.defineIndent(string3);
                    string = CSyntaxEditor.removeLastLine(string.substring(0, string.length() - string3.length()));
                    while (string.length() > 0 && n3 > 0 && n3 >= n2) {
                        string3 = CSyntaxEditor.extractLineFromEnd(string);
                        n3 = CSyntaxEditor.defineIndent(string3);
                        string = CSyntaxEditor.removeLastLine(string.substring(0, string.length() - string3.length()));
                    }
                    if (n2 > n3) {
                        try {
                            this.getDocument().remove(this.getCaretPosition() - n2 + n3 + 1, n2 - n3 - 1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (n2 <= n3) {
                        try {
                            this.getDocument().remove(this.getCaretPosition() - n2 + 1, n2 - 1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            } else if (keyEvent.getKeyCode() == 9) {
                try {
                    this.getDocument().insertString(this.getCaretPosition(), this.createString(" ", this.tabSpace), null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia Syntax Editor Test");
        CSyntaxEditor cSyntaxEditor = new CSyntaxEditor();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(cSyntaxEditor);
        try {
            cSyntaxEditor.setSyntaxHighlighter(new CJavaHighlighter());
            cSyntaxEditor.read(new FileReader("d:\\test.java"), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(305, 320);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    private class CHighlightThread
    extends Thread {
        public int start = -1;
        public int end = -1;
        public boolean ready = false;

        private CHighlightThread() {
        }

        public void run() {
            try {
                while (true) {
                    if (this.ready) {
                        CSyntaxEditor.this.performHighlight(this.start, this.end);
                        this.ready = false;
                    } else {
                        Thread.sleep(150L);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

