/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericButtonListener;
import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class GenericButtonUI
extends BasicButtonUI {
    private GenericButtonListener mButtonListener = new GenericButtonListener(null);
    private Color mSavedSelectedBackgroundColor;

    public static ComponentUI createUI(JComponent c) {
        return new GenericButtonUI();
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return this.mButtonListener;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        if (b.getModel().isSelected()) {
            if (b.getBackground() != GenericLookAndFeel.getSelectColor()) {
                if (this.mSavedSelectedBackgroundColor == null) {
                    this.mSavedSelectedBackgroundColor = b.getBackground();
                }
                if (!b.getModel().isPressed()) {
                    b.setBackground(GenericLookAndFeel.getFillDown());
                }
            }
        } else if (this.mSavedSelectedBackgroundColor != null && !b.isFocusOwner()) {
            b.setBackground(this.mSavedSelectedBackgroundColor);
            this.mSavedSelectedBackgroundColor = null;
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(GenericLookAndFeel.getDarkGray());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }
}

