/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;

class ButtonMouseAdapter
implements MouseListener,
MouseMotionListener {
    private boolean click = false;
    private ActionListener actionListener;
    private Timer timer;

    public ButtonMouseAdapter(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void mousePressed(MouseEvent e) {
        this.click = true;
        if (this.timer != null) {
            return;
        }
        this.createTimer();
        try {
            this.fire(e);
        }
        catch (IllegalStateException is) {
            this.createTimer();
        }
    }

    private void createTimer() {
        this.timer = new Timer("ButtonTimer", true);
    }

    private void fire(final MouseEvent e) {
        this.timer.schedule(new TimerTask(){

            public void run() {
                while (ButtonMouseAdapter.this.click) {
                    try {
                        if (ButtonMouseAdapter.this.click) {
                            ButtonMouseAdapter.this.actionListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        ButtonMouseAdapter.this.click = false;
                    }
                }
            }
        }, 500L);
    }

    private void cancel() {
        this.click = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public void mouseReleased(MouseEvent e) {
        this.cancel();
    }

    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    public void mouseExited(MouseEvent e) {
        this.cancel();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

