/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.ui.propertyinspector.display.editor.BaseEditor;
import ch.abacus.lib.ui.propertyinspector.display.editor.EditorValueAccessor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.SwingUtilities;

public class EditorDelegate
implements ActionListener,
ItemListener,
Serializable,
FocusListener,
KeyListener,
EditorValueAccessor {
    protected Object value;
    private BaseEditor baseEditor;
    protected boolean modified;

    public EditorDelegate(BaseEditor baseEditor) {
        this.baseEditor = baseEditor;
    }

    public void clearModified() {
        this.modified = false;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void modify() {
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean startCellEditing(EventObject anEvent) {
        this.modified = false;
        return true;
    }

    public boolean stopCellEditing() {
        this.baseEditor.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.modified = false;
        this.baseEditor.fireEditingCanceled();
    }

    public void selectAll() {
    }

    public void selectNone() {
    }

    public void actionPerformed(ActionEvent e) {
        this.modify();
        this.baseEditor.stopCellEditing();
    }

    public void itemStateChanged(ItemEvent e) {
        this.modify();
        this.baseEditor.stopCellEditing();
    }

    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorDelegate.this.selectAll();
            }
        });
    }

    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() == null || e.getOppositeComponent() == this.baseEditor.getEditorButton()) {
            return;
        }
        this.baseEditor.stopCellEditing();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorDelegate.this.selectNone();
            }
        });
    }

    public void keyTyped(KeyEvent e) {
        this.modify();
    }

    public void keyPressed(KeyEvent e) {
        this.modify();
    }

    public void keyReleased(KeyEvent e) {
        this.modify();
    }
}

