/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;
import ch.abacus.lib.ui.propertyinspector.display.renderer.BaseCellRenderer;
import ch.abacus.lib.ui.propertyinspector.display.renderer.CategoryCellRenderer;
import ch.abacus.lib.ui.propertyinspector.display.renderer.PropertyNameCellRenderer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertyInspectorCellRenderer
extends DefaultTableCellRenderer {
    private CategoryCellRenderer categoryRenderer;
    private BaseCellRenderer nameRenderer;

    public PropertyInspectorCellRenderer(JTable table) {
        this.categoryRenderer = new CategoryCellRenderer(table);
        this.nameRenderer = new PropertyNameCellRenderer(table);
    }

    public CategoryCellRenderer getCategoryRenderer() {
        return this.categoryRenderer;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DisplayGroup) {
            return this.categoryRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof DisplayProperty) {
            DisplayProperty property = (DisplayProperty)value;
            switch (column) {
                case 0: {
                    JComponent component = (JComponent)this.nameRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    component.setEnabled(property.isEnabled() && !property.getProperty().isReadOnly());
                    if (((PropertyModel)table.getModel()).getSelection().size() > 1 && property.getProperty().isSingleSelection()) {
                        component.setEnabled(false);
                    }
                    component.setToolTipText(property.getHint());
                    return component;
                }
                case 1: {
                    if (property.getProperty().getRenderer() == null) break;
                    JComponent component = (JComponent)property.getProperty().getRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    component.setEnabled(property.isEnabled() && !property.getProperty().isReadOnly() && !property.getProperty().isValueEditorReadOnly());
                    if (((PropertyModel)table.getModel()).getSelection().size() > 1 && property.getProperty().isSingleSelection()) {
                        component.setEnabled(false);
                    }
                    component.setToolTipText(property.getHint());
                    return component;
                }
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

