/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerClassByteFileLoader;
import ch.abacus.lib.ui.renderer.common.HammerClassDescriptor;
import ch.abacus.lib.ui.renderer.common.HammerInputStream;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.misc.CompoundEnumeration;

public class HammerClassCustomLoader
extends ClassLoader {
    private HashMap hashmap;
    String theClassPath;
    ArrayList classPathArrayList = new ArrayList(0);
    ArrayList shortClassPathArrayList = new ArrayList(0);
    HashMap properties = new HashMap();
    HammerClassByteFileLoader classByteFileLoader;
    AbaMetaDataUser theUser = null;
    private String m_sClassPath = null;
    private String m_sShortClassPath = null;
    private boolean bIDEADev = false;
    static final int QUICK_HASH_SIZE = 257;
    static final int QUICK_MAX_ENTRIES = 16001;
    private static int quickLookupCount = 0;
    static HashMap quickJarLookup = new HashMap(257);

    public HammerClassCustomLoader(AbaMetaDataUser theUser, String sClassPath, String sShortClassPath) {
        this.theClassPath = sClassPath;
        this.theUser = theUser;
        this.m_sClassPath = sClassPath;
        this.m_sShortClassPath = sShortClassPath;
        this.classPathArrayList = this.makeClassPathArrayList(sClassPath);
        this.shortClassPathArrayList = sClassPath.equals(sShortClassPath) ? this.classPathArrayList : this.makeClassPathArrayList(sShortClassPath);
        this.hashmap = new HashMap();
        this.classByteFileLoader = new HammerClassByteFileLoader(this.classPathArrayList, this.shortClassPathArrayList, this.properties, theUser);
        this.properties.put("fileSeparator", System.getProperty("file.separator"));
        this.properties.put("pathSeparator", System.getProperty("path.separator"));
        this.properties.put("archiveSufffix", ".jar");
        this.properties.put("compiledSuffix", ".class");
        this.properties.put("packageSeparator", ".");
        this.bIDEADev = this.isDevOn(System.getProperty("ch.abacus.renderer.devmode"));
    }

    ArrayList makeClassPathArrayList(String sClassPath) {
        StringTokenizer tokenizer = new StringTokenizer(sClassPath, File.pathSeparator);
        ArrayList<String> v = new ArrayList<String>(0);
        while (tokenizer.hasMoreElements()) {
            String token = (String)tokenizer.nextElement();
            if (v.contains(token)) continue;
            v.add(token);
        }
        return v;
    }

    public HammerJarAccess getResourceAccess(String name) {
        HammerJarAccess fastJarAccess = (HammerJarAccess)this.quickGet(name);
        if (fastJarAccess != null) {
            this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream@SPEEDFETCH:", "Got " + name);
            return fastJarAccess;
        }
        this.logClassLoaderMessage("In getResourceAccess of hammer class loader - loading:", name);
        ArrayList theJarAccessArray = this.classByteFileLoader.getJarAccess(name, false, false);
        if (theJarAccessArray == null) {
            this.logClassLoaderMessage("In getResourceAccess of hammer class loader - Cannot find:", name);
            return null;
        }
        HammerJarAccess theJarAccess = (HammerJarAccess)theJarAccessArray.get(0);
        if (theJarAccess == null) {
            this.logClassLoaderMessage("In getResourceAccess of hammer class loader - Cannot find:", name);
            return null;
        }
        this.logClassLoaderMessage("In getResourceAccess of IDE class loader - Found:", name);
        this.quickPut(name, theJarAccess);
        return theJarAccess;
    }

    public InputStream getResourceAsStream(HammerJarAccess theJarAccess) {
        InputStream is = null;
        if (theJarAccess != null) {
            JarEntry entry = theJarAccess.theJarEntry;
            JarFile jarf = theJarAccess.theJarFile;
            try {
                is = jarf.getInputStream(entry);
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Input stream " + is);
        return is;
    }

    public InputStream getResourceAsStream(String name) {
        HammerJarAccess fastJarAccess = (HammerJarAccess)this.quickGet(name);
        if (fastJarAccess != null) {
            this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream@SPEEDFETCH:", "Got " + name);
            InputStream streamReturned = this.getResourceAsStream(fastJarAccess);
            if (streamReturned != null) {
                return streamReturned;
            }
            this.quickRemove(name);
        }
        this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Searching for " + name);
        HammerJarAccess theJarAccess = null;
        if (this.bIDEADev) {
            if (!this.isDevFilterEligible(name)) {
                theJarAccess = this.getResourceAccess(name);
            }
        } else {
            theJarAccess = this.getResourceAccess(name);
        }
        if (theJarAccess != null) {
            this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Found " + name + " now reading from jar file!");
            InputStream streamReturned = this.getResourceAsStream(theJarAccess);
            if (streamReturned != null) {
                this.quickPut(name, theJarAccess);
            }
            return streamReturned;
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public HammerInputStream getResourceInPathAsStream(String name) {
        this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Searching for " + name);
        HammerJarAccess theJarAccess = null;
        if (this.bIDEADev) {
            if (!this.isDevFilterEligible(name)) {
                theJarAccess = this.getResourceAccess(name);
            }
        } else {
            theJarAccess = this.getResourceAccess(name);
        }
        if (theJarAccess != null) {
            this.logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Found " + name + " now reading from jar file!");
            HammerInputStream in = new HammerInputStream("", theJarAccess.theJarFile.getName(), theJarAccess.theJarEntry.getName(), this.getResourceAsStream(theJarAccess));
            return in;
        }
        HammerInputStream in = new HammerInputStream("", "", "", ClassLoader.getSystemResourceAsStream(name));
        return in;
    }

    public HammerInputStream getFileInPathAsStream(String sFileName) {
        HammerInputStream theRetVal = null;
        this.logClassLoaderMessage("HammerClassCustomLoader@getFileInPathAsStream:", "Searching for " + sFileName);
        theRetVal = this.isDevFilterEligible(sFileName) && this.bIDEADev ? this.classByteFileLoader.getFileInPathAsStream(sFileName, true) : this.classByteFileLoader.getFileInPathAsStream(sFileName, false);
        if (theRetVal == null && (theRetVal = this.getResourceInPathAsStream(sFileName)) == null) {
            try {
                FileInputStream in = new FileInputStream(sFileName);
                if (in != null) {
                    theRetVal = new HammerInputStream("", sFileName, in);
                    return theRetVal;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return theRetVal;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Object lookup = this.hashmap.get(name);
        if (lookup == null) {
            throw new ClassNotFoundException("Cannot find class " + name);
        }
        return (Class)lookup;
    }

    protected Class loadLoadedClass(String name) throws ClassNotFoundException {
        Class resultClass = null;
        Object lookup = this.hashmap.get(name);
        this.logClassLoaderMessage("In loadClass of hammer class loader - Attempting to load:", name);
        if (lookup != null) {
            resultClass = (Class)lookup;
            this.logClassLoaderMessage("In loadClass of hammer class loader - Already loaded!:", name);
            return resultClass;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> resultClass = null;
        Object lookup = this.hashmap.get(name);
        this.logClassLoaderMessage("In loadClass of hammer class loader - Attempting to load:", name);
        if (lookup != null) {
            resultClass = (Class<?>)lookup;
            this.logClassLoaderMessage("In loadClass of hammer class loader - Already loaded!:", name);
            return resultClass;
        }
        try {
            try {
                Class<?> clsThroughSystemLoader = Class.forName(name);
                if (clsThroughSystemLoader != null) {
                    return clsThroughSystemLoader;
                }
            }
            catch (ClassNotFoundException e99) {
                // empty catch block
            }
            byte[] classBytes = this.classByteFileLoader.getClassBytes(name);
            if (classBytes == null) {
                throw new ClassNotFoundException("ClassByteLoader.get returned null for class " + name);
            }
            resultClass = this.defineClass(name, classBytes, 0, classBytes.length);
        }
        catch (ClassFormatError e2) {
            System.err.println("Bad format for class " + name + " " + e2);
            throw new ClassNotFoundException("format of class file incorrect for class " + name + ": " + e2.getMessage());
        }
        if (resolve) {
            this.resolveClass(resultClass);
        }
        this.hashmap.put(name, resultClass);
        this.logClassLoaderMessage("In loadClass of hammer class loader - New class loaded!:", name);
        return resultClass;
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    protected Enumeration findResources(String name) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    protected URL findResource(String resource) {
        this.logClassLoaderMessage("In findResource of hammer class loader.  Resource is: ", resource);
        String sJarFileName = this.classByteFileLoader.findJarFileWithResource(resource);
        if (sJarFileName != null) {
            try {
                this.logClassLoaderMessage("In findResource of IDE class loader.  Jar file name is: ", sJarFileName);
                return new URL(this.getJarURL(sJarFileName) + resource);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.logClassLoaderMessage("Cannot find resource in IDE class loader: ", resource);
        return null;
    }

    private String getJarURL(String sJarName) {
        StringBuffer buf = new StringBuffer("jar:file:");
        buf.append(sJarName.replace('\\', '/'));
        buf.append("!/");
        String fJarURLPath = buf.toString();
        this.logClassLoaderMessage("In getJarURL.  Jar path is: ", fJarURLPath);
        return fJarURLPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class[] getClassesFromPath(String sSearchPath) {
        String fileSeparator = (String)this.properties.get("fileSeparator");
        String packageSeparator = (String)this.properties.get("packageSeparator");
        ArrayList theClassByteArray = this.classByteFileLoader.getClassesFromPath(sSearchPath);
        if (theClassByteArray == null) {
            return null;
        }
        if (theClassByteArray.size() == 0) {
            return null;
        }
        Class[] retVal = new Class[theClassByteArray.size()];
        int i = 0;
        while (i < theClassByteArray.size()) {
            int iBegin;
            HammerClassDescriptor descriptor = (HammerClassDescriptor)theClassByteArray.get(i);
            String sClassName = descriptor.sClassName;
            if (sClassName.endsWith(".class")) {
                sClassName = sClassName.substring(0, sClassName.length() - 6);
            }
            int iMatch = sClassName.indexOf(fileSeparator);
            while (iMatch != -1) {
                block17: {
                    if (iMatch == 0) {
                        if (sClassName.length() > 1) {
                            sClassName = sClassName.substring(iMatch + 1);
                            break block17;
                        } else {
                            sClassName = "";
                            break;
                        }
                    }
                    sClassName = sClassName.substring(0, iMatch) + packageSeparator + sClassName.substring(iMatch + 1);
                }
                iMatch = sClassName.indexOf(fileSeparator);
            }
            iMatch = sSearchPath.indexOf("/");
            while (iMatch != -1) {
                block18: {
                    if (iMatch == 0) {
                        if (sSearchPath.length() > 1) {
                            sSearchPath = sSearchPath.substring(iMatch + 1);
                            break block18;
                        } else {
                            sSearchPath = "";
                            break;
                        }
                    }
                    sSearchPath = sSearchPath.substring(0, iMatch) + packageSeparator + sSearchPath.substring(iMatch + 1);
                }
                iMatch = sSearchPath.indexOf("/");
            }
            if ((iBegin = sClassName.indexOf(sSearchPath)) != -1) {
                sClassName = sClassName.substring(iBegin);
            }
            Class<?> clsCreated = null;
            try {
                clsCreated = this.defineClass(sClassName, descriptor.classBytes, 0, descriptor.classBytes.length);
            }
            catch (LinkageError e1) {
                // empty catch block
            }
            if (clsCreated != null) {
                retVal[i] = clsCreated;
                this.resolveClass(retVal[i]);
            }
            ++i;
        }
        return retVal;
    }

    public void setPaths(String sClassPath, String sShortPath) {
        this.theClassPath = sClassPath;
        if (!this.m_sClassPath.equals(sClassPath)) {
            this.classPathArrayList = this.makeClassPathArrayList(sClassPath);
        }
        if (!this.m_sShortClassPath.equals(sShortPath)) {
            this.shortClassPathArrayList = this.makeClassPathArrayList(sShortPath);
        }
        this.classByteFileLoader.setPaths(this.classPathArrayList, this.shortClassPathArrayList);
    }

    public Class defineClass(String sClassName, byte[] bytes) {
        Class<?> clsCreated;
        Object lookup = this.hashmap.get(sClassName);
        if (lookup != null) {
            return (Class)lookup;
        }
        try {
            clsCreated = this.defineClass(sClassName, bytes, 0, bytes.length);
            this.hashmap.put(sClassName, clsCreated);
        }
        catch (LinkageError e1) {
            return null;
        }
        return clsCreated;
    }

    Object quickGet(String name) {
        Object quick = quickJarLookup.get(name);
        return quick;
    }

    void quickPut(Object key, Object name) {
        if (quickLookupCount < 16001) {
            quickJarLookup.put(key, name);
            ++quickLookupCount;
        }
    }

    void quickRemove(Object key) {
        quickJarLookup.remove(key);
    }

    private void logClassLoaderMessage(String sDesription, String sMessage) {
        if (this.theUser != null && this.theUser.getLogFile() != null && this.theUser.getLogFile().bClassLoaderLogging) {
            this.theUser.getLogFile().doClassLoaderLogEntry(sDesription, sMessage);
        }
    }

    protected boolean isDevOn(String fileName) {
        boolean rtVal = false;
        if (fileName == null) {
            return rtVal;
        }
        if (fileName.equalsIgnoreCase("on")) {
            rtVal = true;
        }
        return rtVal;
    }

    protected boolean isDevFilterEligible(String fileName) {
        boolean rtVal = false;
        if (fileName.endsWith(".proz")) {
            rtVal = true;
        } else if (fileName.endsWith(".nls")) {
            rtVal = true;
        }
        return rtVal;
    }
}

