/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaProject;
import electric.xml.Element;

public class HammerLanguagePresentation {
    public static final int DEFAULT = 0;
    public static final int DEUTSCH = 0;
    public static final int FRANCAIS = 1;
    public static final int ENGLISH = 3;
    public static final int ITALIAN = 2;
    public static final int LAST_LANGUAGE = 3;
    public int theLanguage = 0;
    public HammerLanguagePresentation theNextLanguage = null;
    public HammerLanguagePresentation thePreviousLanguage = null;
    public MetaProject theDesignProject = null;

    public HammerLanguagePresentation() {
    }

    public HammerLanguagePresentation(int theLanguage, MetaProject theDesignProject) {
        this.theLanguage = theLanguage;
        this.theDesignProject = theDesignProject;
    }

    public static String getLanguageName(int iLanguage) {
        switch (iLanguage) {
            case 0: {
                return "Deutsch (Default)";
            }
            case 1: {
                return "Francais";
            }
            case 2: {
                return "Italiano";
            }
            case 3: {
                return "English";
            }
        }
        return "";
    }

    public boolean save(Element theParent) {
        Element xmlLanguage = new Element("Language");
        theParent.addElement(xmlLanguage);
        xmlLanguage.setAttribute("Name", new Integer(this.theLanguage).toString());
        return true;
    }

    public boolean load(Element theElement) {
        String theAttribute = theElement.getAttribute("Name");
        try {
            Integer theValue = new Integer(theAttribute);
            this.theLanguage = theValue;
        }
        catch (NumberFormatException e1) {
            this.theLanguage = 0;
        }
        return true;
    }

    public boolean saveValue(Element theParent, String theData) {
        Element xmlLanguage = new Element("Language");
        theParent.addElement(xmlLanguage);
        xmlLanguage.setAttribute("Name", new Integer(this.theLanguage).toString());
        Element xmlData = new Element("Data");
        xmlData.setText(theData);
        xmlLanguage.addElement(xmlData);
        return true;
    }

    public String[] loadValue(Element theElement, String[] theValues) {
        Element xmlData = theElement.getElement("Data");
        if (xmlData != null) {
            theValues[this.theLanguage] = xmlData.getTextString();
        }
        return theValues;
    }
}

