/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerConfigurationManager;
import ch.abacus.lib.ui.renderer.common.HammerLogConsoleStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class HammerLogFileAccess {
    PrintStream theLogWriter = null;
    public HammerLogConsoleStream theLogConsoleStream = null;
    AbaMetaDataUser theUser = null;
    public boolean bExtendedLogging = false;
    public boolean bConsoleLogging = false;
    public boolean bFileLogging = false;
    public boolean bDedicatedConsoles = false;
    public boolean bDebuggingLogging = false;
    public boolean bClassLoaderLogging = false;
    public boolean bCacheManagerLogging = false;
    public boolean bNLSLogging = false;
    public boolean bConfigured = false;
    private boolean bCustomizerLogging = false;
    private static final String LOG_FILENAME = "designcockpit.log";
    private static final int MAX_LOG_FILESIZE = 2000000;

    public HammerLogConsoleStream getLogConsoleStream() {
        return this.theLogConsoleStream;
    }

    public void setLogConsoleStream(HammerLogConsoleStream theLogConsoleStream) {
        this.theLogConsoleStream = theLogConsoleStream;
    }

    public boolean isExtendedLogging() {
        return this.bExtendedLogging;
    }

    public boolean isConsoleLogging() {
        return this.bConsoleLogging;
    }

    public boolean isFileLogging() {
        return this.bFileLogging;
    }

    public boolean isDedicatedConsoles() {
        return this.bDedicatedConsoles;
    }

    public void setDedicatedConsoles(boolean bDedicatedConsoles) {
        this.bDedicatedConsoles = bDedicatedConsoles;
    }

    public boolean isDebuggingLogging() {
        return this.bDebuggingLogging;
    }

    public boolean isClassLoaderLogging() {
        return this.bClassLoaderLogging;
    }

    public boolean isCacheManagerLogging() {
        return this.bCacheManagerLogging;
    }

    public PrintStream getLogWriter() {
        return this.theLogWriter;
    }

    public void setLogWriter(PrintStream theLogWriter) {
        this.theLogWriter = theLogWriter;
    }

    public void setUser(AbaMetaDataUser theUser) {
        this.theUser = theUser;
    }

    public HammerLogFileAccess(AbaMetaDataUser theUser) {
        this.theUser = theUser;
        HammerConfigurationManager configurationManager = this.theUser.getConfigurationManager();
        this.bFileLogging = configurationManager != null ? configurationManager.checkConfigurationSetting("FileLogging") : false;
        if (this.bFileLogging) {
            File logFile = this.getLogFile();
            if (logFile.exists() && logFile.length() > 2000000L) {
                this.clearLogContents();
            }
            this.theLogWriter = this.createLogWriter(logFile, true);
        }
        this.theLogConsoleStream = new HammerLogConsoleStream(theUser);
        this.bConfigured = true;
    }

    private File getLogFile() {
        String sLogDirectory = this.theUser.getConfigurationManager().getLogDirectory();
        if (sLogDirectory == null) {
            sLogDirectory = "";
        } else if (!sLogDirectory.endsWith(System.getProperty("file.separator"))) {
            sLogDirectory = sLogDirectory + System.getProperty("file.separator");
        }
        File logFile = new File(sLogDirectory + LOG_FILENAME);
        return logFile;
    }

    public boolean isCustomizerLogging() {
        return this.bCustomizerLogging;
    }

    public void setNLSLogging(boolean newLogging) {
        this.bNLSLogging = newLogging;
    }

    public boolean isNLSLogging() {
        return this.bNLSLogging;
    }

    public void setExtendedLogging(boolean newLogging) {
        this.bExtendedLogging = newLogging;
    }

    public void setDedicatedConsole(boolean dedicatedConsoles) {
        this.bDedicatedConsoles = dedicatedConsoles;
    }

    public void setConsoleLogging(boolean consoleLogging) {
        this.bConsoleLogging = consoleLogging;
    }

    public void setClassLoaderLogging(boolean classLoaderLogging) {
        this.bClassLoaderLogging = classLoaderLogging;
    }

    public void setDebuggingLogging(boolean debuggingLogging) {
        this.bDebuggingLogging = debuggingLogging;
    }

    public void setFileLogging(boolean fileLogging) {
        this.bFileLogging = fileLogging;
    }

    public void doDebuggingLogEntry(String sDescription, String sMessage) {
        if (this.bDebuggingLogging) {
            this.doLogEntry("Debugging: ", sDescription + sMessage);
        }
    }

    public void setCacheManagerLogging(boolean cacheManagerLogging) {
        this.bCacheManagerLogging = cacheManagerLogging;
    }

    public void setCustomizerLogging(boolean customizerLogging) {
        this.bCustomizerLogging = customizerLogging;
    }

    public void doClassLoaderLogEntry(String sDescription, String sMessage) {
        if (this.bClassLoaderLogging) {
            this.doLogEntry("ClassLoader: ", sDescription + sMessage);
        }
    }

    public void doCacheManagerLogEntry(String sDescription, String sMessage) {
        if (this.bCacheManagerLogging) {
            this.doLogEntry("CacheManager: ", sDescription + sMessage);
        }
    }

    public void doLogEntry(String pDescription, String pMessage) {
        if (this.bExtendedLogging && this.theLogWriter != null) {
            String sMessage = "Description: " + pDescription + ", " + pMessage + "\r\n";
            if (this.bFileLogging) {
                this.theLogWriter.print(sMessage);
                this.theLogWriter.flush();
            }
            if (this.bConsoleLogging) {
                boolean bOldLogging = this.bClassLoaderLogging;
                this.bClassLoaderLogging = false;
                this.theLogConsoleStream.print(sMessage);
                this.theLogConsoleStream.flush();
                this.bClassLoaderLogging = bOldLogging;
            }
        }
    }

    public void clearLogContents() {
        if (this.theLogWriter != null) {
            this.theLogWriter.flush();
            this.theLogWriter.close();
        }
        File logFile = this.getLogFile();
        this.theLogWriter = this.createLogWriter(logFile, false);
    }

    private PrintStream createLogWriter(File logFile, boolean bKeepContents) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(logFile, bKeepContents));
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot create designcockpit.log");
        }
        return printStream;
    }
}

