/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import java.lang.reflect.Constructor;

public class MetaPropertyValueEx {
    int iType = 0;
    Class objectClass = null;
    String[] sValues = new String[4];
    static final int TYPE_UNDEFINED = 0;
    static final int TYPE_STRING = 1;
    static final int TYPE_INT = 2;
    static final int TYPE_DOUBLE = 3;
    static final int TYPE_FLOAT = 4;
    static final int TYPE_CHAR = 5;
    static final int TYPE_BYTE = 6;
    static final int TYPE_LONG = 7;
    static final int TYPE_BOOLEAN = 8;
    static final int TYPE_OBJECT = 9;
    MetaProject theDesignProject = null;
    boolean bAllowMultipleLanguages = false;
    boolean bResolveAsObject = false;
    boolean bMnemonic = false;

    public MetaPropertyValueEx(String sValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.theDesignProject = theProject;
        this.iType = 1;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setLocalString(sValue);
    }

    public MetaPropertyValueEx(int iValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 2;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(iValue);
    }

    public MetaPropertyValueEx(double dValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 3;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(dValue);
    }

    public MetaPropertyValueEx(float fValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 4;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(fValue);
    }

    public MetaPropertyValueEx(char cValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 5;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(cValue);
    }

    public MetaPropertyValueEx(byte byteValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 6;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(byteValue);
    }

    public MetaPropertyValueEx(long lValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 7;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(lValue);
    }

    public MetaPropertyValueEx(boolean bValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.iType = 8;
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setValue(bValue);
    }

    public MetaPropertyValueEx(String sType, String sValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.setType(sType);
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setLocalString(sValue);
    }

    public MetaPropertyValueEx(int iType, String sValue, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.setType(iType);
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        this.setLocalString(sValue);
    }

    public MetaPropertyValueEx(int iType, String[] sValues, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.setType(iType);
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        for (int i = 0; i < this.sValues.length && i < sValues.length; ++i) {
            if (sValues[i] == null) {
                String sNewValue = sValues[0];
                if (sNewValue != null) {
                    this.sValues[i] = new String(sValues[0]);
                    continue;
                }
                this.sValues[i] = "";
                continue;
            }
            this.sValues[i] = new String(sValues[i]);
        }
    }

    public MetaPropertyValueEx(String sType, String[] sValues, MetaProject theProject, boolean bAllowMultipleLanguages) {
        this.setType(MetaPropertyValueEx.translateType(sType));
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        String sDefaultValue = sValues[0];
        for (int i = 0; i < this.sValues.length && i < sValues.length; ++i) {
            String sNewValue = sValues[i];
            if (sNewValue == null) {
                sNewValue = sDefaultValue;
            }
            if (sNewValue == null) {
                sNewValue = "";
            }
            this.sValues[i] = new String(sNewValue);
        }
    }

    public MetaPropertyValueEx(String sClassName, Object someValue, boolean bCast, MetaProject theProject, boolean bAllowMultipleLanguages) {
        int iTranslatedType = MetaPropertyValueEx.translateType(sClassName);
        this.theDesignProject = theProject;
        this.bAllowMultipleLanguages = bAllowMultipleLanguages;
        if (someValue instanceof String) {
            this.setValue(someValue);
            if (iTranslatedType == 1) {
                this.setType(1);
            } else {
                this.setType(sClassName);
                iTranslatedType = this.iType;
            }
        } else if (someValue instanceof Integer) {
            this.setValue((Integer)someValue);
            this.setType(2);
        } else if (someValue instanceof Double) {
            this.setValue(someValue.toString());
            this.setType(3);
        } else if (someValue instanceof Float) {
            this.setValue(someValue.toString());
            this.setType(4);
        } else if (someValue instanceof Character) {
            this.setValue(someValue.toString());
            this.setType(5);
        } else if (someValue instanceof Byte) {
            this.setValue(someValue.toString());
            this.setType(6);
        } else if (someValue instanceof Long) {
            this.setValue(someValue.toString());
            this.setType(7);
        } else if (someValue instanceof Boolean) {
            this.setValue(someValue.toString());
            this.setType(8);
        }
        if (iTranslatedType == 0) {
            iTranslatedType = 1;
            this.setValue(someValue.toString());
        }
        if (bCast && this.getType() != iTranslatedType) {
            this.setType(iTranslatedType);
        }
    }

    public static Class getTypeAsClass(int type) {
        switch (type) {
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.TYPE;
            }
            case 3: {
                return Double.TYPE;
            }
            case 4: {
                return Float.TYPE;
            }
            case 5: {
                return Character.TYPE;
            }
            case 6: {
                return Byte.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public MetaPropertyValueEx Clone() {
        MetaPropertyValueEx retVal = new MetaPropertyValueEx(this.iType, this.sValues, this.theDesignProject, this.bAllowMultipleLanguages);
        retVal.bResolveAsObject = this.bResolveAsObject;
        retVal.bMnemonic = this.bMnemonic;
        return retVal;
    }

    public String getLocalString() {
        String sReturnValue = "";
        sReturnValue = !this.bAllowMultipleLanguages ? this.sValues[0] : (this.theDesignProject != null && this.sValues[this.theDesignProject.theCurrentLanguage.theLanguage] != null ? this.sValues[this.theDesignProject.theCurrentLanguage.theLanguage] : this.sValues[0]);
        if (this.theDesignProject != null && this.theDesignProject.iMode == 2) {
            return this.theDesignProject.getNLS().getTranslatedValue(sReturnValue, this.theDesignProject.theCurrentLanguage.theLanguage, this.bMnemonic);
        }
        return sReturnValue;
    }

    public void setLocalString(String sValue) {
        if (this.iType == 6 || this.iType == 2 || this.iType == 7) {
            if (sValue.startsWith("$")) {
                sValue = "0x" + sValue.substring(1);
            }
            if (sValue.startsWith("0x")) {
                switch (this.iType) {
                    case 6: {
                        sValue = Byte.valueOf(sValue.substring(2), 16).toString();
                        break;
                    }
                    case 2: {
                        sValue = Integer.valueOf(sValue.substring(2), 16).toString();
                        break;
                    }
                    case 7: {
                        sValue = Long.valueOf(sValue.substring(2), 16).toString();
                    }
                }
            }
        }
        if (!this.bAllowMultipleLanguages) {
            this.sValues[0] = sValue;
            return;
        }
        this.sValues[this.theDesignProject.theCurrentLanguage.theLanguage] = sValue;
        if (this.theDesignProject.theCurrentLanguage.theLanguage == 0) {
            for (int i = 1; i <= 3; ++i) {
                if (this.sValues[i] != null) continue;
                this.sValues[i] = sValue;
            }
        }
    }

    public boolean getResolveAsObject() {
        return this.bResolveAsObject;
    }

    public void setResolveAsObject(boolean bResolveAsObject) {
        this.bResolveAsObject = bResolveAsObject;
    }

    public void setValue(Object oValue) {
        if (oValue instanceof String) {
            String sValue = (String)oValue;
            this.setLocalString(sValue);
        } else {
            this.setLocalString(oValue.toString());
        }
    }

    public void setValue(int iValue) {
        this.setLocalString(new Integer(iValue).toString());
    }

    public void setValue(double dValue) {
        this.setLocalString(new Double(dValue).toString());
    }

    public void setValue(float fValue) {
        this.setLocalString(new Float(fValue).toString());
    }

    public void setValue(char cValue) {
        char iValue = cValue;
        this.setLocalString(new Integer(iValue).toString());
    }

    public void setValue(byte byteValue) {
        byte iValue = byteValue;
        this.setLocalString(new Integer(iValue).toString());
    }

    public void setValue(boolean bValue) {
        this.setLocalString(new Boolean(bValue).toString());
    }

    public void setValue(long lValue) {
        this.setLocalString(new Long(lValue).toString());
    }

    public String getLanguageDependentValue(int iLang) {
        if (this.sValues[iLang] == null) {
            return this.sValues[0];
        }
        return this.sValues[iLang];
    }

    public int getLanguageCount() {
        int i = 0;
        for (i = 0; i < 3; ++i) {
            if (this.sValues[i] == null) continue;
            ++i;
        }
        if (i > 1) {
            return 3;
        }
        return 1;
    }

    public void setType(int type) {
        this.iType = type;
    }

    public void setType(String sTypeName) {
        this.iType = MetaPropertyValueEx.translateType(sTypeName);
        if (this.iType == 0) {
            try {
                this.objectClass = Class.forName(sTypeName);
                this.iType = 9;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            this.objectClass = null;
        }
    }

    public int getType() {
        return this.iType;
    }

    public static Object getObjectForValue(int type, String value) {
        switch (type) {
            case 1: {
                return new String(value);
            }
            case 2: {
                return new Integer(value);
            }
            case 3: {
                return new Double(value);
            }
            case 4: {
                return new Float(value);
            }
            case 7: {
                return new Long(value);
            }
            case 8: {
                return new Boolean(value);
            }
            case 5: {
                return new Character(value.charAt(0));
            }
        }
        return new String("Undefined");
    }

    public static String translateType(int type) {
        switch (type) {
            case 1: {
                return new String("java.lang.String");
            }
            case 2: {
                return new String("int");
            }
            case 3: {
                return new String("double");
            }
            case 4: {
                return new String("float");
            }
            case 5: {
                return new String("char");
            }
            case 6: {
                return new String("byte");
            }
            case 7: {
                return new String("long");
            }
            case 8: {
                return new String("boolean");
            }
        }
        return new String("Undefined");
    }

    public void setMnemonic() {
        this.bMnemonic = true;
    }

    public static int translateType(String sTypeName) {
        int type = sTypeName.equals("java.lang.String") || sTypeName.equals("String") ? 1 : (sTypeName.equals("int") ? 2 : (sTypeName.equals("double") ? 3 : (sTypeName.equals("float") ? 4 : (sTypeName.equals("char") ? 5 : (sTypeName.equals("byte") ? 7 : (sTypeName.equals("boolean") ? 8 : 0))))));
        return type;
    }

    public int toInt() {
        int iRetVal = 0;
        try {
            iRetVal = new Integer(this.getLocalString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return iRetVal;
    }

    public float toFloat() {
        float fRetVal = 0.0f;
        try {
            fRetVal = new Float(this.getLocalString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return fRetVal;
    }

    public double toDouble() {
        double dRetVal = 0.0;
        try {
            dRetVal = new Double(this.getLocalString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dRetVal;
    }

    public String toChar() {
        return this.getLocalString();
    }

    public byte toByte() {
        int iRetVal = 0;
        try {
            iRetVal = new Integer(this.getLocalString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return (byte)iRetVal;
    }

    public long toLong() {
        long lRetVal = 0L;
        try {
            lRetVal = new Long(this.getLocalString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lRetVal;
    }

    public boolean toBoolean() {
        boolean bRetVal = false;
        try {
            bRetVal = new Boolean(this.getLocalString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bRetVal;
    }

    public String getStringValue() {
        return this.getLocalString();
    }

    public Object getNativeValue() {
        switch (this.iType) {
            case 1: {
                return this.getLocalString();
            }
            case 2: {
                int iValue = this.toInt();
                return new Integer(iValue);
            }
            case 3: {
                double dValue = this.toDouble();
                return new Double(dValue);
            }
            case 4: {
                float fValue = this.toFloat();
                return new Float(fValue);
            }
            case 5: {
                return new String(this.toChar());
            }
            case 6: {
                byte bValue = this.toByte();
                return new Byte(bValue);
            }
            case 7: {
                long lValue = this.toLong();
                return new Long(lValue);
            }
            case 8: {
                boolean bValue = this.toBoolean();
                return new Boolean(bValue);
            }
            case 9: {
                if (!this.getResolveAsObject()) {
                    try {
                        Class[] theClasses = new Class[1];
                        Object[] theObjects = new Object[1];
                        String sValue = this.getLocalString();
                        if (sValue != null) {
                            theClasses[0] = sValue.getClass();
                            theObjects[0] = sValue;
                            Constructor constr = this.objectClass.getConstructor(theClasses);
                            return constr.newInstance(theObjects);
                        }
                        return null;
                    }
                    catch (Exception e1) {
                        return null;
                    }
                }
                try {
                    String sValue = this.getLocalString();
                    MetaObject obj = this.theDesignProject.findObject(sValue);
                    Object javaObject = obj.getSwingObject();
                    return javaObject;
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        return null;
    }

    public boolean isMultipleLanguages() {
        return this.bAllowMultipleLanguages;
    }
}

