/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaDataMember;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import electric.xml.CData;
import electric.xml.Child;
import electric.xml.Document;
import electric.xml.Element;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class MetadataDocumentGenerator {
    MetaClass theFirstClass;
    MetaClass theLastClass;
    String theMetaDocumentName = "";

    public MetadataDocumentGenerator(String sName, MetaClass objFirstClass, MetaClass objLastClass) {
        this.theFirstClass = objFirstClass;
        this.theLastClass = objLastClass;
        this.theMetaDocumentName = sName;
    }

    public boolean doPropertyListLevel(MetaPropertyDescriptor propListMetadata, Element theParent) {
        while (propListMetadata != null) {
            String sHelper;
            String sDefaultConstantType;
            String sDefaultPropertyValue;
            String sSetMethod;
            Element theProp = new Element("Property");
            Element thePropName = new Element("Name");
            Element theDefaultConstantType = new Element("DefaultConstantType");
            Element theGet = new Element("Get");
            Element theSet = new Element("Set");
            Element theGenerate = new Element("Generate");
            Element theDataAwareness = new Element("DataAwareness");
            Element theArray = new Element("Array");
            Element theLanguages = new Element("Languages");
            Element theHelper = new Element("Helper");
            Element theVisible = new Element("Visible");
            Element theDoc = new Element("Doc");
            Element thePropType = new Element("Type");
            Element thePropClass = new Element("Class");
            Element theReadOnly = new Element("ReadOnly");
            Element theObjRef = new Element("ObjectReference");
            theParent.addChild((Child)theProp);
            String sPropertyName = propListMetadata.getName();
            thePropName.addText(sPropertyName);
            theProp.addChild((Child)thePropName);
            String sGetMethod = propListMetadata.getGetMethod();
            if (sGetMethod != null && sGetMethod.length() > 0) {
                theProp.addChild((Child)theGet);
                theGet.addText(sGetMethod);
            }
            if ((sSetMethod = propListMetadata.getSetMethod()) != null && sSetMethod.length() > 0) {
                theProp.addChild((Child)theSet);
                theSet.addText(sSetMethod);
            }
            if ((sDefaultPropertyValue = propListMetadata.getDefaultValue()) != null && sDefaultPropertyValue.trim().length() != 0) {
                Element theDefaultValue = new Element("DefaultValue");
                theProp.addChild((Child)theDefaultValue);
                theDefaultValue.addText(sDefaultPropertyValue);
            }
            if ((sDefaultConstantType = propListMetadata.getIncludeTypeConstants()) != null && sDefaultConstantType.length() > 0) {
                theDefaultConstantType.addText(sDefaultConstantType);
                theProp.addChild((Child)theDefaultConstantType);
            }
            int iPropertyValueChoices = propListMetadata.getValueChoiceCount();
            for (int iValueChoice = 0; iValueChoice < iPropertyValueChoices; ++iValueChoice) {
                Element theValueChoice = new Element("ValueChoice");
                theValueChoice.addText(propListMetadata.getValueChoiceAsString(iValueChoice));
                theProp.addElement(theValueChoice);
            }
            if (propListMetadata.bGenerate) {
                theProp.addChild((Child)theGenerate);
            }
            if (propListMetadata.getDataAwareness()) {
                theProp.addChild((Child)theDataAwareness);
            }
            if (propListMetadata.bVisible) {
                theProp.addChild((Child)theVisible);
            }
            if (propListMetadata.isReadOnly()) {
                theProp.addChild((Child)theReadOnly);
            }
            if (propListMetadata.bAllowMultipleValues) {
                theProp.addChild((Child)theArray);
            }
            if (propListMetadata.bAllowMultipleLanguages) {
                theProp.addChild((Child)theLanguages);
            }
            if (propListMetadata.bObjectReference) {
                theProp.addChild((Child)theObjRef);
            }
            if ((sHelper = propListMetadata.getHelperClass()) != null && sHelper.length() > 0) {
                theHelper.addText(sHelper);
                theProp.addChild((Child)theHelper);
            }
            if (propListMetadata.getDoc() != null && propListMetadata.getDoc().length() != 0) {
                CData theDocText = new CData(propListMetadata.getDoc());
                theProp.addChild((Child)theDocText);
            }
            if (propListMetadata.getClassName().length() != 0) {
                thePropType.addText("Class");
                thePropClass.addText(propListMetadata.getClassName());
                theProp.addElement(thePropClass);
            } else if (propListMetadata.getTypeName().length() != 0) {
                thePropType.addText(propListMetadata.getTypeName());
            } else {
                thePropType.addText("String");
            }
            theProp.addElement(thePropType);
            if (propListMetadata.theFirstSubproperty != null) {
                this.doPropertyListLevel(propListMetadata.theFirstSubproperty, theProp);
            }
            propListMetadata = propListMetadata.getNextProperty();
        }
        return true;
    }

    public boolean addClass(Element theClassList, MetaClass theClass, MetadataDispenser theMetadataDispenser) {
        MetaClassDetail clsmd = theClass.theMetadata;
        if (clsmd != null) {
            Element thisClass = new Element(clsmd.sClassName);
            theClassList.addElement(thisClass);
            if (clsmd.sClassComment != null) {
                Element theClassCommentsElement = new Element("Comments");
                theClassCommentsElement.setText(clsmd.sClassComment);
                thisClass.addElement(theClassCommentsElement);
            }
            Element theFullClassName = new Element("FullClassName");
            theFullClassName.addText(clsmd.sFullClassName);
            thisClass.addElement(theFullClassName);
            if (clsmd.getSuperClassName() != null) {
                Element theSuper = new Element("Superclass");
                Element theClassName = new Element("Name");
                theSuper.addChild((Child)theClassName);
                theClassName.addText(clsmd.getSuperClassName());
                if (clsmd.getFullPathOfSuperClass() != null) {
                    Element theFullPath = new Element("FullPath");
                    theSuper.addChild((Child)theFullPath);
                    theFullPath.addText(clsmd.getFullPathOfSuperClass());
                }
                thisClass.addElement(theSuper);
            }
            if (clsmd.bHidden) {
                Element xmlHidden = new Element("Hidden");
                thisClass.addElement(xmlHidden);
            }
            if (clsmd.bSkipDecl) {
                Element theSkipDeclarations = new Element("SkipDeclarations");
                thisClass.addElement(theSkipDeclarations);
            }
            if (clsmd.theFactoryName != null) {
                Element xmlFactoryName = new Element("ClassFactory");
                xmlFactoryName.setText(clsmd.theFactoryName);
                thisClass.addElement(xmlFactoryName);
            }
            if (!clsmd.bDefaultListeners) {
                Element theSkipDefaultListeners = new Element("SkipDefaultListeners");
                thisClass.addElement(theSkipDefaultListeners);
            }
            if (clsmd.containerType.getContainerType() != 0) {
                Element theContainerType = new Element("ContainerType");
                thisClass.addElement(theContainerType);
                theContainerType.setText(clsmd.containerType.getContainerTypeAsString());
            }
            if (clsmd.sCustomCodeGenerationMethod.trim().length() != 0) {
                Element theCustom = new Element("Custom");
                thisClass.addElement(theCustom);
                theCustom.setText(clsmd.sCustomCodeGenerationMethod);
            }
            if (clsmd.sDisplayClass != null && clsmd.sDisplayClass.trim().length() != 0) {
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText(clsmd.sDisplayClass);
                thisClass.addElement(theDisplayClass);
            }
            if (clsmd.bDesignBorders) {
                Element xmlDesignBorders = new Element("DesignBorders");
                thisClass.addElement(xmlDesignBorders);
            }
            if (clsmd.getVisibility() != 0) {
                Element theVisibility = new Element("Visibility");
                switch (clsmd.getVisibility()) {
                    case 2: {
                        theVisibility.addText("private");
                        break;
                    }
                    case 3: {
                        theVisibility.addText("protected");
                        break;
                    }
                    case 1: {
                        theVisibility.addText("public");
                    }
                }
                thisClass.addChild((Child)theVisibility);
            }
            MetaClassDetail theListener = clsmd.theFirstListener;
            while (theListener != null) {
                int iListener = 0;
                String sListenerName = theListener.sClassName;
                int iDefaultListeners = theMetadataDispenser.theListenerCollection.iDefaultListeners;
                for (iListener = 0; iListener < iDefaultListeners && !sListenerName.equals(theMetadataDispenser.theListenerCollection.getDefaultListenerName(iListener)); ++iListener) {
                }
                if (iListener == iDefaultListeners) {
                    Element theListenerElement = new Element("Listener");
                    theListenerElement.setText(sListenerName);
                    thisClass.addElement(theListenerElement);
                }
                theListener = theListener.theNextClass;
            }
            MetaPropertyDescriptor propListMetadata = clsmd.theFirstProperty;
            this.doPropertyListLevel(propListMetadata, thisClass);
            for (MetaDataMember dataListMetadata = clsmd.theFirstData; dataListMetadata != null; dataListMetadata = dataListMetadata.getNextData()) {
                Element theMemberData = new Element("MemberData");
                Element theMemberName = new Element("Name");
                Element theDoc = new Element("Doc");
                Element theType = new Element("Type");
                Element theValue = new Element("Value");
                thisClass.addChild((Child)theMemberData);
                theMemberData.addChild((Child)theMemberName);
                theMemberData.addChild((Child)theType);
                theMemberData.addChild((Child)theValue);
                theMemberName.addText(dataListMetadata.getDataName());
                theType.addText(dataListMetadata.getTypeName());
                if (dataListMetadata.getDoc() != null && dataListMetadata.getDoc().length() != 0) {
                    CData theDocText = new CData(dataListMetadata.getDoc());
                    theMemberData.addChild((Child)theDoc);
                    theDoc.addChild((Child)theDocText);
                }
                theValue.addText(dataListMetadata.getValue());
            }
            for (MetaMethod methodListMetadata = clsmd.theFirstMethod; methodListMetadata != null; methodListMetadata = methodListMetadata.getNextMethod()) {
                if (methodListMetadata.getCode().trim().length() <= 0) continue;
                Element theMethod = new Element("Method");
                thisClass.addChild((Child)theMethod);
                Element theMethodName = new Element("Name");
                theMethodName.addText(methodListMetadata.getMethodName());
                theMethod.addElement(theMethodName);
                Element theMethodCode = new Element("Code");
                CData theMethodCodeText = new CData(methodListMetadata.getCode());
                theMethodCode.addChild((Child)theMethodCodeText);
                theMethod.addElement(theMethodCode);
                if (methodListMetadata.getDoc() == null || methodListMetadata.getDoc().length() == 0) continue;
                Element theMethodDocumentation = new Element("Documentation");
                CData theMethodDocumentationText = new CData(methodListMetadata.getDoc());
                theMethodDocumentation.addChild((Child)theMethodDocumentationText);
                theMethod.addElement(theMethodDocumentation);
            }
            if (theClass.theFirstClass != null) {
                theClassList = new Element("Classes");
                thisClass.addElement(theClassList);
                theClass = theClass.theFirstClass;
                while (theClass != null) {
                    this.addClass(theClassList, theClass, theMetadataDispenser);
                    theClass = theClass.theNextSibling;
                }
            }
        }
        return true;
    }

    public boolean GenerateFromMetadata(MetadataDispenser theMetadataDispenser) {
        try {
            File fileOutput = new File(this.theMetaDocumentName);
            PrintWriter pwOutput = new PrintWriter(new FileWriter(fileOutput));
            Document theDocument = new Document();
            Element theRootElement = new Element("Metadata");
            theDocument.addChild((Child)theRootElement);
            String sComments = theMetadataDispenser.theMetadataDocument.sDocumentComments;
            if (sComments != null) {
                Element theDocumentCommentsElement = new Element("Comments");
                theDocumentCommentsElement.setText(theMetadataDispenser.theMetadataDocument.sDocumentComments);
                theRootElement.addChild((Child)theDocumentCommentsElement);
            }
            Element theVersionInfo = new Element("Version");
            Element theVersionNumber = new Element("VersionNumber");
            Element theRevisionNumber = new Element("RevisionNumber");
            Element theSubrevisionNumber = new Element("SubrevisionNumber");
            Element theBuildNumber = new Element("BuildNumber");
            theVersionNumber.setText(new Integer(theMetadataDispenser.theMetaDataAdministrator.iVersionNumber).toString());
            theRevisionNumber.setText(new Integer(theMetadataDispenser.theMetaDataAdministrator.iRevisionNumber).toString());
            theSubrevisionNumber.setText(new Integer(theMetadataDispenser.theMetaDataAdministrator.iSubrevisionNumber).toString());
            theBuildNumber.setText(new Integer(theMetadataDispenser.theMetaDataAdministrator.iBuildNumber).toString());
            theVersionInfo.addElement(theVersionNumber);
            theVersionInfo.addElement(theRevisionNumber);
            theVersionInfo.addElement(theSubrevisionNumber);
            theVersionInfo.addElement(theBuildNumber);
            theRootElement.addElement(theVersionInfo);
            Element theDesignBorderDefinition = new Element("DesignBorderDefinition");
            theDesignBorderDefinition.setText(theMetadataDispenser.sDesignBorderDefinition);
            theRootElement.addElement(theDesignBorderDefinition);
            this.addConstantCollections(theMetadataDispenser, theRootElement);
            this.addContantGroups(theMetadataDispenser, theRootElement);
            if (this.theFirstClass != null) {
                Element theClassList = new Element("Classes");
                theRootElement.addElement(theClassList);
                MetaClass theClass = this.theFirstClass;
                while (theClass != null) {
                    this.addClass(theClassList, theClass, theMetadataDispenser);
                    theClass = theClass.theNextSibling;
                }
            }
            theDocument.write((Writer)pwOutput);
            pwOutput.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void addContantGroups(MetadataDispenser theMetadataDispenser, Element theRootElement) {
        Element xmlConstants = new Element("Constants");
        MetaConstantGroup group = theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            String sGroup = group.sClassName;
            Element xmlGroup = new Element(sGroup);
            xmlConstants.addElement(xmlGroup);
            ArrayList constants = group.getConstantList();
            for (int iGroup = 0; iGroup < constants.size(); ++iGroup) {
                String sConstantName = (String)group.getConstantList().get(iGroup);
                String sConstantValue = group.get((String)group.getConstantList().get(iGroup));
                Element xmlConstant = new Element(sConstantName);
                xmlConstant.setText(sConstantValue);
                xmlGroup.addElement(xmlConstant);
            }
            group = group.theNextSibling;
        }
        theRootElement.addElement(xmlConstants);
    }

    private void addConstantCollections(MetadataDispenser theMetadataDispenser, Element theRootElement) {
        Element xmlConstantCollections = new Element("ConstantCollections");
        MetaConstantGroupCollection collection = theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            String sCollection = collection.sClassName;
            Element xmlCollection = new Element(sCollection);
            xmlConstantCollections.addElement(xmlCollection);
            for (int i = 0; i < collection.getGroupCount(); ++i) {
                Element xmlGroup = new Element(collection.getGroup((int)i).sClassName);
                xmlCollection.addElement(xmlGroup);
            }
            collection = collection.theNextSibling;
        }
        theRootElement.addElement(xmlConstantCollections);
    }
}

