/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.FileCopy;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetadataProvider;
import ch.abacus.lib.ui.renderer.common.UIFactoryBlueprint;
import ch.abacus.lib.ui.renderer.common.UIFactoryBroadcaster;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeGenerator;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeJumper;
import ch.abacus.lib.ui.renderer.common.UIFactoryComponentFactory;
import ch.abacus.lib.ui.renderer.common.UIFactoryException;
import ch.abacus.lib.ui.renderer.common.UIFactoryInvokeHelper;
import ch.abacus.lib.ui.renderer.programmableCompiler.ProgrammableCompiler;
import electric.xml.ParseException;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class UIFactoryAssemblyLine {
    protected String sObjectDescriptionDocumentName;
    protected String sMetaDataDocumentName;
    protected String sPackageName;
    protected UIFactoryBroadcaster BroadcasterHead;
    protected boolean bDebugCall = false;
    protected MetadataProvider factoryMetadata;
    protected ProgrammableCompiler dc;
    protected UIFactoryInvokeHelper invHelper;
    protected UIFactoryComponentFactory componentFactory = null;
    protected String sConstructorParamList = null;
    protected String sPreConstructionCode = null;
    public String sOutputDirectoryName = "";
    public UIFactoryCodeJumper theCodeJumper = null;
    public MetaProject theDesignProject;

    public UIFactoryAssemblyLine(MetaProject theProject, String sWorkingDirectory) throws ParseException {
        this.sOutputDirectoryName = sWorkingDirectory;
        this.theDesignProject = theProject;
        this.dc = new ProgrammableCompiler();
    }

    public boolean ProcessObjects(UIFactoryBroadcaster theParent, MetaObject theObject) throws Throwable {
        UIFactoryBroadcaster oThisObjectAccessor;
        String sObjectIdentifier = theObject.getName();
        String sPostConstructionCode = theObject.getPostConstructionCode();
        String sPreConstructionCode = theObject.getPreConstructionCode();
        String sConstructorParameters = theObject.getConstructorParameters();
        UIFactoryBlueprint objMetaObject = new UIFactoryBlueprint(theObject);
        if (objMetaObject == null) {
            throw new UIFactoryException("Cannot create object " + sObjectIdentifier);
        }
        String sParentName = null;
        if (this.BroadcasterHead == null) {
            oThisObjectAccessor = this.BroadcasterHead = new UIFactoryBroadcaster(objMetaObject, sObjectIdentifier);
        } else {
            oThisObjectAccessor = new UIFactoryBroadcaster(objMetaObject, sObjectIdentifier);
            theParent.addChildObject(oThisObjectAccessor);
            sParentName = theParent.sObjectIdentifier;
            objMetaObject.setParentMeta(theParent.oTheObject);
        }
        if (sPostConstructionCode != null) {
            objMetaObject.setCustomCode(sPostConstructionCode);
        }
        if (sConstructorParameters != null) {
            objMetaObject.setConstructorParameterList(sConstructorParameters);
        }
        if (sPreConstructionCode != null) {
            objMetaObject.setPreConstructionCode(sPreConstructionCode);
        }
        MetaProperty theProperty = theObject.theFirstProperty;
        while (theProperty != null) {
            int iCount = theProperty.getValueCount();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                String oValue = theProperty.getLiteralValue(iIndex);
                if (oValue == null) continue;
                objMetaObject.setPropertyValue(theProperty.theName, iIndex, oValue);
            }
            theProperty = theProperty.theNextProperty;
        }
        if (sParentName != null) {
            objMetaObject.setContainerName(sParentName);
        }
        if (theObject.theParentObject != null) {
            objMetaObject.setDeclareAsMember(Boolean.TRUE);
        }
        MetaObject theChild = theObject.theFirstChild;
        while (theChild != null) {
            this.ProcessObjects(oThisObjectAccessor, theChild);
            theChild = theChild.theNextObject;
        }
        return true;
    }

    public boolean CreateUI() throws Throwable {
        MetaObject theRootObject = this.theDesignProject.getFirstObject();
        String sTransientDirectory = this.theDesignProject.theProgramData.sTransientDirectory;
        String sProjectName = this.theDesignProject.theProgramData.sProjectName;
        String sMainClass = this.theDesignProject.getFirstObject().theClass.getMetadata().sClassName;
        boolean bAbalet = this.theDesignProject.theProgramData.bAbalet;
        boolean bApplication = this.theDesignProject.theProgramData.bApplication;
        String sPackage = this.theDesignProject.theProgramData.sPackageName;
        String sPlatformLookAndFeel = this.theDesignProject.theProgramData.sPlatformLookAndFeel;
        MetadataProvider factoryMetadata = new MetadataProvider(this.theDesignProject);
        this.componentFactory = new UIFactoryComponentFactory(null, factoryMetadata);
        UIFactoryCodeGenerator codeOutput = new UIFactoryCodeGenerator(factoryMetadata, this.theDesignProject, theRootObject);
        this.ProcessObjects(this.BroadcasterHead, theRootObject);
        codeOutput.generatePreamble(this.sPackageName, sMainClass);
        this.BroadcasterHead.generateCode(codeOutput);
        codeOutput.generateEpilogue(this.BroadcasterHead.sObjectIdentifier, sPlatformLookAndFeel);
        String sSourceCode = codeOutput.getFormattedSource();
        File outstuff = new File("TheStuff");
        PrintWriter pw = new PrintWriter(new FileWriter(outstuff));
        pw.print(sSourceCode);
        pw.close();
        String[] defns = new String[]{sSourceCode};
        this.theCodeJumper = new UIFactoryCodeJumper(sSourceCode);
        String sClassPath = System.getProperty("java.class.path");
        int iOtherClassPaths = this.theDesignProject.theProgramData.getAdditionalClassPathCount();
        String sPathSeparator = System.getProperty("path.separator");
        for (int iClassPath = 0; iClassPath < iOtherClassPaths; ++iClassPath) {
            sClassPath = sClassPath + sPathSeparator + this.theDesignProject.theProgramData.getAdditionalClassPath(iClassPath);
        }
        this.dc.setProperty("javaClassPath", sClassPath);
        if (sTransientDirectory != null) {
            this.dc.setProperty("tempDirNameRoot", sTransientDirectory);
        }
        File[] files = this.dc.compileClassesToFiles(defns);
        int iFilesToWrite = files.length;
        String sTempDir = this.dc.getProperty("tempDirNameRoot");
        for (int i = 0; i < iFilesToWrite; ++i) {
            int iMatch = files[i].getPath().indexOf(sTempDir);
            if (iMatch <= 0) continue;
            String sSeparator = files[i].getPath().substring(iMatch - 1, iMatch);
            String sFileSubName = files[i].getPath().substring(iMatch);
            iMatch = sFileSubName.indexOf(sSeparator);
            sFileSubName = sFileSubName.substring(iMatch);
            String sOldClassFileName = files[i].getPath();
            if (this.sOutputDirectoryName == null || this.sOutputDirectoryName.trim().length() == 0) {
                this.sOutputDirectoryName = "." + sSeparator;
            }
            String sNewClassFileName = this.sOutputDirectoryName + sFileSubName;
            int iSuffix = sNewClassFileName.lastIndexOf(".class");
            String sNewJavaFileName = sNewClassFileName.substring(0, iSuffix) + ".java";
            iSuffix = sOldClassFileName.lastIndexOf(".class");
            String sOldJavaFileName = sOldClassFileName.substring(0, iSuffix) + ".java";
            iSuffix = sNewClassFileName.lastIndexOf(sSeparator);
            String sOutputDirectoryFullPath = sNewClassFileName.substring(0, iSuffix);
            new File(sOutputDirectoryFullPath).mkdirs();
            FileCopy.copyFile(sOldClassFileName, sNewClassFileName);
            FileCopy.copyFile(sOldJavaFileName, sNewJavaFileName);
            File oldFile = new File(sOldClassFileName);
            oldFile.delete();
            oldFile = new File(sOldJavaFileName);
            oldFile.delete();
        }
        this.dc.cleanup();
        return true;
    }
}

