/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.UIFactoryClassJumpPoint;
import ch.abacus.lib.ui.renderer.common.UIFactoryListenerJumpPoint;
import ch.abacus.lib.ui.renderer.common.UIFactoryMemberDataJumpPoint;
import ch.abacus.lib.ui.renderer.common.UIFactoryMethodJumpPoint;
import ch.abacus.lib.ui.renderer.common.UIFactoryPropertyJumpPoint;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class UIFactoryCodeJumper {
    UIFactoryClassJumpPoint theFirstClassJumpPoint;
    UIFactoryClassJumpPoint theLastClassJumpPoint;
    public static final int JUMPPOINT_NONE = 0;
    public static final int JUMPPOINT_METHOD = 1;
    public static final int JUMPPOINT_MEMBERDATA = 2;
    public static final int JUMPPOINT_PROPERTY = 3;
    public static final int JUMPCLASS_NONE = 0;
    public static final int JUMPCLASS_CLASS = 1;
    public static final int JUMPCLASS_LISTENER = 2;

    public UIFactoryCodeJumper(String sSourceCode) {
        StringReader theBufferAccess = new StringReader(sSourceCode);
        LineNumberReader theLineCounter = new LineNumberReader(theBufferAccess);
        try {
            String sTheLine = theLineCounter.readLine();
            UIFactoryClassJumpPoint currentClassJump = null;
            while (sTheLine != null) {
                int iMatchEndIdentifier;
                int iMatchIdentifier;
                int iMatch = sTheLine.indexOf("/***__@");
                if (iMatch != -1 && (iMatchIdentifier = sTheLine.indexOf("[", iMatch)) != -1 && (iMatchEndIdentifier = sTheLine.indexOf("]", iMatchIdentifier)) != -1) {
                    String sIdentifier = sTheLine.substring(iMatchIdentifier + 1, iMatchEndIdentifier);
                    int iMatchEndTag = sTheLine.indexOf(":", iMatch);
                    if (iMatchEndTag != -1) {
                        String sTag = "";
                        boolean bEnd = false;
                        if (sTheLine.charAt(iMatch + 7) == '@') {
                            sTag = sTheLine.substring(iMatch + 8, iMatchEndTag);
                            bEnd = true;
                        } else {
                            sTag = sTheLine.substring(iMatch + 7, iMatchEndTag);
                        }
                        if (sTag.equalsIgnoreCase("class")) {
                            if (bEnd) {
                                currentClassJump.iEndLineNumber = theLineCounter.getLineNumber();
                                currentClassJump = currentClassJump.theParent;
                            } else {
                                UIFactoryClassJumpPoint theNewClass = new UIFactoryClassJumpPoint();
                                theNewClass.iBeginLineNumber = theLineCounter.getLineNumber();
                                theNewClass.sClassName = sIdentifier;
                                theNewClass.theParent = currentClassJump;
                                if (this.theFirstClassJumpPoint == null) {
                                    this.theFirstClassJumpPoint = theNewClass;
                                } else {
                                    this.theLastClassJumpPoint.theNextClassJumpPoint = theNewClass;
                                }
                                this.theLastClassJumpPoint = theNewClass;
                                if (currentClassJump != null) {
                                    if (currentClassJump.theFirstClassChild == null) {
                                        currentClassJump.theFirstClassChild = theNewClass;
                                    } else {
                                        currentClassJump.theLastClassChild.theNextClassJumpPoint = theNewClass;
                                    }
                                    currentClassJump.theLastClassChild = theNewClass;
                                }
                                currentClassJump = theNewClass;
                            }
                        }
                        if (sTag.equalsIgnoreCase("listener")) {
                            if (bEnd) {
                                currentClassJump.theLastListenerJumpPoint.iEndLineNumber = theLineCounter.getLineNumber();
                            } else {
                                UIFactoryListenerJumpPoint theNewListener = new UIFactoryListenerJumpPoint();
                                theNewListener.iBeginLineNumber = theLineCounter.getLineNumber();
                                theNewListener.sListenerName = sIdentifier;
                                if (currentClassJump.theFirstListenerJumpPoint == null) {
                                    currentClassJump.theFirstListenerJumpPoint = theNewListener;
                                } else {
                                    currentClassJump.theLastListenerJumpPoint.theNextListenerJumpPoint = theNewListener;
                                }
                                currentClassJump.theLastListenerJumpPoint = theNewListener;
                            }
                        }
                        if (sTag.equalsIgnoreCase("member data")) {
                            if (bEnd) {
                                currentClassJump.theLastMemberDataJumpPoint.iEndLineNumber = theLineCounter.getLineNumber();
                            } else {
                                UIFactoryMemberDataJumpPoint theNewMemberData = new UIFactoryMemberDataJumpPoint();
                                theNewMemberData.iBeginLineNumber = theLineCounter.getLineNumber();
                                theNewMemberData.sMemberDataName = sIdentifier;
                                if (currentClassJump.theFirstMemberDataJumpPoint == null) {
                                    currentClassJump.theFirstMemberDataJumpPoint = theNewMemberData;
                                } else {
                                    currentClassJump.theLastMemberDataJumpPoint.theNextMemberDataJumpPoint = theNewMemberData;
                                }
                                currentClassJump.theLastMemberDataJumpPoint = theNewMemberData;
                            }
                        }
                        if (sTag.equalsIgnoreCase("property")) {
                            if (bEnd) {
                                currentClassJump.theLastPropertyJumpPoint.iEndLineNumber = theLineCounter.getLineNumber();
                            } else {
                                UIFactoryPropertyJumpPoint theNewProperty = new UIFactoryPropertyJumpPoint();
                                theNewProperty.iBeginLineNumber = theLineCounter.getLineNumber();
                                theNewProperty.sPropertyName = sIdentifier;
                                if (currentClassJump.theFirstPropertyJumpPoint == null) {
                                    currentClassJump.theFirstPropertyJumpPoint = theNewProperty;
                                } else {
                                    currentClassJump.theLastPropertyJumpPoint.theNextPropertyJumpPoint = theNewProperty;
                                }
                                currentClassJump.theLastPropertyJumpPoint = theNewProperty;
                            }
                        }
                        if (sTag.equalsIgnoreCase("method")) {
                            if (bEnd) {
                                currentClassJump.theLastMethodJumpPoint.iEndLineNumber = theLineCounter.getLineNumber();
                            } else {
                                UIFactoryMethodJumpPoint theNewMethod = new UIFactoryMethodJumpPoint();
                                theNewMethod.iBeginLineNumber = theLineCounter.getLineNumber();
                                theNewMethod.sMethodName = sIdentifier;
                                if (currentClassJump.theFirstMethodJumpPoint == null) {
                                    currentClassJump.theFirstMethodJumpPoint = theNewMethod;
                                } else {
                                    currentClassJump.theLastMethodJumpPoint.theNextMethodJumpPoint = theNewMethod;
                                }
                                currentClassJump.theLastMethodJumpPoint = theNewMethod;
                            }
                        }
                    }
                }
                sTheLine = theLineCounter.readLine();
            }
        }
        catch (IOException e0) {
            System.out.println("Source file corrupt!");
        }
    }

    private UIFactoryClassJumpPoint getClassJumpNested(int iLineNumber, UIFactoryClassJumpPoint theJumpPoint) {
        while (theJumpPoint != null) {
            if (iLineNumber > theJumpPoint.iBeginLineNumber && iLineNumber < theJumpPoint.iEndLineNumber) {
                UIFactoryClassJumpPoint theSubClasses = this.getClassJumpNested(iLineNumber, theJumpPoint.theFirstClassChild);
                if (theSubClasses != null) {
                    return theSubClasses;
                }
                return theJumpPoint;
            }
            theJumpPoint = theJumpPoint.theNextClassJumpPoint;
        }
        return theJumpPoint;
    }

    public UIFactoryClassJumpPoint getClassJump(int iLineNumber) {
        UIFactoryClassJumpPoint theJumpPoint = this.theFirstClassJumpPoint;
        return this.getClassJumpNested(iLineNumber, theJumpPoint);
    }

    public String getMethodName(int iLineNumber) {
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null) {
            return theClassJump.getMethodName(iLineNumber);
        }
        return null;
    }

    public String getPropertyName(int iLineNumber) {
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null) {
            return theClassJump.getPropertyName(iLineNumber);
        }
        return null;
    }

    public String getMemberDataName(int iLineNumber) {
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null) {
            return theClassJump.getMemberDataName(iLineNumber);
        }
        return null;
    }

    public String getClassName(int iLineNumber) {
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null) {
            return theClassJump.sClassName;
        }
        return null;
    }

    public String getListenerName(int iLineNumber) {
        UIFactoryListenerJumpPoint theListenerJump;
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null && (theListenerJump = theClassJump.getListenerJump(iLineNumber)) != null) {
            return theListenerJump.sListenerName;
        }
        return null;
    }

    public int getJumpPointType(int iLineNumber) {
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        if (theClassJump != null) {
            String theMethodName = theClassJump.getMethodName(iLineNumber);
            if (theMethodName != null) {
                return 1;
            }
            String theMemberDataName = theClassJump.getMemberDataName(iLineNumber);
            if (theMemberDataName != null) {
                return 2;
            }
            String thePropertyName = theClassJump.getPropertyName(iLineNumber);
            if (thePropertyName != null) {
                return 3;
            }
        }
        return 0;
    }

    public int getJumpPointClass(int iLineNumber) {
        String theMethodName;
        UIFactoryClassJumpPoint theClassJump = this.getClassJump(iLineNumber);
        UIFactoryListenerJumpPoint theListenerJump = theClassJump.getListenerJump(iLineNumber);
        if (theListenerJump != null && (theMethodName = theClassJump.getMethodName(iLineNumber)) != null) {
            return 2;
        }
        if (theClassJump != null) {
            theMethodName = theClassJump.getMethodName(iLineNumber);
            if (theMethodName != null) {
                return 1;
            }
            String theMemberDataName = theClassJump.getMemberDataName(iLineNumber);
            if (theMemberDataName != null) {
                return 1;
            }
            String thePropertyName = theClassJump.getPropertyName(iLineNumber);
            if (thePropertyName != null) {
                return 1;
            }
        }
        return 0;
    }
}

