/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.jdbc;

import ch.abacus.lib.ui.renderer.common.jdbc.JSSUpdatableRowSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.sql.RowSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JSSDataSource
extends JPanel {
    Connection conn = null;
    JSSUpdatableRowSet rowset = null;
    int paramCount = 1;
    public boolean readOnly = false;
    private String JDBCClassName = null;
    private String JDBCURL = null;
    private String JDBCUserName = null;
    private String JDBCPassword = null;
    private String SQLCommand = null;
    private String sqlTable = null;
    private boolean bRetryCommand = false;
    private int columnCount = 0;
    String datePattern = "MM/dd/yyyy";

    public JSSDataSource() {
    }

    public JSSDataSource(String ClassName, String URL2, String UserName, String Password) {
        this.JDBCClassName = ClassName;
        this.JDBCURL = URL2;
        this.JDBCUserName = UserName;
        this.JDBCPassword = Password;
        this.setConnection();
    }

    public void setJDBCClassName(String sValue) {
        this.JDBCClassName = sValue;
        this.setConnection();
    }

    public void setJDBCURL(String sValue) {
        this.JDBCURL = sValue;
        this.setConnection();
    }

    public void setJDBCUserName(String sValue) {
        this.JDBCUserName = sValue;
        this.setConnection();
    }

    public void setJDBCPassword(String sValue) {
        this.JDBCPassword = sValue;
        this.setConnection();
    }

    public void setTableName(String Table) {
        this.sqlTable = Table;
    }

    public void setReadOnly(boolean bFlag) {
        this.rowset.setReadOnly(bFlag);
    }

    public boolean isReadOnly() {
        return this.rowset.isReadOnly();
    }

    public String getCommand() {
        return this.rowset.getCommand();
    }

    public void setSQLCommand(String sValue) {
        this.SQLCommand = sValue;
        if (this.conn == null || this.rowset == null) {
            this.setConnection();
            if (this.rowset == null) {
                this.bRetryCommand = true;
                return;
            }
        }
        try {
            if (this.SQLCommand.length() > 0 && !this.SQLCommand.equalsIgnoreCase("")) {
                this.rowset.setCommand(this.SQLCommand);
                this.bRetryCommand = false;
                this.rowset.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RowSet getRowSet() {
        return this.rowset;
    }

    public synchronized void setConnection() {
        boolean bAllParams = true;
        if (this.JDBCClassName == null || this.JDBCURL == null || this.JDBCUserName == null || this.JDBCPassword == null) {
            bAllParams = false;
        }
        if (this.paramCount < 5 && !bAllParams) {
            ++this.paramCount;
            return;
        }
        this.paramCount = 1;
        if (this.conn != null && this.rowset != null) {
            return;
        }
        System.out.println("In setConnection:" + this.JDBCClassName + ":" + this.JDBCURL + ":" + this.JDBCUserName + ":" + this.JDBCPassword);
        try {
            Class.forName(this.JDBCClassName);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
        try {
            this.conn = this.JDBCPassword == null ? DriverManager.getConnection(this.JDBCURL) : DriverManager.getConnection(this.JDBCURL, this.JDBCUserName, this.JDBCPassword);
        }
        catch (SQLException E) {
            System.err.println(E.getMessage() + ", SQLState: " + E.getSQLState() + ", VendorError:  " + E.getErrorCode() + "\n");
        }
        if (this.conn == null) {
            return;
        }
        try {
            this.rowset = new JSSUpdatableRowSet(this.conn, this.sqlTable, null);
            this.rowset.setUrl(this.JDBCURL);
            this.rowset.setReadOnly(this.readOnly);
            try {
                this.rowset.setType(1005);
            }
            catch (SQLException e) {
                System.err.println("setType(ResultSet.TYPE_SCROLL_SENSITIVE): " + e);
            }
            try {
                if (!this.readOnly) {
                    this.rowset.setConcurrency(1008);
                }
            }
            catch (SQLException e) {
                System.err.println("setConcurrency(ResultSet.CONCUR_UPDATABLE): " + e);
                this.readOnly = true;
                this.rowset.setConcurrency(1007);
            }
            if (this.JDBCUserName != null) {
                this.rowset.setUsername(this.JDBCUserName);
            }
            if (this.JDBCPassword != null) {
                this.rowset.setPassword(this.JDBCPassword);
            }
            if (this.bRetryCommand) {
                this.setSQLCommand(this.SQLCommand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public boolean execute() {
        try {
            this.rowset.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean next() {
        try {
            if (!this.rowset.isLast()) {
                this.rowset.next();
            } else {
                this.rowset.last();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean previous() {
        try {
            if (!this.rowset.isFirst()) {
                this.rowset.previous();
            } else {
                this.rowset.first();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean first() {
        try {
            this.rowset.first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean update() {
        try {
            this.rowset.updateRow();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean insert() {
        try {
            this.rowset.insertRow();
            this.rowset.moveToCurrentRow();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delete() {
        try {
            int answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this record?", "Delete Present Record", 0);
            if (answer != 0) {
                return false;
            }
            this.rowset.deleteRow();
            if (!this.rowset.next()) {
                this.rowset.last();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean last() {
        try {
            this.rowset.last();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean clear() {
        try {
            this.rowset.beforeFirst();
            this.rowset.moveToInsertRow();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getStringValue(String _columnName) {
        String strValue = "";
        try {
            if (this.rowset.isBeforeFirst() || this.rowset.isAfterLast()) {
                return null;
            }
            int type = this.rowset.getMetaData().getColumnType(this.rowset.findColumn(_columnName));
            switch (type) {
                case 91: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);
                    strValue = dateFormat.format(this.rowset.getDate(_columnName));
                    break;
                }
                default: {
                    strValue = this.rowset.getString(_columnName);
                    break;
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return strValue;
    }

    public ArrayList getFieldNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        if (this.rowset != null) {
            try {
                ResultSetMetaData mt = this.rowset.getMetaData();
                this.columnCount = mt.getColumnCount();
                for (int i = 1; i <= this.columnCount; ++i) {
                    fieldList.add(mt.getColumnName(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldList;
    }

    public ArrayList getTableNames() {
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            if (this.conn != null) {
                DatabaseMetaData dbmd = this.conn.getMetaData();
                String[] types = new String[]{"TABLE"};
                ResultSet resultSet = dbmd.getTables(null, null, "%", types);
                while (resultSet.next()) {
                    String tableName = resultSet.getString(3);
                    String tableCatalog = resultSet.getString(1);
                    String tableSchema = resultSet.getString(2);
                    tableList.add(tableName);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tableList;
    }
}

