/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.programmableCompiler;

import ch.abacus.lib.ui.renderer.programmableCompiler.ClassByteFileLoader;
import ch.abacus.lib.ui.renderer.programmableCompiler.CompilationException;
import ch.abacus.lib.ui.renderer.programmableCompiler.CustomClassLoader;
import ch.abacus.lib.ui.renderer.programmableCompiler.Exec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.janino.Compiler;
import net.janino.Java;
import net.janino.Parser;
import net.janino.Scanner;
import net.janino.util.StringPattern;

public class ProgrammableCompiler {
    private static int count = 0;
    private Hashtable properties = null;
    private ClassByteFileLoader classByteFileLoader = null;
    private Object[] compilerConstructorParams = null;
    private Constructor compilerConstructor = null;
    private Class[] compileParamTypes = null;
    private Method compileMethod = null;
    private boolean testedCompilerClass = false;
    private boolean testedShell = false;
    private boolean compilerClassAvailable = false;
    private boolean shellAvailable = false;
    public Vector classPathVector = new Vector();
    public OutputStream outputStream;
    public boolean useCompilerClass = true;
    public boolean useShell = true;
    public boolean useJaninoCompiler = false;
    public boolean deleteFilesOnFinalize = true;

    public ProgrammableCompiler() {
        this.properties = new Hashtable();
        this.classByteFileLoader = new ClassByteFileLoader(this.classPathVector, this.properties);
        this.outputStream = new ByteArrayOutputStream();
        this.setProperty("userDirPath", System.getProperty("java.io.tmpdir"));
        String sClassPath = System.getProperty("java.class.path");
        this.setProperty("javaClassPath", System.getProperty("java.class.path"));
        this.setProperty("javaHomePath", System.getProperty("java.home"));
        this.setProperty("fileSeparator", System.getProperty("file.separator"));
        this.setProperty("pathSeparator", System.getProperty("path.separator"));
        this.setProperty("tempDirNameRoot", "transient");
        this.setProperty("sourceSuffix", ".java");
        this.setProperty("compiledSuffix", ".class");
        this.setProperty("packageSeparator", ".");
        this.setProperty("javacMainClassName", "sun.tools.javac.Main");
        this.setProperty("outputStreamClassName", "java.io.OutputStream");
        this.setProperty("stringClassName", "java.lang.String");
        this.setProperty("compileCommandName", "javac");
        this.setProperty("compileMethodName", "compile");
    }

    public ProgrammableCompiler(boolean bUseJaninoCompiler) {
        this();
        this.useJaninoCompiler = bUseJaninoCompiler;
    }

    public synchronized void setProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public synchronized String getProperty(String propertyName) {
        Object val = this.properties.get(propertyName);
        if (val == null) {
            if (propertyName.equals("javaBinPath")) {
                return this.getProperty("fileSeparator") + "bin";
            }
            if (propertyName.equals("javaAltBinPath")) {
                return this.getProperty("fileSeparator") + ".." + this.getProperty("fileSeparator") + "bin";
            }
            if (propertyName.equals("compilerPath")) {
                return this.getProperty("javaHomePath") + this.getProperty("javaBinPath") + this.getProperty("fileSeparator") + "javac";
            }
            if (propertyName.equals("altCompilerPath")) {
                return this.getProperty("javaHomePath") + this.getProperty("javaAltBinPath") + this.getProperty("fileSeparator") + "javac";
            }
            if (propertyName.equals("interpreterPath")) {
                return this.getProperty("javaHomePath") + this.getProperty("javaBinPath") + this.getProperty("fileSeparator") + "java";
            }
            return "";
        }
        return (String)val;
    }

    public synchronized boolean isCompilerClassAvailable() {
        if (this.testedCompilerClass) {
            return this.compilerClassAvailable;
        }
        this.testedCompilerClass = true;
        try {
            Class<?> javacMain = Class.forName(this.getProperty("javacMainClassName"));
            Object[] objs = new Object[]{this.outputStream, this.getProperty("compileCommandName")};
            this.compilerConstructorParams = objs;
            Class[] compilerConstructorParamTypes = new Class[]{Class.forName(this.getProperty("outputStreamClassName")), Class.forName(this.getProperty("stringClassName"))};
            this.compilerConstructor = javacMain.getConstructor(compilerConstructorParamTypes);
            Class[] classes = new Class[]{new String[0].getClass()};
            this.compileParamTypes = classes;
            this.compileMethod = javacMain.getMethod(this.getProperty("compileMethodName"), this.compileParamTypes);
            this.compilerClassAvailable = true;
            return this.compilerClassAvailable;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean isShellAvailable() {
        if (this.testedShell) {
            return this.shellAvailable;
        }
        this.testedShell = true;
        try {
            String command = this.getProperty("interpreterPath") + " -version";
            Exec.setVerbose(false);
            this.shellAvailable = Exec.execWait(command);
            return this.shellAvailable;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized Class compileClass(String classDefinition) throws CompilationException {
        String[] classDefinitions = new String[]{classDefinition};
        String resultClassName = this.extractFullClassNames(classDefinitions)[0];
        try {
            return this.compileClass(classDefinitions, resultClassName);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Class name extraction failed");
        }
    }

    public synchronized Class compileClass(String classDefinition, String mainClassName) throws CompilationException, ClassNotFoundException {
        String[] classDefinitions = new String[]{classDefinition};
        String[] mainClassNames = new String[]{mainClassName};
        Class[] compiledClasses = this.compileClasses(classDefinitions, mainClassNames);
        return this.findNamedClass(compiledClasses, mainClassName);
    }

    public synchronized Class compileClass(String[] classDefinitions, String resultClassName) throws CompilationException, ClassNotFoundException {
        Class[] compiledClasses = this.compileClasses(classDefinitions);
        return this.findNamedClass(compiledClasses, resultClassName);
    }

    public synchronized Class compileClass(String[] classDefinitions, String[] mainClassNames, String resultClassName) throws CompilationException, ClassNotFoundException {
        Class[] compiledClasses = this.compileClasses(classDefinitions, mainClassNames);
        return this.findNamedClass(compiledClasses, resultClassName);
    }

    public synchronized Class[] compileClasses(String[] classDefinitions) throws CompilationException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClasses(classDefinitions, mainClassNames);
    }

    public synchronized Class[] compileClasses(String[] classDefinitions, String[] mainClassNames) throws CompilationException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        String[] resultClassNames = this.fileToClassNames(this.scanFileNames());
        try {
            return this.loadClasses(resultClassNames);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Loading all classes failed");
        }
    }

    public synchronized Class[] compileSpecificClasses(String[] classDefinitions, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClasses(classDefinitions, mainClassNames, resultClassNames);
    }

    public synchronized Class[] compileClasses(String[] classDefinitions, String[] mainClassNames, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        return this.loadClasses(resultClassNames);
    }

    public synchronized byte[][] compileClassesToBytes(String[] classDefinitions) throws CompilationException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClassesToBytes(classDefinitions, mainClassNames);
    }

    public synchronized byte[][] compileClassesToBytes(String[] classDefinitions, String[] mainClassNames) throws CompilationException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        String[] resultClassNames = this.fileToClassNames(this.scanFileNames());
        try {
            return this.loadBytes(resultClassNames);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Loading all classes failed");
        }
    }

    public synchronized byte[][] compileSpecificClassesToBytes(String[] classDefinitions, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClassesToBytes(classDefinitions, mainClassNames, resultClassNames);
    }

    public synchronized byte[][] compileClassesToBytes(String[] classDefinitions, String[] mainClassNames, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        return this.loadBytes(resultClassNames);
    }

    public synchronized File[] compileClassesToFiles(String[] classDefinitions) throws CompilationException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClassesToFiles(classDefinitions, mainClassNames);
    }

    public synchronized File[] compileClassesToFiles(String[] classDefinitions, String[] mainClassNames) throws CompilationException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        String[] resultClassNames = this.fileToClassNames(this.scanFileNames());
        try {
            return this.loadFiles(resultClassNames);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Loading all classes failed");
        }
    }

    public synchronized File[] compileSpecificClassesToFiles(String[] classDefinitions, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        String[] mainClassNames = this.extractFullClassNames(classDefinitions);
        return this.compileClassesToFiles(classDefinitions, mainClassNames, resultClassNames);
    }

    public synchronized File[] compileClassesToFiles(String[] classDefinitions, String[] mainClassNames, String[] resultClassNames) throws CompilationException, ClassNotFoundException {
        this.createNewCompilationDir();
        this.compile(classDefinitions, mainClassNames);
        return this.loadFiles(resultClassNames);
    }

    protected void compile(String[] classDefinitions, String[] mainClassNames) throws CompilationException {
        if (classDefinitions == null || mainClassNames == null || classDefinitions.length == 0 || classDefinitions.length != mainClassNames.length) {
            throw new CompilationException("incorrect number of class names");
        }
        try {
            String[] argv = new String[mainClassNames.length + 4];
            String compilationClassPath = "";
            Enumeration compilationDirs = this.classPathVector.elements();
            while (compilationDirs.hasMoreElements()) {
                compilationClassPath = compilationClassPath + this.getProperty("pathSeparator") + ((File)compilationDirs.nextElement()).getAbsolutePath();
            }
            String outputDirPath = ((File)this.classPathVector.firstElement()).getAbsolutePath();
            argv[0] = "-classpath";
            argv[1] = this.getProperty("javaClassPath") + compilationClassPath;
            argv[2] = "-d";
            argv[3] = outputDirPath;
            this.generateSourceFiles(classDefinitions, mainClassNames, argv);
            if (this.useJaninoCompiler) {
                this.compileWithjanino(argv);
                return;
            }
            if (this.useCompilerClass && this.isCompilerClassAvailable()) {
                Object[] compileParams;
                Object compiler = this.compilerConstructor.newInstance(this.compilerConstructorParams);
                if (!((Boolean)this.compileMethod.invoke(compiler, compileParams = new Object[]{argv})).booleanValue()) {
                    this.throwCompilationErrors();
                }
                return;
            }
            if (this.useShell && this.isShellAvailable()) {
                int i;
                String compileCommand = "\"" + this.getProperty("compilerPath") + "\" -classpath \"" + this.getProperty("javaClassPath") + compilationClassPath + "\" -d \"" + outputDirPath + "\"";
                String alternateCompileCommand = "\"" + this.getProperty("altCompilerPath") + "\" -classpath \"" + this.getProperty("javaClassPath") + compilationClassPath + "\" -d \"" + outputDirPath + "\"";
                for (i = 4; i < argv.length; ++i) {
                    compileCommand = compileCommand + " " + argv[i];
                }
                for (i = 4; i < argv.length; ++i) {
                    alternateCompileCommand = alternateCompileCommand + " " + argv[i];
                }
                Exec.setVerbose(false);
                if (!Exec.execWait(compileCommand) && !Exec.execWait(alternateCompileCommand)) {
                    this.throwCompilationErrors();
                }
                return;
            }
            throw new CompilationException("no compilation mechanism successful");
        }
        catch (IOException e) {
            throw new CompilationException("could not create source files: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new CompilationException("could not create new instance of " + this.getProperty("javacMainClassName") + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new CompilationException("could not access constructor for " + this.getProperty("javacMainClassName") + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CompilationException("constructor for " + this.getProperty("javacMainClassName") + " threw exception: " + e.getMessage());
        }
        catch (Scanner.ScanException e) {
            throw new CompilationException("could not scan the source file. " + e.getMessage());
        }
        catch (Parser.ParseException e) {
            throw new CompilationException("could not Parse the source file. " + e.getMessage());
        }
        catch (Java.CompileException e) {
            throw new CompilationException("could not compile the source file. " + e.getMessage());
        }
    }

    private void compileWithjanino(String[] argv) throws Java.CompileException, IOException, Parser.ParseException, Scanner.ScanException {
        String sClassPath = argv[1];
        File[] paths = this.convertPathsToFileArray(sClassPath);
        File sourceFile = new File(argv[4]);
        File[] sourceFiles = new File[]{sourceFile};
        File[] optionalSourcePath = null;
        File[] classPath = paths;
        File[] optionalExtDirs = null;
        File[] optionalBootClassPath = null;
        File optionalDestinationDirectory = (File)this.classPathVector.firstElement();
        String optionalCharacterEncoding = null;
        boolean verbose = false;
        int debuggingInformation = 0;
        StringPattern[] optionalWarningHandlePatterns = null;
        boolean rebuild = false;
        Compiler comp = new Compiler(optionalSourcePath, classPath, optionalExtDirs, optionalBootClassPath, optionalDestinationDirectory, optionalCharacterEncoding, verbose, debuggingInformation, optionalWarningHandlePatterns, rebuild);
        comp.compile(sourceFiles);
    }

    private File[] convertPathsToFileArray(String sClassPath) {
        String sSeparator = System.getProperty("path.separator");
        String[] paths = sClassPath.split(sSeparator);
        File[] files = new File[paths.length];
        for (int iPath = 0; iPath < paths.length; ++iPath) {
            files[iPath] = new File(paths[iPath]);
        }
        return files;
    }

    protected void throwCompilationErrors() throws CompilationException {
        String compilerMessages = this.outputStream.toString();
        String errorMessage = "compilation failed";
        if (compilerMessages.length() > 0) {
            errorMessage = errorMessage + "\n\nError messages:\n\n========================\n\n" + compilerMessages + "\n\n========================\n";
        }
        throw new CompilationException(errorMessage);
    }

    protected void createNewCompilationDir() throws CompilationException {
        ProgrammableCompiler.createNewCompilationDirSynchronized(this);
    }

    protected static synchronized void createNewCompilationDirSynchronized(ProgrammableCompiler dc) throws CompilationException {
        dc.createNewCompilationDirActual();
    }

    protected void createNewCompilationDirActual() throws CompilationException {
        File newDir = new File(this.getProperty("userDirPath"), this.getProperty("tempDirNameRoot") + ++count);
        if (newDir.exists()) {
            this.clearDir(newDir, false);
        } else if (!newDir.mkdir()) {
            throw new CompilationException("creation of root directory failed");
        }
        this.classPathVector.insertElementAt(newDir, 0);
    }

    protected String[] scanFileNames() {
        Vector fullClassNameVector = new Vector();
        this.scanFileNames((File)this.classPathVector.firstElement(), "", fullClassNameVector);
        int noClasses = fullClassNameVector.size();
        String[] fullClassNames = new String[noClasses];
        for (int i = 0; i < noClasses; ++i) {
            fullClassNames[i] = (String)fullClassNameVector.elementAt(i);
        }
        return fullClassNames;
    }

    protected void scanFileNames(File parentDir, String pathName, Vector fullClassNameVector) {
        String[] fileList = parentDir.list();
        if (!pathName.equals("")) {
            pathName = pathName + ".";
        }
        for (int i = 0; i < fileList.length; ++i) {
            String localFileName = fileList[i];
            String fullFileName = pathName + localFileName;
            if (localFileName.endsWith(this.getProperty("compiledSuffix"))) {
                fullClassNameVector.addElement(fullFileName);
                continue;
            }
            File subDir = new File(parentDir, localFileName);
            if (!subDir.isDirectory()) continue;
            this.scanFileNames(subDir, fullFileName, fullClassNameVector);
        }
    }

    protected String[] fileToClassNames(String[] fileNames) {
        String[] classNames = new String[fileNames.length];
        int suffixLength = this.getProperty("compiledSuffix").length();
        for (int i = 0; i < classNames.length; ++i) {
            String fileName = fileNames[i];
            classNames[i] = fileName.substring(0, fileName.length() - suffixLength);
        }
        return classNames;
    }

    protected Class[] loadClasses(String[] classNames) throws ClassNotFoundException {
        CustomClassLoader rootDirLoader = new CustomClassLoader(this.classByteFileLoader);
        Class[] compiledClasses = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            compiledClasses[i] = rootDirLoader.loadClass(classNames[i], true);
        }
        return compiledClasses;
    }

    protected byte[][] loadBytes(String[] classNames) throws ClassNotFoundException {
        byte[][] compiledBytes = new byte[classNames.length][];
        for (int i = 0; i < classNames.length; ++i) {
            compiledBytes[i] = this.classByteFileLoader.get(classNames[i]);
            if (compiledBytes[i] != null) continue;
            throw new ClassNotFoundException("byte code not found");
        }
        return compiledBytes;
    }

    protected File[] loadFiles(String[] classNames) throws ClassNotFoundException {
        File[] compiledFiles = new File[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            compiledFiles[i] = this.classByteFileLoader.findClassFile(classNames[i]);
            if (compiledFiles[i] != null) continue;
            throw new ClassNotFoundException("file not found");
        }
        return compiledFiles;
    }

    protected void clearDir(File dir, boolean deleteDir) {
        this.clearDir(dir);
        if (deleteDir) {
            dir.delete();
        }
    }

    protected void clearDir(File dir) {
        String[] existingFileNames = dir.list();
        for (int i = 0; i < existingFileNames.length; ++i) {
            File f = new File(dir, existingFileNames[i]);
            if (f.isDirectory()) {
                this.clearDir(f);
            }
            f.delete();
        }
    }

    protected void generateSourceFiles(String[] classDefinitions, String[] mainClassNames, String[] argv) throws CompilationException, IOException {
        for (int i = 0; i < mainClassNames.length; ++i) {
            String localClassName;
            String sourceFileName;
            File packageDir = this.getPackageDirectory(mainClassNames[i]);
            File sourceFile = new File(packageDir, sourceFileName = (localClassName = this.extractLocalClassName(mainClassNames[i])) + this.getProperty("sourceSuffix"));
            if (sourceFile.exists() && !sourceFile.delete()) {
                throw new CompilationException("deletion of existing source class file failed");
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(sourceFile));
            printWriter.println(classDefinitions[i]);
            printWriter.flush();
            printWriter.close();
            argv[4 + i] = sourceFile.getAbsolutePath();
        }
    }

    protected String extractLocalClassName(String mainClassName) throws CompilationException {
        int fullPackageNameLength;
        String localClassName = mainClassName;
        int lastDotIndex = mainClassName.lastIndexOf(this.getProperty("packageSeparator"));
        String fullPackageName = "";
        if (lastDotIndex > -1) {
            fullPackageName = mainClassName.substring(0, lastDotIndex);
        }
        if ((fullPackageNameLength = fullPackageName.length()) > 0) {
            localClassName = mainClassName.substring(fullPackageNameLength + 1);
        }
        return localClassName;
    }

    protected File getPackageDirectory(String fullClassName) throws CompilationException {
        StringTokenizer st = new StringTokenizer(fullClassName, this.getProperty("packageSeparator"));
        File packageDir = (File)this.classPathVector.firstElement();
        String t = st.nextToken();
        while (st.hasMoreTokens()) {
            if (!(packageDir = new File(packageDir, t)).exists() && !packageDir.mkdir()) {
                throw new CompilationException("creation of root directory failed");
            }
            t = st.nextToken();
        }
        return packageDir;
    }

    protected String[] extractFullClassNames(String[] classDefinitions) {
        String[] fullClassNames = new String[classDefinitions.length];
        for (int i = 0; i < fullClassNames.length; ++i) {
            String classDefinition = classDefinitions[i];
            StringTokenizer st = new StringTokenizer(classDefinition, " \t\n\r;");
            String localClassName = "";
            String fullClassName = "";
            String packageName = "";
            String token = st.nextToken();
            while (st.hasMoreTokens()) {
                if (token.equals("package")) {
                    packageName = st.nextToken();
                }
                if (token.equals("class")) {
                    localClassName = st.nextToken();
                    if (packageName.equals("")) {
                        fullClassName = localClassName;
                        break;
                    }
                    fullClassName = packageName + "." + localClassName;
                    break;
                }
                token = st.nextToken();
            }
            fullClassNames[i] = fullClassName;
        }
        return fullClassNames;
    }

    protected Class findNamedClass(Class[] classes, String fullClassName) throws ClassNotFoundException {
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(fullClassName)) continue;
            return classes[i];
        }
        throw new ClassNotFoundException();
    }

    public void cleanup() throws Throwable {
        if (this.deleteFilesOnFinalize) {
            Enumeration compilationDirs = this.classPathVector.elements();
            while (compilationDirs.hasMoreElements()) {
                File transientDir = (File)compilationDirs.nextElement();
                this.clearDir(transientDir, true);
            }
        }
    }
}

