/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.windows;

import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.windows.ExtWindowsArrowButton;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class ExtWindowsComboBoxUI
extends WindowsComboBoxUI {
    private static final JTextField phantom = new JTextField("Phantom");

    public static ComponentUI createUI(JComponent b) {
        return new ExtWindowsComboBoxUI();
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        Dimension textFieldSize = phantom.getMinimumSize();
        return new Dimension(size.width, Math.max(textFieldSize.height, size.height));
    }

    protected LayoutManager createLayoutManager() {
        return LookUtils.HAS_XP_LAF ? super.createLayoutManager() : new ExtWindowsComboBoxLayoutManager();
    }

    protected JButton createArrowButton() {
        return LookUtils.HAS_XP_LAF ? super.createArrowButton() : new ExtWindowsArrowButton(5);
    }

    private class ExtWindowsComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private ExtWindowsComboBoxLayoutManager() {
            super((BasicComboBoxUI)((Object)ExtWindowsComboBoxUI.this));
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = ExtWindowsComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width");
            int buttonHeight = height - (insets.top + insets.bottom);
            if (ExtWindowsComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    ExtWindowsComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    ExtWindowsComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (ExtWindowsComboBoxUI.this.editor != null) {
                ExtWindowsComboBoxUI.this.editor.setBounds(ExtWindowsComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

