/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.windows;

import com.jgoodies.plaf.BorderStyle;
import com.jgoodies.plaf.HeaderStyle;
import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.windows.ExtWindowsBorders;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsToggleButtonUI;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public final class ExtWindowsToolBarUI
extends MetalToolBarUI {
    private final Border myRolloverBorder = this.createRolloverBorder();
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent b) {
        return new ExtWindowsToolBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("jgoodies.headerStyle") || prop.equals("jgoodies.windows.borderStyle")) {
                    ExtWindowsToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void installSpecialBorder() {
        void var1_2;
        String suffix;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "jgoodies.windows.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            suffix = "emptyBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            suffix = "separatorBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            suffix = "etchedBorder";
        } else if (HeaderStyle.from(this.toolBar) == HeaderStyle.BOTH) {
            suffix = "headerBorder";
        } else {
            return;
        }
        LookAndFeel.installBorder(this.toolBar, "ToolBar." + (String)var1_2);
    }

    protected BasicToolBarUI.DockingListener createDockingListener(JToolBar toolbar) {
        return new BasicToolBarUI.DockingListener(this, toolbar);
    }

    protected Border createRolloverBorder() {
        return ExtWindowsBorders.getRolloverButtonBorder();
    }

    protected void setBorderToRollover(Component c) {
        if (LookUtils.IS_BEFORE_14) {
            this.setBorderToRollover13(c);
            return;
        }
        if (c instanceof AbstractButton) {
            super.setBorderToRollover(c);
        } else if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                super.setBorderToRollover(cont.getComponent(i));
            }
        }
    }

    private void setBorderToRollover13(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            ButtonUI ui = b.getUI();
            if (ui instanceof WindowsButtonUI || ui instanceof WindowsToggleButtonUI) {
                b.setBorder(this.myRolloverBorder);
            }
            b.setRolloverEnabled(true);
        } else if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setBorderToRollover(cont.getComponent(i));
            }
        }
    }
}

