/*
 * Decompiled with CFR 0.152.
 */
package org.openabacus.jfreechart;

import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.openabacus.jfreechart.JAChartPanel;

public class JAStackedBarChart
extends JAChartPanel {
    private JFreeChart chart;
    private CategoryDataset dataset = null;
    private Font plotFont = new Font("SansSerif", 0, 12);
    private String defaultTitle = "Default Title";
    private String xAxisdefaultTitle = "X-Axis Title";
    private String yAxisdefaultTitle = "Y-Axis Title";
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private CategoryPlot plot = null;
    private CategoryItemRenderer renderer = null;
    private CategoryAxis domainAxis = null;

    public JAStackedBarChart() {
        this.dataset = this.createDataset();
        this.createChart(this.dataset);
        this.setChart(this.chart);
    }

    public CategoryDataset createDataset() {
        double[][] data = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        CategoryDataset localDataset = DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Type ", (double[][])data);
        return localDataset;
    }

    public void set3DChart(boolean bFlag) {
        this.b3DChart = bFlag;
        this.chart = this.createChart(this.dataset);
        this.setChart(this.chart);
    }

    public boolean get3DChart(boolean bFlag) {
        return this.b3DChart;
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public String getTitle() {
        return this.defaultTitle;
    }

    public JFreeChart createChart(CategoryDataset localDataSet) {
        JFreeChart localChart = null;
        localChart = this.b3DChart ? ChartFactory.createStackedBarChart3D((String)this.defaultTitle, (String)this.xAxisdefaultTitle, (String)this.yAxisdefaultTitle, (CategoryDataset)localDataSet, (PlotOrientation)this.orientation, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createStackedBarChart((String)this.defaultTitle, (String)this.xAxisdefaultTitle, (String)this.yAxisdefaultTitle, (CategoryDataset)localDataSet, (PlotOrientation)this.orientation, (boolean)true, (boolean)false, (boolean)false);
        this.plot = (CategoryPlot)localChart.getPlot();
        this.renderer = this.plot.getRenderer();
        this.renderer.setItemLabelsVisible(true);
        this.dataset = localDataSet;
        return localChart;
    }
}

