/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.event;

import javax.swing.JComponent;
import java.util.EventObject;

/**
 * Presents an event object which is generated by CSpinButton control.
 */
public class CSpinEvent extends EventObject {
  /**
   * The up spin command.
   */
  final public static int UP = 0;

  /**
   * The down spin command.
   */
  final public static int DOWN = 1;

  /**
   * The occurned spin command.
   */
  private int command;

  /**
   * Constructs a new CSpinEvent.
   * @param src the source of the event.
   * @param cmd the action command of the Spinner causing the event.
   */
  public CSpinEvent(Object src, int cmd) {
    super(src);
    this.command = cmd;
  }

  /**
   * Get the action command of this Spinner that caused this SpinEvent.
   * @return \u0435he action command of this \u0421SpinEvent.
   */
  public int getSpinCommand() {
    return this.command;
  }
}